/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.OrigFontType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PostscriptTokenParser {
    private static final Pattern origFontTypePattern = Pattern.compile("/OrigFontType\\s*/((?:" + OrigFontType.kTYPE1.toString() + ")|(?:" + OrigFontType.kTRUETYPE.toString() + ")|(?:" + OrigFontType.kOCF.toString() + ")|(?:" + OrigFontType.kCID.toString() + "))(\\s+def)", 0);
    private static final Pattern fsTypePattern = Pattern.compile("/FSType\\s*(-?\\d+)(\\s+def)", 0);

    public static Integer getFSType(String v) {
        Matcher m;
        if (v != null && (m = fsTypePattern.matcher(v)).find()) {
            int startPos = m.start(1);
            int endPos = m.start(2);
            return new Integer(Integer.parseInt(v.substring(startPos, endPos)));
        }
        return null;
    }

    public static OrigFontType getOrigFontType(String v) {
        Matcher m;
        if (v != null && (m = origFontTypePattern.matcher(v)).find()) {
            int endPos;
            int startPos = m.start(1);
            String s = v.substring(startPos, endPos = m.start(2));
            if (s.equals(OrigFontType.kTYPE1.toString())) {
                return OrigFontType.kTYPE1;
            }
            if (s.equals(OrigFontType.kTRUETYPE.toString())) {
                return OrigFontType.kTRUETYPE;
            }
            if (s.equals(OrigFontType.kCID.toString())) {
                return OrigFontType.kCID;
            }
            if (s.equals(OrigFontType.kOCF.toString())) {
                return OrigFontType.kOCF;
            }
        }
        return null;
    }
}

