/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.internal.io.ExtendedDataInputStream;
import com.adobe.internal.mac.resource.BasicResourceHandler;
import com.adobe.internal.mac.resource.ResourceParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;

public class FONDResourceHandler
extends BasicResourceHandler {
    private static final byte[] FOND = new byte[]{70, 79, 78, 68};
    private static final long ASSOCIATION_TABLE_OFFSET = 52L;
    private Set<Association> associations = new LinkedHashSet<Association>();

    public FONDResourceHandler() {
        super(FOND);
    }

    @Override
    public void handleResource(ResourceParser.ResourceEntry entry, long length, InputStream stream) {
        try {
            ExtendedDataInputStream dis = new ExtendedDataInputStream(stream);
            dis.skipFully(52L);
            int numberOfAssociations = dis.readUnsignedShort();
            for (int associationIndex = 0; associationIndex <= numberOfAssociations; ++associationIndex) {
                int size = dis.readUnsignedShort();
                int style = dis.readUnsignedShort();
                int fontID = dis.readUnsignedShort();
                Association association = new Association(entry.getID(), fontID, entry.getName(), entry.getScriptCode(), size, style);
                this.associations.add(association);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public Set<Association> getAssociations() {
        return this.associations;
    }

    public static class Association {
        private static final int STYLE_BOLD = 1;
        private static final int STYLE_ITALIC = 2;
        private String name;
        private int size;
        private int style;
        private int fontID;
        private int script;
        private int fondID;

        private Association(int fondID, int fontID, String name, int script, int size, int style) {
            this.fondID = fondID;
            this.size = size;
            this.style = style;
            this.fontID = fontID;
            this.name = name;
            this.script = script;
        }

        public int getFondID() {
            return this.fondID;
        }

        public int getSize() {
            return this.size;
        }

        public int getStyle() {
            return this.style;
        }

        public boolean isBold() {
            return (this.style & 1) == 1;
        }

        public boolean isItalic() {
            return (this.style & 2) == 2;
        }

        public int getFontID() {
            return this.fontID;
        }

        public String getName() {
            return this.name;
        }

        public int getScriptCode() {
            return this.script;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("fondID = " + this.fondID);
            sb.append("fontID = " + this.fontID);
            sb.append(", name = " + this.name);
            sb.append(", size = " + this.size);
            sb.append(", style = " + this.style);
            sb.append(" (bold = " + this.isBold());
            sb.append(", italic = " + this.isItalic() + ")");
            return sb.toString();
        }
    }
}

