/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.Type2Consumer;
import com.adobe.fontengine.font.postscript.SeacPhase;
import com.adobe.fontengine.font.postscript.StandardEncoding;

public final class Type2Parser {
    private final double[] stack = new double[48];
    private final double[] storage = new double[32];
    private int nbHints;
    private int stackDepth;
    private int callDepth;
    private boolean widthMayBeThere;
    private SeacPhase seacPhase;
    private double seacAccentX;
    private double seacAccentY;

    private void check(boolean b) throws InvalidGlyphException {
        if (!b) {
            throw new InvalidGlyphException("invalid Type2 charstring");
        }
    }

    private int checkInt(double d) throws InvalidGlyphException {
        int i = (int)d;
        if ((double)i != d) {
            throw new InvalidGlyphException("unexpected non-integer value");
        }
        return i;
    }

    private boolean handleWidth(Type2Consumer c) throws InvalidGlyphException {
        boolean result = true;
        if (this.stackDepth == 1) {
            if (this.widthMayBeThere) {
                result = c.width(this.stack[0]);
            } else if (this.seacPhase == SeacPhase.seacNone) {
                throw new InvalidGlyphException("stack is non empty");
            }
            this.stackDepth = 0;
        }
        this.widthMayBeThere = false;
        return result;
    }

    public void parse(CharStrings charStrings, int index, CharStrings localSubrs, CharStrings globalSubrs, Type2Consumer c, NameKeyedFont font) throws InvalidGlyphException, UnsupportedFontException {
        int nextOffset;
        int offset;
        this.widthMayBeThere = true;
        this.stackDepth = 0;
        this.callDepth = 0;
        this.nbHints = 0;
        this.seacPhase = SeacPhase.seacNone;
        try {
            offset = charStrings.offsetOf(index);
            nextOffset = charStrings.offsetFollowing(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidGlyphException("Glyph past end of charstrings array", e);
        }
        try {
            boolean keepGoing = this.parse(charStrings.data, offset, nextOffset, localSubrs, globalSubrs, c, font);
            if (keepGoing) {
                c.endchar(this.stack, this.stackDepth);
            }
        }
        catch (InvalidFontException e) {
            throw new InvalidGlyphException(e);
        }
    }

    private boolean parse(CFFByteArray data, int offset, int end, CharStrings localSubrs, CharStrings globalSubrs, Type2Consumer c, NameKeyedFont font) throws InvalidFontException, UnsupportedFontException {
        block56: while (offset < end) {
            int b0 = data.getcard8(offset);
            ++offset;
            switch (b0) {
                case 1: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int i;
                        int n = i = this.stackDepth % 2 != 0 ? 1 : 0;
                        this.stack[n] = this.stack[n] + this.seacAccentY;
                    }
                    c.hstem(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean keepGoing = this.handleWidth(c);
                    if (keepGoing) continue block56;
                    return false;
                }
                case 3: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int i;
                        int n = i = this.stackDepth % 2 != 0 ? 1 : 0;
                        this.stack[n] = this.stack[n] + this.seacAccentX;
                    }
                    c.vstem(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean keepGoing = this.handleWidth(c);
                    if (keepGoing) continue block56;
                    return false;
                }
                case 4: {
                    boolean keepGoing;
                    this.check(this.stackDepth == 1 || this.stackDepth == 2);
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        if (this.stackDepth == 2) {
                            this.stack[2] = this.stack[1] + this.seacAccentY;
                            this.stack[1] = this.seacAccentX;
                        } else {
                            this.stack[1] = this.stack[0] + this.seacAccentY;
                            this.stack[0] = this.seacAccentX;
                        }
                        ++this.stackDepth;
                        c.moveto(this.stack, this.stackDepth);
                        this.stackDepth -= 2;
                        this.seacPhase = SeacPhase.seacAccentPostMove;
                    } else {
                        c.vmoveto(this.stack, this.stackDepth);
                        --this.stackDepth;
                    }
                    if (keepGoing = this.handleWidth(c)) continue block56;
                    return false;
                }
                case 5: {
                    this.check(this.stackDepth >= 2 && this.stackDepth % 2 == 0);
                    c.rlineto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 6: {
                    this.check(this.stackDepth > 0);
                    c.hlineto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 7: {
                    this.check(this.stackDepth > 0);
                    c.vlineto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 8: {
                    this.check(this.stackDepth > 0 && this.stackDepth % 6 == 0);
                    c.rrcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 10: {
                    this.check(this.stackDepth >= 1);
                    this.check(localSubrs != null);
                    int subr = this.checkInt(this.stack[--this.stackDepth]);
                    subr = localSubrs.getCount() < 1240 ? (subr += 107) : (localSubrs.getCount() < 33900 ? (subr += 1131) : (subr += 32768));
                    c.callsubr(this.stack, this.stackDepth, subr);
                    ++this.callDepth;
                    boolean keepGoing = this.parse(localSubrs.data, localSubrs.offsetOf(subr), localSubrs.offsetFollowing(subr), localSubrs, globalSubrs, c, font);
                    --this.callDepth;
                    if (keepGoing) continue block56;
                    return keepGoing;
                }
                case 11: {
                    this.check(this.callDepth > 0);
                    c.return_op(this.stack, this.stackDepth);
                    return true;
                }
                case 12: {
                    int b1 = data.getcard8(offset);
                    ++offset;
                    switch (b1) {
                        case 0: {
                            continue block56;
                        }
                        case 3: {
                            this.check(this.stackDepth >= 2);
                            c.and(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 == 0.0 || num2 == 0.0 ? 0.0 : 1.0;
                            continue block56;
                        }
                        case 4: {
                            this.check(this.stackDepth >= 2);
                            c.or(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 == 0.0 && num2 == 0.0 ? 0.0 : 1.0;
                            continue block56;
                        }
                        case 5: {
                            this.check(this.stackDepth >= 1);
                            c.not(this.stack, this.stackDepth);
                            double num = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num == 0.0 ? 1.0 : 0.0;
                            continue block56;
                        }
                        case 9: {
                            this.check(this.stackDepth >= 1);
                            c.abs(this.stack, this.stackDepth);
                            double num = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num < 0.0 ? -num : num;
                            continue block56;
                        }
                        case 10: {
                            this.check(this.stackDepth >= 2);
                            c.add(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 + num2;
                            continue block56;
                        }
                        case 11: {
                            this.check(this.stackDepth >= 2);
                            c.sub(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 - num2;
                            continue block56;
                        }
                        case 12: {
                            this.check(this.stackDepth >= 2);
                            c.div(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 / num2;
                            continue block56;
                        }
                        case 14: {
                            this.check(this.stackDepth >= 1);
                            c.neg(this.stack, this.stackDepth);
                            double num = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = -num;
                            continue block56;
                        }
                        case 15: {
                            this.check(this.stackDepth >= 2);
                            c.eq(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 == num2 ? 1.0 : 0.0;
                            continue block56;
                        }
                        case 18: {
                            this.check(this.stackDepth >= 1);
                            c.drop(this.stack, this.stackDepth);
                            --this.stackDepth;
                            continue block56;
                        }
                        case 20: {
                            double val;
                            this.check(this.stackDepth >= 2);
                            c.put(this.stack, this.stackDepth);
                            int i = this.checkInt(this.stack[--this.stackDepth]);
                            this.storage[i] = val = this.stack[--this.stackDepth];
                            continue block56;
                        }
                        case 21: {
                            this.check(this.stackDepth >= 1);
                            c.get(this.stack, this.stackDepth);
                            int i = this.checkInt(this.stack[--this.stackDepth]);
                            this.stack[this.stackDepth++] = this.storage[i];
                            continue block56;
                        }
                        case 22: {
                            this.check(this.stackDepth >= 4);
                            c.ifelse(this.stack, this.stackDepth);
                            double v2 = this.stack[--this.stackDepth];
                            double v1 = this.stack[--this.stackDepth];
                            double s2 = this.stack[--this.stackDepth];
                            double s1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = v1 <= v2 ? s1 : s2;
                            continue block56;
                        }
                        case 23: {
                            this.check(this.stackDepth < this.stack.length);
                            c.random(this.stack, this.stackDepth);
                            this.stack[this.stackDepth++] = 0.0;
                            continue block56;
                        }
                        case 24: {
                            this.check(this.stackDepth >= 2);
                            c.mul(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num1 * num2;
                            continue block56;
                        }
                        case 26: {
                            this.check(this.stackDepth >= 1);
                            c.sqrt(this.stack, this.stackDepth);
                            double num = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = Math.sqrt(num);
                            continue block56;
                        }
                        case 27: {
                            this.check(this.stackDepth >= 1);
                            this.check(this.stackDepth < this.stack.length);
                            c.dup(this.stack, this.stackDepth);
                            double num = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num;
                            this.stack[this.stackDepth++] = num;
                            continue block56;
                        }
                        case 28: {
                            this.check(this.stackDepth >= 2);
                            c.exch(this.stack, this.stackDepth);
                            double num2 = this.stack[--this.stackDepth];
                            double num1 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = num2;
                            this.stack[this.stackDepth++] = num1;
                            continue block56;
                        }
                        case 29: {
                            this.check(this.stackDepth >= 1);
                            int i = this.checkInt(this.stack[this.stackDepth]);
                            this.check(this.stackDepth >= i + 1);
                            c.index(this.stack, this.stackDepth);
                            --this.stackDepth;
                            this.stack[this.stackDepth++] = this.stack[this.stackDepth - i - 1];
                            continue block56;
                        }
                        case 30: {
                            this.check(this.stackDepth >= 2);
                            this.check(this.stack[this.stackDepth - 2] > 0.0);
                            this.check((double)this.stackDepth >= this.stack[this.stackDepth - 2] + 2.0);
                            c.roll(this.stack, this.stackDepth);
                            int j = this.checkInt(this.stack[--this.stackDepth]);
                            int n = this.checkInt(this.stack[--this.stackDepth]);
                            if (j < 0) {
                                j = n - -j % n;
                            }
                            int top = this.stackDepth - 1;
                            int bottom = this.stackDepth - n;
                            this.reverseStackRange(top - (j %= n) + 1, top);
                            this.reverseStackRange(bottom, top - j);
                            this.reverseStackRange(bottom, top);
                            continue block56;
                        }
                        case 34: {
                            this.check(this.stackDepth == 7);
                            c.hflex(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 35: {
                            this.check(this.stackDepth == 13);
                            c.flex(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 36: {
                            this.check(this.stackDepth == 9);
                            c.hflex1(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 37: {
                            this.check(this.stackDepth == 11);
                            c.flex1(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 38: {
                            c.globalColorMe(this.stack, this.stackDepth);
                            continue block56;
                        }
                    }
                    throw new InvalidGlyphException("Invalid Type2 operator (12, " + b1 + ")");
                }
                case 14: {
                    if (this.seacPhase != SeacPhase.seacNone) {
                        return false;
                    }
                    if (this.stackDepth == 4 || this.stackDepth == 5) {
                        int startOfSeacArgs = 0;
                        if (this.stackDepth == 5) {
                            this.stackDepth = 1;
                            if (!this.handleWidth(c)) {
                                return false;
                            }
                            this.stackDepth = 5;
                            startOfSeacArgs = 1;
                        }
                        if (c.seac(this.stack, this.stackDepth)) {
                            this.seacPhase = SeacPhase.seacBase;
                            this.seacAccentX = this.stack[startOfSeacArgs++];
                            this.seacAccentY = this.stack[startOfSeacArgs++];
                            int base = (int)this.stack[startOfSeacArgs++];
                            int accent = (int)this.stack[startOfSeacArgs++];
                            if (font == null) {
                                throw new InvalidGlyphException("Seac found in non-nk font");
                            }
                            base = font.glyphName2gid(StandardEncoding.names[base]);
                            accent = font.glyphName2gid(StandardEncoding.names[accent]);
                            this.stackDepth = 0;
                            this.parse(font.charStrings.data, font.charStrings.offsetOf(base), font.charStrings.offsetFollowing(base), localSubrs, globalSubrs, c, font);
                            this.seacPhase = SeacPhase.seacAccentPreMove;
                            this.nbHints = 0;
                            this.stackDepth = 0;
                            this.parse(font.charStrings.data, font.charStrings.offsetOf(accent), font.charStrings.offsetFollowing(accent), localSubrs, globalSubrs, c, font);
                        }
                        this.stackDepth = 0;
                    }
                    this.handleWidth(c);
                    c.endchar(this.stack, this.stackDepth);
                    return false;
                }
                case 18: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int n = this.stackDepth % 2;
                        this.stack[n] = this.stack[n] + this.seacAccentY;
                    }
                    c.hstemhm(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean keepGoing = this.handleWidth(c);
                    if (keepGoing) continue block56;
                    return false;
                }
                case 19: {
                    boolean keepGoing;
                    if (this.stackDepth > 1) {
                        this.nbHints += this.stackDepth / 2;
                        if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                            int i;
                            int n = i = this.stackDepth % 2 != 0 ? 1 : 0;
                            this.stack[n] = this.stack[n] + this.seacAccentX;
                        }
                        c.implicit_vstemhm(this.stack, this.stackDepth);
                        this.stackDepth %= 2;
                    }
                    if (!(keepGoing = this.handleWidth(c))) {
                        return false;
                    }
                    int nbBytes = (this.nbHints + 7) / 8;
                    c.hintmask(this.stack, this.stackDepth, data, offset, nbBytes);
                    offset += nbBytes;
                    this.stackDepth = 0;
                    continue block56;
                }
                case 20: {
                    boolean keepGoing;
                    if (this.stackDepth > 1) {
                        this.nbHints += this.stackDepth / 2;
                        if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                            int i;
                            int n = i = this.stackDepth % 2 != 0 ? 1 : 0;
                            this.stack[n] = this.stack[n] + this.seacAccentX;
                        }
                        c.implicit_vstemhm(this.stack, this.stackDepth);
                        this.stackDepth %= 2;
                    }
                    if (!(keepGoing = this.handleWidth(c))) {
                        return false;
                    }
                    int nbBytes = (this.nbHints + 7) / 8;
                    c.cntrmask(this.stack, this.stackDepth, data, offset, nbBytes);
                    offset += nbBytes;
                    this.stackDepth = 0;
                    continue block56;
                }
                case 21: {
                    this.check(this.stackDepth == 2 || this.stackDepth == 3);
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        if (this.stackDepth == 2) {
                            this.stack[0] = this.stack[0] + this.seacAccentX;
                            this.stack[1] = this.stack[1] + this.seacAccentY;
                        } else {
                            this.stack[1] = this.stack[1] + this.seacAccentX;
                            this.stack[2] = this.stack[2] + this.seacAccentY;
                        }
                        this.seacPhase = SeacPhase.seacAccentPostMove;
                        c.moveto(this.stack, this.stackDepth);
                    } else {
                        c.rmoveto(this.stack, this.stackDepth);
                    }
                    this.stackDepth -= 2;
                    boolean keepGoing = this.handleWidth(c);
                    if (keepGoing) continue block56;
                    return false;
                }
                case 22: {
                    boolean keepGoing;
                    this.check(this.stackDepth == 1 || this.stackDepth == 2);
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        if (this.stackDepth == 2) {
                            this.stack[2] = this.seacAccentY;
                            this.stack[1] = this.stack[1] + this.seacAccentX;
                        } else {
                            this.stack[1] = this.seacAccentY;
                            this.stack[0] = this.stack[0] + this.seacAccentX;
                        }
                        ++this.stackDepth;
                        c.moveto(this.stack, this.stackDepth);
                        this.stackDepth -= 2;
                        this.seacPhase = SeacPhase.seacAccentPostMove;
                    } else {
                        c.hmoveto(this.stack, this.stackDepth);
                        --this.stackDepth;
                    }
                    if (keepGoing = this.handleWidth(c)) continue block56;
                    return false;
                }
                case 23: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int i;
                        int n = i = this.stackDepth % 2 != 0 ? 1 : 0;
                        this.stack[n] = this.stack[n] + this.seacAccentX;
                    }
                    c.vstemhm(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean keepGoing = this.handleWidth(c);
                    if (keepGoing) continue block56;
                    return false;
                }
                case 24: {
                    this.check(this.stackDepth >= 8 && this.stackDepth % 6 == 2);
                    c.rcurveline(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 25: {
                    this.check(this.stackDepth >= 8 && this.stackDepth % 2 == 0);
                    c.rlinecurve(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 26: {
                    this.check(this.stackDepth >= 4 && this.stackDepth % 4 <= 1);
                    c.vvcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 27: {
                    this.check(this.stackDepth >= 4 && this.stackDepth % 4 <= 1);
                    c.hhcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 28: {
                    this.check(this.stackDepth < this.stack.length);
                    int val = data.getint16(offset);
                    offset += 2;
                    c.integer(this.stack, this.stackDepth, val);
                    this.stack[this.stackDepth++] = val;
                    continue block56;
                }
                case 29: {
                    this.check(this.stackDepth >= 1);
                    int subr = this.checkInt(this.stack[--this.stackDepth]);
                    subr = globalSubrs.getCount() < 1240 ? (subr += 107) : (globalSubrs.getCount() < 33900 ? (subr += 1131) : (subr += 32768));
                    c.callgsubr(this.stack, this.stackDepth, subr);
                    ++this.callDepth;
                    boolean keepGoing = this.parse(globalSubrs.data, globalSubrs.offsetOf(subr), globalSubrs.offsetFollowing(subr), localSubrs, globalSubrs, c, font);
                    --this.callDepth;
                    if (keepGoing) continue block56;
                    return keepGoing;
                }
                case 30: {
                    this.check(this.stackDepth >= 4 && (this.stackDepth % 8 == 0 || this.stackDepth % 8 == 1 || this.stackDepth % 8 == 4 || this.stackDepth % 8 == 5));
                    c.vhcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 31: {
                    this.check(this.stackDepth >= 4 && (this.stackDepth % 8 == 0 || this.stackDepth % 8 == 1 || this.stackDepth % 8 == 4 || this.stackDepth % 8 == 5));
                    c.hvcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 255: {
                    this.check(this.stackDepth < this.stack.length);
                    double a = (double)data.getint32(offset) / 65536.0;
                    offset += 4;
                    c.real(this.stack, this.stackDepth, a);
                    this.stack[this.stackDepth++] = a;
                    continue block56;
                }
            }
            if (32 <= b0 && b0 <= 246) {
                this.check(this.stackDepth < this.stack.length);
                int val = b0 - 139;
                c.integer(this.stack, this.stackDepth, val);
                this.stack[this.stackDepth++] = val;
                continue;
            }
            if (247 <= b0 && b0 <= 250) {
                this.check(this.stackDepth < this.stack.length);
                int b1 = data.getcard8(offset);
                ++offset;
                int val = (b0 - 247) * 256 + b1 + 108;
                c.integer(this.stack, this.stackDepth, val);
                this.stack[this.stackDepth++] = val;
                continue;
            }
            if (251 <= b0 && b0 <= 254) {
                this.check(this.stackDepth < this.stack.length);
                int b1 = data.getcard8(offset);
                ++offset;
                int val = -(b0 - 251) * 256 - b1 - 108;
                c.integer(this.stack, this.stackDepth, val);
                this.stack[this.stackDepth++] = val;
                continue;
            }
            throw new InvalidGlyphException("invalid Type2 operator (" + b0 + ")");
        }
        this.check(false);
        return false;
    }

    private void reverseStackRange(int min, int max) {
        while (min < max) {
            double tmp = this.stack[min];
            this.stack[min] = this.stack[max];
            this.stack[max] = tmp;
            ++min;
            --max;
        }
    }
}

