/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;
import java.util.Calendar;
import java.util.TimeZone;

public class LcTime {
    protected int mMillis;
    protected int mAdjustment;
    private boolean mDaylightSavingsTime;
    protected int mHourOfDay;
    protected int mHourOfMeriDiem;
    protected LcLocale mLocale;
    protected int mMeriDiem;
    protected int mMinuteOfHour;
    protected int mSecondOfMinute;
    private Symbols mSymbols;
    protected int mThousandthOfSecond;
    protected int mTimeZone;
    protected boolean mTimeZoneSeen;
    protected boolean mValid;
    private static final TimeZoneInfo[] mTimeZoneName = new TimeZoneInfo[]{new TimeZoneInfo("en_US", -600, 1, "HAST", "HADT"), new TimeZoneInfo(null, -600, 0, "HAST", "HAST"), new TimeZoneInfo(null, -540, 1, "AKST", "AKDT"), new TimeZoneInfo(null, -480, 1, "PST", "PDT"), new TimeZoneInfo(null, -420, 1, "MST", "MDT"), new TimeZoneInfo(null, -420, 0, "PNT", "MST"), new TimeZoneInfo(null, -360, 1, "CST", "CDT"), new TimeZoneInfo(null, -300, 1, "EST", "EDT"), new TimeZoneInfo(null, -300, 0, "IET", "EST"), new TimeZoneInfo(null, -240, 1, "AST", "ADT"), new TimeZoneInfo(null, -210, 1, "NST", "NDT"), new TimeZoneInfo("c", 0, 0, null, null), new TimeZoneInfo("ar_AE", 240, 0, null, null), new TimeZoneInfo("ar_BH", 180, 0, null, null), new TimeZoneInfo("ar_DZ", 60, 0, null, null), new TimeZoneInfo("ar_EG", 120, 1, null, null), new TimeZoneInfo("ar_IQ", 180, 1, null, null), new TimeZoneInfo("ar_JO", 120, 1, null, null), new TimeZoneInfo("ar_KW", 180, 0, null, null), new TimeZoneInfo("ar_LB", 120, 1, null, null), new TimeZoneInfo("ar_LY", 120, 0, null, null), new TimeZoneInfo("ar_MA", 0, 0, null, null), new TimeZoneInfo("ar_OM", 240, 0, null, null), new TimeZoneInfo("ar_QA", 180, 0, null, null), new TimeZoneInfo("ar_SA", 180, 0, null, null), new TimeZoneInfo("ar_SD", 180, 0, null, null), new TimeZoneInfo("ar_SY", 120, 1, null, null), new TimeZoneInfo("ar_TN", 60, 0, null, null), new TimeZoneInfo("ar_YE", 180, 0, null, null), new TimeZoneInfo("az_Cyrl_AZ", 240, 1, null, null), new TimeZoneInfo("az_Latn_AZ", 240, 1, null, null), new TimeZoneInfo("be_BY", 120, 1, "EET", "EEST"), new TimeZoneInfo("bg_BG", 120, 1, "EET", "EEST"), new TimeZoneInfo("bs_BA", 60, 1, "CET", "CEST"), new TimeZoneInfo("ca_ES", 60, 1, "CET", "CEST"), new TimeZoneInfo("cs_CZ", 60, 1, "CET", "CEST"), new TimeZoneInfo("da_DK", 60, 1, "CET", "CEST"), new TimeZoneInfo("de_AT", 60, 1, "CET", "CEST"), new TimeZoneInfo(null, 60, 1, "MEZ", "MESZ"), new TimeZoneInfo("de_BE", 60, 1, "CET", "CEST"), new TimeZoneInfo("de_CH", 60, 1, "CET", "CEST"), new TimeZoneInfo(null, 60, 1, "MEZ", "MESZ"), new TimeZoneInfo("de_DE", 60, 1, "CET", "CEST"), new TimeZoneInfo(null, 60, 1, "MEZ", "MESZ"), new TimeZoneInfo("de_LI", 60, 1, "CET", "CEST"), new TimeZoneInfo("de_LU", 60, 1, "CET", "CEST"), new TimeZoneInfo(null, 60, 1, "MEZ", "MESZ"), new TimeZoneInfo("el_GR", 120, 1, "EET", "EEST"), new TimeZoneInfo("en_AU", 420, 0, "CXT", "CXT"), new TimeZoneInfo(null, 480, 0, "AWST", "AWST"), new TimeZoneInfo(null, 570, 1, "ACST", "ACDT"), new TimeZoneInfo(null, 570, 0, "ACST", "ACST"), new TimeZoneInfo(null, 600, 1, "AEST", "AEDT"), new TimeZoneInfo(null, 600, 0, "AEST", "AEST"), new TimeZoneInfo(null, 690, 0, "NFT", "NFT"), new TimeZoneInfo("en_BE", 60, 1, "CET", "CEST"), new TimeZoneInfo("en_CA", -480, 1, "PST", "PDT"), new TimeZoneInfo(null, -420, 1, "MST", "MDT"), new TimeZoneInfo(null, -360, 1, "CST", "CDT"), new TimeZoneInfo(null, -300, 1, "EST", "EDT"), new TimeZoneInfo(null, -240, 1, "AST", "ADT"), new TimeZoneInfo(null, -210, 1, "NST", "NDT"), new TimeZoneInfo("en_GB", 0, 1, null, "BST"), new TimeZoneInfo("en_HK", 480, 0, null, null), new TimeZoneInfo("en_IE", 0, 1, null, "IST"), new TimeZoneInfo("en_IN", 330, 0, null, null), new TimeZoneInfo("en_NZ", 720, 0, null, null), new TimeZoneInfo("en_PH", 480, 0, null, null), new TimeZoneInfo("en_SG", 480, 0, "SST", null), new TimeZoneInfo("en_VI", -240, 1, null, null), new TimeZoneInfo("en_ZA", 120, 0, null, null), new TimeZoneInfo("es_AR", -180, 0, null, null), new TimeZoneInfo("es_BO", -240, 0, "AST", "AST"), new TimeZoneInfo("es_CL", -240, 0, null, null), new TimeZoneInfo("es_CO", -300, 0, null, null), new TimeZoneInfo("es_CR", -360, 0, null, null), new TimeZoneInfo("es_DO", -240, 0, null, null), new TimeZoneInfo("es_EC", -300, 0, null, null), new TimeZoneInfo("es_ES", 60, 1, "CET", "CEST"), new TimeZoneInfo("es_GT", -360, 0, null, null), new TimeZoneInfo("es_HN", -360, 0, null, null), new TimeZoneInfo("es_MX", -480, 1, "PST", "PDT"), new TimeZoneInfo(null, -420, 1, "MST", "MDT"), new TimeZoneInfo(null, -420, 0, "MST", "MST"), new TimeZoneInfo(null, -360, 1, "CST", "CDT"), new TimeZoneInfo("es_NI", -360, 0, null, null), new TimeZoneInfo("es_PA", -300, 0, null, null), new TimeZoneInfo("es_PE", -300, 0, null, null), new TimeZoneInfo("es_PR", -300, 0, null, null), new TimeZoneInfo("es_PY", -240, 0, null, null), new TimeZoneInfo("es_SV", -360, 0, null, null), new TimeZoneInfo("es_US", -600, 1, "HAST", "HADT"), new TimeZoneInfo(null, -600, 0, "HAST", "HAST"), new TimeZoneInfo(null, -540, 1, "AKST", "AKDT"), new TimeZoneInfo(null, -480, 1, "PST", "PDT"), new TimeZoneInfo(null, -420, 1, "MST", "MDT"), new TimeZoneInfo(null, -420, 0, "PNT", "MST"), new TimeZoneInfo(null, -360, 1, "CST", "CDT"), new TimeZoneInfo(null, -300, 1, "EST", "EDT"), new TimeZoneInfo(null, -300, 0, "IET", "EST"), new TimeZoneInfo(null, -240, 1, "AST", "ADT"), new TimeZoneInfo(null, -210, 1, "NST", "NDT"), new TimeZoneInfo("es_UY", -180, 0, null, null), new TimeZoneInfo("es_VE", -240, 0, null, null), new TimeZoneInfo("et_EE", 120, 1, "EET", "EEST"), new TimeZoneInfo("eu_ES", 60, 1, "CET", "CEST"), new TimeZoneInfo("fa_IR", 210, 0, null, null), new TimeZoneInfo("fi_FI", 120, 1, "EET", "EEST"), new TimeZoneInfo("fr_BE", 60, 1, "CET", "CEST"), new TimeZoneInfo("fr_CA", -480, 1, "HNP", "HAP"), new TimeZoneInfo(null, -420, 1, "HNR", "HAR"), new TimeZoneInfo(null, -360, 1, "HNC", "HAC"), new TimeZoneInfo(null, -300, 1, "HNE", "HAE"), new TimeZoneInfo(null, -240, 1, "HNA", "HAA"), new TimeZoneInfo(null, -210, 1, "HNT", "HAT"), new TimeZoneInfo("fr_CH", 60, 1, "CET", "CEST"), new TimeZoneInfo("fr_FR", 60, 1, "CET", "CEST"), new TimeZoneInfo("fr_LU", 60, 1, "CET", "CEST"), new TimeZoneInfo("he_IL", 120, 1, null, null), new TimeZoneInfo("hi_IN", 330, 0, null, null), new TimeZoneInfo("hr_HR", 60, 1, "CET", "CEST"), new TimeZoneInfo("hu_HU", 60, 1, "CET", "CEST"), new TimeZoneInfo("hy_AM", 240, 1, null, null), new TimeZoneInfo("id_ID", 420, 0, null, null), new TimeZoneInfo("is_IS", 0, 0, null, null), new TimeZoneInfo("it_CH", 60, 1, "CET", "CEST"), new TimeZoneInfo("it_IT", 60, 1, "CET", "CEST"), new TimeZoneInfo("ja_JP", 540, 0, "JST", "JST"), new TimeZoneInfo("kk_KZ", 300, 0, null, null), new TimeZoneInfo(null, 360, 0, null, null), new TimeZoneInfo("km_KH", 420, 0, null, null), new TimeZoneInfo("ko_KR", 540, 0, "KST", "KST"), new TimeZoneInfo("lo_LA", 420, 1, null, null), new TimeZoneInfo("lt_LT", 120, 1, "EET", "EEST"), new TimeZoneInfo("lv_LV", 120, 1, "EET", "EEST"), new TimeZoneInfo("mk_MK", 60, 1, "CET", "CEST"), new TimeZoneInfo("ms_MY", 480, 0, null, null), new TimeZoneInfo("nb_NO", 60, 1, "CET", "CEST"), new TimeZoneInfo("nl_BE", 60, 1, "CET", "CEST"), new TimeZoneInfo("nl_NL", 60, 1, "CET", "CEST"), new TimeZoneInfo("nn_NO", 60, 1, "CET", "CEST"), new TimeZoneInfo("no_NO", 60, 1, "CET", "CEST"), new TimeZoneInfo("no_NO_NY", 60, 1, "CET", "CEST"), new TimeZoneInfo("pl_PL", 120, 1, "CET", "CEST"), new TimeZoneInfo("pt_BR", -240, 0, null, null), new TimeZoneInfo(null, -240, 0, null, null), new TimeZoneInfo(null, -180, 1, null, null), new TimeZoneInfo(null, -120, 0, null, null), new TimeZoneInfo("pt_PT", 0, 1, "WET", "WEST"), new TimeZoneInfo("ro_MD", 120, 1, "EET", "EEST"), new TimeZoneInfo("ro_RO", 120, 1, "EET", "EEST"), new TimeZoneInfo("ru_MD", 120, 1, "EET", "EEST"), new TimeZoneInfo("ru_RU", 180, 1, null, null), new TimeZoneInfo(null, 240, 1, null, null), new TimeZoneInfo(null, 300, 1, null, null), new TimeZoneInfo(null, 360, 1, null, null), new TimeZoneInfo(null, 420, 1, null, null), new TimeZoneInfo(null, 480, 1, null, null), new TimeZoneInfo(null, 540, 1, null, null), new TimeZoneInfo(null, 600, 1, null, null), new TimeZoneInfo(null, 660, 1, null, null), new TimeZoneInfo(null, 720, 1, null, null), new TimeZoneInfo("ru_UA", 120, 1, "EET", "EEST"), new TimeZoneInfo("sh", 60, 1, "CET", "CEST"), new TimeZoneInfo("sh_BA", 60, 1, "CET", "CEST"), new TimeZoneInfo("sh_CS", 60, 1, "CET", "CEST"), new TimeZoneInfo("sh_HR", 60, 1, "CET", "CEST"), new TimeZoneInfo("sk_SK", 60, 1, "CET", "CEST"), new TimeZoneInfo("sl_SI", 60, 1, "CET", "CEST"), new TimeZoneInfo("sq_AL", 60, 1, "CET", "CEST"), new TimeZoneInfo("sr_CS", 60, 1, "CET", "CEST"), new TimeZoneInfo("sr_Cyrl_CS", 60, 1, null, null), new TimeZoneInfo("sr_Latn_CS", 60, 1, null, null), new TimeZoneInfo("sv_FI", 120, 1, "EET", "EEST"), new TimeZoneInfo("sv_SE", 60, 1, "CET", "CEST"), new TimeZoneInfo("th_TH", 420, 0, null, null), new TimeZoneInfo("tl_PH", 480, 0, null, null), new TimeZoneInfo("tr_TR", 120, 1, "EET", "EEST"), new TimeZoneInfo("uk_UA", 120, 1, "EET", "EEST"), new TimeZoneInfo("vi_VN", 420, 0, null, null), new TimeZoneInfo("zh_CN", 480, 0, null, null), new TimeZoneInfo("zh_HK", 480, 0, null, null), new TimeZoneInfo("zh_SG", 480, 0, null, null), new TimeZoneInfo("zh_TW", 480, 0, null, null)};
    public static final String DEFAULT_TIME_FMT = "h:MM:SS A";
    public static final int MILLISPERDAY = 86400000;
    public static final int MILLISPERHOUR = 3600000;
    public static final int MILLISPERMINUTE = 60000;
    public static final int MILLISPERSECOND = 1000;
    public static final String TIME_FMT1 = "HHMMSS.FFFz";
    public static final String TIME_FMT2 = "HH:MM:SS.FFFzz";
    public static final String TIME_PICTURE_SYMBOLS = "hkHKMSFAZzt";

    public LcTime(String locale) {
        this.mSymbols = new Symbols();
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int uhr = now.get(11);
        int min = now.get(12);
        int sec = now.get(13);
        int millisec = now.get(14);
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        this.mLocale = new LcLocale(sLocale);
        if (!this.mLocale.isValid()) {
            this.mLocale = new LcLocale("en_US");
        }
        this.setTimeSymbols(this.mLocale.getIsoName());
        this.mMillis = LcTime.epoch(uhr, min, sec, millisec, 0);
        this.mValid = this.mMillis != 0;
    }

    public LcTime(int millis, String locale) {
        this.mSymbols = new Symbols();
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        this.mLocale = new LcLocale(sLocale);
        if (!this.mLocale.isValid()) {
            this.mLocale = new LcLocale("en_US");
        }
        this.setTimeSymbols(this.mLocale.getIsoName());
        this.mMillis = millis % 86400000;
        this.mValid = this.mMillis != 0;
    }

    public LcTime(String time, String pat, String locale) {
        this.mSymbols = new Symbols();
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        this.mLocale = new LcLocale(sLocale);
        if (!this.mLocale.isValid()) {
            this.mLocale = new LcLocale("en_US");
        }
        this.setTimeSymbols(this.mLocale.getIsoName());
        if (this.parse(time, pat)) {
            this.mMillis = LcTime.epoch(this.mHourOfDay, this.mMinuteOfHour, this.mSecondOfMinute, this.mThousandthOfSecond, this.mTimeZone);
            this.mValid = true;
        }
    }

    public LcTime(LcTime oTime) {
        this.asgn(oTime);
    }

    public LcTime add(int millis) {
        if (this.mValid) {
            this.mMillis += millis;
        }
        this.mMillis %= 86400000;
        this.mValid = this.mMillis != 0;
        return this;
    }

    public LcTime asgn(LcTime oTime) {
        this.mMillis = oTime.mMillis;
        this.mAdjustment = oTime.mAdjustment;
        this.mDaylightSavingsTime = oTime.mDaylightSavingsTime;
        this.mLocale = oTime.mLocale;
        this.mValid = oTime.mValid;
        ((Symbols)this.mSymbols).meridiemName[0] = oTime.mSymbols.meridiemName[0];
        ((Symbols)this.mSymbols).meridiemName[1] = oTime.mSymbols.meridiemName[1];
        this.mSymbols.zeroDigit = oTime.mSymbols.zeroDigit;
        this.mHourOfMeriDiem = oTime.mHourOfMeriDiem;
        this.mHourOfDay = oTime.mHourOfDay;
        this.mMinuteOfHour = oTime.mMinuteOfHour;
        this.mSecondOfMinute = oTime.mSecondOfMinute;
        this.mThousandthOfSecond = oTime.mThousandthOfSecond;
        this.mMeriDiem = oTime.mMeriDiem;
        this.mTimeZone = oTime.mTimeZone;
        this.mTimeZoneSeen = oTime.mTimeZoneSeen;
        return this;
    }

    protected static int epoch(int hour, int minute, int second, int millisecond, int timezone) {
        if (hour < 0 || 23 < hour) {
            return 0;
        }
        if (minute < 0 || 59 < minute) {
            return 0;
        }
        if (second < 0 || 59 < second) {
            return 0;
        }
        if (millisecond < 0 || 999 < millisecond) {
            return 0;
        }
        int mMillis = hour * 3600000 + minute * 60000 + second * 1000 + millisecond + timezone + 1;
        return mMillis;
    }

    public String format(String pat) {
        if (!this.mValid) {
            return "";
        }
        StringBuilder sBuf = new StringBuilder();
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int patLen = pat.length();
        int i = 0;
        while (i < patLen) {
            String sub;
            char chr = pat.charAt(i++);
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    sBuf.append(chr);
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                } else {
                    sBuf.append(chr);
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    sub = this.subFormat(prevChr, chrCnt);
                    if (sub.length() == 0) {
                        return "";
                    }
                    if (!sub.equals("\u001f")) {
                        sBuf.append(sub);
                    }
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(TIME_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        sub = this.subFormat(prevChr, chrCnt);
                        if (sub.length() == 0) {
                            return "";
                        }
                        if (!sub.equals("\u001f")) {
                            sBuf.append(sub);
                        }
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                sub = this.subFormat(prevChr, chrCnt);
                if (sub.length() == 0) {
                    return "";
                }
                if (!sub.equals("\u001f")) {
                    sBuf.append(sub);
                }
                chrCnt = 0;
            }
            if (chr == '?' || chr == '*' || chr == '+') {
                sBuf.append(' ');
            } else {
                sBuf.append(chr);
            }
            prevChr = '\u0000';
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            return "";
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            String sub = this.subFormat(prevChr, chrCnt);
            if (sub.length() == 0) {
                return "";
            }
            if (!sub.equals("\u001f")) {
                sBuf.append(sub);
            }
        }
        return sBuf.toString();
    }

    public int getDays() {
        if (!this.mValid) {
            return -366;
        }
        int millis = this.getMillis() - 1;
        int bias = millis > 0 ? 0 : -1;
        return (millis + bias * 86400000) / 86400000;
    }

    public int getHour() {
        int millis;
        if (!this.mValid) {
            return -1;
        }
        int uhr = 0;
        int min = 0;
        int bias = (millis = this.getMillis() - 1) > 0 ? 1 : -1;
        int sec = (millis + bias * 60000) % 60000 / 1000;
        if (sec < 0) {
            --min;
        }
        if ((min += (millis + bias * 3600000) % 3600000 / 60000) < 0) {
            --uhr;
        }
        if ((uhr += (millis + bias * 86400000) % 86400000 / 3600000) < 0) {
            uhr += 24;
        }
        return uhr;
    }

    public static String getLocalTimeFormat(int style, String locale) {
        return new LcData(locale).getLocalTimeFormat(style);
    }

    public int getMillis() {
        if (!this.mValid) {
            return 0;
        }
        return this.mMillis + this.mAdjustment;
    }

    public int getMilliSecond() {
        int millis;
        if (!this.mValid) {
            return -1;
        }
        int bias = (millis = this.getMillis() - 1) > 0 ? 1 : -1;
        int millisec = (millis + bias * 1000) % 1000;
        if (millisec < 0) {
            millisec += 1000;
        }
        return millisec;
    }

    public int getMinute() {
        int millis;
        if (!this.mValid) {
            return -1;
        }
        int min = 0;
        int bias = (millis = this.getMillis() - 1) > 0 ? 1 : -1;
        int sec = (millis + bias * 60000) % 60000 / 1000;
        if (sec < 0) {
            --min;
        }
        if ((min += (millis + bias * 3600000) % 3600000 / 60000) < 0) {
            min += 60;
        }
        return min;
    }

    public int getSecond() {
        int millis;
        if (!this.mValid) {
            return -1;
        }
        int bias = (millis = this.getMillis() - 1) > 0 ? 1 : -1;
        int sec = (millis + bias * 60000) % 60000 / 1000;
        if (sec < 0) {
            sec += 60;
        }
        return sec;
    }

    public static String getTimeFormat(int style, String locale) {
        return new LcData(locale).getTimeFormat(style);
    }

    public int getTimeZone() {
        if (!this.mValid) {
            return -1;
        }
        return this.mTimeZone / 60000;
    }

    private int getTimeZoneName() {
        TimeZone tz = TimeZone.getDefault();
        int tzdiff = tz.getRawOffset() / 60000;
        int tzdst = tz.useDaylightTime() ? 1 : 0;
        String sLocName = this.mLocale.getIsoName();
        int n = mTimeZoneName.length;
        for (int i = 0; i < n; ++i) {
            if (mTimeZoneName[i].isoName == null || !sLocName.equals(mTimeZoneName[i].isoName)) continue;
            do {
                if (tzdiff != mTimeZoneName[i].offset || tzdst != mTimeZoneName[i].dstflg) continue;
                return i;
            } while (++i < mTimeZoneName.length && mTimeZoneName[i].isoName == null);
            break;
        }
        return -1;
    }

    public boolean isValid() {
        return this.mValid;
    }

    protected boolean parse(String str, String pat) {
        int parseRes;
        int strPos = 0;
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int strLen = str.length();
        int patLen = pat.length();
        this.mHourOfDay = -1;
        this.mHourOfMeriDiem = -1;
        this.mMinuteOfHour = -1;
        this.mSecondOfMinute = -1;
        this.mThousandthOfSecond = -1;
        this.mMeriDiem = -1;
        this.mTimeZone = -1;
        this.mTimeZoneSeen = false;
        int i = 0;
        while (i < patLen) {
            char chr;
            boolean fw;
            boolean bl = fw = '\uff01' <= (chr = pat.charAt(i++)) && chr <= '\uff5e';
            if (strPos >= strLen) {
                if (inQuoted && chr == '\'') {
                    inQuoteQuoted = true;
                    break;
                }
                return false;
            }
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    if (!DateTimeUtil.matchChr(str, strPos, chr, fw)) {
                        return false;
                    }
                    ++strPos;
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                } else {
                    if (!DateTimeUtil.matchChr(str, strPos, chr, fw)) {
                        return false;
                    }
                    ++strPos;
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    parseRes = this.subParse(str, strPos, prevChr, chrCnt);
                    if (parseRes < 0) {
                        return false;
                    }
                    strPos = parseRes;
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(TIME_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        parseRes = this.subParse(str, strPos, prevChr, chrCnt);
                        if (parseRes < 0) {
                            return false;
                        }
                        strPos = parseRes;
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                parseRes = this.subParse(str, strPos, prevChr, chrCnt);
                if (parseRes < 0) {
                    return false;
                }
                strPos = parseRes;
                chrCnt = 0;
                prevChr = '\u0000';
            }
            if (chr == '?') {
                if (strPos >= strLen || !Character.isDefined(str.charAt(strPos))) continue;
                ++strPos;
                continue;
            }
            if (chr == '+') {
                if (strPos >= strLen || !Character.isWhitespace(str.charAt(strPos))) {
                    return false;
                }
                ++strPos;
                while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                    ++strPos;
                }
                continue;
            }
            if (chr == '*') {
                while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                    ++strPos;
                }
                continue;
            }
            if (strPos < strLen && str.charAt(strPos) == chr) {
                ++strPos;
                continue;
            }
            return false;
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            return false;
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            parseRes = this.subParse(str, strPos, prevChr, chrCnt);
            if (parseRes < 0) {
                return false;
            }
            strPos = parseRes;
        }
        if (strPos != strLen) {
            return false;
        }
        if (this.mHourOfMeriDiem >= 0 && this.mMeriDiem >= 0) {
            this.mHourOfDay = this.mHourOfMeriDiem + this.mMeriDiem * 12;
        }
        if (this.mThousandthOfSecond == -1) {
            this.mThousandthOfSecond = 0;
        }
        if (this.mSecondOfMinute == -1) {
            this.mSecondOfMinute = 0;
        }
        if (this.mHourOfDay < 0 || this.mMinuteOfHour < 0) {
            return false;
        }
        if (!this.mTimeZoneSeen) {
            Calendar now = Calendar.getInstance();
            this.mTimeZone = -now.get(15);
            if (TimeZone.getDefault().inDaylightTime(now.getTime())) {
                this.mTimeZone -= now.get(16);
            }
        }
        return true;
    }

    public void setGMTime() {
        this.mAdjustment = 0;
        this.mDaylightSavingsTime = false;
    }

    public void setLocalTime() {
        Calendar now = Calendar.getInstance();
        this.mAdjustment = now.get(15);
        this.mDaylightSavingsTime = TimeZone.getDefault().inDaylightTime(now.getTime());
        if (this.mDaylightSavingsTime) {
            this.mAdjustment += now.get(16);
        }
    }

    protected void setTimeSymbols(String locale) {
        LcData oData = new LcData(locale);
        for (int i = 0; i < 2; ++i) {
            ((Symbols)this.mSymbols).meridiemName[i] = oData.getMeridiemName(i);
        }
        this.mSymbols.zeroDigit = oData.getZeroSymbol().charAt(0);
    }

    protected String subFormat(char chr, int chrCnt) {
        StringBuilder sBuf = new StringBuilder();
        boolean fw = '\uff01' <= chr && chr <= '\uff5e';
        int tr = 0;
        char[] pCJK_Num = null;
        if (this.mLocale.isJapanese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isTraditionalChinese()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.getName().equals("zh_HK")) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isChinese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isKoreanHani()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isKorean()) {
            pCJK_Num = DateTimeUtil.Hangul_Num;
        }
        int value = 0;
        switch (chr) {
            case '\uff48': {
                value = this.getHour() % 12;
                if (value == 0) {
                    value = 12;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'h': {
                if (chr == 'h' && (value = this.getHour() % 12) == 0) {
                    value = 12;
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff4b': {
                value = this.getHour() % 12;
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'k': {
                if (chr == 'k') {
                    value = this.getHour() % 12;
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff28': {
                value = this.getHour();
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'H': {
                if (chr == 'H') {
                    value = this.getHour();
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff2b': {
                value = this.getHour();
                if (value == 0) {
                    value = 24;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'K': {
                if (chr == 'K' && (value = this.getHour()) == 0) {
                    value = 24;
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff2d': {
                value = this.getMinute();
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'M': {
                if (chr == 'M') {
                    value = this.getMinute();
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff33': {
                value = this.getSecond();
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'S': {
                if (chr == 'S') {
                    value = this.getSecond();
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 'F': 
            case '\uff26': {
                value = this.getMilliSecond();
                switch (chrCnt) {
                    case 3: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 'A': {
                value = this.getHour() >= 12 ? 1 : 0;
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        if (chrCnt == 1) {
                            sBuf.append(DateTimeUtil.fmtStr(this.mSymbols.meridiemName[value], fw));
                            break;
                        }
                        String[] meridiemName = new String[2];
                        for (int i = 0; i < 2; ++i) {
                            int k = 1;
                            meridiemName[i] = this.mSymbols.meridiemName[i].substring(0, k);
                        }
                        sBuf.append(DateTimeUtil.fmtStr(meridiemName[value], fw));
                    }
                }
                break;
            }
            case 'Z': {
                int idx = this.getTimeZoneName();
                switch (chrCnt) {
                    case 1: {
                        if (this.mAdjustment != 0 && idx >= 0 && mTimeZoneName[idx].stdName != null) {
                            if (this.mDaylightSavingsTime || mTimeZoneName[idx].dstflg == 0) {
                                sBuf.append(DateTimeUtil.fmtStr(mTimeZoneName[idx].dstName, fw));
                                break;
                            }
                            sBuf.append(DateTimeUtil.fmtStr(mTimeZoneName[idx].stdName, fw));
                            break;
                        }
                        value = this.mAdjustment;
                        sBuf.append(DateTimeUtil.fmtStr("GMT", fw));
                        if (value < 0) {
                            sBuf.append(DateTimeUtil.matchChr('-', fw));
                            value = -value;
                        } else if (value > 0) {
                            sBuf.append(DateTimeUtil.matchChr('+', fw));
                        }
                        if (value == 0) break;
                        sBuf.append(DateTimeUtil.fmtNum(2, value / 3600000, fw, this.mSymbols.zeroDigit));
                        sBuf.append(DateTimeUtil.matchChr(':', fw));
                        value = value % 3600000 / 60000;
                        sBuf.append(DateTimeUtil.fmtNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: 
                    case 3: {
                        value = this.mAdjustment;
                        if (value == 0) {
                            sBuf.append(chrCnt == 3 ? DateTimeUtil.matchChr('Z', fw) : (char)'\u001f');
                        } else if (value < 0) {
                            sBuf.append(DateTimeUtil.matchChr('-', fw));
                            value = -value;
                        } else if (value > 0) {
                            sBuf.append(DateTimeUtil.matchChr('+', fw));
                        }
                        if (value == 0) break;
                        sBuf.append(DateTimeUtil.fmtNum(2, value / 3600000, fw, this.mSymbols.zeroDigit));
                        sBuf.append(DateTimeUtil.matchChr('\'', fw));
                        value = value % 3600000 / 60000;
                        sBuf.append(DateTimeUtil.fmtNum(2, value, fw, this.mSymbols.zeroDigit));
                        sBuf.append(DateTimeUtil.matchChr('\'', fw));
                    }
                }
                break;
            }
            case 'z': 
            case '\uff5a': {
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        value = this.mAdjustment;
                        if (value == 0) {
                            sBuf.append(DateTimeUtil.matchChr('Z', fw));
                        } else if (value < 0) {
                            sBuf.append(DateTimeUtil.matchChr('-', fw));
                            value = -value;
                        } else if (value > 0) {
                            sBuf.append(DateTimeUtil.matchChr('+', fw));
                        }
                        if (value == 0) break;
                        sBuf.append(DateTimeUtil.fmtNum(2, value / 3600000, fw, this.mSymbols.zeroDigit));
                        if (chrCnt == 2) {
                            sBuf.append(DateTimeUtil.matchChr(':', fw));
                        }
                        value = value % 3600000 / 60000;
                        sBuf.append(DateTimeUtil.fmtNum(2, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 't': {
                while (chrCnt-- > 0) {
                    sBuf.append('\t');
                }
                break;
            }
            default: {
                sBuf.append(chr);
            }
        }
        return sBuf.toString();
    }

    protected int subParse(String src, int srcPos, char chr, int chrCnt) {
        int curPos = srcPos;
        int srcLen = src.length();
        boolean fw = '\uff01' <= chr && chr <= '\uff5e';
        boolean tr = false;
        char[] pCJK_Num = null;
        if (this.mLocale.isJapanese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isTraditionalChinese()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.getName().equals("zh_HK")) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isChinese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isKoreanHani()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isKorean()) {
            pCJK_Num = DateTimeUtil.Hangul_Num;
        }
        block0 : switch (chr) {
            case '\uff48': {
                int len;
                if (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfMeriDiem = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'h': {
                int len;
                if (chr == 'h' && (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0)) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfMeriDiem = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        if (chr != 'h') break;
                        return -1;
                    }
                }
                if (this.mHourOfMeriDiem < 1 || 12 < this.mHourOfMeriDiem) {
                    return -1;
                }
                if (this.mHourOfMeriDiem != 12) break;
                this.mHourOfMeriDiem = 0;
                break;
            }
            case '\uff4b': {
                int len;
                if (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfMeriDiem = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'k': {
                int len;
                if (chr == 'k' && (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0)) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfMeriDiem = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        if (chr != 'k') break;
                        return -1;
                    }
                }
                if (this.mHourOfMeriDiem >= 0 && 11 >= this.mHourOfMeriDiem) break;
                return -1;
            }
            case '\uff28': {
                int len;
                if (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfDay = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'H': {
                int len;
                if (chr == 'H' && (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0)) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfDay = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        if (chr != 'H') break;
                        return -1;
                    }
                }
                if (this.mHourOfDay >= 0 && 23 >= this.mHourOfDay) break;
                return -1;
            }
            case '\uff2b': {
                int len;
                if (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfDay = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'K': {
                int len;
                if (chr == 'K' && (this.mHourOfDay >= 0 || this.mHourOfMeriDiem >= 0)) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mHourOfDay = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        if (chr != 'K') break;
                        return -1;
                    }
                }
                if (this.mHourOfDay < 1 || 24 < this.mHourOfDay) {
                    return -1;
                }
                if (this.mHourOfDay != 24) break;
                this.mHourOfDay = 0;
                break;
            }
            case '\uff2d': {
                int len;
                if (this.mMinuteOfHour >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mMinuteOfHour = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'M': {
                int len;
                if (chr == 'M' && this.mMinuteOfHour >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mMinuteOfHour = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        if (chr != 'M') break;
                        return -1;
                    }
                }
                if (this.mMinuteOfHour >= 0 && 59 >= this.mMinuteOfHour) break;
                return -1;
            }
            case '\uff33': {
                int len;
                if (this.mSecondOfMinute >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mSecondOfMinute = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'S': {
                int len;
                if (chr == 'S' && this.mSecondOfMinute >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mSecondOfMinute = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        if (chr != 'S') break;
                        return -1;
                    }
                }
                if (this.mSecondOfMinute >= 0 && 59 >= this.mSecondOfMinute) break;
                return -1;
            }
            case 'F': 
            case '\uff26': {
                if (this.mThousandthOfSecond >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: {
                        int len = DateTimeUtil.matchNum(src, srcPos, srcPos + 3, fw, this.mSymbols.zeroDigit);
                        if (len != 3) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mThousandthOfSecond = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                if (this.mThousandthOfSecond >= 0 && 999 >= this.mSecondOfMinute) break;
                return -1;
            }
            case 'A': {
                if (this.mMeriDiem >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        int len;
                        int idx;
                        if (chrCnt == 1) {
                            idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.meridiemName, true);
                            if (idx < 0) {
                                return -1;
                            }
                            len = this.mSymbols.meridiemName[idx].length();
                        } else {
                            String[] meridiemName = new String[2];
                            for (int i = 0; i < 2; ++i) {
                                meridiemName[i] = this.mSymbols.meridiemName[i].substring(0, 1);
                            }
                            idx = DateTimeUtil.matchName(src, srcPos, meridiemName, true);
                            if (idx < 0) {
                                return -1;
                            }
                            len = meridiemName[idx].length();
                        }
                        this.mMeriDiem = idx;
                        srcPos += len;
                        break block0;
                    }
                }
                return -1;
            }
            case 'Z': {
                if (this.mTimeZoneSeen) {
                    return -1;
                }
                this.mTimeZoneSeen = true;
                switch (chrCnt) {
                    case 1: {
                        int tzLen;
                        String tz;
                        int i;
                        int len = DateTimeUtil.matchStr(src, srcPos, "GMT", fw);
                        if (len > 0) {
                            srcPos = len;
                            if (srcPos == srcLen) {
                                this.mTimeZone = 0;
                                return srcPos;
                            }
                            if (DateTimeUtil.matchChr(src, srcPos, '-', fw)) {
                                ++srcPos;
                                this.mTimeZone = 1;
                            } else if (DateTimeUtil.matchChr(src, srcPos, '+', fw)) {
                                ++srcPos;
                                this.mTimeZone = -1;
                            } else {
                                this.mTimeZone = 0;
                                return srcPos;
                            }
                            len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                            if (len != 2) {
                                return -1;
                            }
                            curPos = DateTimeUtil.incPos(src, srcPos, len);
                            int hours = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                            if (hours < 0 || 12 < hours) {
                                return -1;
                            }
                            srcPos = curPos;
                            if (!DateTimeUtil.matchChr(src, srcPos, ':', fw)) {
                                return -1;
                            }
                            if ((len = DateTimeUtil.matchNum(src, ++srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit)) != 2) {
                                return -1;
                            }
                            curPos = DateTimeUtil.incPos(src, srcPos, len);
                            int minutes = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                            if (minutes < 0 || 59 < minutes) {
                                return -1;
                            }
                            srcPos = curPos;
                            this.mTimeZone *= (hours * 60 + minutes) * 60000;
                            break block0;
                        }
                        String sLocName = this.mLocale.getIsoName();
                        int n = mTimeZoneName.length;
                        for (int k = 0; !(k >= n || mTimeZoneName[k].isoName != null && sLocName.equals(mTimeZoneName[k].isoName)); ++k) {
                        }
                        for (i = k; i < n && mTimeZoneName[i].stdName != null; ++i) {
                            tz = mTimeZoneName[i].stdName;
                            tzLen = tz.length();
                            if (srcPos + tzLen > srcLen) continue;
                            len = DateTimeUtil.matchStr(src, srcPos, tz, fw);
                            if (len > 0) {
                                this.mTimeZone = -mTimeZoneName[i].offset * 60000;
                                srcPos = len;
                                return srcPos;
                            }
                            if (i + 1 < n && mTimeZoneName[i + 1].isoName != null) break;
                        }
                        for (i = k; i < n && mTimeZoneName[i].dstName != null; ++i) {
                            tz = mTimeZoneName[i].dstName;
                            tzLen = tz.length();
                            if (srcPos + tzLen > srcLen) continue;
                            len = DateTimeUtil.matchStr(src, srcPos, tz, fw);
                            if (len > 0) {
                                this.mTimeZone = -mTimeZoneName[i].offset * 60000;
                                this.mTimeZone -= 3600000;
                                srcPos = len;
                                return srcPos;
                            }
                            if (i + 1 < n && mTimeZoneName[i + 1].isoName != null) break;
                        }
                        return -1;
                    }
                    case 2: 
                    case 3: {
                        int len = DateTimeUtil.matchStr(src, srcPos, "Z", fw);
                        if (len > 0) {
                            this.mTimeZone = 0;
                            return srcPos;
                        }
                        int direction = 0;
                        if (DateTimeUtil.matchChr(src, srcPos, '-', fw)) {
                            ++srcPos;
                            direction = 1;
                        } else if (DateTimeUtil.matchChr(src, srcPos, '+', fw)) {
                            ++srcPos;
                            direction = -1;
                        }
                        if (direction == 0) {
                            if (chrCnt == 2) {
                                return -1;
                            }
                            this.mTimeZone = 0;
                            return srcPos;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len != 2) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        int hours = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        if (hours < 0 || 12 < hours) {
                            return -1;
                        }
                        srcPos = curPos;
                        this.mTimeZone = direction * (hours * 60) * 60000;
                        if (!DateTimeUtil.matchChr(src, srcPos, '\'', fw)) {
                            return -1;
                        }
                        if ((len = DateTimeUtil.matchNum(src, ++srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit)) != 2) {
                            return srcPos;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        int minutes = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        if (minutes < 0 || 59 < minutes) {
                            return -1;
                        }
                        srcPos = curPos;
                        if (!DateTimeUtil.matchChr(src, srcPos, '\'', fw)) {
                            return -1;
                        }
                        ++srcPos;
                        this.mTimeZone += direction * minutes * 60000;
                        break block0;
                    }
                }
                return -1;
            }
            case 'z': 
            case '\uff5a': {
                if (this.mTimeZoneSeen) {
                    return -1;
                }
                this.mTimeZoneSeen = true;
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        if (DateTimeUtil.matchChr(src, srcPos, 'Z', fw)) {
                            ++srcPos;
                            this.mTimeZone = 0;
                            break block0;
                        }
                        if (DateTimeUtil.matchChr(src, srcPos, 'z', fw)) {
                            ++srcPos;
                            this.mTimeZone = 0;
                            break block0;
                        }
                        int direction = 0;
                        if (DateTimeUtil.matchChr(src, srcPos, '-', fw)) {
                            ++srcPos;
                            direction = 1;
                        } else if (DateTimeUtil.matchChr(src, srcPos, '+', fw)) {
                            ++srcPos;
                            direction = -1;
                        }
                        int len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len != 2) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        int hours = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        if (hours < 0 || 12 < hours) {
                            return -1;
                        }
                        this.mTimeZone = direction * (hours * 60) * 60000;
                        srcPos = curPos;
                        if (srcPos == srcLen) {
                            return srcPos;
                        }
                        if (chrCnt == 2) {
                            if (!DateTimeUtil.matchChr(src, srcPos, ':', fw)) {
                                return srcPos;
                            }
                            ++srcPos;
                        }
                        if ((len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit)) != 2) {
                            return srcPos;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        int minutes = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        if (minutes < 0 || 59 < minutes) {
                            return -1;
                        }
                        this.mTimeZone += direction * minutes * 60000;
                        srcPos = curPos;
                        break block0;
                    }
                }
                return -1;
            }
            case 't': {
                while (chrCnt-- != 0) {
                    if (src.charAt(srcPos) != '\t') {
                        return -1;
                    }
                    ++srcPos;
                }
                break;
            }
            default: {
                if (!DateTimeUtil.matchChr(src, srcPos, chr, fw)) {
                    return -1;
                }
                ++srcPos;
            }
        }
        return srcPos;
    }

    public String toString() {
        return this.format(DEFAULT_TIME_FMT);
    }

    private static class TimeZoneInfo {
        private final String isoName;
        private final int offset;
        private final int dstflg;
        private final String stdName;
        private final String dstName;

        private TimeZoneInfo(String iso, int off, int flg, String std, String dst) {
            this.isoName = iso;
            this.offset = off;
            this.dstflg = flg;
            this.stdName = std;
            this.dstName = dst;
        }
    }

    private static class Symbols {
        private final String[] meridiemName = new String[2];
        private char zeroDigit;

        private Symbols() {
        }
    }
}

