/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.lcdata.LcBundle;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class LcData {
    public static final int SUN = 0;
    public static final int MON = 1;
    public static final int TUE = 2;
    public static final int WED = 3;
    public static final int THU = 4;
    public static final int FRI = 5;
    public static final int SAT = 6;
    public static final int JAN = 0;
    public static final int FEB = 1;
    public static final int MAR = 2;
    public static final int APR = 3;
    public static final int MAY = 4;
    public static final int JUN = 5;
    public static final int JUL = 6;
    public static final int AUG = 7;
    public static final int SEP = 8;
    public static final int OCT = 9;
    public static final int NOV = 10;
    public static final int DEC = 11;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int BC = 0;
    public static final int AD = 1;
    public static final int DEFLT = 2;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MED = 2;
    public static final int SHORT = 3;
    public static final int NUMERIC = 0;
    public static final int CURRENCY = 1;
    public static final int PERCENT = 2;
    public static final int NUM_DECIMAL = 0;
    public static final int NUM_GROUPING = 1;
    public static final int NUM_PERCENT = 2;
    public static final int NUM_MINUS = 3;
    public static final int NUM_ZERO = 4;
    public static final int CUR_SYMBOL = 0;
    public static final int CUR_ISONAME = 1;
    public static final int CUR_DECIMAL = 2;
    public static final int DEFLT_FMT = 0;
    public static final int SHORT_FMT = 1;
    public static final int MED_FMT = 2;
    public static final int LONG_FMT = 3;
    public static final int FULL_FMT = 4;
    public static final int INTEGRAL_FMT = 0;
    public static final int DECIMAL_FMT = 1;
    public static final int CURRENCY_FMT = 2;
    public static final int PERCENT_FMT = 3;
    public static final int WITHOUT_RADIX = 0;
    public static final int WITHOUT_GROUPINGS = 0;
    public static final int WITH_GROUPINGS = 1;
    public static final int WITH_ZEDS = 0;
    public static final int WITH_EIGHTS = 2;
    public static final int WITH_RADIX = 4;
    public static final int KEEP_NINES = 8;
    public static final int WITHOUT_CATEGORIES = 0;
    public static final int WITH_CATEGORIES = 1;
    private static final int MAX_DBL_DIG = 18;
    private static final int MAX_INT_DIG = 10;
    private static final int MAX_DBL_WIDTH = 15;
    private static final String gpDateMask = "GYMD     EJFwW     ";
    private static final String gpTimeMask = "    KHMSF     AhkZz";
    private static final ThreadLocal<Map<String, LcRunTimeData>> mRuntimeMap = new ThreadLocal<Map<String, LcRunTimeData>>(){

        @Override
        protected Map<String, LcRunTimeData> initialValue() {
            return new HashMap<String, LcRunTimeData>();
        }
    };
    private static final String[] gLocaleList = new String[]{"ar", "ar_AE", "ar_BH", "ar_DZ", "ar_EG", "ar_IQ", "ar_JO", "ar_KW", "ar_LB", "ar_LY", "ar_MA", "ar_OM", "ar_QA", "ar_SA", "ar_SD", "ar_SY", "ar_TN", "ar_YE", "az", "az_AZ", "az_Cyrl", "az_Cyrl_AZ", "az_Latn", "az_Latn_AZ", "be", "be_BY", "bg", "bg_BG", "bs", "bs_BA", "c", "ca", "ca_ES", "cs", "cs_CZ", "da", "da_DK", "de", "de_AT", "de_BE", "de_CH", "de_DE", "de_LI", "de_LU", "el", "el_GR", "en", "en_AU", "en_BE", "en_CA", "en_GB", "en_GB_EURO", "en_HK", "en_IE", "en_IN", "en_IN_RUPEE", "en_NZ", "en_PH", "en_SG", "en_US", "en_US_POSIX", "en_VI", "en_ZA", "es", "es_AR", "es_BO", "es_CL", "es_CO", "es_CR", "es_DO", "es_EC", "es_ES", "es_GT", "es_HN", "es_MX", "es_NI", "es_PA", "es_PE", "es_PR", "es_PY", "es_SV", "es_US", "es_UY", "es_VE", "et", "et_EE", "eu", "eu_ES", "fa", "fa_IR", "fi", "fi_FI", "fr", "fr_BE", "fr_CA", "fr_CH", "fr_FR", "fr_LU", "he", "he_IL", "hi", "hi_IN", "hr", "hr_HR", "hu", "hu_HU", "hy", "hy_AM", "id", "id_ID", "is", "is_IS", "it", "it_CH", "it_IT", "ja", "ja_JP", "kk", "kk_KZ", "km", "km_KH", "ko", "ko_KR", "ko_KR_HANI", "lo", "lo_LA", "lt", "lt_LT", "lv", "lv_LV", "mk", "mk_MK", "ms", "ms_MY", "nb", "nb_NO", "nl", "nl_BE", "nl_NL", "nn", "nn_NO", "no", "no_NO", "no_NO_NY", "pl", "pl_PL", "pt", "pt_BR", "pt_PT", "ro", "ro_RO", "root", "ru", "ru_RU", "ru_UA", "sh", "sh_BA", "sh_CS", "sh_HR", "sk", "sk_SK", "sl", "sl_SI", "sq", "sq_AL", "sr", "sr_CS", "sr_Cyrl", "sr_Cyrl_CS", "sr_Latn", "sr_Latn_CS", "sv", "sv_FI", "sv_SE", "th", "th_TH", "th_TH_TH", "tl", "tl_PH", "tr", "tr_TR", "uk", "uk_UA", "vi", "vi_VN", "zh", "zh_CN", "zh_Hans", "zh_Hans_CN", "zh_Hans_SG", "zh_Hant", "zh_Hant_HK", "zh_Hant_TW", "zh_HK", "zh_SG", "zh_TW"};
    private static final Map<String, String>[] staticData = new Map[gLocaleList.length];
    private static final int[] staticParentIndex = new int[gLocaleList.length];
    private static final int numAliases = 6;
    private static final int[] aliasFromIndex = new int[6];
    private static final int[] aliasToIndex = new int[6];
    private static final int rootIndex = LcData.localeIndex("root");
    private final String msLocale;
    private final int mnIndex;
    private static final PropertyRetriever<String> retrieveWeekdayNameProperty;
    private static final PropertyRetriever<String> retrieveAbbrWeekdayNameProperty;
    private static final PropertyRetriever<String> retrieveMonthNameProperty;
    private static final PropertyRetriever<String> retrieveMonthAbbrNamesProperty;
    private static final PropertyRetriever<String> retrieveMeridiemNameProperty;
    private static final PropertyRetriever<String> retrieveEraNameProperty;
    private static final PropertyRetriever<String> retrieveDatePatternProperty;
    private static final PropertyRetriever<String> retrieveTimePatternProperty;
    private static final PropertyRetriever<String> retrieveDateTimeSymbolsProperty;
    private static final PropertyRetriever<String> retrieveDateTimeFormatProperty;
    private static final PropertyRetriever<String> retrieveNumberPatternProperty;
    private static final PropertyRetriever<String> retrieveCurrencySymbolProperty;
    private static final PropertyRetriever<String> retrieveNumericSymbolProperty;
    private static final PropertyRetriever<List<String>> retrieveTypefaceListProperty;

    public static final int withWidth(int width) {
        return width << 16;
    }

    public static final int withPrecision(int prec) {
        return (prec & 0xFF) << 8;
    }

    private static int localeIndex(String sLocaleName) {
        return Arrays.binarySearch(gLocaleList, sLocaleName, String.CASE_INSENSITIVE_ORDER);
    }

    private static void initParentIndex(String sLocaleName, int parentIndex) {
        int index = LcData.localeIndex(sLocaleName);
        LcData.staticParentIndex[index] = parentIndex;
    }

    private static void initScriptAlias(int index, String sLocaleName, String sRealLocaleName) {
        LcData.aliasFromIndex[index] = LcData.localeIndex(sLocaleName);
        LcData.aliasToIndex[index] = LcData.localeIndex(sRealLocaleName);
    }

    private static int mapLocaleIndexToAlias(int localeIndex) {
        for (int i = 0; i < 6; ++i) {
            if (aliasFromIndex[i] != localeIndex) continue;
            return aliasToIndex[i];
        }
        return localeIndex;
    }

    public LcData(String locale) {
        int localeIndex = LcData.localeIndex(locale);
        if (localeIndex >= 0) {
            locale = gLocaleList[localeIndex];
            localeIndex = LcData.mapLocaleIndexToAlias(localeIndex);
        } else {
            String sLocaleName = locale = LcLocale.normalize(locale);
            while (true) {
                if ((localeIndex = LcData.localeIndex(sLocaleName)) >= 0) {
                    localeIndex = LcData.mapLocaleIndexToAlias(localeIndex);
                    break;
                }
                if (localeIndex == -1) {
                    localeIndex = rootIndex;
                    break;
                }
                int delim = sLocaleName.lastIndexOf(95);
                if (delim == -1) {
                    localeIndex = rootIndex;
                    break;
                }
                sLocaleName = sLocaleName.substring(0, delim);
            }
        }
        assert (localeIndex >= 0);
        this.msLocale = locale;
        this.mnIndex = localeIndex;
    }

    private static Map<String, String> getStaticData(int staticDataIndex) {
        Map<String, String> result = staticData[staticDataIndex];
        if (result == null) {
            result = LcData.loadStaticData(gLocaleList[staticDataIndex]);
            assert (result != null);
            LcData.staticData[staticDataIndex] = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadStaticData(String sLocale) {
        if (sLocale.equals("root")) {
            sLocale = "";
        }
        String resourceName = "com/adobe/xfa/ut/lcdata/Locale" + (sLocale.length() == 0 ? "" : Character.valueOf('_')) + sLocale + ".properties";
        InputStream stream = LcData.class.getClassLoader().getResourceAsStream(resourceName);
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException ignored) {
            assert (false);
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException streamCantBeClosedException) {}
            stream = null;
        }
        HashMap<String, String> staticData = new HashMap<String, String>(properties.size());
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            staticData.put(key, (String)properties.get(key));
        }
        return staticData;
    }

    public String getLocale() {
        return this.msLocale;
    }

    public static boolean validate(LcRunTimeData oLcData) {
        String decimal = oLcData.numericSymbols[0];
        return decimal == null || !decimal.equals(oLcData.numericSymbols[2]);
    }

    public static void reset() {
        LcData.getMap().clear();
    }

    public static void update(LcRunTimeData oLcData) {
        Map<String, LcRunTimeData> map = LcData.getMap();
        map.put(oLcData.localeName, oLcData);
    }

    public static LcRunTimeData get(String sLocale) {
        LcRunTimeData oRunTimeData = LcData.getMap().get(sLocale);
        if (oRunTimeData == null) {
            oRunTimeData = new LcRunTimeData(sLocale);
        }
        return oRunTimeData;
    }

    public String getWeekDayName(int weekday) {
        if (weekday < 0 || weekday > 6) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(weekday, retrieveWeekdayNameProperty);
    }

    public String getAbbrWeekdayName(int weekday) {
        if (weekday < 0 || weekday > 6) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(weekday, retrieveAbbrWeekdayNameProperty);
    }

    public String getMonthName(int month) {
        if (month < 0 || month > 11) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(month, retrieveMonthNameProperty);
    }

    public String getAbbrMonthName(int month) {
        if (month < 0 || month > 11) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(month, retrieveMonthAbbrNamesProperty);
    }

    public String getMeridiemName(int aspect) {
        if (aspect < 0 || aspect > 1) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(aspect, retrieveMeridiemNameProperty);
    }

    public String getEraName(int era) {
        if (era < 0 || era > 1) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(era, retrieveEraNameProperty);
    }

    public String getDateFormat(int style) {
        if (style < 0 || style > 4) {
            style = 2;
        }
        if (style == 0) {
            style = 2;
        }
        return this.searchRuntimeThenStaticStore(4 - style, retrieveDatePatternProperty);
    }

    public String getTimeFormat(int style) {
        if (style < 0 || style > 4) {
            style = 2;
        }
        if (style == 0) {
            style = 2;
        }
        return this.searchRuntimeThenStaticStore(4 - style, retrieveTimePatternProperty);
    }

    public String getDateTimePattern() {
        return this.searchRuntimeThenStaticStore(0, retrieveDateTimeSymbolsProperty);
    }

    public String getDateTimeFormat(int style, int type) {
        if (style < 0 || 4 < style) {
            style = 2;
        }
        StringBuilder sDateTimeFmt = new StringBuilder(this.searchStaticStore(0, retrieveDateTimeFormatProperty));
        if (type == 0) {
            String sDateFmt = this.getDateFormat(style);
            String sTimeFmt = this.getTimeFormat(style);
            int nPat = sDateTimeFmt.indexOf("date{}");
            if (nPat >= 0) {
                sDateTimeFmt.replace(nPat, nPat + 6, sDateFmt);
            }
            if ((nPat = sDateTimeFmt.indexOf("time{}")) >= 0) {
                sDateTimeFmt.replace(nPat, nPat + 6, sTimeFmt);
            }
        } else if (type == 1) {
            String sDateFmt = this.getDateFormat(style);
            String sTimeFmt = this.getTimeFormat(style);
            int nPat = sDateTimeFmt.indexOf("date{}");
            if (nPat >= 0) {
                sDateTimeFmt.insert(nPat + 5, sDateFmt);
            }
            if ((nPat = sDateTimeFmt.indexOf("time{}")) >= 0) {
                sDateTimeFmt.insert(nPat + 5, sTimeFmt);
            }
        }
        return sDateTimeFmt.toString();
    }

    public String getLocalDateFormat(int style) {
        String date = this.getDateFormat(style);
        if (StringUtils.isEmpty(date)) {
            return "";
        }
        String pattern = this.getDateTimePattern();
        return LcData.xlate(date, pattern, gpDateMask);
    }

    public String getLocalTimeFormat(int style) {
        String time = this.getTimeFormat(style);
        if (StringUtils.isEmpty(time)) {
            return "";
        }
        String pattern = this.getDateTimePattern();
        return LcData.xlate(time, pattern, gpTimeMask);
    }

    public String getLocalDateTimeFormat() {
        return "";
    }

    public String getNumericFormat(int style) {
        if (style < 0 || style > 2) {
            assert (false);
            return "";
        }
        return this.searchRuntimeThenStaticStore(style, retrieveNumberPatternProperty);
    }

    public String getNumberFormat(int style, int option) {
        int nTrim;
        StringBuilder sFormat;
        int nBar;
        if (style < 0 || style > 3) {
            style = 1;
        }
        if ((nBar = (sFormat = new StringBuilder(this.getNumericFormat(style > 0 ? style - 1 : style))).indexOf("|")) >= 0) {
            sFormat.delete(0, nBar + 1);
        }
        String[] dotChars = new String[]{".", "v", "V", "E", " ", "%"};
        int nDot = -1;
        for (int i = 0; i < dotChars.length && (nDot = sFormat.indexOf(dotChars[i])) < 0; ++i) {
        }
        if (nDot < 0) {
            nDot = sFormat.length();
        } else if (StringUtils.skipOver(sFormat, "89zZ", nDot - 1) != 1) {
            nDot = sFormat.length();
        }
        StringBuilder sZZZ = new StringBuilder();
        int nZed = sFormat.indexOf("z,");
        if (nZed >= 0) {
            int nSep = nDot;
            int nComma = sFormat.indexOf(",", nZed + 2);
            if (nComma >= 0) {
                nSep = nComma;
            }
            if (nSep > nZed + 2) {
                int n = nSep - nZed - 1;
                for (int i = 1; i <= n; ++i) {
                    sZZZ.append('z');
                }
            } else {
                sZZZ.append('z');
            }
        } else {
            nZed = 0;
        }
        int nPrec = 0;
        int nWidth = 10;
        if (style != 0) {
            boolean trim;
            nPrec = option >> 8 & 0xFF;
            boolean bl = trim = (nPrec & 0x80) == 0;
            if ((nPrec &= 0x7F) == 127) {
                nPrec = StringUtils.skipOver(sFormat, "89zZ", nDot + 1);
            }
            nWidth = (option & 0xFF0000) != 0 ? option >> 16 & 0xFF : 18;
            if (sFormat.indexOf("s") >= 0) {
                ++nWidth;
            }
            if (sFormat.indexOf("(") >= 0) {
                ++nWidth;
            }
            if (sFormat.indexOf(")") >= 0) {
                ++nWidth;
            }
            int nFmtPrec = StringUtils.skipOver(sFormat, "89zZ", nDot + 1);
            if (0 < nPrec && nPrec < nFmtPrec) {
                nWidth += nFmtPrec - nPrec;
            }
            if (trim && nPrec > 0 && nWidth > nPrec) {
                if (nPrec <= sFormat.length() - 1 - nDot) {
                    nWidth += sFormat.length() - 1 - nDot - nPrec;
                }
                for (int i = nWidth - 1; i > 15 && nPrec > sFormat.length() - 1 - nDot; --nPrec, --i) {
                }
            }
        }
        if (style == 2) {
            if (sFormat.indexOf("$") >= 0) {
                ++nWidth;
            }
            if (sFormat.indexOf(" ") >= 0) {
                ++nWidth;
            }
        }
        if (style == 3) {
            nTrim = StringUtils.skipOver(sFormat, "89zZ", nDot + 1);
            if (nDot < sFormat.length()) {
                sFormat.replace(nDot + 1, nDot + 1 + nTrim, "");
            }
            if (sFormat.indexOf("%") >= 0) {
                ++nWidth;
            }
        } else if (style == 0 || nPrec == 0 && (option & 4) == 0) {
            nTrim = StringUtils.skipOver(sFormat, "89zZ", nDot + 1);
            if (nDot < sFormat.length()) {
                sFormat.replace(nDot, nDot + nTrim + 1, "");
            }
        } else if ((option & 2) == 2) {
            int nEight = nDot + 1;
            while ((nEight = sFormat.indexOf("z", nEight)) >= 0) {
                sFormat.setCharAt(nEight, '8');
            }
            while (sFormat.length() - nDot <= nPrec) {
                sFormat.insert(nDot + 1, '8');
            }
        } else if ((option & 2) == 0 && (option & 8) != 8) {
            int nNine = nDot + 1;
            while ((nNine = sFormat.indexOf("9", nNine)) >= 0) {
                sFormat.setCharAt(nNine, 'z');
            }
            while (sFormat.length() - nDot <= nPrec) {
                sFormat.insert(nDot + 1, 'z');
            }
        }
        if (StringUtils.isEmpty(sZZZ)) {
            sZZZ.append('z');
        } else if ((option & 1) == 0) {
            int nComma = nZed + 1;
            sFormat.setCharAt(nComma, 'z');
            while ((nComma = sFormat.indexOf(",", nComma)) >= 0 && nComma < nDot) {
                sFormat.setCharAt(nComma, '8');
            }
        } else if ((option & 1) == 1) {
            sZZZ.setCharAt(0, ',');
            nWidth += (nWidth + sZZZ.length()) / sZZZ.length();
        }
        while (sFormat.length() < nWidth) {
            sFormat.insert(nZed + 1, sZZZ);
        }
        return sFormat.toString();
    }

    public int getNumberPrecision(String sVal) {
        int nRadix = sVal.indexOf(this.getRadixSymbol());
        if (nRadix >= 0) {
            return sVal.length() - nRadix - 1;
        }
        return 0;
    }

    private <T> T searchRuntimeStore(int key, PropertyRetriever<T> retriever) {
        Map<String, LcRunTimeData> runtimeMap = mRuntimeMap.get();
        if (runtimeMap.size() == 0) {
            return null;
        }
        String sLocaleName = this.msLocale;
        int staticIndex = -1;
        while (true) {
            T value;
            LcRunTimeData lcData;
            if ((lcData = runtimeMap.get(sLocaleName)) != null && (value = retriever.retrieveRuntime(lcData, key)) != null) {
                return value;
            }
            if (staticIndex >= 0) {
                int parentIndex = staticParentIndex[staticIndex];
                if (parentIndex < 0) break;
                sLocaleName = gLocaleList[parentIndex];
                staticIndex = parentIndex;
                continue;
            }
            int delim = sLocaleName.lastIndexOf(95);
            if (delim == -1) {
                if (sLocaleName.equals("root")) break;
                sLocaleName = "root";
                staticIndex = rootIndex;
                continue;
            }
            staticIndex = LcData.localeIndex(sLocaleName = sLocaleName.substring(0, delim));
            if (staticIndex < 0) continue;
            staticIndex = LcData.mapLocaleIndexToAlias(staticIndex);
        }
        return null;
    }

    private <T> T searchStaticStore(int key, PropertyRetriever<T> retriever) {
        int staticDataIndex = this.mnIndex;
        do {
            Map<String, String> lcData;
            T value;
            if ((value = retriever.retrieveStatic(lcData = LcData.getStaticData(staticDataIndex), key)) == null) continue;
            return value;
        } while ((staticDataIndex = staticParentIndex[staticDataIndex]) != -1);
        assert (false);
        return null;
    }

    private <T> T searchRuntimeThenStaticStore(int key, PropertyRetriever<T> retriever) {
        T value = this.searchRuntimeStore(key, retriever);
        if (value != null) {
            return value;
        }
        return this.searchStaticStore(key, retriever);
    }

    public String getCurrencyName() {
        return this.searchRuntimeThenStaticStore(1, retrieveCurrencySymbolProperty);
    }

    public String getCurrencySymbol() {
        return this.searchRuntimeThenStaticStore(0, retrieveCurrencySymbolProperty);
    }

    public String getCurrencyRadix() {
        return this.searchRuntimeThenStaticStore(2, retrieveCurrencySymbolProperty);
    }

    public String getRadixSymbol() {
        return this.searchRuntimeThenStaticStore(0, retrieveNumericSymbolProperty);
    }

    public String getGroupingSymbol() {
        return this.searchRuntimeThenStaticStore(1, retrieveNumericSymbolProperty);
    }

    public String getPercentSymbol() {
        return this.searchRuntimeThenStaticStore(2, retrieveNumericSymbolProperty);
    }

    public List<String> getTypefaces() {
        List<String> typefaces = this.searchRuntimeThenStaticStore(0, retrieveTypefaceListProperty);
        if (typefaces == null) {
            typefaces = Collections.emptyList();
        }
        return typefaces;
    }

    public String getNegativeSymbol() {
        return this.searchRuntimeThenStaticStore(3, retrieveNumericSymbolProperty);
    }

    public String getZeroSymbol() {
        return this.searchRuntimeThenStaticStore(4, retrieveNumericSymbolProperty);
    }

    public String getPositiveSymbol() {
        return "+";
    }

    public static void getLocaleNames(List<String> oLocales) {
        oLocales.addAll(LcData.getMap().keySet());
        for (int i = 0; i < gLocaleList.length; ++i) {
            oLocales.add(gLocaleList[i]);
        }
    }

    public static String findMatchingLocale(String sCurrencySymbol, String sRadixSymbol, String sGroupingSymbol) {
        String dflt = LcLocale.getLocale();
        if (LcData.testMatchingLocale(dflt, sCurrencySymbol, sRadixSymbol, sGroupingSymbol)) {
            return dflt;
        }
        for (int i = 0; i < gLocaleList.length; ++i) {
            String locale = gLocaleList[i];
            if (!LcData.testMatchingLocale(locale, sCurrencySymbol, sRadixSymbol, sGroupingSymbol)) continue;
            return locale;
        }
        return "";
    }

    private static boolean testMatchingLocale(String locale, String sCurrencySymbol, String sRadixSymbol, String sGroupingSymbol) {
        LcData oData = new LcData(locale);
        if (!StringUtils.isEmpty(sCurrencySymbol) && !oData.getCurrencySymbol().equals(sCurrencySymbol)) {
            return false;
        }
        if (!StringUtils.isEmpty(sRadixSymbol) && !oData.getRadixSymbol().equals(sRadixSymbol)) {
            return false;
        }
        return StringUtils.isEmpty(sGroupingSymbol) || oData.getGroupingSymbol().equals(sGroupingSymbol);
    }

    private static String xlate(String pPat, String pLocal, String pMask) {
        StringBuilder sBuf = new StringBuilder();
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int nPatLen = pPat.length();
        for (int i = 0; i < nPatLen; ++i) {
            char c;
            char chr = pPat.charAt(i);
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    chrCnt = 0;
                    sBuf.append(chr);
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                } else {
                    sBuf.append(chr);
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    c = LcData.subXlate(prevChr, pLocal, pMask);
                    while (chrCnt-- > 0) {
                        sBuf.append(c);
                    }
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if ('a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        c = LcData.subXlate(prevChr, pLocal, pMask);
                        while (chrCnt-- > 0) {
                            sBuf.append(c);
                        }
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                c = LcData.subXlate(prevChr, pLocal, pMask);
                while (chrCnt-- > 0) {
                    sBuf.append(c);
                }
                if (chr == '?' || chr == '*' || chr == '+') {
                    sBuf.append(' ');
                } else {
                    sBuf.append(chr);
                }
                chrCnt = 0;
                prevChr = '\u0000';
                continue;
            }
            if (chr == '?' || chr == '*' || chr == '+') {
                sBuf.append(' ');
            } else {
                sBuf.append(chr);
            }
            prevChr = '\u0000';
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            sBuf.setLength(0);
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            char c = LcData.subXlate(prevChr, pLocal, pMask);
            while (chrCnt-- > 0) {
                sBuf.append(c);
            }
        }
        return sBuf.toString();
    }

    private static char subXlate(char c, String pPat, String pMask) {
        assert (pPat != null && pMask != null);
        assert (pPat.length() == pMask.length());
        if (c == ' ') {
            return c;
        }
        int index = pMask.indexOf(c);
        if (index >= 0) {
            return pPat.charAt(index);
        }
        return c;
    }

    private static final Map<String, LcRunTimeData> getMap() {
        return mRuntimeMap.get();
    }

    static {
        assert (rootIndex != -1);
        LcData.staticParentIndex[LcData.rootIndex] = -1;
        for (int i = 0; i < gLocaleList.length; ++i) {
            String sFollowingLocaleName;
            if (i == rootIndex) continue;
            String sLocaleName = gLocaleList[i];
            if (sLocaleName.indexOf(95) == -1) {
                LcData.staticParentIndex[i] = rootIndex;
            }
            for (int j = i + 1; j < gLocaleList.length && (sFollowingLocaleName = gLocaleList[j]).length() > sLocaleName.length() && sFollowingLocaleName.startsWith(sLocaleName) && sFollowingLocaleName.charAt(sLocaleName.length()) == '_'; ++j) {
                LcData.staticParentIndex[j] = i;
            }
        }
        LcData.initParentIndex("az_Cyrl", rootIndex);
        LcData.initParentIndex("sr_Latn", rootIndex);
        int index = 0;
        LcData.initScriptAlias(index++, "zh_CN", "zh_Hans_CN");
        LcData.initScriptAlias(index++, "zh_SG", "zh_Hans_SG");
        LcData.initScriptAlias(index++, "zh_HK", "zh_Hant_HK");
        LcData.initScriptAlias(index++, "zh_TW", "zh_Hant_TW");
        LcData.initScriptAlias(index++, "az_AZ", "az_Latn_AZ");
        LcData.initScriptAlias(index++, "sr_CS", "sr_Cyrl_CS");
        assert (index == 6);
        retrieveWeekdayNameProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.dayNames[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getLongDayProperty(key));
            }
        };
        retrieveAbbrWeekdayNameProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.abbrWeekdayNames[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getShortDayProperty(key));
            }
        };
        retrieveMonthNameProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.monthNames[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getLongMonthProperty(key));
            }
        };
        retrieveMonthAbbrNamesProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.abbrMonthNames[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getShortMonthProperty(key));
            }
        };
        retrieveMeridiemNameProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.meridiemNames[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getMeridiemProperty(key));
            }
        };
        retrieveEraNameProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.eraNames[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getEraProperty(key));
            }
        };
        retrieveDatePatternProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.datePatterns[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getDateFormatProperty(key));
            }
        };
        retrieveTimePatternProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.timePatterns[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getTimeFormatProperty(key));
            }
        };
        retrieveDateTimeSymbolsProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.dateTimeSymbols[0];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getDateTimeSymbolsProperty());
            }
        };
        retrieveDateTimeFormatProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return null;
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getDateTimeFormatProperty());
            }
        };
        retrieveNumberPatternProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.numberPatterns[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getNumberFormatProperty(key));
            }
        };
        retrieveCurrencySymbolProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.currencySymbols[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getCurrencySymbolProperty(key));
            }
        };
        retrieveNumericSymbolProperty = new PropertyRetriever<String>(){

            @Override
            public String retrieveRuntime(LcRunTimeData runtimeData, int key) {
                return runtimeData.numericSymbols[key];
            }

            @Override
            public String retrieveStatic(Map<String, String> staticData, int key) {
                return staticData.get(LcBundle.getNumericSymbolProperty(key));
            }
        };
        retrieveTypefaceListProperty = new PropertyRetriever<List<String>>(){

            @Override
            public List<String> retrieveRuntime(LcRunTimeData runtimeData, int key) {
                List<String> typefaces = runtimeData.typefaceList;
                return typefaces.size() == 0 ? null : typefaces;
            }

            @Override
            public List<String> retrieveStatic(Map<String, String> staticData, int key) {
                String sList = staticData.get(LcBundle.getTypefacesProperty());
                if (StringUtils.isEmpty(sList)) {
                    return null;
                }
                ArrayList<String> typefaceList = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(sList, ";");
                while (tokenizer.hasMoreTokens()) {
                    typefaceList.add(tokenizer.nextToken());
                }
                return typefaceList;
            }
        };
    }

    private static interface PropertyRetriever<T> {
        public T retrieveRuntime(LcRunTimeData var1, int var2);

        public T retrieveStatic(Map<String, String> var1, int var2);
    }

    public static class LcRunTimeData {
        public final String localeName;
        public final String[] monthNames = new String[12];
        public final String[] abbrMonthNames = new String[12];
        public final String[] dayNames = new String[7];
        public final String[] abbrWeekdayNames = new String[7];
        public final String[] meridiemNames = new String[2];
        public final String[] eraNames = new String[2];
        public final String[] datePatterns = new String[4];
        public final String[] timePatterns = new String[4];
        public final String[] dateTimeSymbols = new String[1];
        public final String[] numberPatterns = new String[3];
        public final String[] numericSymbols = new String[5];
        public final String[] currencySymbols = new String[3];
        public final List<String> typefaceList = new ArrayList<String>();

        public LcRunTimeData(String sLocaleName) {
            int index = LcData.localeIndex(sLocaleName);
            sLocaleName = index >= 0 ? gLocaleList[index] : LcLocale.normalize(sLocaleName);
            this.localeName = sLocaleName;
        }
    }
}

