/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.ut.UnitSpan;

public class TextPanel
extends TextFrame {
    private static final UnitSpan DEFAULT_SIZE = new UnitSpan(3, 72000);
    private UnitSpan moWidth;
    private UnitSpan moHeight;

    public TextPanel() {
        this.moWidth = DEFAULT_SIZE;
        this.moHeight = DEFAULT_SIZE;
    }

    public TextPanel(TextPanel oSource) {
        this.moWidth = oSource.moWidth;
        this.moHeight = oSource.moHeight;
    }

    public TextPanel(UnitSpan oWidth, UnitSpan oHeight) {
        this.moWidth = oWidth;
        this.moHeight = oHeight;
    }

    public void setWidth(UnitSpan oWidth) {
        if (oWidth == this.moWidth) {
            return;
        }
        this.moWidth = oWidth;
        this.reflowFromHere();
    }

    public UnitSpan getWidth() {
        return this.moWidth;
    }

    public void setHeight(UnitSpan oHeight) {
        if (oHeight == this.moHeight) {
            return;
        }
        this.moHeight = oHeight;
        this.reflowFromHere();
    }

    public UnitSpan getHeight() {
        return this.moHeight;
    }

    public void setDimensions(UnitSpan oWidth, UnitSpan oHeight) {
        if (oWidth == this.moWidth && oHeight == this.moHeight) {
            return;
        }
        this.moWidth = oWidth;
        this.moHeight = oHeight;
        this.reflowFromHere();
    }

    public void copyFrom(TextPanel oSource) {
        this.moWidth = oSource.moWidth;
        this.moHeight = oSource.moHeight;
    }

    @Override
    public UnitSpan minWidth() {
        return this.moWidth;
    }

    @Override
    public UnitSpan minHeight() {
        return this.moHeight;
    }

    @Override
    public UnitSpan maxWidth() {
        return this.moWidth;
    }

    @Override
    public UnitSpan maxHeight() {
        return this.moHeight;
    }

    @Override
    public TextFrame cloneFrame() {
        return new TextPanel(this);
    }
}

