/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.gfx.GFXModelContext;
import com.adobe.xfa.text.ABXY;
import com.adobe.xfa.text.DispChange;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispMapSet;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.FormatInfo;
import com.adobe.xfa.text.LineDesc;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextDrawInfo;
import com.adobe.xfa.text.TextLayout;
import com.adobe.xfa.text.TextNullFrame;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextSelection;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.UnitSpan;

public abstract class TextFrame
implements GFXModelContext {
    static final int LAYOUT_NORMAL = 0;
    static final int LAYOUT_INITIAL = 1;
    static final int LAYOUT_SUSPECT = 2;
    private static final Rect gDefaultExtent = Rect.ZERO;
    private TextSparseStream mpoStream;
    private TextPosn moStart;
    private CoordPair moXYOrigin = CoordPair.ZERO_ZERO;
    private UnitSpan moAMax = UnitSpan.ZERO;
    private UnitSpan moBMax = UnitSpan.ZERO;
    private Rect moExtent = gDefaultExtent;
    private final Storage<DispLineWrapped> moLines = new Storage();
    private int mnActualCombCells;
    private int meLayout = 0;
    private int meOldOrientation = 0;
    private boolean mbIsDirty;

    public TextFrame() {
    }

    public TextFrame(TextFrame oSource) {
        this.copyFrom(oSource);
    }

    public boolean alignVPoint() {
        return this.minHeight().value() < 0;
    }

    public boolean alignHPoint() {
        return this.minWidth().value() < 0;
    }

    public boolean unlimitedWidth() {
        return this.maxWidth().value() < 0;
    }

    public boolean unlimitedHeight() {
        return this.maxHeight().value() < 0;
    }

    public boolean isDirty() {
        return this.mbIsDirty;
    }

    public void setDirty(boolean bDirty) {
        this.mbIsDirty = bDirty;
    }

    public void gfxDraw(TextDrawInfo oDrawInfo) {
        Rect oInvalid = oDrawInfo.getInvalid();
        if (oInvalid.isDegenerate()) {
            UnitSpan oLarge = new UnitSpan(3, 0xFFFFFF);
            UnitSpan oLargeNeg = new UnitSpan(3, -16777215);
            if (this.unlimitedWidth()) {
                oInvalid.leftRight(oLargeNeg, oLarge);
            } else {
                oInvalid.leftRight(UnitSpan.ZERO, this.maxWidth());
            }
            if (this.unlimitedHeight()) {
                oInvalid.topBottom(oLargeNeg, oLarge);
            } else {
                oInvalid.topBottom(UnitSpan.ZERO, this.maxHeight());
            }
        }
        DrawParm oParm = new DrawParm(oDrawInfo);
        oParm.setInvalid(oInvalid);
        this.gfxDraw(oParm, UnitSpan.ZERO);
    }

    public void gfxDraw(GFXEnv poGfxEnv, Rect poInvalid, TextSelection poSelection, int eOpt) {
        TextDrawInfo oDrawInfo = new TextDrawInfo(poGfxEnv);
        if (poInvalid != null) {
            oDrawInfo.setInvalid(poInvalid);
        }
        oDrawInfo.setPrimary(poSelection);
        this.gfxDraw(oDrawInfo);
    }

    public void gfxDraw(GFXEnv poGfxEnv, Rect poInvalid, TextSelection poSelection) {
        this.gfxDraw(poGfxEnv, poInvalid, poSelection, 0);
    }

    public void gfxDraw(GFXEnv poGfxEnv, Rect poInvalid) {
        this.gfxDraw(poGfxEnv, poInvalid, null, 0);
    }

    public void gfxDraw(GFXEnv poGfxEnv) {
        this.gfxDraw(poGfxEnv, null, null, 0);
    }

    public TextLayout format(boolean bAllowCharGlyphs) {
        TextLayout poLayout = new TextLayout();
        for (int i = 0; i < this.moLines.size(); ++i) {
            this.getLine(i).compose(poLayout, bAllowCharGlyphs);
        }
        return poLayout;
    }

    public int getLayoutOrientation() {
        return this.display().getLayoutOrientation();
    }

    public void copyFrom(TextFrame oSource) {
        this.meLayout = oSource.meLayout;
        this.mbIsDirty = oSource.mbIsDirty;
    }

    public abstract UnitSpan minWidth();

    public abstract UnitSpan minHeight();

    public abstract UnitSpan maxWidth();

    public abstract UnitSpan maxHeight();

    public abstract TextFrame cloneFrame();

    TextSparseStream getStream() {
        return this.mpoStream;
    }

    void setStream(TextSparseStream poStream) {
        this.mpoStream = poStream;
    }

    TextPosn getStart() {
        return this.moStart;
    }

    void setStart(TextPosnBase oStart) {
        DispLineWrapped poLine;
        this.moStart = new TextPosn(oStart);
        this.moStart.position(1);
        if (this.moLines != null && this.moLines.size() > 0 && (poLine = this.getLine(0)).getPositionCount() > 0) {
            TextPosn oLineStart = poLine.getPosition(0).pp();
            if (this.moStart.stream() == oLineStart.stream() && this.moStart.index() >= oLineStart.index()) {
                oLineStart.copyFrom(this.moStart);
                oLineStart.tighten(true);
            }
        }
    }

    TextDisplay display() {
        assert (this.mpoStream != null);
        assert (this.mpoStream.display() != null);
        return this.mpoStream.display();
    }

    UnitSpan getAMax() {
        return this.moAMax;
    }

    UnitSpan getBMax() {
        return this.moBMax;
    }

    Rect getExtent() {
        return this.moExtent;
    }

    void setExtent(Rect oExtent) {
        this.moAMax = oExtent.right();
        this.moBMax = oExtent.bottom();
        this.moExtent = ABXY.toXY(this.getXYOrigin(), oExtent, this.getLayoutOrientation());
    }

    Rect runtimeExtent(boolean bExtended) {
        return this.xyFullExtent(bExtended);
    }

    CoordPair getXYOrigin() {
        return this.moXYOrigin;
    }

    int getActualCombCells() {
        return this.mnActualCombCells;
    }

    int getLayoutState() {
        return this.meLayout;
    }

    Rect preLayout(FormatInfo oFormatInfo) {
        Rect oOldExtent = Rect.ZERO;
        if (this.moLines.size() > 0) {
            oOldExtent = this.abSubExtent(0, this.moLines.size(), this.meOldOrientation, true);
        }
        switch (oFormatInfo.getChange().type()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                if (this.meLayout != 2) {
                    this.meLayout = 0;
                }
                this.mbIsDirty = true;
                break;
            }
            case 3: {
                if (this.mpoStream.getFrame(oFormatInfo.getSuspectFrameIndex()) != this) break;
                this.meLayout = 0;
                break;
            }
            default: {
                this.meLayout = 0;
                this.mbIsDirty = true;
            }
        }
        this.mnActualCombCells = this.combCells();
        if (this.mnActualCombCells > 0 || oFormatInfo.getJustH() == 11 || oFormatInfo.getJustH() == 12 || oFormatInfo.getJustH() == 13) {
            if (this.mnActualCombCells == 0) {
                this.mnActualCombCells = this.mpoStream.maxSize();
            }
            if (this.mnActualCombCells == 0) {
                this.mnActualCombCells = 1;
            }
        }
        return oOldExtent;
    }

    void postLayout(FormatInfo oFormatInfo, Rect oOldExtent, boolean bIsJustifyOnly) {
        int i;
        if (this.moLines.size() == 0) {
            return;
        }
        UnitSpan oWidth = UnitSpan.ZERO;
        UnitSpan oLinesHeight = UnitSpan.ZERO;
        boolean bRestrictWidth = false;
        boolean bIsHorizontalLayout = false;
        if (this.isOrientationHorizontal()) {
            if (this.enforceAlignmentWidth()) {
                oWidth = this.alignmentWidth();
                bRestrictWidth = true;
            } else if (!this.alignHPoint()) {
                oWidth = this.minWidth();
            }
            bIsHorizontalLayout = true;
        } else {
            if (this.enforceAlignmentHeight()) {
                oWidth = this.alignmentHeight();
                bRestrictWidth = true;
            } else if (!this.alignHPoint()) {
                oWidth = this.minHeight();
            }
            bIsHorizontalLayout = false;
        }
        int nLines = bIsJustifyOnly ? this.moLines.size() : oFormatInfo.getNewSize();
        for (int i2 = 0; i2 < nLines; ++i2) {
            DispLineWrapped poLine = this.getLine(i2);
            UnitSpan oRawWidth = poLine.getRawWidth();
            if (!bRestrictWidth && oRawWidth.gt(oWidth)) {
                oWidth = oRawWidth;
            }
            oLinesHeight = oLinesHeight.add(poLine.getBExtent());
        }
        if (!bRestrictWidth) {
            UnitSpan oMaxWidth;
            UnitSpan unitSpan = oMaxWidth = bIsHorizontalLayout ? this.maxWidth() : this.maxHeight();
            if (oMaxWidth.value() >= 0 && oWidth.gt(oMaxWidth)) {
                oWidth = oMaxWidth;
            }
        }
        UnitSpan oJustifyHeight = UnitSpan.ZERO;
        UnitSpan oOffsetY = UnitSpan.ZERO;
        if (this.alignVPoint()) {
            switch (oFormatInfo.getJustV()) {
                case 2: {
                    oOffsetY = oLinesHeight.divide(2);
                    oJustifyHeight = oOffsetY = new UnitSpan(oOffsetY.units(), -oOffsetY.value());
                    break;
                }
                case 3: {
                    oOffsetY = new UnitSpan(oLinesHeight.units(), -oLinesHeight.value());
                    break;
                }
                default: {
                    oJustifyHeight = oLinesHeight;
                    break;
                }
            }
        } else {
            oJustifyHeight = bIsHorizontalLayout ? (this.enforceAlignmentHeight() ? this.alignmentHeight() : this.minHeight()) : (this.enforceAlignmentWidth() ? this.alignmentWidth() : this.minWidth());
            UnitSpan oRoomLeft = oJustifyHeight.subtract(oLinesHeight);
            if (oRoomLeft.value() > 0) {
                switch (oFormatInfo.getJustV()) {
                    case 2: {
                        oOffsetY = oLinesHeight.divide(2);
                        break;
                    }
                    case 3: {
                        oOffsetY = oRoomLeft;
                    }
                }
            } else {
                oJustifyHeight = oLinesHeight;
            }
        }
        UnitSpan oOriginX = bIsHorizontalLayout ? UnitSpan.ZERO : oJustifyHeight;
        this.moXYOrigin = new CoordPair(oOriginX, this.moXYOrigin.y());
        for (i = 0; i < nLines; ++i) {
            DispLineWrapped poLine = this.getLine(i);
            if (i >= oFormatInfo.getOldSize() || oFormatInfo.getOld(i) != null) {
                poLine.justify(oWidth);
            }
            CoordPair oLineOrigin = new CoordPair(UnitSpan.ZERO, oOffsetY);
            oLineOrigin = ABXY.toXY(this.moXYOrigin, oLineOrigin, this.getLayoutOrientation());
            poLine.setXYOrigin(oLineOrigin);
            oOffsetY = poLine.getBMax();
        }
        Rect oExtent = this.abSubExtent(0, nLines);
        if (!this.adjustAndSetExtent(oLinesHeight, oExtent, oFormatInfo.getNewSize() > 1)) {
            oFormatInfo.setFits(false);
        }
        oFormatInfo.releaseOldLines();
        if (!oFormatInfo.isUpdate()) {
            for (i = 0; i < this.moLines.size(); ++i) {
                this.getLine(i).updateSubsettedChars();
            }
        }
        this.debugLines();
        this.meOldOrientation = this.getLayoutOrientation();
        this.moStart = this.getLine(0).getStartPosition();
    }

    UnitSpan subHeight(int nStart, int nEnd) {
        int nSafeEnd;
        int nMax = this.moLines.size();
        if (nMax == 0) {
            return UnitSpan.ZERO;
        }
        int nSafeStart = nStart;
        if (nSafeStart >= nMax) {
            nSafeStart = nMax - 1;
        }
        if ((nSafeEnd = nEnd) > nMax) {
            nSafeEnd = nMax;
        }
        if (nSafeEnd <= nSafeStart) {
            return UnitSpan.ZERO;
        }
        UnitSpan oStart = this.getLine(nSafeStart).getBMin();
        UnitSpan oEnd = this.getLine(nSafeEnd - 1).getBMax();
        return oEnd.subtract(oStart);
    }

    UnitSpan lineMinY(int nIndex) {
        if (nIndex >= this.moLines.size()) {
            return UnitSpan.ZERO;
        }
        return this.getLine(nIndex).getXYOrigin().y();
    }

    void debugLines() {
        TextContext context = this.getContext();
        if (context.debug()) {
            for (int i = 0; i < this.moLines.size(); ++i) {
                this.getLine(i).textDebug(i);
            }
        }
    }

    TextContext getContext() {
        return this.mpoStream.getContext();
    }

    DispMapSet getDisposableMaps() {
        return this.display().getDisposableMaps();
    }

    public void releaseDisposableMaps(DispMapSet poMaps) {
        this.display().releaseDisposableMaps(poMaps);
    }

    boolean isOrientationHorizontal() {
        return this.getLayoutOrientation() == 0;
    }

    boolean isOrientationVertical() {
        return this.getLayoutOrientation() != 0;
    }

    boolean isRTL(TextAttr poAttr) {
        return this.display().isRTL(poAttr);
    }

    boolean isIdeographic(TextAttr poAttr) {
        return this.display().isIdeographic(poAttr);
    }

    DispLineWrapped allocateWrappedLine(LineDesc oLineDesc) {
        DispLineWrapped poLine = this.getContext().allocateWrappedLine(this, oLineDesc);
        poLine.setVerticalOrientation(this.getLayoutOrientation() != 0);
        return poLine;
    }

    void releaseWrappedLine(DispLineWrapped poLine) {
        this.getContext().releaseWrappedLine(poLine);
    }

    int getLegacyLevel() {
        return this.display().getLegacyLevel();
    }

    public int getLineCount() {
        return this.moLines.size();
    }

    DispLineWrapped getLine(int nIndex) {
        return (DispLineWrapped)this.moLines.get(nIndex);
    }

    Storage<DispLineWrapped> getLines() {
        return this.moLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean gfxDraw(DrawParm oParm, UnitSpan oOffset) {
        boolean bFit = true;
        TextFrame poContext = this;
        GFXDriver poDriver = oParm.env().driverAttach(poContext);
        oParm.setDriver(poDriver);
        CoordPair oFrameOrigin = new CoordPair(UnitSpan.ZERO, oOffset);
        oParm.driver().pushOffset(true, oFrameOrigin);
        try {
            oFrameOrigin = new CoordPair(this.getXYOrigin().x(), oFrameOrigin.y());
            oParm.translate(oFrameOrigin, this.getLayoutOrientation());
            for (int i = 0; i < this.moLines.size(); ++i) {
                boolean bInvalidHasHeight;
                int oRound2;
                int oRound1;
                int nDiff;
                DispLineWrapped poLine = this.getLine(i);
                UnitSpan oBMin = poLine.getBMin();
                UnitSpan oBMax = poLine.getBMax();
                UnitSpan oBExtent = poLine.getBExtent();
                if (oParm.truncate() != null && oBMax.gt(oParm.truncateBMax()) && (nDiff = (oRound1 = UnitSpan.convertUnit(19, oBMax.units(), oBMax.value())) - (oRound2 = UnitSpan.convertUnit(19, oParm.truncateBMax().units(), oParm.truncateBMax().value()))) > 1) {
                    bFit = false;
                    break;
                }
                boolean bl = bInvalidHasHeight = oParm.invalid().height().value() > 0;
                if (bInvalidHasHeight) {
                    if (oBMin.gt(oParm.invalidBMax())) {
                        break;
                    }
                    if (oBMin.equals(oParm.invalidBMax()) && oBExtent.gt(UnitSpan.ZERO)) {
                        break;
                    }
                }
                if (!oBMax.gt(oParm.invalidBMin()) && (!oBMax.equals(oParm.invalidBMin()) || bInvalidHasHeight)) continue;
                bFit = poLine.gfxDraw(oParm) && bFit;
            }
        }
        finally {
            oParm.driver().popOffset();
            oParm.env().driverDetach(poContext);
        }
        oParm.setDriver(null);
        return bFit;
    }

    boolean isInsertAtEnd(DispChange oChange, int nLine) {
        if (oChange.type() != 1) {
            return false;
        }
        DispLineWrapped poLine = this.getLine(nLine);
        if (poLine.getStartBreak() == 2 || poLine.getStartBreak() == 1) {
            return false;
        }
        TextPosnBase oResult = new TextPosnBase();
        if (poLine.getCaretStartEnd(oChange.stream(), true, false, oResult) == 0) {
            return false;
        }
        return oChange.index() >= oResult.index();
    }

    public int combCells() {
        return 0;
    }

    boolean allowExtension() {
        return false;
    }

    boolean suppressWordWrap() {
        return false;
    }

    UnitSpan alignmentHeight() {
        return this.maxHeight();
    }

    boolean enforceAlignmentHeight() {
        return false;
    }

    UnitSpan alignmentWidth() {
        return this.minWidth();
    }

    boolean enforceAlignmentWidth() {
        return false;
    }

    boolean testFitSize() {
        return false;
    }

    boolean enforceDisplayExtent() {
        return false;
    }

    TextNullFrame isNullFrame() {
        return null;
    }

    protected void reflowFromHere() {
        if (this.mpoStream == null) {
            return;
        }
        TextDisplay poDisplay = this.mpoStream.display();
        if (poDisplay == null) {
            return;
        }
        poDisplay.updateToEnd(this.moStart.stream(), this.moStart.index());
    }

    private boolean adjustAndSetExtent(UnitSpan oHeight, Rect oABExtent, boolean bTestFit) {
        boolean bFit = true;
        if (!this.unlimitedWidth() && this.maxWidth().gt(oABExtent.width())) {
            oABExtent = oABExtent.leftRight(UnitSpan.ZERO, this.maxWidth());
        }
        if (!this.unlimitedHeight()) {
            boolean bForceExtent = this.enforceDisplayExtent();
            if (oHeight.lte(this.maxHeight())) {
                bForceExtent = true;
            } else if (bTestFit && this.testFitSize()) {
                bFit = false;
            }
            if (bForceExtent) {
                oABExtent = oABExtent.topBottom(UnitSpan.ZERO, this.maxHeight());
            }
        }
        this.setExtent(oABExtent);
        return bFit;
    }

    private Rect abSubExtent(int nStart, int nEnd) {
        return this.abSubExtent(nStart, nEnd, this.getLayoutOrientation(), false);
    }

    private Rect abSubExtent(int nStart, int nEnd, int eOrientation, boolean bExtended) {
        return this.subExtent(true, nStart, nEnd, this.getLayoutOrientation(), bExtended);
    }

    private Rect xyFullExtent(boolean bExtended) {
        return this.xySubExtent(0, this.moLines.size(), bExtended);
    }

    private Rect xySubExtent(int nStart, int nEnd, boolean bExtended) {
        return this.xySubExtent(nStart, nEnd, this.getLayoutOrientation(), bExtended);
    }

    private Rect xySubExtent(int nStart, int nEnd, int eOrientation, boolean bExtended) {
        return this.subExtent(false, nStart, nEnd, this.getLayoutOrientation(), bExtended);
    }

    private Rect subExtent(boolean bAB, int nStart, int nEnd, int eOrientation, boolean bExtended) {
        UnitSpan oLeft = UnitSpan.ZERO;
        UnitSpan oTop = UnitSpan.ZERO;
        UnitSpan oRight = UnitSpan.ZERO;
        UnitSpan oBottom = UnitSpan.ZERO;
        for (int i = nStart; i < nEnd; ++i) {
            DispLineWrapped poLine = this.getLine(i);
            if (poLine == null) continue;
            UnitSpan oAMin = poLine.getAMin();
            UnitSpan oAMax = poLine.getAMax(bExtended);
            if (oLeft == null) {
                oTop = bExtended ? poLine.getBMinExtended(false) : poLine.getBMin();
                oLeft = oAMin;
                oRight = oAMax;
            } else {
                if (oAMin.lt(oLeft)) {
                    oLeft = oAMin;
                }
                if (oAMax.gt(oRight)) {
                    oRight = oAMax;
                }
            }
            oBottom = bExtended ? poLine.getBMaxExtended(false) : poLine.getBMax();
        }
        Rect result = new Rect(oLeft, oTop, oRight, oBottom);
        if (!bAB) {
            result = ABXY.toXY(this.getXYOrigin(), result, eOrientation);
        }
        return result;
    }
}

