/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispPoint;
import com.adobe.xfa.text.DispRect;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;

class ABXY {
    ABXY() {
    }

    static CoordPair toXY(CoordPair oXYOrigin, CoordPair oAB, int eOrientation) {
        if (eOrientation == 0) {
            return oAB.add(oXYOrigin);
        }
        return new CoordPair(oXYOrigin.x().subtract(oAB.y()), oXYOrigin.y().add(oAB.x()));
    }

    static CoordPair toAB(CoordPair oXYOrigin, CoordPair oXY, int eOrientation) {
        if (eOrientation == 0) {
            return oXY.subtract(oXYOrigin);
        }
        return new CoordPair(oXY.y().subtract(oXYOrigin.y()), oXY.x().subtract(oXYOrigin.x()));
    }

    static Rect toXY(CoordPair oXYOrigin, Rect oAB, int eOrientation) {
        if (eOrientation == 0) {
            return oAB.add(oXYOrigin);
        }
        CoordPair oTL = ABXY.toXY(oXYOrigin, oAB.topLeft(), eOrientation);
        CoordPair oBR = ABXY.toXY(oXYOrigin, oAB.bottomRight(), eOrientation);
        return new Rect(oTL.x(), oTL.y(), oBR.x(), oBR.y());
    }

    static Rect toAB(CoordPair oXYOrigin, Rect oXY, int eOrientation) {
        if (eOrientation == 0) {
            return oXY.subtract(oXYOrigin);
        }
        CoordPair oTL = ABXY.toAB(oXYOrigin, oXY.topLeft(), eOrientation);
        CoordPair oBR = ABXY.toAB(oXYOrigin, oXY.bottomRight(), eOrientation);
        return new Rect(oTL.x(), oTL.y(), oBR.x(), oBR.y());
    }

    static DispRect toXY(CoordPair oXYOrigin, DispRect oAB, int eOrientation) {
        DispRect oResult = new DispRect(oAB);
        ABXY.toXY(oXYOrigin, eOrientation, oResult);
        return oResult;
    }

    static void toXY(CoordPair oXYOrigin, int eOrientation, DispRect oConvert) {
        float oOriginX = Units.toFloat(oXYOrigin.x());
        float oOriginY = Units.toFloat(oXYOrigin.y());
        if (eOrientation == 0) {
            oConvert.xMin += oOriginX;
            oConvert.yMin += oOriginY;
            oConvert.xMax += oOriginX;
            oConvert.yMax += oOriginY;
        } else {
            float oLeft = oConvert.xMin;
            oConvert.xMin = oOriginX - oConvert.yMax;
            oConvert.yMax = oOriginY + oConvert.xMax;
            oConvert.xMax = oOriginX - oConvert.yMin;
            oConvert.yMin = oOriginY + oLeft;
        }
    }

    static DispRect toAB(CoordPair oXYOrigin, DispRect oXY, int eOrientation) {
        DispRect oResult = new DispRect(oXY);
        ABXY.toAB(oXYOrigin, eOrientation, oResult);
        return oResult;
    }

    static void toAB(CoordPair oXYOrigin, int eOrientation, DispRect oConvert) {
        float oOriginX = Units.toFloat(oXYOrigin.x());
        float oOriginY = Units.toFloat(oXYOrigin.y());
        if (eOrientation == 0) {
            oConvert.xMin -= oOriginX;
            oConvert.yMin -= oOriginY;
            oConvert.xMax -= oOriginX;
            oConvert.yMax -= oOriginY;
        } else {
            float oLeft = oConvert.xMin;
            oConvert.xMin = oConvert.yMin - oOriginY;
            oConvert.yMin = oOriginX - oConvert.xMax;
            oConvert.xMax = oConvert.yMax - oOriginY;
            oConvert.yMax = oOriginY - oLeft;
        }
    }

    static DispPoint toXY(CoordPair oXYOrigin, DispPoint oAB, int eOrientation) {
        return ABXY.toXY(oXYOrigin, oAB.x, oAB.y, eOrientation);
    }

    static DispPoint toXY(CoordPair oXYOrigin, float oA, float oB, int eOrientation) {
        float oOriginX = Units.toFloat(oXYOrigin.x());
        float oOriginY = Units.toFloat(oXYOrigin.y());
        return eOrientation == 0 ? new DispPoint(oA + oOriginX, oB + oOriginY) : new DispPoint(oOriginX - oB, oOriginY + oA);
    }

    static DispPoint toAB(CoordPair oXYOrigin, DispPoint oXY, int eOrientation) {
        return ABXY.toAB(oXYOrigin, oXY.x, oXY.y, eOrientation);
    }

    static DispPoint toAB(CoordPair oXYOrigin, float oX, float oY, int eOrientation) {
        float oOriginX = Units.toFloat(oXYOrigin.x());
        float oOriginY = Units.toFloat(oXYOrigin.y());
        return eOrientation == 0 ? new DispPoint(oX - oOriginX, oY - oOriginY) : new DispPoint(oOriginX - oY, oX - oOriginY);
    }
}

