/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.datamatrixpmp;

import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixBaseCompactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixInfo;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixPadder;
import java.util.ArrayList;
import java.util.List;

class DataMatrixC40Compactor
extends DataMatrixBaseCompactor {
    static final CharacterSet[] basicSet = new CharacterSet[]{new CharacterSet(32, 3), new CharacterSet(48, 4), new CharacterSet(49, 5), new CharacterSet(50, 6), new CharacterSet(51, 7), new CharacterSet(52, 8), new CharacterSet(53, 9), new CharacterSet(54, 10), new CharacterSet(55, 11), new CharacterSet(56, 12), new CharacterSet(57, 13), new CharacterSet(65, 14), new CharacterSet(66, 15), new CharacterSet(67, 16), new CharacterSet(68, 17), new CharacterSet(69, 18), new CharacterSet(70, 19), new CharacterSet(71, 20), new CharacterSet(72, 21), new CharacterSet(73, 22), new CharacterSet(74, 23), new CharacterSet(75, 24), new CharacterSet(76, 25), new CharacterSet(77, 26), new CharacterSet(78, 27), new CharacterSet(79, 28), new CharacterSet(80, 29), new CharacterSet(81, 30), new CharacterSet(82, 31), new CharacterSet(83, 32), new CharacterSet(84, 33), new CharacterSet(85, 34), new CharacterSet(86, 35), new CharacterSet(87, 36), new CharacterSet(88, 37), new CharacterSet(89, 38), new CharacterSet(90, 39)};
    static final CharacterSet[] shift1Set = new CharacterSet[]{new CharacterSet(0, 0), new CharacterSet(1, 1), new CharacterSet(2, 2), new CharacterSet(3, 3), new CharacterSet(4, 4), new CharacterSet(5, 5), new CharacterSet(6, 6), new CharacterSet(7, 7), new CharacterSet(8, 8), new CharacterSet(9, 9), new CharacterSet(10, 10), new CharacterSet(11, 11), new CharacterSet(12, 12), new CharacterSet(13, 13), new CharacterSet(14, 14), new CharacterSet(15, 15), new CharacterSet(16, 16), new CharacterSet(17, 17), new CharacterSet(18, 18), new CharacterSet(19, 19), new CharacterSet(20, 20), new CharacterSet(21, 21), new CharacterSet(22, 22), new CharacterSet(23, 23), new CharacterSet(24, 24), new CharacterSet(25, 25), new CharacterSet(26, 26), new CharacterSet(27, 27), new CharacterSet(28, 28), new CharacterSet(29, 29), new CharacterSet(30, 30), new CharacterSet(31, 31)};
    static final CharacterSet[] shift2Set = new CharacterSet[]{new CharacterSet(33, 0), new CharacterSet(34, 1), new CharacterSet(35, 2), new CharacterSet(36, 3), new CharacterSet(37, 4), new CharacterSet(38, 5), new CharacterSet(39, 6), new CharacterSet(40, 7), new CharacterSet(41, 8), new CharacterSet(42, 9), new CharacterSet(43, 10), new CharacterSet(44, 11), new CharacterSet(45, 12), new CharacterSet(46, 13), new CharacterSet(47, 14), new CharacterSet(58, 15), new CharacterSet(59, 16), new CharacterSet(60, 17), new CharacterSet(61, 18), new CharacterSet(62, 19), new CharacterSet(63, 20), new CharacterSet(64, 21), new CharacterSet(91, 22), new CharacterSet(92, 23), new CharacterSet(93, 24), new CharacterSet(94, 25), new CharacterSet(95, 26)};
    static final CharacterSet[] shift3Set = new CharacterSet[]{new CharacterSet(96, 0), new CharacterSet(97, 1), new CharacterSet(98, 2), new CharacterSet(99, 3), new CharacterSet(100, 4), new CharacterSet(101, 5), new CharacterSet(102, 6), new CharacterSet(103, 7), new CharacterSet(104, 8), new CharacterSet(105, 9), new CharacterSet(106, 10), new CharacterSet(107, 11), new CharacterSet(108, 12), new CharacterSet(109, 13), new CharacterSet(110, 14), new CharacterSet(111, 15), new CharacterSet(112, 16), new CharacterSet(113, 17), new CharacterSet(114, 18), new CharacterSet(115, 19), new CharacterSet(116, 20), new CharacterSet(117, 21), new CharacterSet(118, 22), new CharacterSet(119, 23), new CharacterSet(120, 24), new CharacterSet(121, 25), new CharacterSet(122, 26), new CharacterSet(123, 27), new CharacterSet(124, 28), new CharacterSet(125, 29), new CharacterSet(126, 30), new CharacterSet(127, 31)};

    DataMatrixC40Compactor() {
    }

    void compact(char[] message) {
        int c40End;
        int jdx;
        int idx;
        this.m_codeWords.clear();
        this.m_valid = false;
        C40Encoding[] c40Encoding = new C40Encoding[message.length];
        int messageSize = message.length;
        for (idx = 0; idx < messageSize; ++idx) {
            int v = message[idx];
            boolean found = false;
            for (jdx = 0; jdx < basicSet.length && !found; ++jdx) {
                if (v != DataMatrixC40Compactor.basicSet[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.basicSet[jdx].codeValue);
                found = true;
            }
            for (jdx = 0; jdx < shift1Set.length && !found; ++jdx) {
                if (v != DataMatrixC40Compactor.shift1Set[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(0);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.shift1Set[jdx].codeValue);
                found = true;
            }
            for (jdx = 0; jdx < shift2Set.length && !found; ++jdx) {
                if (v != DataMatrixC40Compactor.shift2Set[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(1);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.shift2Set[jdx].codeValue);
                found = true;
            }
            for (jdx = 0; jdx < shift3Set.length && !found; ++jdx) {
                if (v != DataMatrixC40Compactor.shift3Set[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(2);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.shift3Set[jdx].codeValue);
                found = true;
            }
            if (found) continue;
            int v1 = v - 128;
            for (jdx = 0; jdx < basicSet.length && !found; ++jdx) {
                if (v1 != DataMatrixC40Compactor.basicSet[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(1);
                c40Encoding[idx].c40Value.add(30);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.basicSet[jdx].codeValue);
                found = true;
            }
            for (jdx = 0; jdx < shift1Set.length && !found; ++jdx) {
                if (v1 != DataMatrixC40Compactor.shift1Set[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(1);
                c40Encoding[idx].c40Value.add(30);
                c40Encoding[idx].c40Value.add(0);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.shift1Set[jdx].codeValue);
                found = true;
            }
            for (jdx = 0; jdx < shift2Set.length && !found; ++jdx) {
                if (v1 != DataMatrixC40Compactor.shift2Set[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(1);
                c40Encoding[idx].c40Value.add(30);
                c40Encoding[idx].c40Value.add(1);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.shift2Set[jdx].codeValue);
                found = true;
            }
            for (jdx = 0; jdx < shift3Set.length && !found; ++jdx) {
                if (v1 != DataMatrixC40Compactor.shift3Set[jdx].messageValue) continue;
                c40Encoding[idx] = new C40Encoding();
                c40Encoding[idx].messageValue = v;
                c40Encoding[idx].c40Value.add(1);
                c40Encoding[idx].c40Value.add(30);
                c40Encoding[idx].c40Value.add(2);
                c40Encoding[idx].c40Value.add(DataMatrixC40Compactor.shift3Set[jdx].codeValue);
                found = true;
            }
            if (found) continue;
        }
        ArrayList<Integer> textCodeWords = new ArrayList<Integer>();
        for (idx = 0; idx < messageSize; ++idx) {
            for (jdx = 0; jdx < c40Encoding[idx].c40Value.size(); ++jdx) {
                textCodeWords.add(c40Encoding[idx].c40Value.get(jdx));
            }
        }
        int c40Size = textCodeWords.size();
        if (c40Size < 3) {
            return;
        }
        for (c40End = messageSize - 1; c40Size % 3 != 0 && c40End > 0; --c40End) {
            c40Size -= c40Encoding[c40End].c40Value.size();
        }
        if (++c40End > 0) {
            this.m_codeWords.add(230);
        }
        for (idx = 0; idx < c40Size; idx += 3) {
            int value16 = (Integer)textCodeWords.get(idx) * 1600 + (Integer)textCodeWords.get(idx + 1) * 40 + (Integer)textCodeWords.get(idx + 2) + 1;
            this.m_codeWords.add(value16 / 256);
            this.m_codeWords.add(value16 % 256);
        }
        int tempSymbolSize = this.findSymbolSize(this.m_codeWords.size());
        if (tempSymbolSize < 0) {
            return;
        }
        int remainSymbolCodeWords = DataMatrixInfo.DATA_SYMBOLS[tempSymbolSize] - this.m_codeWords.size();
        int remainTextCodeWords = 0;
        for (idx = c40End; idx < messageSize; ++idx) {
            remainTextCodeWords += c40Encoding[idx].c40Value.size();
        }
        if (remainTextCodeWords == 0) {
            if (remainSymbolCodeWords > 0) {
                this.m_codeWords.add(254);
                DataMatrixPadder.addPadding(this.m_codeWords, tempSymbolSize);
                this.m_symbolSize = tempSymbolSize;
                this.m_valid = true;
            } else {
                this.m_symbolSize = tempSymbolSize;
                this.m_valid = true;
            }
        } else if (remainSymbolCodeWords == 1 && remainTextCodeWords == 1) {
            if (c40Encoding[c40End].messageValue < 128) {
                this.m_codeWords.add(c40Encoding[c40End].messageValue + 1);
                this.m_symbolSize = tempSymbolSize;
                this.m_valid = true;
            } else {
                this.m_codeWords.add(254);
                this.m_codeWords.add(235);
                this.m_codeWords.add(c40Encoding[c40End].messageValue - 127);
                this.m_symbolSize = this.findSymbolSize(this.m_codeWords.size());
                if (this.m_symbolSize == -1) {
                    return;
                }
                DataMatrixPadder.addPadding(this.m_codeWords, this.m_symbolSize);
                this.m_valid = true;
            }
        } else if (remainSymbolCodeWords == 2 && remainTextCodeWords == 1) {
            if (c40Encoding[c40End].messageValue < 128) {
                this.m_codeWords.add(254);
                this.m_codeWords.add(c40Encoding[c40End].messageValue + 1);
                this.m_symbolSize = tempSymbolSize;
                this.m_valid = true;
            } else {
                this.m_codeWords.add(254);
                this.m_codeWords.add(235);
                this.m_codeWords.add(c40Encoding[c40End].messageValue - 127);
                this.m_symbolSize = this.findSymbolSize(this.m_codeWords.size());
                if (this.m_symbolSize == -1) {
                    return;
                }
                DataMatrixPadder.addPadding(this.m_codeWords, this.m_symbolSize);
                this.m_valid = true;
            }
        } else if (remainSymbolCodeWords == 2 && remainTextCodeWords == 2) {
            int value16 = (Integer)textCodeWords.get(c40Size) * 1600 + (Integer)textCodeWords.get(c40Size + 1) * 40 + 0 + 1;
            this.m_codeWords.add(value16 / 256);
            this.m_codeWords.add(value16 % 256);
            this.m_symbolSize = tempSymbolSize;
            this.m_valid = true;
        } else {
            this.m_codeWords.add(254);
            for (idx = c40End; idx < messageSize; ++idx) {
                int v = c40Encoding[idx].messageValue;
                if (v > 127) {
                    v -= 128;
                    this.m_codeWords.add(235);
                }
                this.m_codeWords.add(v + 1);
            }
            this.m_symbolSize = this.findSymbolSize(this.m_codeWords.size());
            if (this.m_symbolSize == -1) {
                return;
            }
            DataMatrixPadder.addPadding(this.m_codeWords, this.m_symbolSize);
            this.m_valid = true;
        }
    }

    static class CharacterSet {
        int messageValue;
        int codeValue;

        CharacterSet(int messageValue, int codeValue) {
            this.messageValue = messageValue;
            this.codeValue = codeValue;
        }
    }

    static class C40Encoding {
        int messageValue;
        List<Integer> c40Value = new ArrayList<Integer>();

        C40Encoding() {
        }
    }
}

