/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.FormCalcUtil;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.PictureFmt;
import java.util.UUID;

final class BuiltinString {
    static final long QUINTILLION = 1000000000000000000L;
    static final String[] Ones = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};
    static final String[] Teens = new String[]{"Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    static final String[] Tens = new String[]{"Zero", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety", "Hundred"};
    static final String[] Thousands = new String[]{"Thousand", "Million", "Billion", "Trillion", "Quadrillion", "Quintillion"};
    static final String[] Ands = new String[]{"", "And "};
    static final String[] Dollars = new String[]{"Dollar"};
    static final String[] Cents = new String[]{"Cent"};
    static final String[] Comma = new String[]{""};
    static final String Hyphen = "-";
    static final String Space = " ";

    private BuiltinString() {
    }

    static void At(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s1 = oParser.getString(oArgSym[0]);
                String s2 = oParser.getString(oArgSym[1]);
                int nUniIndex = 0;
                int nChrIndex = s1.indexOf(s2);
                if (nChrIndex >= 0) {
                    for (int i = 0; i < s1.length() && nChrIndex != i; ++i) {
                        if (s1.codePointAt(i) > 65535) continue;
                        ++nUniIndex;
                    }
                    ++nUniIndex;
                }
                oRetSym = new CalcSymbol((double)nUniIndex);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Concat(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.limitExceptionArgs(oArgSym);
                try {
                    Builtins.limitAllNullArgs(oParser, oArgSym);
                    oRetSym = BuiltinString.computeCat(oParser, nArgs, oArgSym);
                }
                catch (CalcException e) {
                    oRetSym = new CalcSymbol();
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static CalcSymbol computeCat(CalcParser oParser, int nArgs, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block8: {
            oRetSym = null;
            try {
                StringBuilder s = new StringBuilder();
                block6: for (int i = 0; i < nArgs; ++i) {
                    switch (oArgSym[i].getType()) {
                        case 9: {
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            CalcSymbol pCat = BuiltinString.computeCat(oParser, oSym.length, oSym);
                            s.append(oParser.getString(pCat));
                            for (int j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                            continue block6;
                        }
                        case 1: {
                            continue block6;
                        }
                        default: {
                            s.append(oParser.getString(oArgSym[i]));
                        }
                    }
                }
                oRetSym = new CalcSymbol(s.toString());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block8;
                oParser.mbInThrow = true;
            }
        }
        return oRetSym;
    }

    static void Format(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block6: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 1, oArgSym);
                String m = oParser.getString(oArgSym[0]);
                String s = oParser.getString(oArgSym[1]);
                if (oParser.getActualType(oArgSym[1]).getType() == 1) {
                    s = null;
                }
                String l = oParser.msLocaleName;
                StringBuilder sFormat = new StringBuilder();
                try {
                    PictureFmt oPict = new PictureFmt(l);
                    oPict.format(s, m, sFormat);
                }
                catch (ExFull oException) {
                    String sErr = oException.toString();
                    if (sErr != null) {
                        throw new CalcException(sErr);
                    }
                    throw new CalcException();
                }
                oRetSym = new CalcSymbol(sFormat.toString());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block6;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Left(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block5: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int i;
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                int n = (int)oParser.getNumeric(oArgSym[1]);
                if (n < 0) {
                    n = 0;
                }
                if (n > s.length()) {
                    n = s.length();
                }
                int nUniChar = 0;
                for (i = 0; i < s.length() && nUniChar != n; ++i) {
                    if (s.codePointAt(i) > 65535) continue;
                    ++nUniChar;
                }
                oRetSym = new CalcSymbol(s.substring(0, i));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block5;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Len(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                int nUniChar = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if (s.codePointAt(i) > 65535) continue;
                    ++nUniChar;
                }
                oRetSym = new CalcSymbol(nUniChar);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Lower(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block5: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                StringBuilder s = new StringBuilder(oParser.getString(oArgSym[0]));
                for (int i = 0; i < s.length(); ++i) {
                    char n = s.charAt(i);
                    if ('@' < n && n < '[') {
                        s.setCharAt(i, (char)(n | 0x20));
                        continue;
                    }
                    if ('\u00bf' < n && n < '\u00d7' || '\u00d7' < n && n < '\u00df') {
                        s.setCharAt(i, (char)(n | 0x20));
                        continue;
                    }
                    if ('\uff20' >= n || n >= '\uff3b') continue;
                    s.setCharAt(i, (char)(n & 0xFFFFFFDF | 0x40));
                }
                oRetSym = new CalcSymbol(s.toString());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block5;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Ltrim(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int i;
                int cUni;
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                for (i = 0; i < s.length() && (Character.isWhitespace(cUni = s.codePointAt(i)) || Character.isSpaceChar(cUni)); i += cUni <= 65535 ? 1 : 2) {
                }
                oRetSym = new CalcSymbol(s.substring(i));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void NumFmt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String l = nArgs > 1 ? oParser.getString(oArgSym[1]) : oParser.msLocaleName;
                LcData data = new LcData(l);
                int o = LcData.withPrecision(-1) | 1;
                oRetSym = new CalcSymbol(data.getNumberFormat(n, o));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Parse(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block6: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 1, oArgSym);
                String m = oParser.getString(oArgSym[0]);
                String s = oParser.getString(oArgSym[1]);
                if (oArgSym[1].getType() == 1) {
                    s = null;
                }
                String l = oParser.msLocaleName;
                String sFormat = null;
                try {
                    PictureFmt oPict = new PictureFmt(l);
                    sFormat = oPict.parse(s, m, null);
                }
                catch (ExFull oException) {
                    String sErr = oException.toString();
                    if (sErr != null) {
                        throw new CalcException(sErr);
                    }
                    throw new CalcException();
                }
                oRetSym = sFormat == null ? new CalcSymbol() : new CalcSymbol(sFormat);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block6;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Replace(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 2, oArgSym);
                String str = oParser.getString(oArgSym[0]);
                String old = oParser.getString(oArgSym[1]);
                String rep = nArgs > 2 ? oParser.getString(oArgSym[2]) : "";
                StringBuilder s = new StringBuilder();
                int k = old.length();
                if (k > 0 && !old.equals(rep)) {
                    int i = 0;
                    while ((i = str.indexOf(old)) >= 0) {
                        s.append(str, 0, i);
                        s.append(rep);
                        str = str.substring(i += k);
                    }
                }
                s.append(str);
                oRetSym = new CalcSymbol(s.toString());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Right(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block7: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int i;
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                int n = (int)oParser.getNumeric(oArgSym[1]);
                int len = s.length();
                if (n > len) {
                    n = len;
                }
                if (n < 0) {
                    n = 0;
                }
                int nUniChar = 0;
                for (i = 0; i < s.length(); ++i) {
                    if (s.codePointAt(i) > 65535) continue;
                    ++nUniChar;
                }
                if (n > nUniChar) {
                    n = nUniChar;
                }
                n = nUniChar - n;
                nUniChar = 0;
                for (i = 0; i < s.length() && nUniChar != n; ++i) {
                    if (s.codePointAt(i) > 65535) continue;
                    ++nUniChar;
                }
                oRetSym = new CalcSymbol(s.substring(i));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block7;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Rtrim(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block5: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                int i = 0;
                while (i < s.length()) {
                    int cUni;
                    int k = i;
                    i += (cUni = s.codePointAt(i)) <= 65535 ? 1 : 2;
                    if (!Character.isWhitespace(cUni) && !Character.isSpaceChar(cUni)) continue;
                    int m = i;
                    for (int j = i; j < s.length(); j += (cUni = s.codePointAt(j)) <= 65535 ? 1 : 2) {
                        if (!Character.isWhitespace(cUni) && !Character.isSpaceChar(cUni)) break;
                        m = j;
                    }
                    if (m == s.length()) {
                        s = s.substring(0, k);
                        continue;
                    }
                    i = m;
                }
                oRetSym = new CalcSymbol(s);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block5;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Space(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = (int)oParser.getNumeric(oArgSym[0]);
                if (n < 0) {
                    n = 0;
                }
                char[] s = new char[n];
                for (int i = 0; i < n; ++i) {
                    s[i] = 32;
                }
                oRetSym = new CalcSymbol(new String(s));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    private static String dblToStr(double n, int w, int p) {
        StringBuilder oStr;
        block3: {
            int k;
            block2: {
                oStr = new StringBuilder(FormCalcUtil.dblToStr(n, p));
                FormCalcUtil.trimRadix(oStr);
                FormCalcUtil.trimSign(oStr);
                k = oStr.length();
                if (k >= w) break block2;
                for (int i = k; i < w; ++i) {
                    oStr.insert(0, ' ');
                }
                break block3;
            }
            if (k <= w) break block3;
            oStr.setLength(0);
            for (int i = 0; i < w; ++i) {
                oStr.append('*');
            }
        }
        return oStr.toString();
    }

    static void Str(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int p;
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double n = oParser.getNumeric(oArgSym[0]);
                int w = nArgs > 1 ? (int)oParser.getNumeric(oArgSym[1]) : 10;
                int n2 = p = nArgs > 2 ? (int)oParser.getNumeric(oArgSym[2]) : 0;
                if (w < 0) {
                    w = 10;
                }
                if (p < 0) {
                    p = 0;
                }
                oRetSym = new CalcSymbol(BuiltinString.dblToStr(n, w, p));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Stuff(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block7: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int i;
                int len;
                Builtins.minArgs(nArgs, 3);
                Builtins.maxArgs(nArgs, 4);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, 3, oArgSym);
                String str = oParser.getString(oArgSym[0]);
                int loc = (int)oParser.getNumeric(oArgSym[1]);
                if (--loc < 0) {
                    loc = 0;
                }
                if ((len = (int)oParser.getNumeric(oArgSym[2])) < 0) {
                    len = 0;
                }
                String ins = nArgs > 3 ? oParser.getString(oArgSym[3]) : "";
                int nUniChar = 0;
                int k = 0;
                for (i = 0; i < str.length() && nUniChar++ < loc; i += str.codePointAt(i) <= 65535 ? 1 : 2) {
                    k = i;
                }
                loc = nUniChar <= loc ? k : i;
                nUniChar = 0;
                for (i = loc; i < str.length() && nUniChar++ < len; i += str.codePointAt(i) <= 65535 ? 1 : 2) {
                }
                len = i - loc;
                StringBuilder s = new StringBuilder(str.substring(0, loc));
                s.append(ins);
                if (loc + len < str.length()) {
                    s.append(str, loc + len, str.length());
                }
                oRetSym = new CalcSymbol(s.toString());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block7;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Substr(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block6: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int i;
                int len;
                Builtins.minArgs(nArgs, 3);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String str = oParser.getString(oArgSym[0]);
                int loc = (int)oParser.getNumeric(oArgSym[1]);
                if (--loc < 0) {
                    loc = 0;
                }
                if ((len = (int)oParser.getNumeric(oArgSym[2])) < 0) {
                    len = 0;
                }
                int nUniChar = 0;
                int k = 0;
                for (i = 0; i < str.length() && nUniChar++ < loc; i += str.codePointAt(i) <= 65535 ? 1 : 2) {
                    k = i;
                }
                loc = nUniChar <= loc ? k : i;
                nUniChar = 0;
                for (i = loc; i < str.length() && nUniChar++ < len; i += str.codePointAt(i) <= 65535 ? 1 : 2) {
                }
                str = str.substring(loc, i);
                oRetSym = new CalcSymbol(str);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block6;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Uuid(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String u = UUID.randomUUID().toString();
                if (n == 0) {
                    StringBuilder sUuid = new StringBuilder(u);
                    int nDash = sUuid.indexOf(Hyphen);
                    while (nDash >= 0) {
                        sUuid.deleteCharAt(nDash);
                        nDash = sUuid.lastIndexOf(Hyphen);
                    }
                    u = sUuid.toString();
                }
                oRetSym = new CalcSymbol(u);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Upper(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block5: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                StringBuilder s = new StringBuilder(oParser.getString(oArgSym[0]));
                for (int i = 0; i < s.length(); ++i) {
                    char n = s.charAt(i);
                    if ('`' < n && n < '{') {
                        s.setCharAt(i, (char)(n & 0xFFFFFFDF));
                        continue;
                    }
                    if ('\u00df' < n && n < '\u00f7' || '\u00f7' < n && n < '\u00ff') {
                        s.setCharAt(i, (char)(n & 0xFFFFFFDF));
                        continue;
                    }
                    if ('\uff40' >= n || n >= '\uff5b') continue;
                    s.setCharAt(i, (char)(n & 0xFFFFFFBF | 0x20));
                }
                oRetSym = new CalcSymbol(s.toString());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block5;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    private static String wordnum(double n, int f) {
        long dollars;
        String sStr;
        int cents;
        if (Double.isNaN(n) || Double.isInfinite(n) || n < 0.0) {
            return "*********";
        }
        if (f < 0 || 2 < f) {
            f = 0;
        }
        if ((cents = (int)(((n = FormCalcUtil.strToDbl(sStr = FormCalcUtil.dblToStr(n, 2), false)) - (double)(dollars = (long)n)) * 100.0 + 0.5)) > 100) {
            ++dollars;
            cents -= 100;
        }
        if (cents > 100) {
            return "*********";
        }
        StringBuilder s = new StringBuilder();
        int thousands = Thousands.length;
        for (long div = 1000000000000000000L; div > 0L; div /= 1000L) {
            long number = dollars / div;
            int hundreds = (int)(number / 100L);
            int tens = (int)((number - (long)(hundreds * 100)) / 10L);
            int ones = (int)(number - (long)(hundreds * 100) - (long)(tens * 10));
            dollars -= number * div;
            if (hundreds > 0) {
                s.append(Ones[hundreds]);
                s.append(Space);
                s.append(Tens[10]);
                s.append(Space);
                if (tens > 0 || ones > 0) {
                    s.append(Ands[0]);
                }
            }
            if (tens > 0) {
                s.append(tens == 1 ? Teens[ones] : Tens[tens]);
                s.append(ones > 0 && tens != 1 ? Hyphen : Space);
            }
            if (ones > 0 && tens != 1) {
                if (tens > 0 && ones > 0) {
                    String o = Ones[ones];
                    s.append(Character.toLowerCase(o.charAt(0)));
                    s.append(o, 1, o.length());
                } else {
                    s.append(Ones[ones]);
                }
                s.append(Space);
            }
            if (--thousands < 0 || number <= 0L) continue;
            s.append(Thousands[thousands]);
            s.append(Comma[0]);
            s.append(Space);
        }
        if (n < 1.0) {
            s.append(Ones[0]);
            s.append(Space);
        }
        if (f == 0) {
            if (s.length() > 0) {
                s.setLength(s.length() - Space.length());
            }
        } else if (f == 1 || f == 2) {
            s.append(Dollars[0]);
            if ((int)n != 1) {
                s.append('s');
            }
            if (f == 2) {
                s.append(Space);
                s.append(Ands[1]);
                int tens = cents / 10;
                int ones = cents - tens * 10;
                if (tens > 0) {
                    s.append(tens == 1 ? Teens[ones] : Tens[tens]);
                }
                if (tens != 1) {
                    if (tens > 0 && ones > 0) {
                        String o = Ones[ones];
                        s.append(Hyphen);
                        s.append(Character.toLowerCase(o.charAt(1)));
                        s.append(o, 1, o.length());
                    } else if (tens == 0) {
                        s.append(Ones[ones]);
                    }
                }
                s.append(Space);
                s.append(Cents[0]);
                if ((double)cents != 1.0) {
                    s.append('s');
                }
            }
        }
        return s.toString();
    }

    static void WordNum(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]).trim();
                double n = FormCalcUtil.strToDbl(s, true);
                int f = nArgs > 1 ? (int)oParser.getNumeric(oArgSym[1]) : 0;
                oRetSym = new CalcSymbol(BuiltinString.wordnum(n, f));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }
}

