/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormInstanceManager;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.template.containers.SubformSet;
import com.adobe.xfa.ut.StringUtils;

public class FormSubformSet
extends SubformSet {
    private FormInstanceManager mInstanceManager;
    private boolean mbIsLayoutNode;

    public FormSubformSet(Element parent, Node prevSibling) {
        super(parent, prevSibling);
    }

    int getRelation() {
        ProtoableNode proto;
        int relation = -2144600064;
        if (this.hasProto() && (proto = this.getProto()).isPropertySpecified(XFA.RELATIONTAG, true, 0)) {
            relation = ((EnumValue)proto.getAttribute(XFA.RELATIONTAG)).getInt();
        }
        return relation;
    }

    boolean isValidSubformChild(String sName) {
        if (StringUtils.isEmpty(sName)) {
            return false;
        }
        String aName = sName.intern();
        if (this.hasProto()) {
            ProtoableNode proto = this.getProto();
            for (Node child = proto.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!child.isSameClass(XFA.SUBFORMTAG) || child.getName() != aName) continue;
                return true;
            }
        }
        return false;
    }

    FormSubform getSubformChild(String sName) {
        if (StringUtils.isEmpty(sName)) {
            return null;
        }
        String aName = sName.intern();
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            FormSubform formSubform;
            if (!(child instanceof FormSubform) || (formSubform = (FormSubform)child).getName() != aName) continue;
            return formSubform;
        }
        return null;
    }

    boolean isLayoutNode() {
        return this.mbIsLayoutNode;
    }

    void setLayoutNode() {
        this.mbIsLayoutNode = true;
    }

    @Override
    public boolean isSpecified(int eTag, boolean bCheckProtos, int nOccurrence) {
        FormInstanceManager manager;
        if (eTag == XFA.OCCURTAG && (manager = this.getInstanceManager()) != null) {
            return manager.isSpecified(eTag, bCheckProtos, nOccurrence);
        }
        return super.isSpecified(eTag, bCheckProtos, nOccurrence);
    }

    @Override
    public Element getElement(int eTag, boolean bPeek, int nOccurrence, boolean bReturnDefault, boolean bValidate) {
        FormInstanceManager manager;
        if (eTag == XFA.OCCURTAG && (manager = this.getInstanceManager()) != null) {
            return manager.getElement(eTag, bPeek, nOccurrence, bReturnDefault, bValidate);
        }
        return super.getElement(eTag, bPeek, nOccurrence, bReturnDefault, bValidate);
    }

    @Override
    public Node setElement(Node child, int eTag, int nOccurrence) {
        FormInstanceManager manager;
        if (eTag == XFA.OCCURTAG && (manager = this.getInstanceManager()) != null) {
            manager.setElement(child, eTag, nOccurrence);
        }
        return super.setElement(child, eTag, nOccurrence);
    }

    @Override
    public FormInstanceManager getInstanceManager() {
        return this.mInstanceManager;
    }

    void setInstanceManager(FormInstanceManager instanceManager) {
        this.mInstanceManager = instanceManager;
    }

    @Override
    protected int getInstanceIndex(DependencyTracker dependencyTrack) {
        if (this.mInstanceManager != null) {
            if (dependencyTrack != null) {
                dependencyTrack.addDependency(this.mInstanceManager);
            }
            return this.mInstanceManager.findIndex(this);
        }
        return 0;
    }

    @Override
    public void setInstanceIndex(int nMoveTo) {
        if (this.mInstanceManager != null) {
            int nIndex = this.mInstanceManager.findIndex(this);
            this.mInstanceManager.moveInstance(nIndex, nMoveTo, true);
        }
    }
}

