/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.dom.DocumentImpl;
import com.adobe.xfa.dom.ParentNode;
import com.adobe.xfa.dom.XFANodeHolder;

public class DOM {
    public static org.w3c.dom.Node attach(Node xfaNode) {
        return DOM.attachNode(xfaNode, false);
    }

    public static org.w3c.dom.Node attach(org.w3c.dom.Document document, Node xfaNode) {
        assert (document instanceof DocumentImpl);
        DocumentImpl documentImpl = (DocumentImpl)document;
        return documentImpl.attach(xfaNode);
    }

    private static XFANodeHolder attachNode(Node xfaNode, boolean recursive) {
        XFANodeHolder result = null;
        if (xfaNode instanceof Element.DualDomNode) {
            xfaNode = ((Element.DualDomNode)((Object)xfaNode)).getXmlPeer();
        }
        if (xfaNode instanceof Document) {
            Document xfaDoc = (Document)xfaNode;
            if (recursive) {
                result = new DocumentImpl(xfaDoc);
            } else {
                Node xfaDocChild;
                for (xfaDocChild = xfaDoc.getFirstXMLChild(); xfaDocChild != null && !(xfaDocChild instanceof Element); xfaDocChild = xfaDocChild.getNextXMLSibling()) {
                }
                if (xfaDocChild == null) {
                    return null;
                }
                XFANodeHolder docElement = DOM.attachNode(xfaDocChild, true);
                result = docElement.getDocument();
            }
        } else {
            Element xfaParent = XFANodeHolder.getXFAParent(xfaNode);
            if (xfaParent == null) {
                return null;
            }
            XFANodeHolder parent = DOM.attachNode(xfaParent, true);
            if (parent == null) {
                return null;
            }
            assert (parent instanceof ParentNode);
            ParentNode parentNode = (ParentNode)parent;
            result = XFANodeHolder.createNode(parentNode, xfaNode);
            parentNode.setOnlyChild(result);
        }
        return result;
    }
}

