/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.Chars;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.data.DataWindow;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataTransformations {
    private static final Pattern whitespaceDelimitedToken = Pattern.compile("\\s*([^\\s]+)\\s*");
    private final List<Transformation> mTransformations = new ArrayList<Transformation>();
    private final List<Transformation> mNodeTransformations = new ArrayList<Transformation>();
    private String msCurNodeName;
    private String msCurGroupName = "";
    private final BitSet msCurGroupAvailable = new BitSet();
    private Element mCurGroupNode;
    private DataNode mLastParent;

    DataTransformations() {
    }

    void add(String sTransformations) {
        this.mTransformations.add(new Transformation(sTransformations));
    }

    private List<DataNode> getDataValues(DataNode dataValue) {
        ArrayList<DataNode> dataValues = new ArrayList<DataNode>();
        return this.getDataValues(dataValue, dataValues);
    }

    private List<DataNode> getDataValues(DataNode dataValue, List<DataNode> dataValues) {
        if (dataValue.getFirstXFAChild() == null) {
            dataValues.add(dataValue);
        } else {
            for (Node child = dataValue.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                this.getDataValues((DataNode)child, dataValues);
            }
        }
        return dataValues;
    }

    int getOperation(String aNodeName, int eOpType) {
        int eOperation = 0;
        this.getTransformations(aNodeName);
        block5: for (int i = 0; i < this.mNodeTransformations.size(); ++i) {
            int ePrevOperation = eOperation;
            eOperation = this.mNodeTransformations.get(i).getOperation(eOpType);
            switch (eOpType) {
                case 1076494336: {
                    eOperation = this.getOverridingOperation(ePrevOperation, eOperation);
                    continue block5;
                }
                case 1077870592: {
                    if (ePrevOperation == 1077870594 && eOperation == 1077870593 || ePrevOperation == 1077870593 && eOperation == 1077870594) {
                        eOperation = 1077870592;
                        continue block5;
                    }
                    eOperation = this.getOverridingOperation(ePrevOperation, eOperation);
                    continue block5;
                }
                case 1075314688: {
                    int eOverridingOperation = this.getOverridingOperation(ePrevOperation, eOperation);
                    if (eOverridingOperation != 1075314688 && eOverridingOperation != 1075314689) continue block5;
                    eOperation = eOverridingOperation;
                }
            }
        }
        return eOperation;
    }

    String getMapName(String aNodeName) {
        this.getTransformations(aNodeName);
        int nTrans = this.mNodeTransformations.size();
        String sNewName = "";
        boolean bFound = false;
        if (nTrans > 0) {
            String sGlobalName = "";
            for (int i = 0; i < nTrans; ++i) {
                Transformation transformation = this.mNodeTransformations.get(i);
                if (!transformation.hasMapName()) continue;
                String sNodeNameList = transformation.getNodeNameList();
                if (this.matchName(sNodeNameList, aNodeName)) {
                    sNewName = transformation.getMapName();
                    bFound = true;
                    break;
                }
                if (!StringUtils.isEmpty(sNodeNameList)) continue;
                sGlobalName = transformation.getMapName();
            }
            if (!bFound) {
                sNewName = sGlobalName;
            }
        }
        return sNewName.intern();
    }

    private int getOperationPrecedence(int eOperation) {
        switch (eOperation) {
            case 0x220002: {
                return 0;
            }
            case 0x220000: {
                return 1;
            }
            case 0x220001: {
                return 2;
            }
            case 0x220003: {
                return 3;
            }
            case 1077870596: {
                return 0;
            }
            case 1077870593: {
                return 1;
            }
            case 1077870594: {
                return 1;
            }
            case 1077870592: {
                return 2;
            }
            case 1077870595: {
                return 3;
            }
            case 1075314690: {
                return 0;
            }
            case 1075314691: {
                return 0;
            }
            case 1075314688: {
                return 1;
            }
            case 1075314689: {
                return 2;
            }
        }
        return -1;
    }

    private int getOverridingOperation(int ePrevOperation, int eOperation) {
        int nPrecedence;
        int nPrevPrecedence = this.getOperationPrecedence(ePrevOperation);
        return nPrevPrecedence > (nPrecedence = this.getOperationPrecedence(eOperation)) ? ePrevOperation : eOperation;
    }

    private void getTransformations(String sNodeName) {
        if (!sNodeName.equals(this.msCurNodeName)) {
            this.msCurNodeName = null;
            this.mNodeTransformations.clear();
            for (int i = 0; i < this.mTransformations.size(); ++i) {
                Transformation transformation = this.mTransformations.get(i);
                String sNodeNameList = transformation.getNodeNameList();
                if (StringUtils.isEmpty(sNodeNameList)) {
                    this.mNodeTransformations.add(transformation);
                    continue;
                }
                if (!this.matchName(sNodeNameList, sNodeName)) continue;
                transformation.setIndex(i);
                this.mNodeTransformations.add(transformation);
            }
            if (this.mNodeTransformations.size() > 0) {
                this.msCurNodeName = sNodeName;
            }
        }
    }

    private DataNode insertGroupParent(DataNode node, DataNode groupNode, String sCurList, String sParentList, int nLevel) {
        int nFoundAt = sParentList.indexOf(46);
        if (nFoundAt >= 0) {
            String sCurRest = "";
            String sCurRoot = "";
            String sTheRest = sParentList.substring(nFoundAt + 1);
            String sTheRoot = sParentList.substring(0, nFoundAt);
            nFoundAt = sCurList.indexOf(46);
            if (nFoundAt >= 0) {
                sCurRest = sCurList.substring(nFoundAt + 1);
                sCurRoot = sCurList.substring(0, nFoundAt);
            }
            if (sTheRoot.equals(sCurRoot)) {
                Node lastXFAChild = null;
                for (Node child = groupNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    lastXFAChild = child;
                }
                groupNode.appendChild(node);
                groupNode = (DataNode)lastXFAChild;
                groupNode = this.insertGroupParent(node, groupNode, sCurRest, sTheRest, nLevel + 1);
            } else {
                groupNode = this.insertGroupParent(node, groupNode, "", sTheRest, nLevel + 1);
                DataNode parentNode = (DataNode)node.getModel().createNode(XFA.DATAGROUPTAG, null, sTheRoot.intern(), null, true);
                groupNode.getXFAParent().insertChild(parentNode, groupNode, true);
                parentNode.appendChild(groupNode, true);
                groupNode = parentNode;
                if (nLevel == 0) {
                    this.mLastParent = groupNode;
                }
            }
        } else {
            groupNode = (DataNode)node.getModel().createNode(XFA.DATAGROUPTAG, null, sParentList.intern(), null, true);
            node.getXFAParent().insertChild(groupNode, node, true);
            groupNode.appendChild(node, true);
            this.mCurGroupNode = groupNode;
            if (nLevel == 0) {
                this.mLastParent = groupNode;
            }
        }
        return groupNode;
    }

    private DataNode applyGroupParent(DataNode node, String sNodeName) {
        this.getTransformations(sNodeName);
        int nTrans = this.mNodeTransformations.size();
        boolean bFound = false;
        boolean bAvailable = false;
        int nCurrent = 0;
        if (nTrans > 0) {
            String sGroupName;
            Transformation transformation;
            int i;
            if (nTrans > 1) {
                for (i = 0; i < nTrans; ++i) {
                    transformation = this.mNodeTransformations.get(i);
                    if (!transformation.hasGroupParent() || !(sGroupName = transformation.getGroupName(this.mTransformations, transformation.getIndex())).equals(this.msCurGroupName)) continue;
                    nCurrent = i;
                }
            }
            i = nCurrent;
            while (i < nTrans) {
                transformation = this.mNodeTransformations.get(i);
                if (transformation.hasGroupParent()) {
                    String sNodeNameList = transformation.getNodeNameList();
                    sGroupName = transformation.getGroupName(this.mTransformations, transformation.getIndex());
                    int index = 0;
                    int count = 0;
                    StringTokenizer tokenizer = new StringTokenizer(sNodeNameList, " ");
                    while (tokenizer.hasMoreTokens()) {
                        String sOneName = tokenizer.nextToken();
                        if (sOneName.equals(sNodeName)) {
                            bFound = true;
                            index = count;
                            if (!sGroupName.equals(this.msCurGroupName) || this.msCurGroupAvailable.get(index)) {
                                bAvailable = true;
                                break;
                            }
                        }
                        ++count;
                    }
                    if (bFound) {
                        if (bAvailable && sGroupName.equals(this.msCurGroupName)) {
                            this.mCurGroupNode.appendChild(node);
                        } else {
                            this.insertGroupParent(node, this.mLastParent, this.msCurGroupName, sGroupName, 0);
                            int j = 0;
                            StringTokenizer tokenizer2 = new StringTokenizer(sNodeNameList, " ");
                            while (tokenizer2.hasMoreTokens()) {
                                tokenizer2.nextToken();
                                ++j;
                            }
                            this.msCurGroupAvailable.set(0, j);
                            this.msCurGroupName = sGroupName;
                        }
                        this.msCurGroupAvailable.clear(index);
                        break;
                    }
                }
                if (nCurrent != 0) {
                    i = 0;
                    nCurrent = 0;
                    continue;
                }
                ++i;
            }
        }
        return node;
    }

    String getNameAttr(String aNodeName) {
        String sNameAttr = "";
        boolean bFound = false;
        this.getTransformations(aNodeName);
        int nTrans = this.mNodeTransformations.size();
        if (nTrans > 0) {
            String sGlobalName = "";
            for (int i = 0; i < nTrans; ++i) {
                Transformation transformation = this.mNodeTransformations.get(i);
                if (!transformation.hasNameAttr()) continue;
                String sNodeNameList = transformation.getNodeNameList();
                if (this.matchName(sNodeNameList, aNodeName)) {
                    bFound = true;
                    sNameAttr = transformation.getNameAttr();
                    break;
                }
                if (!StringUtils.isEmpty(sNodeNameList)) continue;
                sGlobalName = transformation.getNameAttr();
            }
            if (!bFound) {
                sNameAttr = sGlobalName;
            }
        }
        return sNameAttr.intern();
    }

    String getPictureFormat(String aNodeName) {
        String sPictureFormat = "";
        boolean bFound = false;
        this.getTransformations(aNodeName);
        int nTrans = this.mNodeTransformations.size();
        if (nTrans > 0) {
            String sGlobalPictureFormat = "";
            for (int i = 0; i < nTrans; ++i) {
                Transformation transformation = this.mNodeTransformations.get(i);
                if (!transformation.hasPictureFormat()) continue;
                String sNodeNameList = transformation.getNodeNameList();
                if (this.matchName(sNodeNameList, aNodeName)) {
                    bFound = true;
                    sPictureFormat = transformation.getPictureFormat();
                    break;
                }
                if (!StringUtils.isEmpty(sNodeNameList)) continue;
                sGlobalPictureFormat = transformation.getPictureFormat();
            }
            if (!bFound) {
                sPictureFormat = sGlobalPictureFormat;
            }
        }
        return sPictureFormat;
    }

    private void ignore(DataNode node) {
        DataModel dataModel;
        DataWindow dataWindow;
        if (node.getClassTag() == XFA.DATAGROUPTAG && (dataWindow = (dataModel = (DataModel)node.getModel()).getDataWindow()) != null) {
            dataWindow.removeRecordGroup(node);
        }
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            this.ignore((DataNode)child);
        }
        node.getXmlPeer().setXfaPeer(null);
        node.setXmlPeer(null);
        node.remove();
    }

    private void remove(DataNode node) {
        DataModel dataModel;
        DataWindow dataWindow;
        if (node.getClassTag() == XFA.DATAGROUPTAG && (dataWindow = (dataModel = (DataModel)node.getModel()).getDataWindow()) != null) {
            dataWindow.removeRecordGroup(node);
        }
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            this.remove((DataNode)child);
        }
        node.remove();
    }

    private void ltrim(List<DataNode> dataValues) {
        for (int i = 0; i < dataValues.size(); ++i) {
            DataNode dataValue = dataValues.get(i);
            Node peer = dataValue.getXmlPeer();
            if (!(peer instanceof Chars) || !((Chars)peer).isXMLSpace()) {
                String sValue = dataValue.getValue();
                sValue = sValue == null ? "" : StringUtils.trimStart(sValue);
                dataValue.setValue(sValue, true);
                return;
            }
            dataValue.setValue("", true);
        }
    }

    private void rtrim(List<DataNode> dataValues) {
        for (int i = dataValues.size(); i > 0; --i) {
            DataNode dataValue = dataValues.get(i - 1);
            Node peer = dataValue.getXmlPeer();
            if (!(peer instanceof Chars) || !((Chars)peer).isXMLSpace()) {
                String sValue = dataValue.getValue();
                sValue = sValue == null ? "" : StringUtils.trim(sValue);
                dataValue.setValue(sValue, true);
                return;
            }
            dataValue.setValue("", true);
        }
    }

    private void normalize(List<DataNode> dataValues) {
        boolean bPrevNodeEndsWithWS = true;
        for (int i = 0; i < dataValues.size(); ++i) {
            DataNode dataValue = dataValues.get(i);
            String sNodeValue = dataValue.getValue();
            if (StringUtils.isEmpty(sNodeValue)) continue;
            boolean bNodeStartsWithWS = Character.isWhitespace(sNodeValue.charAt(0));
            boolean bNodeEndsWithWS = Character.isWhitespace(sNodeValue.charAt(sNodeValue.length() - 1));
            Matcher matcher = whitespaceDelimitedToken.matcher(sNodeValue);
            if (matcher.lookingAt()) {
                StringBuilder sResult = new StringBuilder();
                if (bNodeStartsWithWS && !bPrevNodeEndsWithWS) {
                    sResult.append(' ');
                }
                sResult.append(matcher.group(1));
                matcher.region(matcher.end(), matcher.regionEnd());
                while (matcher.lookingAt()) {
                    sResult.append(' ');
                    sResult.append(matcher.group(1));
                    matcher.region(matcher.end(), matcher.regionEnd());
                }
                if (bNodeEndsWithWS) {
                    sResult.append(' ');
                }
                dataValue.setValue(sResult.toString(), true);
                bPrevNodeEndsWithWS = bNodeEndsWithWS;
                continue;
            }
            dataValue.setValue("", true);
        }
    }

    private boolean matchName(String sNodeNameList, String sNodeName) {
        StringTokenizer tokenizer = new StringTokenizer(sNodeNameList, " ");
        while (tokenizer.hasMoreTokens()) {
            if (!tokenizer.nextToken().equals(sNodeName)) continue;
            return true;
        }
        return false;
    }

    DataNode transform(DataNode node) {
        String aNodeName = node.getName();
        if (aNodeName != "") {
            this.performOperation(node, this.getOperation(aNodeName, 1077870592));
            node = this.performOperation(node, this.getOperation(aNodeName, 1075314688));
            node = this.applyGroupParent(node, aNodeName);
        }
        return node;
    }

    private DataNode toDataGroup(DataNode node) {
        Element parent = node.getXFAParent();
        Node xmlNode = node.getXmlPeer();
        xmlNode.setXfaPeer(null);
        node.setXmlPeer(null);
        DataNode dataGroup = new DataNode(parent, null, null, null, null, null);
        dataGroup.setXmlPeer(xmlNode);
        xmlNode.setXfaPeer(dataGroup);
        node.remove();
        return dataGroup;
    }

    private DataNode toDataValue(DataNode node) {
        DataWindow dataWindow;
        Element parent = node.getXFAParent();
        DataModel dataModel = (DataModel)node.getModel();
        if (node.getClassTag() == XFA.DATAGROUPTAG && (dataWindow = dataModel.getDataWindow()) != null) {
            dataWindow.removeRecordGroup(node);
        }
        Node oDomNode = node.getXmlPeer();
        node.setXmlPeer(null);
        oDomNode.setXfaPeer(null);
        DataNode dataValue = (DataNode)dataModel.getSchema().getInstance(XFA.DATAVALUETAG, dataModel, parent, null, false);
        dataValue.setXmlPeer(oDomNode);
        oDomNode.setXfaPeer(dataValue);
        node.remove();
        return dataValue;
    }

    private DataNode performOperation(DataNode node, int eOperation) {
        if (eOperation == 0) {
            return node;
        }
        boolean bIsRoot = node.getClassTag() == XFA.DATAGROUPTAG && node.getXFAParent() instanceof DataModel;
        boolean bIsDataValue = node.getClassTag() == XFA.DATAVALUETAG;
        boolean bIsEmpty = this.isEmpty(node);
        switch (eOperation) {
            case 1075314690: {
                if (bIsRoot || !bIsDataValue || !bIsEmpty) break;
                return this.toDataGroup(node);
            }
            case 1075314691: {
                if (bIsRoot || bIsDataValue || !bIsEmpty) break;
                return this.toDataValue(node);
            }
            case 1075314688: {
                if (bIsRoot || !bIsEmpty) break;
                this.ignore(node);
                return node;
            }
            case 1075314689: {
                if (bIsRoot || !bIsEmpty) break;
                this.remove(node);
                return node;
            }
        }
        if (!bIsDataValue) {
            return node;
        }
        switch (eOperation) {
            case 1077870592: {
                List<DataNode> dataValues = this.getDataValues(node);
                this.rtrim(dataValues);
                this.ltrim(dataValues);
                break;
            }
            case 1077870593: {
                List<DataNode> dataValues = this.getDataValues(node);
                this.rtrim(dataValues);
                break;
            }
            case 1077870594: {
                List<DataNode> dataValues = this.getDataValues(node);
                this.ltrim(dataValues);
                break;
            }
            case 1077870595: {
                List<DataNode> dataValues = this.getDataValues(node);
                this.rtrim(dataValues);
                this.ltrim(dataValues);
                this.normalize(dataValues);
                break;
            }
            case 1077870596: {
                break;
            }
        }
        return node;
    }

    private boolean isEmpty(DataNode node) {
        if (node.getClassTag() == XFA.DATAVALUETAG) {
            return StringUtils.isEmpty(node.getValue());
        }
        return node.getFirstXFAChild() == null;
    }

    int size() {
        return this.mTransformations.size();
    }

    void reset() {
        this.mTransformations.clear();
        for (int i = 0; i < this.mNodeTransformations.size(); ++i) {
            this.mNodeTransformations.remove(i);
        }
        this.msCurNodeName = "";
        this.msCurGroupName = "";
        this.msCurGroupAvailable.clear();
        this.mCurGroupNode = null;
        this.mLastParent = null;
    }

    private static class Transformation {
        private static final Pattern pattern = Pattern.compile("\\s*([^\\s]+)\\s*=\\s*(['\"])(.*?)\\2\\s*");
        private static final Pattern badName = Pattern.compile("\\s*([^\\s]+)\\s*");
        private static final SortedMap<String, Integer> operationTypes = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private static final SortedMap<String, Integer> operationValues = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private final String msNodeNameList;
        private final int mePresence;
        private final int meWhiteSpace;
        private final int meIfEmpty;
        private final String msMapName;
        private final String msGroupParent;
        private final String msNameAttr;
        private final boolean mbHasMapName;
        private final boolean mbHasGroupParent;
        private final boolean mbHasNameAttr;
        private final String msPictureFormat;
        private int mnListIndex;

        public Transformation(String sTransformation) {
            String sName;
            int ePresence = 0;
            int eWhiteSpace = 0;
            int eIfEmpty = 0;
            String sMapName = "";
            String sGroupParent = "";
            String sNameAttr = "";
            boolean bHasMapName = false;
            boolean bHasGroupParent = false;
            boolean bHasNameAttr = false;
            String sPictureFormat = null;
            sTransformation = sTransformation.trim();
            Matcher matcher = pattern.matcher(sTransformation);
            boolean refMatched = false;
            String sNodeNameList = "";
            while (matcher.lookingAt()) {
                sName = matcher.group(1);
                String sValue = matcher.group(3);
                if (!refMatched) {
                    assert (sName.equals("ref"));
                    sNodeNameList = sValue;
                    refMatched = true;
                } else {
                    Integer slot = (Integer)operationTypes.get(sName);
                    if (slot != null) {
                        int oOperationType = slot;
                        slot = (Integer)operationValues.get(sName + "_" + sValue);
                        if (slot != null) {
                            int eOperationValue = slot;
                            switch (oOperationType) {
                                case 1076494336: {
                                    ePresence = eOperationValue;
                                    break;
                                }
                                case 1077870592: {
                                    eWhiteSpace = eOperationValue;
                                    break;
                                }
                                case 1075314688: {
                                    eIfEmpty = eOperationValue;
                                }
                            }
                        }
                    } else if (sName.equals("rename")) {
                        if (!StringUtils.isEmpty(sValue)) {
                            sMapName = sValue;
                            bHasMapName = true;
                        }
                    } else if (sName.equals("groupParent")) {
                        if (!StringUtils.isEmpty(sValue)) {
                            sGroupParent = sValue;
                            bHasGroupParent = true;
                        }
                    } else if (sName.equals("nameAttr")) {
                        if (!StringUtils.isEmpty(sValue)) {
                            sNameAttr = sValue;
                            bHasNameAttr = true;
                        }
                    } else if (sName.equals("picture") && !StringUtils.isEmpty(sValue)) {
                        assert (StringUtils.isEmpty(sPictureFormat));
                        sPictureFormat = sValue;
                    }
                }
                matcher.region(matcher.end(), matcher.regionEnd());
            }
            if (!refMatched || !matcher.hitEnd()) {
                matcher.usePattern(badName);
                matcher.lookingAt();
                sName = matcher.group(1);
                throw new ExFull(ResId.MalformedOptionException, sName);
            }
            this.msNodeNameList = sNodeNameList;
            this.mePresence = ePresence;
            this.meWhiteSpace = eWhiteSpace;
            this.meIfEmpty = eIfEmpty;
            this.msMapName = sMapName;
            this.msGroupParent = sGroupParent;
            this.msNameAttr = sNameAttr;
            this.mbHasMapName = bHasMapName;
            this.mbHasGroupParent = bHasGroupParent;
            this.mbHasNameAttr = bHasNameAttr;
            this.msPictureFormat = sPictureFormat;
        }

        public String getNodeNameList() {
            return this.msNodeNameList;
        }

        public int getOperation(int eOpType) {
            switch (eOpType) {
                case 1076494336: {
                    return this.mePresence;
                }
                case 1077870592: {
                    return this.meWhiteSpace;
                }
                case 1075314688: {
                    return this.meIfEmpty;
                }
            }
            return 0;
        }

        public int getIndex() {
            return this.mnListIndex;
        }

        public void setIndex(int nIndex) {
            this.mnListIndex = nIndex;
        }

        public String getMapName() {
            return this.msMapName;
        }

        public boolean hasMapName() {
            return this.mbHasMapName;
        }

        private boolean matchName(String sNodeNameList, String sNodeName) {
            StringTokenizer tokenizer = new StringTokenizer(sNodeNameList, " ");
            while (tokenizer.hasMoreTokens()) {
                if (!tokenizer.nextToken().equals(sNodeName)) continue;
                return true;
            }
            return false;
        }

        public String getGroupName(List<Transformation> transformations, int nCurrent) {
            String sParentList = this.msGroupParent;
            if (!StringUtils.isEmpty(this.msGroupParent)) {
                for (int i = nCurrent + 1; i < transformations.size(); ++i) {
                    String sNodeNameList;
                    Transformation transformation = transformations.get(i);
                    if (!transformation.hasGroupParent() || StringUtils.isEmpty(sNodeNameList = transformation.getNodeNameList()) || !this.matchName(sNodeNameList, this.msGroupParent)) continue;
                    sParentList = transformation.getGroupName(transformations, i) + "." + this.msGroupParent;
                    break;
                }
            }
            return sParentList;
        }

        public boolean hasGroupParent() {
            return this.mbHasGroupParent;
        }

        public String getNameAttr() {
            return this.msNameAttr;
        }

        public boolean hasNameAttr() {
            return this.mbHasNameAttr;
        }

        public String getPictureFormat() {
            return this.msPictureFormat;
        }

        public boolean hasPictureFormat() {
            return !StringUtils.isEmpty(this.msPictureFormat);
        }

        private static void initOperationTypes() {
            operationTypes.put("presence", 1076494336);
            operationTypes.put("whitespace", 1077870592);
            operationTypes.put("ifEmpty", 1075314688);
        }

        private static void initOperationValues() {
            operationValues.put("presence_preserve", 0x220002);
            operationValues.put("presence_ignore", 0x220000);
            operationValues.put("presence_dissolve", 0x220001);
            operationValues.put("presence_dissolveStructure", 0x220003);
            operationValues.put("whitespace_preserve", 1077870596);
            operationValues.put("whitespace_rtrim", 1077870593);
            operationValues.put("whitespace_ltrim", 1077870594);
            operationValues.put("whitespace_trim", 1077870592);
            operationValues.put("whitespace_normalize", 1077870595);
            operationValues.put("ifEmpty_dataGroup", 1075314690);
            operationValues.put("ifEmpty_dataValue", 1075314691);
            operationValues.put("ifEmpty_ignore", 1075314688);
            operationValues.put("ifEmpty_remove", 1075314689);
        }

        static {
            Transformation.initOperationTypes();
            Transformation.initOperationValues();
        }
    }
}

