/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.Comment;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Generator;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.PseudoModel;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.data.DataModelScript;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.data.DataSchema;
import com.adobe.xfa.data.DataTransformations;
import com.adobe.xfa.data.DataWindow;
import com.adobe.xfa.data.DataWindowFilter;
import com.adobe.xfa.data.IncrementalLoader;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.Key;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.xml.sax.Attributes;

public final class DataModel
extends Model
implements Model.DualDomModel {
    public static final int FMT_XML_DATA = 0;
    public static final int FMT_XPF_DATA = 1;
    private static final DataSchema gDataSchema = new DataSchema();
    private static final boolean ACROBAT_PLUGIN = ResourceLoader.loadProperty("ACROBAT_PLUGIN").equalsIgnoreCase("true");
    private String maRecordName;
    private boolean mbAttributesAreValues = true;
    private boolean mbDataWindowRecordsSpecified;
    private boolean mbHasMapping;
    private boolean mbProcessRecords;
    private final DataWindow mDataWindow = new DataWindow();
    private int meFormat = 0;
    private boolean mbDisableSchemaValidation;
    private boolean mbIgnoreSchemaDuringCurNodeCreation;
    private final Map<String, Boolean> mExcludeNSList;
    private IncrementalLoader mIncrLoadHandler;
    private int mnDataWindowRecordsAfter;
    private int mnDataWindowRecordsBefore;
    private int mnRecordLevel = 1;
    private SourceSetLink mSourceSetLink;
    private String mStartNodeSOMString;
    private DataTransformations mTransformations;
    static final String patentRef = "AdobePatentID=\"B1082\"";

    public static String dataDescriptionNS() {
        return "http://ns.adobe.com/data-description/";
    }

    private static void flattenNode(Element parentNode, Node node) {
        Node child;
        if (node instanceof TextNode) {
            return;
        }
        boolean bHasChildElements = false;
        for (child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            bHasChildElements = true;
            break;
        }
        if (bHasChildElements) {
            child = node.getFirstXMLChild();
            while (child != null) {
                Node nextChild = child.getNextXMLSibling();
                DataModel.flattenNode(parentNode, child);
                child = nextChild;
            }
            node.getXFAParent().removeChild(node);
        } else {
            parentNode.appendChild(node, true);
        }
    }

    static DataNode getDataDesc(Node dataNode) {
        if (dataNode instanceof DataNode) {
            return ((DataNode)dataNode).getDataDescription();
        }
        return null;
    }

    static String getDataDescriptionName(Element domDataDesc) {
        int attr;
        String sDDName = "";
        if (domDataDesc != null && (attr = domDataDesc.findAttr("http://ns.adobe.com/data-description/", "name")) != -1) {
            sDDName = domDataDesc.getAttrVal(attr);
        }
        return sDDName;
    }

    public static DataModel getDataModel(AppModel app, boolean bCreateIfNotFound, boolean bAppend) {
        DataModel data = (DataModel)Model.getNamedModel(app, "dataModel");
        if (bCreateIfNotFound && data == null) {
            List<ModelFactory> factoryList = app.factories();
            int nFactoryCount = factoryList.size();
            DataModelFactory dataModelFactory = null;
            for (int i = 0; i < nFactoryCount; ++i) {
                ModelFactory item = factoryList.get(i);
                if (!(item instanceof DataModelFactory)) continue;
                dataModelFactory = (DataModelFactory)item;
                break;
            }
            if (dataModelFactory == null) {
                dataModelFactory = new DataModelFactory();
            }
            Document doc = bAppend ? app.getDocument() : Document.createDocument(app);
            data = (DataModel)dataModelFactory.createDOM(bAppend ? (Element)app.getXmlPeer() : doc);
            data.setDocument(doc);
            data.mDataWindow.initialize(data, (Element)data.getXmlPeer(), data.mnRecordLevel, data.maRecordName, data.mnDataWindowRecordsAfter, data.mnDataWindowRecordsAfter);
            app.notifyPeers(4, "dataModel", data);
        }
        return data;
    }

    static int getMaxOccurFromDataDescription(Node node, boolean bUseGroup) {
        Element group;
        Element element;
        int i;
        int nRet = 1;
        if (node instanceof Element && (i = (element = (Element)node).findAttr("http://ns.adobe.com/data-description/", "maxOccur")) != -1) {
            String sMaxOccur = element.getAttrVal(i);
            try {
                nRet = Integer.parseInt(sMaxOccur);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (bUseGroup && nRet > 0 && DataModel.isDataDescriptionGroup(group = node.getXFAParent())) {
            nRet *= DataModel.getMaxOccurFromDataDescription(group, true);
        }
        if (nRet < 0) {
            return -1;
        }
        return nRet;
    }

    static int getMinOccurFromDataDescription(Node node, boolean bUseGroup) {
        Element group;
        Element element;
        int i;
        int nRet = 1;
        if (node instanceof Element && (i = (element = (Element)node).findAttr("http://ns.adobe.com/data-description/", "minOccur")) != -1) {
            String sMinOccur = element.getAttrVal(i);
            try {
                nRet = Integer.parseInt(sMinOccur);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (nRet < 0) {
            return -1;
        }
        if (bUseGroup && nRet > 0 && DataModel.isDataDescriptionGroup(group = node.getXFAParent())) {
            nRet *= DataModel.getMinOccurFromDataDescription(group, true);
        }
        return nRet;
    }

    static Schema getModelSchema() {
        return gDataSchema;
    }

    @Override
    public ScriptTable getScriptTable() {
        return DataModelScript.getScriptTable();
    }

    static boolean isDataDescriptionGroup(Element e) {
        return DataModel.isDataDescriptionNS(e.getNS()) && e.getLocalName() == "group";
    }

    static boolean isDataDescriptionNode(Node dataDescNode) {
        Element node;
        return dataDescNode instanceof Element && (node = (Element)dataDescNode).getName() == "dataDescription" && node.getNS() == DataModel.dataDescriptionNS();
    }

    static boolean isDataDescriptionNS(String aNS) {
        return aNS == "http://ns.adobe.com/data-description/";
    }

    public DataModel(Element parent, Node prevSibling) {
        super(parent, prevSibling, "http://www.xfa.org/schema/xfa-data/1.0/", "xfa:datasets", "datasets", "$data", XFA.DATAMODELTAG, "dataModel", DataModel.getModelSchema());
        if (!this.isDuplicateDataModel()) {
            this.getAppModel().addPseudoModel("$dataWindow", this.mDataWindow);
            this.getAppModel().addPseudoModel("$record", new RecordPseudoModel(this.mDataWindow));
        }
        this.mExcludeNSList = new HashMap<String, Boolean>();
        this.mbValidateTextOnLoad = false;
        this.mbIgnoreSchemaDuringCurNodeCreation = false;
    }

    private boolean isDuplicateDataModel() {
        for (Node child = this.getAppModel().getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child == this || !(child instanceof DataModel)) continue;
            return true;
        }
        return false;
    }

    protected void addAttributes(Element pParent, Element node, Generator generator) {
        if (!this.attributesAreValues() || node.getNumAttrs() == 0) {
            return;
        }
        int numAttrs = node.getNumAttrs();
        for (int i = 0; i < numAttrs; ++i) {
            Attribute domAttr = node.getAttr(i);
            String aLocalName = domAttr.getLocalName();
            boolean bCheckOnly = true;
            boolean bSkipAttr = this.loadSpecialAttribute(domAttr, aLocalName, pParent, bCheckOnly);
            if (domAttr.isNameSpaceAttr()) {
                bSkipAttr = true;
            }
            String aNamespaceURI = domAttr.getNS();
            if (!bSkipAttr && this.isCompatibleNS(aNamespaceURI)) {
                bSkipAttr = true;
            }
            if (!bSkipAttr && DataModel.isDataDescriptionNS(aNamespaceURI)) {
                bSkipAttr = true;
            }
            if (bSkipAttr) continue;
            BooleanHolder bRecordLoaded = new BooleanHolder();
            this.loadDataNode(pParent, new AttributeWrapper(domAttr, pParent), generator, bRecordLoaded);
        }
    }

    @Override
    protected boolean canCreateChild(boolean bIsLeaf, String aName) {
        return true;
    }

    boolean canCreateChild(DataNode parent, boolean bIsLeaf, String aName) {
        DataNode desc = DataModel.getDataDesc(parent);
        if (!this.mbDisableSchemaValidation && desc != null) {
            String sNewNode = aName;
            DataNode dataDescChild = this.getDataDescriptionChild(desc, sNewNode);
            if (dataDescChild != null) {
                if (bIsLeaf && dataDescChild.getClassTag() == XFA.DATAVALUETAG || !bIsLeaf && dataDescChild.getClassTag() == XFA.DATAGROUPTAG) {
                    int nMax = DataModel.getMaxOccurFromDataDescription(dataDescChild, true);
                    if (nMax < 0) {
                        return true;
                    }
                    int nCount = 0;
                    for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                        if (child.getName() == aName && child.isSameClass(dataDescChild)) {
                            ++nCount;
                        }
                        if (nCount != nMax) continue;
                        return false;
                    }
                    return nCount < nMax;
                }
                return false;
            }
            return false;
        }
        if (parent.getClassTag() == XFA.DATAGROUPTAG) {
            return true;
        }
        if (parent.getClassTag() == XFA.DATAVALUETAG) {
            return bIsLeaf;
        }
        assert (false);
        return false;
    }

    boolean attributesAreValues() {
        return this.mbAttributesAreValues;
    }

    @Override
    public void appendChild(Node newChild, boolean bValidate) {
        if (this.getXmlPeer().getXMLParent() == null && this.getName() == "datasets" && this.isCompatibleNS(((ModelPeer)this.getXmlPeer()).getNS())) {
            this.connectPeerToDocument();
        }
        super.appendChild(newChild, bValidate);
    }

    @Override
    public Node createChild(boolean bIsLeaf, String aName) {
        assert (aName != null);
        return this.getModel().createNode(XFA.DATAGROUPTAG, this, aName, this.getNS(), true);
    }

    @Override
    public Node createNode(int eClassTag, Element parent, String aNodeName, String ns, boolean bDoVersionCheck) {
        Element oParentPeer;
        assert (aNodeName != null);
        Element element = oParentPeer = parent == null ? null : (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer();
        if (eClassTag == XFA.DATAVALUETAG) {
            if (aNodeName == "") {
                TextNode text = new TextNode(oParentPeer, null, "");
                DataNode dataValue = this.createDataValueFromPeer(parent, text);
                return dataValue;
            }
            Element peerNode = new Element(oParentPeer, null, ns, aNodeName, aNodeName, null, XFA.INVALID_ELEMENT, "");
            peerNode.setModel(this);
            peerNode.setDocument(this.getDocument());
            TextNode text = new TextNode(peerNode, null, "");
            DataNode dataValue = this.createDataValueFromPeer(parent, peerNode);
            dataValue.singleTextChild(text);
            this.processDataDescription(parent);
            dataValue.setIsNull(true, false);
            return dataValue;
        }
        if (eClassTag == XFA.DATAGROUPTAG) {
            Element peerNode = new Element(oParentPeer, null, ns, aNodeName, aNodeName, null, XFA.INVALID_ELEMENT, "");
            peerNode.setModel(this);
            peerNode.setDocument(this.getDocument());
            DataNode dataGroup = this.createDataGroupFromPeer(parent, peerNode);
            this.processDataDescription(parent);
            return dataGroup;
        }
        if (eClassTag == XFA.DSIGDATATAG) {
            MsgFormatPos msgFormatPos = new MsgFormatPos(ResId.InvalidNodeTypeException);
            msgFormatPos.format(this.getAtom(eClassTag));
            throw new ExFull(msgFormatPos);
        }
        MsgFormatPos msgFormatPos = new MsgFormatPos(ResId.InvalidNodeTypeException);
        msgFormatPos.format(this.getAtom(eClassTag));
        throw new ExFull(msgFormatPos);
    }

    @Override
    public Element createElement(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int lineNumber, String fileName) {
        Element retVall = new Element(parent, prevSibling, uri, localName, qName, attributes, XFA.INVALID_ELEMENT, localName);
        return retVall;
    }

    static DataNode changeType(DataNode source, boolean bDataValue) {
        if (bDataValue) {
            source.setClass("dataValue", XFA.DATAVALUETAG);
        } else {
            source.setClass("dataGroup", XFA.DATAGROUPTAG);
        }
        for (Node child = source.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!bDataValue || child.getClassTag() != XFA.DATAGROUPTAG) continue;
            child = DataModel.changeType((DataNode)child, true);
        }
        return source;
    }

    boolean excludeNS(String aNS) {
        if (aNS == "http://www.xfa.org/schema/xfa-data/1.0/") {
            return false;
        }
        if (aNS == null) {
            return false;
        }
        if (aNS == "") {
            return false;
        }
        if (aNS == "http://www.xfa.com/schema/xml-package") {
            return true;
        }
        if (aNS == "http://ns.adobe.com/xfdf-transition/") {
            return true;
        }
        if (aNS == "http://www.w3.org/XML/1998/namespace") {
            return true;
        }
        int nPackageNSLen = "http://www.xfa.org/schema/xfa-package/".length();
        if (aNS.length() >= nPackageNSLen && aNS.startsWith("http://www.xfa.org/schema/xfa-package/", nPackageNSLen)) {
            return true;
        }
        Boolean b = this.mExcludeNSList.get(aNS);
        return b != null && b != false;
    }

    public Attribute findAttrInNS(Element e, String aNodeName) {
        int len = e.getNumAttrs();
        for (int i = 0; i < len; ++i) {
            Attribute a = e.getAttr(i);
            if (a.getName() != aNodeName || !this.isCompatibleNS(a.getNS())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttrInNS(Attribute[] attrs, String aNodeName) {
        if (aNodeName == null) {
            return null;
        }
        for (Attribute node : attrs) {
            if (node.getLocalName() != aNodeName || !this.isCompatibleNS(node.getNS())) continue;
            return node;
        }
        return null;
    }

    @Override
    public String getBaseNS() {
        return "http://www.xfa.org/schema/xfa-data/";
    }

    public DataNode getDataDescriptionRoot(String sDataRootName) {
        DataNode ret = null;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!DataModel.isDataDescriptionNode(child)) continue;
            String sDDName = DataModel.getDataDescriptionName((Element)child);
            if (sDDName.equals(sDataRootName)) {
                return (DataNode)child;
            }
            if (ret != null || sDDName.length() != 0) continue;
            ret = (DataNode)child;
        }
        return ret;
    }

    private static void dissolveNode(Element parentNode, Node node) {
        Node child = node.getFirstXMLChild();
        while (child != null) {
            Node nextChild = child.getNextXMLSibling();
            if (!(child instanceof TextNode)) {
                parentNode.appendChild(child);
            }
            child = nextChild;
        }
        node.remove();
    }

    String getMapping(String aNodeName) {
        String aNewName = "";
        if (this.mTransformations != null) {
            aNewName = this.mTransformations.getMapName(aNodeName);
        }
        return aNewName;
    }

    public DataNode createDataRootElement(DataNode dataDescription) {
        DataNode rootElement = null;
        if (dataDescription != null) {
            for (Node dataDesc = dataDescription.getFirstXFAChild(); dataDesc != null; dataDesc = dataDesc.getNextXFASibling()) {
                if (!(dataDesc instanceof DataNode)) continue;
                rootElement = this.createNodeFromDataDescription((DataNode)dataDesc, null, null, false);
                this.clearDataDescriptionInfo(rootElement);
                break;
            }
        }
        return rootElement;
    }

    private Node populateParent(Element dataParent, ObjectHolder<Node> prevDataNode, Node dataDescriptionParent, DataNode dataDescriptionNode, int occIndex, boolean bDefault) {
        int eModel = this.getElementModel(dataDescriptionParent);
        if (eModel == -2144600064) {
            return this.populateOrderedParent(dataParent, prevDataNode, dataDescriptionParent, dataDescriptionNode, occIndex, bDefault);
        }
        if (eModel == -2144600063) {
            return this.populateUnorderedParent(dataParent, prevDataNode, dataDescriptionParent, dataDescriptionNode, occIndex, bDefault);
        }
        return this.populateChoiceParent(dataParent, prevDataNode, dataDescriptionParent, dataDescriptionNode, occIndex, bDefault);
    }

    private int getElementModel(Node node) {
        Element element;
        int index;
        if (node instanceof Element && (index = (element = (Element)node).findAttr("http://ns.adobe.com/data-description/", "model")) != -1) {
            String sModel = element.getAttrVal(index);
            if (sModel.equals("choice")) {
                return -2144600062;
            }
            if (sModel.equals("unordered")) {
                return -2144600063;
            }
        }
        return -2144600064;
    }

    private Node populateOrderedParent(Element dataParent, ObjectHolder<Node> prevDataNodeHolder, Node dataDescriptionParent, DataNode dataDescriptionNode, int occIndex, boolean bDefault) {
        Node newNode = null;
        Node prevDataNode = prevDataNodeHolder != null ? (Node)prevDataNodeHolder.value : null;
        for (DataNode dataDesc = (DataNode)dataDescriptionParent.getFirstXFAChild(); dataDesc != null; dataDesc = (DataNode)dataDesc.getNextXFASibling()) {
            Element nextDataNode;
            Node existingNode;
            Node peer = dataDesc.getXmlPeer();
            if (!(peer instanceof Element) || peer instanceof AttributeWrapper) continue;
            if (DataModel.isDataDescriptionNS(dataDesc.getNS())) {
                if (!DataModel.isDataDescriptionGroup(dataDesc)) continue;
                if (prevDataNodeHolder == null) {
                    prevDataNodeHolder = new ObjectHolder();
                }
                prevDataNodeHolder.value = prevDataNode;
                Node groupNode = this.populateParent(dataParent, prevDataNodeHolder, dataDesc, dataDescriptionNode, occIndex, bDefault);
                prevDataNode = (Node)prevDataNodeHolder.value;
                if (newNode != null || groupNode == null) continue;
                newNode = groupNode;
                continue;
            }
            IntegerHolder nDDCount = new IntegerHolder();
            if (dataDescriptionNode == dataDesc) {
                int nMax;
                existingNode = this.getNodeFromDataDescription(dataParent, dataDesc, occIndex, nDDCount);
                if (existingNode != null) {
                    if (occIndex == -1 && DataModel.getDDPlaceholderFlag(existingNode)) {
                        return existingNode;
                    }
                    if (occIndex == nDDCount.value - 1 && nDDCount.value > 0) {
                        return existingNode;
                    }
                }
                if (existingNode != null) {
                    prevDataNode = existingNode;
                }
                nextDataNode = null;
                nextDataNode = prevDataNode == null ? DataModel.getFirstElementChild(dataParent) : DataModel.getNextElementChild(prevDataNode);
                if (occIndex == -1) {
                    occIndex = nDDCount.value;
                }
                if (occIndex >= (nMax = DataModel.getMaxOccurFromDataDescription(dataDesc, true)) && nMax >= 0) {
                    return null;
                }
                DataNode createNode = null;
                int nNumToCreate = occIndex - nDDCount.value + 1;
                for (int j = 0; j < nNumToCreate; ++j) {
                    createNode = this.createNodeFromDataDescription(dataDesc, dataParent, nextDataNode, bDefault);
                }
                int nMin = DataModel.getMinOccurFromDataDescription(dataDesc, false) - occIndex - 1;
                for (int j = 0; j < nMin; ++j) {
                    this.createNodeFromDataDescription(dataDesc, dataParent, nextDataNode, bDefault);
                }
                if (existingNode != null) {
                    return createNode;
                }
                prevDataNode = newNode = createNode;
                continue;
            }
            existingNode = this.getNodeFromDataDescription(dataParent, dataDesc, -2, nDDCount);
            if (existingNode == null) {
                nextDataNode = null;
                nextDataNode = prevDataNode == null ? DataModel.getFirstElementChild(dataParent) : DataModel.getNextElementChild(prevDataNode);
                DataNode createNode = null;
                int nMin = DataModel.getMinOccurFromDataDescription(dataDesc, false);
                for (int j = 0; j < nMin; ++j) {
                    createNode = this.createNodeFromDataDescription(dataDesc, dataParent, nextDataNode, bDefault);
                }
                if (createNode == null) continue;
                prevDataNode = createNode;
                continue;
            }
            prevDataNode = existingNode;
        }
        if (prevDataNodeHolder != null) {
            prevDataNodeHolder.value = prevDataNode;
        }
        return newNode;
    }

    Node populateUnorderedParent(Element dataParent, ObjectHolder<Node> prevDataNodeHolder, Node dataDescriptionParent, DataNode dataDescriptionNode, int occIndex, boolean bDefault) {
        return this.populateOrderedParent(dataParent, prevDataNodeHolder, dataDescriptionParent, dataDescriptionNode, occIndex, bDefault);
    }

    Node populateChoiceParent(Element dataParent, ObjectHolder<Node> prevDataNodeHolder, Node dataDescriptionParent, DataNode dataDescriptionNode, int occIndex, boolean bDefault) {
        int nMax;
        int nDDCount = 0;
        Node choiceChild = null;
        for (Node child = dataParent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            DataNode childDDesc;
            if (!(child instanceof Element) || (childDDesc = DataModel.getDataDesc(child)) == null) continue;
            if (dataDescriptionNode == childDDesc) {
                if (occIndex == -1 && DataModel.getDDPlaceholderFlag(child)) {
                    return child;
                }
                if (occIndex == nDDCount) {
                    return child;
                }
                ++nDDCount;
                choiceChild = child;
                continue;
            }
            if (!DataModel.isDescendantOfParent(childDDesc, dataDescriptionParent)) continue;
            choiceChild = child;
        }
        if (choiceChild != null && DataModel.getDataDesc(choiceChild) != dataDescriptionNode) {
            Element choiceChildDD = DataModel.getDataDesc(choiceChild);
            if (choiceChildDD.getXFAParent() == dataDescriptionParent) {
                if (prevDataNodeHolder != null) {
                    prevDataNodeHolder.value = choiceChild;
                }
                return null;
            }
            while (choiceChildDD.getXFAParent() != dataDescriptionParent) {
                choiceChildDD = choiceChildDD.getXFAParent();
            }
            return this.populateParent(dataParent, prevDataNodeHolder, choiceChildDD, dataDescriptionNode, occIndex, bDefault);
        }
        if (dataDescriptionNode == null || !DataModel.isDescendantOfParent(dataDescriptionNode, dataDescriptionParent)) {
            return null;
        }
        Node dataGroup = DataModel.getDataDescriptionGroup(dataDescriptionNode, dataDescriptionParent);
        if (dataGroup != null) {
            return this.populateParent(dataParent, prevDataNodeHolder, dataGroup, dataDescriptionNode, occIndex, bDefault);
        }
        if (occIndex == -1) {
            occIndex = nDDCount;
        }
        if (occIndex >= (nMax = DataModel.getMaxOccurFromDataDescription(dataDescriptionNode, true)) && nMax >= 0) {
            return null;
        }
        int nNumToCreate = occIndex - nDDCount + 1;
        Element nextDataNode = null;
        nextDataNode = choiceChild != null ? DataModel.getNextElementChild(choiceChild) : (prevDataNodeHolder == null || prevDataNodeHolder.value == null ? DataModel.getFirstElementChild(dataParent) : DataModel.getNextElementChild((Node)prevDataNodeHolder.value));
        DataNode createNode = null;
        for (int j = 0; j < nNumToCreate; ++j) {
            createNode = this.createNodeFromDataDescription(dataDescriptionNode, dataParent, nextDataNode, bDefault);
        }
        int nMin = DataModel.getMinOccurFromDataDescription(dataDescriptionNode, false) - occIndex - 1;
        for (int j = 0; j < nMin; ++j) {
            this.createNodeFromDataDescription(dataDescriptionNode, dataParent, nextDataNode, bDefault);
        }
        if (prevDataNodeHolder != null) {
            prevDataNodeHolder.value = createNode;
        }
        return createNode;
    }

    void connectDataNodesToDataDescription(Node dataDescriptionParent, Node dataParent) {
        boolean bDontAllowChangeType = this.mbDisableSchemaValidation && this.mbIgnoreSchemaDuringCurNodeCreation;
        for (DataNode dataDesc = (DataNode)dataDescriptionParent.getFirstXMLChild(); dataDesc != null; dataDesc = (DataNode)dataDesc.getNextXFASibling()) {
            if (DataModel.isDataDescriptionNS(dataDesc.getNS())) {
                if (!DataModel.isDataDescriptionGroup(dataDesc)) continue;
                this.connectDataNodesToDataDescription(dataDesc, dataParent);
                continue;
            }
            String aName = dataDesc.getName();
            if (aName == null) continue;
            int nMax = DataModel.getMaxOccurFromDataDescription(dataDesc, true);
            int j = 0;
            Node dataNode = dataParent.getFirstXFAChild();
            while (dataNode != null && nMax != 0) {
                if (dataNode.getName() == aName && DataModel.setDataDesc(dataDesc, (DataNode)dataNode, bDontAllowChangeType)) {
                    --nMax;
                    this.connectDataNodesToDataDescription(dataDesc, dataNode);
                }
                dataNode = dataNode.getNextXFASibling();
                ++j;
            }
        }
    }

    private boolean registerKeys(DataNode dataDesc) {
        boolean bPrimaryKeysFound = false;
        Element domNode = (Element)dataDesc.getXmlPeer();
        int index = domNode.findAttr("http://ns.adobe.com/data-description/", "primaryKey");
        if (index != -1) {
            Attribute primaryKeyAttr = domNode.getAttr(index);
            domNode.getOwnerDocument().declarePKey(domNode.getNS(), domNode.getLocalName(), primaryKeyAttr.getAttrValue(), domNode);
            bPrimaryKeysFound = true;
        }
        for (Node childDataDesc = dataDesc.getFirstXFAChild(); childDataDesc != null; childDataDesc = childDataDesc.getNextXFASibling()) {
            bPrimaryKeysFound |= this.registerKeys((DataNode)childDataDesc);
        }
        return bPrimaryKeysFound;
    }

    private DataNode createNodeFromDataDescription(DataNode dataDescriptionNode, Element dataParent, Node refChild, boolean bDefault) {
        DataNode newNode = (DataNode)dataDescriptionNode.clone(null, false);
        Node newDOMNode = newNode.getXmlPeer();
        if (newDOMNode instanceof Element && !(newDOMNode instanceof AttributeWrapper)) {
            Element newDOMElement = (Element)newDOMNode;
            this.clearDataDescriptionInfo(newNode);
            if (newDOMElement.getNumAttrs() != 0) {
                this.addAttributes((Element)newNode, newDOMElement, new Generator("", ""));
                for (Node child = newNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    DataModel.setDDPlaceholderFlag(child, true);
                }
            }
        }
        if (dataParent != null) {
            if (refChild != null) {
                dataParent.insertChild(newNode, refChild, true);
            } else {
                dataParent.appendChild(newNode, true);
            }
        }
        DataModel.setDDPlaceholderFlag(newNode, true);
        DataModel.setDataDesc(dataDescriptionNode, newNode);
        newNode.setIsNull(true, false);
        if (bDefault) {
            newNode.makeDefault();
        }
        this.populateParent(newNode, null, dataDescriptionNode, null, 0, bDefault);
        for (Node child = newNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int index;
            DataNode dataNode;
            if (!(child instanceof DataNode) || (dataNode = (DataNode)child).getClassTag() != XFA.DATAVALUETAG || !dataNode.isAttribute() || (index = newNode.findAttr(dataNode.getNS(), dataNode.getLocalName())) == -1) continue;
            dataNode.setValue(newNode.getAttrVal(index), false);
        }
        return newNode;
    }

    private void clearDataDescriptionInfo(Element dataNode) {
        if (dataNode == null) {
            return;
        }
        for (int j = 0; j < dataNode.getNumAttrs(); ++j) {
            Attribute attr = dataNode.getAttr(j);
            if (!DataModel.isDataDescriptionNS(attr.getNS()) && (!attr.isNameSpaceAttr() || !DataModel.isDataDescriptionNS(attr.getAttrValue()))) continue;
            dataNode.removeAttr(j);
            --j;
        }
    }

    @Override
    public void connectPeerToDocument() {
        super.connectPeerToDocument();
        this.getDataWindow().resetRecordDepth();
    }

    private Element findStartNodeSOM(Element node) {
        String sep = ".";
        StringTokenizer tokenizer = new StringTokenizer(this.mStartNodeSOMString, sep);
        if (!tokenizer.hasMoreTokens()) {
            throw new ExFull(ResId.SOMEmptyResultException);
        }
        String token = tokenizer.nextToken();
        IntegerHolder occurrence = new IntegerHolder();
        String nodeName = DataModel.parseSOMString(token, occurrence);
        if (occurrence.value != 0 || !node.getName().equals(nodeName)) {
            throw new ExFull(ResId.SOMEmptyResultException);
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            nodeName = DataModel.parseSOMString(token, occurrence);
            boolean bFound = false;
            for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                if (!(child instanceof Element) || !child.getName().equals(nodeName)) continue;
                if (occurrence.value == 0) {
                    node = (Element)child;
                    bFound = true;
                    break;
                }
                --occurrence.value;
            }
            if (bFound) continue;
            throw new ExFull(ResId.SOMEmptyResultException);
        }
        return node;
    }

    private static void setDDPlaceholderFlag(Node dataNode, boolean bIsDDPlaceholder) {
        if (dataNode instanceof DataNode) {
            ((DataNode)dataNode).setIsDDPlaceholder(bIsDDPlaceholder);
        }
    }

    private static boolean getDDPlaceholderFlag(Node dataNode) {
        if (dataNode instanceof DataNode) {
            return ((DataNode)dataNode).getIsDDPlaceholder();
        }
        return false;
    }

    private static boolean isDescendantOfParent(Node dataDescNode, Node dataDescParent) {
        for (Element poParent = dataDescNode.getXFAParent(); poParent != null; poParent = poParent.getXFAParent()) {
            if (poParent != dataDescParent) continue;
            return true;
        }
        return false;
    }

    private static boolean isDataDescriptionGroup(Node node) {
        if (node instanceof Element) {
            Element e = (Element)node;
            return DataModel.isDataDescriptionNS(e.getNS()) && e.getLocalName() == "group";
        }
        return false;
    }

    private static Node getDataDescriptionGroup(Node dataDescriptionNode, Node currentDDParent) {
        Element dataGroup = null;
        for (Element ddParent = dataDescriptionNode.getXFAParent(); ddParent != currentDDParent && DataModel.isDataDescriptionGroup((Node)ddParent); ddParent = ddParent.getXFAParent()) {
            dataGroup = ddParent;
        }
        return dataGroup;
    }

    private static Element getFirstElementChild(Node dataParent) {
        for (Node node = dataParent.getFirstXFAChild(); node != null; node = node.getNextXFASibling()) {
            Node domNode = ((Element.DualDomNode)((Object)node)).getXmlPeer();
            if (!(domNode instanceof Element) || domNode instanceof AttributeWrapper) continue;
            return (Element)node;
        }
        return null;
    }

    private static Element getNextElementChild(Node prevDataNode) {
        for (prevDataNode = prevDataNode.getNextXFASibling(); prevDataNode != null; prevDataNode = prevDataNode.getNextXFASibling()) {
            Node domNode = ((Element.DualDomNode)((Object)prevDataNode)).getXmlPeer();
            if (!(domNode instanceof Element) || domNode instanceof AttributeWrapper) continue;
            return (Element)prevDataNode;
        }
        return null;
    }

    private Node getNodeFromDataDescription(Node dataParent, Node dataDescriptionNode, int index, IntegerHolder count) {
        Node ret = null;
        Node last = null;
        count.value = 0;
        for (Node node = dataParent.getFirstXFAChild(); node != null; node = node.getNextXFASibling()) {
            if (dataDescriptionNode != DataModel.getDataDesc(node)) continue;
            ++count.value;
            if (index == -1 && DataModel.getDDPlaceholderFlag(node)) {
                return node;
            }
            last = node;
            if (index + 1 != count.value) continue;
            ret = node;
        }
        if (ret != null) {
            return ret;
        }
        return last;
    }

    public DataNode getDataRoot() {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof DataNode) || child.getName() != "data" || !this.isCompatibleNS(((Element)child).getNS())) continue;
            return (DataNode)child;
        }
        return null;
    }

    public DataWindow getDataWindow() {
        return this.mDataWindow;
    }

    public SourceSetLink getSourceSetLink() {
        return this.mSourceSetLink;
    }

    protected int getSaveFormat() {
        return this.meFormat;
    }

    public void initFromDataDescription(Element dataNode) {
        DataNode dataDescription = DataModel.getDataDesc(dataNode);
        if (dataDescription == null) {
            return;
        }
        for (Node dataDescriptionChild = ((Node)dataDescription).getFirstXFAChild(); dataDescriptionChild != null; dataDescriptionChild = dataDescriptionChild.getNextXFASibling()) {
            DataNode dataDescriptionChildElement;
            if (!(dataDescriptionChild instanceof DataNode) || (dataDescriptionChildElement = (DataNode)dataDescriptionChild).isAttribute()) continue;
            this.createNodeFromDataDescription(dataDescriptionChildElement, dataNode, null, false);
        }
    }

    @Override
    public void insertChild(Node newChild, Node refChild, boolean bValidate) {
        if (this.getXmlPeer().getXMLParent() == null && this.getName() == "datasets" && this.isCompatibleNS(((ModelPeer)this.getXmlPeer()).getNS())) {
            this.connectPeerToDocument();
        }
        super.insertChild(newChild, refChild, bValidate);
    }

    @Override
    public boolean isCompatibleNS(String aNS) {
        if (aNS == null) {
            return false;
        }
        if (aNS == "") {
            return false;
        }
        if (aNS == "http://www.xfa.com/schema/xfa-data") {
            return true;
        }
        int nDataNSLen = "http://www.xfa.org/schema/xfa-data/".length();
        if (aNS.length() >= nDataNSLen && aNS.startsWith("http://www.xfa.org/schema/xfa-data/")) {
            return true;
        }
        return aNS == "http://ns.adobe.com/data-description/";
    }

    Node loadImage(DataNode node, String sHref) {
        boolean bIsRichText = false;
        String sContentType = "";
        int contentTypeAttr = node.findAttr(null, "contentType");
        if (contentTypeAttr != -1) {
            sContentType = node.getAttrVal(contentTypeAttr);
            bIsRichText = sContentType.equals("text/html");
        }
        boolean bLoad = false;
        try {
            File oContent = new File(sHref);
            bLoad = oContent.exists();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bLoad) {
            int len = sContentType.length();
            if (bIsRichText || len > 4 && (sContentType.endsWith("/xml") || sContentType.endsWith("+xml"))) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataModel#loadImage - xml content");
            }
            if (len > 5 && sContentType.startsWith("text/")) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataModel#loadImage - text content");
            }
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataModel#loadImage - other content");
        }
        return node.getFirstXFAChild();
    }

    @Override
    public void loadNode(Element parent, Node node, Generator generator) {
        BooleanHolder bRecordLoaded = new BooleanHolder();
        this.loadDataNode(parent, node, generator, bRecordLoaded);
    }

    @Override
    public boolean loadRootAttributes() {
        return this.mbAttributesAreValues;
    }

    private static String parseSOMString(String somSection, IntegerHolder occurrence) {
        String nodeName = somSection;
        int nLeftBracketOffset = nodeName.indexOf(91);
        occurrence.value = 0;
        if (nLeftBracketOffset >= 0) {
            int nRightBracketOffset = nodeName.indexOf(93);
            if (nRightBracketOffset < 0) {
                throw new ExFull(ResId.InvalidSOMException);
            }
            int nLength = nodeName.length();
            if (nRightBracketOffset != nLength - 1) {
                throw new ExFull(ResId.InvalidSOMException);
            }
            String occurrenceString = nodeName.substring(nLeftBracketOffset + 1, nLength - 1);
            try {
                int nOccurrence;
                occurrence.value = nOccurrence = Integer.parseInt(occurrenceString);
            }
            catch (NumberFormatException e) {
                throw new ExFull(ResId.InvalidSOMException);
            }
            nodeName = nodeName.substring(0, nLeftBracketOffset);
        }
        return nodeName;
    }

    Node loadToNextRecord() {
        return null;
    }

    @Override
    protected void loadXMLImpl(Element parent, InputStream is, boolean bIgnoreAggregatingTag, Element.ReplaceContent eReplaceContent) {
        Document doc;
        Element imported;
        Element startNode;
        Element domPeer = (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer();
        if (eReplaceContent == Element.ReplaceContent.AllContent || eReplaceContent == Element.ReplaceContent.XFAContent) {
            while (parent.getFirstXFAChild() != null) {
                parent.getFirstXFAChild().remove();
            }
        }
        if (eReplaceContent == Element.ReplaceContent.AllContent) {
            while (domPeer.getFirstXMLChild() != null) {
                domPeer.getFirstXMLChild().remove();
            }
        }
        if ((startNode = (imported = (doc = domPeer.getOwnerDocument()).loadIntoDocument(is)).getFirstXMLChildElement()) == null) {
            return;
        }
        if (!bIgnoreAggregatingTag) {
            domPeer.appendChild(startNode);
            this.loadNode(parent, startNode, new Generator("", ""));
        } else {
            Node child = startNode.getFirstXMLChild();
            while (child != null) {
                Node nextChild = this.preLoadNode(parent, child, new Generator("", ""));
                if (child.getXMLParent() == null) break;
                domPeer.appendChild(child, true);
                if (child instanceof Element || child instanceof Chars) {
                    this.loadNode(parent, child, new Generator("", ""));
                }
                child = nextChild;
            }
            if (this.loadRootAttributes()) {
                this.addAttributes((Element)this, startNode, new Generator("", ""));
            }
        }
        parent.resetPostLoadXML();
        this.resolveProtos(false);
        AppModel appModel = this.getAppModel();
        if (appModel != null && !appModel.getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
            parent.notifyPeers(7, "", parent);
        }
    }

    void popStack() {
        if (this.mIncrLoadHandler != null) {
            --this.mIncrLoadHandler.mnLoadNodeLevel;
            if (this.mIncrLoadHandler.mnLoadNodeLevel > 0 && !this.mIncrLoadHandler.backOut()) {
                this.mIncrLoadHandler.pop();
            }
        }
    }

    @Override
    public void preSave(boolean bSaveXMLScript) {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            child.preSave(bSaveXMLScript);
        }
    }

    @Override
    protected void postLoad() {
        DataModel existingDataModel;
        Element xmlTreeRoot = (Element)this.getXmlPeer();
        ModelPeer modelPeer = new ModelPeer(null, null, "http://www.xfa.org/schema/xfa-data/1.0/", "datasets", "xfa:datasets", null, this);
        modelPeer.setModel(this);
        this.setXmlPeer(modelPeer);
        Generator gen = null;
        this.isLoading(true);
        if (!StringUtils.isEmpty(this.mStartNodeSOMString)) {
            Element startNode = xmlTreeRoot;
            while (startNode.getXMLParent() != null) {
                startNode = startNode.getXMLParent();
            }
            startNode = ((Document)startNode).getDocumentElement();
            xmlTreeRoot = this.findStartNodeSOM(startNode);
            for (Node child = startNode.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                if (!(child instanceof Chars) || ((Chars)child).isXMLSpace()) continue;
                throw new ExFull(ResId.InvalidDataSourceException);
            }
        }
        if ((existingDataModel = DataModel.getDataModel(this.getAppModel(), false, false)) != this) {
            existingDataModel.add(xmlTreeRoot, gen);
            this.remove();
            return;
        }
        boolean bLazyLoading = false;
        if (!this.mbDataWindowRecordsSpecified) {
            if (bLazyLoading) {
                this.mnDataWindowRecordsBefore = 0;
                this.mnDataWindowRecordsAfter = 0;
            } else {
                this.mnDataWindowRecordsBefore = Integer.MAX_VALUE;
                this.mnDataWindowRecordsAfter = Integer.MAX_VALUE;
            }
        }
        DataWindow dw = this.getDataWindow();
        dw.initialize(this, xmlTreeRoot, this.mnRecordLevel, this.maRecordName, this.mnDataWindowRecordsBefore, this.mnDataWindowRecordsAfter);
        BooleanHolder bValidRecordLoaded = new BooleanHolder();
        this.loadDataNode(this, xmlTreeRoot, gen, bValidRecordLoaded);
        dw.updateAfterLoad();
        this.processDataDescription(this.getDataRoot());
        dw.postLoad();
        this.isLoading(false);
    }

    private void add(Element inputNode, Generator generator) {
        boolean bisCompatibleNS = this.isCompatibleNS(inputNode.getNS());
        if (bisCompatibleNS && inputNode.getLocalName() == "datasets") {
            for (Node child = inputNode.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                if (!(child instanceof Element)) continue;
                this.add((Element)child, generator, true);
            }
            return;
        }
        this.add(inputNode, generator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Element inputNode, Generator generator, boolean bDatasetParent) {
        Document inputDoc;
        boolean bisCompatibleNS = this.isCompatibleNS(inputNode.getNS());
        boolean bIsDataDescription = false;
        boolean bIsData = false;
        if (bisCompatibleNS) {
            String aNodeLocalName = inputNode.getLocalName();
            if (aNodeLocalName == "data") {
                bIsData = true;
            } else if (aNodeLocalName == "dataDescription") {
                String aDDName = DataModel.getDataDescriptionName(inputNode);
                if (this.getDataDescriptionRoot(aDDName) != null) {
                    return;
                }
                bIsDataDescription = true;
            }
        }
        Element startNode = inputNode;
        Document doc = this.getDocument();
        if (doc != (inputDoc = inputNode.getOwnerDocument())) {
            if (inputDoc.isIncrementalLoad()) {
                ExFull ex = new ExFull(ResId.IncrementalDataLoadException);
                this.addErrorList(ex, 3, null);
            }
            try {
                doc.autoUniquifyIDs(true);
                startNode = (Element)doc.importNode(inputNode, true);
            }
            finally {
                doc.autoUniquifyIDs(true);
            }
            if (startNode != null) {
                startNode.setIsDataWindowRoot(true);
            }
        }
        doc.indexSubtree(startNode, false);
        DataNode firstData = this.getDataRoot();
        if (firstData != null && (!bDatasetParent || bIsData)) {
            DataNode data;
            if (bIsData) {
                data = this.createDataGroupFromPeer(this, startNode);
            } else {
                Element dataNode = this.getDocument().createElementNS("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:data", null);
                dataNode.setModel(this);
                data = this.createDataGroupFromPeer(this, dataNode);
            }
            this.insertChild(data, firstData, false);
            firstData.remove();
            this.mDataWindow.uninitialize();
            this.mDataWindow.initialize(this, startNode, this.mnRecordLevel, this.maRecordName, this.mnDataWindowRecordsBefore, this.mnDataWindowRecordsAfter);
            if (bIsData) {
                Node child = startNode.getFirstXMLChild();
                while (child != null) {
                    Node nextSibling = child.getNextXMLSibling();
                    if (child instanceof Element) {
                        this.loadNode(data, child, generator);
                    }
                    child = nextSibling;
                }
            } else {
                this.loadNode(data, startNode, generator);
            }
            this.setAliasNode(this.getDataRoot());
            this.processDataDescription(this.getDataRoot());
            return;
        }
        if (bIsData || bIsDataDescription || bDatasetParent) {
            this.loadNode(this, startNode, generator);
        } else {
            Element dataNode = this.getDocument().createElementNS("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:data", null);
            DataNode data = this.createDataGroupFromPeer(this, dataNode);
            this.loadNode(data, startNode, generator);
        }
        this.setAliasNode(this.getDataRoot());
        if (bIsDataDescription || firstData != null) {
            this.processDataDescription(this.getDataRoot());
        }
    }

    private void loadDataNode(Element parent, Node node, Generator generator, BooleanHolder bValidRecordLoaded) {
        boolean bOnlyChild;
        String aNodeLocalName;
        boolean bCheckOnly = true;
        if (this.loadSpecialNode(parent, node, bCheckOnly)) {
            return;
        }
        DataNode newNode = null;
        boolean bOverrideDataName = false;
        boolean bOverride = false;
        boolean bParentIsDataGroup = parent.getClassTag() == XFA.DATAGROUPTAG;
        boolean bCreateDataValue = false;
        boolean bParentIsDataValue = false;
        boolean bParentIsDataModel = false;
        boolean bGrandParentIsDataModel = false;
        boolean bStripWhiteSpace = false;
        boolean bParentIsDataDescription = false;
        String aNodeNameSpace = node instanceof Element ? ((Element)node).getNS() : "";
        String string = aNodeLocalName = node instanceof Element ? ((Element)node).getLocalName() : "";
        if (node instanceof TextNode) {
            aNodeLocalName = "#text";
        }
        if (!bParentIsDataGroup) {
            boolean bl = bParentIsDataValue = parent.getClassTag() == XFA.DATAVALUETAG;
        }
        if (!bParentIsDataValue && !bParentIsDataGroup) {
            boolean bl = bParentIsDataModel = parent.getClassTag() == XFA.DATAMODELTAG;
        }
        if (bParentIsDataGroup && !bParentIsDataModel && parent.getXFAParent() != null) {
            bGrandParentIsDataModel = parent.getXFAParent().getClassTag() == XFA.DATAMODELTAG;
        }
        String aMappedName = "";
        String aRename = "";
        String aNameAttr = "";
        boolean bHasNameAttr = false;
        Attribute nameAttr = null;
        boolean bHasDataPictureFormat = false;
        String sPictureFormat = "";
        int eOperation = 0;
        if (this.mTransformations != null) {
            Element element;
            int index;
            eOperation = this.mTransformations.getOperation(aNodeLocalName, 1076494336);
            aRename = this.mTransformations.getMapName(aNodeLocalName);
            this.mbHasMapping = aRename != "";
            aNameAttr = this.mTransformations.getNameAttr(aNodeLocalName);
            if (aNameAttr != "" && node instanceof Element && (index = (element = (Element)node).findAttr("", aNameAttr)) != -1) {
                nameAttr = element.getAttr(index);
                element.removeAttr(index);
                bHasNameAttr = true;
            }
            bHasDataPictureFormat = !StringUtils.isEmpty(sPictureFormat = this.mTransformations.getPictureFormat(aNodeLocalName));
        }
        boolean bExclude = eOperation == 0x220000 || eOperation == 0x220001 || this.excludeNS(aNodeNameSpace);
        boolean bFlatten = eOperation == 0x220003;
        boolean bIsDatasets = false;
        if (!bExclude && (bParentIsDataModel || bGrandParentIsDataModel)) {
            if (aNodeLocalName == "DataGroup") {
                bExclude = this.isCompatibleNS(aNodeNameSpace);
            } else if (aNodeLocalName == "datasets" && this.isCompatibleNS(aNodeNameSpace)) {
                assert (node instanceof ModelPeer);
                this.setXmlPeer(node);
                bExclude = true;
                bIsDatasets = true;
            }
        }
        if (bExclude) {
            Node child = node.getFirstXMLChild();
            Node oLastChild = node.getLastXMLChild();
            while (child != null) {
                Node nextChild = child.getNextXMLSibling();
                if (!(child instanceof TextNode)) {
                    this.loadDataNode(parent, child, generator, bValidRecordLoaded);
                }
                if (child == oLastChild) break;
                child = nextChild;
            }
            if (eOperation == 0x220001) {
                Node peer;
                if (parent instanceof DataNode) {
                    peer = ((DataNode)parent).getXmlPeer();
                } else {
                    assert (parent instanceof DataModel);
                    peer = ((DataModel)parent).getXmlPeer();
                }
                DataModel.dissolveNode((Element)peer, node);
            }
            if (bIsDatasets && this.getDataRoot() == null) {
                Document doc = node.getOwnerDocument();
                Element dataNode = doc.createElementNS("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:data", null);
                this.createDataGroupFromPeer(this, dataNode);
                this.setAliasNode(this.getDataRoot());
            }
            if (bHasNameAttr && nameAttr != null) {
                this.updateAttribute(nameAttr);
            }
            return;
        }
        if (bParentIsDataModel) {
            boolean b_Data = false;
            boolean b_data = false;
            boolean b_DataDesc = false;
            if (aNodeLocalName == "data") {
                b_data = true;
            } else if (aNodeLocalName == "Data") {
                b_Data = true;
            } else if (aNodeLocalName == "dataDescription") {
                b_DataDesc = true;
            }
            if (this.getXmlPeer().getXMLParent() == null) {
                boolean b3rdPartyNode = true;
                if ((b_data || b_Data || b_DataDesc) && this.isCompatibleNS(aNodeNameSpace)) {
                    b3rdPartyNode = false;
                }
                if (b3rdPartyNode) {
                    Element dataNodePeer = this.getOwnerDocument().createElementNS("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:data", null);
                    dataNodePeer.setModel(this);
                    DataNode data = this.createDataGroupFromPeer(this, dataNodePeer);
                    this.loadDataNode(data, node, generator, bValidRecordLoaded);
                    this.setAliasNode(this.getDataRoot());
                    if (bHasNameAttr && nameAttr != null) {
                        this.updateAttribute(nameAttr);
                    }
                    return;
                }
            }
            if (this.isCompatibleNS(aNodeNameSpace) && (b_Data || b_data || b_DataDesc)) {
                if (b_Data) {
                    aMappedName = "data";
                    bOverrideDataName = true;
                }
                bCreateDataValue = false;
                bOverride = true;
            }
            this.processRecords(false);
        } else if (bGrandParentIsDataModel) {
            String aParentName = parent.getName();
            if (aParentName == "dataDescription") {
                bParentIsDataDescription = true;
                this.processRecords(false);
                bCreateDataValue = false;
                bOverride = true;
            } else if (aParentName == "data") {
                if (parent.getIndex(true) == 0) {
                    this.processRecords(true);
                } else {
                    this.processRecords(false);
                }
            } else {
                this.processRecords(false);
            }
        }
        Node firstChild = node.getFirstXMLChild();
        boolean bIsRichText = false;
        boolean bIsNull = false;
        Attribute dataNodeAttr = null;
        if (node instanceof Element) {
            Element e = (Element)node;
            dataNodeAttr = this.findAttrInNS(e, "dataNode");
            String sContentType = "";
            Attribute contentTypeAttr = this.findAttrInNS(e, "contentType");
            if (contentTypeAttr != null) {
                sContentType = contentTypeAttr.getAttrValue();
                bIsRichText = sContentType.equals("text/html");
            }
        }
        while (firstChild != null && (firstChild instanceof Comment || firstChild instanceof ProcessingInstruction)) {
            firstChild = firstChild.getNextXMLSibling();
        }
        if (!bStripWhiteSpace && (bParentIsDataGroup || bParentIsDataModel) && (dataNodeAttr == null || dataNodeAttr != null && dataNodeAttr.getAttrValue() == "dataGroup")) {
            Node node2 = firstChild;
            while (node2 != null) {
                if (node2 instanceof Element && this.loadSpecialNode(null, (Element)node2, true)) {
                    node2 = node2.getNextXMLSibling();
                    continue;
                }
                if (node2 instanceof Element) {
                    bStripWhiteSpace = true;
                } else if (node2 instanceof Chars && !((Chars)node2).isXMLSpace()) {
                    bStripWhiteSpace = false;
                    break;
                }
                node2 = node2.getNextXMLSibling();
            }
        }
        if (bStripWhiteSpace) {
            if (node instanceof Element) {
                ((Element)node).removeWhiteSpace();
            }
            firstChild = node.getFirstXMLChild();
        }
        DataWindow dw = this.mDataWindow;
        boolean bIsRecordDepth = false;
        if (node instanceof Element) {
            if (!bParentIsDataValue && dataNodeAttr != null) {
                if (dataNodeAttr.getAttrValue().equals("dataValue")) {
                    bCreateDataValue = true;
                    bOverride = true;
                } else if (dataNodeAttr.getAttrValue().equals("dataGroup")) {
                    bCreateDataValue = false;
                    bOverride = true;
                }
            }
            if (!bParentIsDataValue && bIsRichText) {
                bCreateDataValue = true;
                bOverride = true;
            }
            boolean bFoundText = false;
            boolean bFoundFirstElement = false;
            for (Node node3 = firstChild; node3 != null; node3 = node3.getNextXMLSibling()) {
                if (node3 instanceof TextNode) {
                    bFoundText = true;
                    break;
                }
                if (!(node3 instanceof Element)) continue;
                String aNameSpaceURI = ((Element)node3).getNS();
                if (!bFoundFirstElement && aNameSpaceURI == "http://www.w3.org/1999/xhtml") {
                    bCreateDataValue = true;
                    bOverride = true;
                    bIsRichText = true;
                    break;
                }
                bFoundFirstElement = true;
            }
            if (!bOverride) {
                boolean bl = bCreateDataValue = bFoundText || bParentIsDataValue || firstChild == null;
                if (firstChild == null && bParentIsDataGroup && bGrandParentIsDataModel && node.getXMLParent().getFirstXMLChild() == node) {
                    boolean siblingsEmpty = true;
                    for (Node nSibling = node.getNextXMLSibling(); nSibling != null; nSibling = nSibling.getNextXMLSibling()) {
                        Element siblingElement;
                        if (!(nSibling instanceof Element) || (siblingElement = (Element)nSibling).getFirstXMLChild() == null) continue;
                        siblingsEmpty = false;
                        break;
                    }
                    if (siblingsEmpty) {
                        this.getAppModel().getDocument().setAllDataRootsEmpty(true);
                    }
                }
            }
            if (!bOverrideDataName) {
                aMappedName = aNodeLocalName;
                if (this.mbHasMapping) {
                    aMappedName = aRename;
                    bOverrideDataName = true;
                }
                if (bHasNameAttr) {
                    aMappedName = nameAttr.getAttrValue().intern();
                    bOverrideDataName = true;
                }
            }
            if (bCreateDataValue) {
                newNode = this.createDataValueFromPeer(parent, node);
                if (bOverrideDataName) {
                    newNode.setPrivateName(aMappedName);
                }
                if (bIsNull) {
                    newNode.setIsNull(true, true);
                }
                if (bHasDataPictureFormat) {
                    newNode.setPictureFormat(sPictureFormat, "", false);
                }
            } else {
                boolean bIsRecordGroup;
                if (this.mIncrLoadHandler == null && this.processRecords()) {
                    bIsRecordDepth = dw.isRecordDepth(node);
                }
                if ((bIsRecordGroup = bIsRecordDepth) && this.maRecordName != null && this.maRecordName != aMappedName) {
                    bIsRecordGroup = false;
                }
                newNode = this.createDataGroupFromPeer(parent, node);
                if (bOverrideDataName) {
                    newNode.setPrivateName(aMappedName);
                }
                if (bIsRecordGroup) {
                    DataNode dg = newNode;
                    bValidRecordLoaded.value = true;
                    if (bFlatten && node instanceof Element) {
                        Node child = firstChild;
                        Node last = node.getLastXMLChild();
                        while (child != null) {
                            Node next = child.getNextXMLSibling();
                            DataModel.flattenNode((Element)node, child);
                            if (child == last) break;
                            child = next;
                        }
                        firstChild = node.getFirstXMLChild();
                    }
                    this.mDataWindow.addRecordGroup(dg);
                }
            }
        } else if (node instanceof AttributeWrapper || node instanceof Chars) {
            newNode = this.createDataValueFromPeer(parent, node);
            if (this.mbHasMapping && node instanceof AttributeWrapper && aRename != "") {
                newNode.setPrivateName(aRename);
            }
            if (this.mTransformations != null) {
                newNode = this.mTransformations.transform(newNode);
            }
            if (bHasNameAttr && nameAttr != null) {
                this.updateAttribute(nameAttr);
            }
            return;
        }
        if (newNode == null) {
            if (bHasNameAttr && nameAttr != null) {
                this.updateAttribute(nameAttr);
            }
            return;
        }
        boolean bSaveAttributesAreValues = this.attributesAreValues();
        if (bParentIsDataDescription) {
            this.setAttributesAreValues(true);
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            if (this.attributesAreValues()) {
                this.addAttributes((Element)newNode, element, generator);
            } else {
                int numAttrs = element.getNumAttrs();
                for (int i = 0; i < numAttrs; ++i) {
                    Attribute domAttr = element.getAttr(i);
                    String aLocalName = domAttr.getLocalName();
                    boolean bCheckOnly2 = ACROBAT_PLUGIN;
                    this.loadSpecialAttribute(domAttr, aLocalName, newNode, bCheckOnly2);
                }
            }
        }
        boolean bl = bOnlyChild = firstChild != null;
        if (bOnlyChild) {
            Node nextSibling;
            for (nextSibling = firstChild.getNextXMLSibling(); nextSibling != null && (nextSibling instanceof Comment || nextSibling instanceof ProcessingInstruction); nextSibling = nextSibling.getNextXMLSibling()) {
            }
            bOnlyChild = nextSibling == null;
        }
        boolean bSetText = false;
        if (bCreateDataValue && bOnlyChild && node instanceof Element && firstChild instanceof TextNode) {
            newNode.singleTextChild((TextNode)firstChild);
            bSetText = true;
        }
        if (!(bSetText || bIsRichText || bIsNull)) {
            Node child = node.getFirstXMLChild();
            Node oLastChild = node.getLastXMLChild();
            while (child != null) {
                Node nextSibling = child.getNextXMLSibling();
                if (child.getClass() == Element.class || child.getClass() == TextNode.class) {
                    this.loadDataNode(newNode, child, generator, bValidRecordLoaded);
                }
                if (child == oLastChild) break;
                child = nextSibling;
            }
        }
        if (this.mTransformations != null) {
            newNode = this.mTransformations.transform(newNode);
        }
        if (bHasNameAttr && nameAttr != null) {
            this.updateAttribute(nameAttr);
        }
        if (bParentIsDataModel) {
            this.setAliasNode(this.getDataRoot());
        }
        if (bParentIsDataDescription) {
            this.setAttributesAreValues(bSaveAttributesAreValues);
        }
    }

    private DataNode createDataValueFromPeer(Element parentNode, Node peerNode) {
        if (peerNode instanceof Element) {
            ((Element)peerNode).inhibitPrettyPrint(true);
        }
        return this.createDataNodeFromPeer(parentNode, peerNode, "dataValue", XFA.DATAVALUETAG);
    }

    private DataNode createDataGroupFromPeer(Element parentNode, Node peerNode) {
        return this.createDataNodeFromPeer(parentNode, peerNode, "dataGroup", XFA.DATAGROUPTAG);
    }

    private DataNode createDataNodeFromPeer(Element parentNode, Node peerNode, String sClassName, int eClassTag) {
        DataNode dataNode = new DataNode(parentNode, null, null, null, null, null);
        dataNode.setClass(sClassName, eClassTag);
        dataNode.setModel(this);
        dataNode.setDocument(this.getDocument());
        if (peerNode instanceof Element) {
            ((Element)peerNode).setModel(this);
        }
        peerNode.setDocument(this.getDocument());
        peerNode.setXfaPeer(dataNode);
        dataNode.setXmlPeer(peerNode);
        return dataNode;
    }

    private void processRecords(boolean b) {
        this.mbProcessRecords = b;
    }

    private boolean processRecords() {
        return this.mbProcessRecords;
    }

    void processDataDescription(Element dataParent) {
        if (dataParent == null) {
            return;
        }
        DataNode dataDescriptionParent = DataModel.getDataDesc(dataParent);
        if (dataParent == this.getDataRoot()) {
            for (Node dataNode = dataParent.getFirstXFAChild(); dataNode != null; dataNode = dataNode.getNextXFASibling()) {
                DataNode dataDesc;
                dataDescriptionParent = this.getDataDescriptionRoot(dataNode.getName());
                if (dataDescriptionParent == null || (dataDesc = (DataNode)dataDescriptionParent.locateChildByName(dataNode.getName(), 0)) == null || !DataModel.setDataDesc(dataDesc, (DataNode)dataNode)) continue;
                if (this.registerKeys(dataDesc)) {
                    dataDesc.getOwnerDocument().indexSubtree((DataNode)dataNode, false);
                }
                this.connectDataNodesToDataDescription(dataDesc, dataNode);
            }
        } else if (dataDescriptionParent != null) {
            if (this.registerKeys(dataDescriptionParent)) {
                dataDescriptionParent.getOwnerDocument().indexSubtree(dataParent, false);
            }
            this.connectDataNodesToDataDescription(dataDescriptionParent, dataParent);
        }
    }

    void pushStack() {
        if (this.mIncrLoadHandler != null) {
            ++this.mIncrLoadHandler.mnLoadNodeLevel;
        }
    }

    @Override
    public void remove() {
        AppModel appModel = this.getAppModel();
        if (appModel != null && !this.isDuplicateDataModel()) {
            appModel.removePseudoModel("$dataWindow");
            appModel.removePseudoModel("$record");
        }
        super.remove();
    }

    public static void removeDDPlaceholderFlags(Node dataNode, boolean bDeep) {
        if (dataNode == null) {
            return;
        }
        if (dataNode instanceof DataNode) {
            ((DataNode)dataNode).setIsDDPlaceholder(false);
        }
        if (bDeep) {
            for (Node child = dataNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                DataModel.removeDDPlaceholderFlags(child, true);
            }
        } else {
            Element parent = dataNode.getXFAParent();
            if (parent != null && DataModel.getDDPlaceholderFlag(parent)) {
                DataModel.removeDDPlaceholderFlags(parent, false);
            }
        }
    }

    protected void removeTextNodes() {
        Node child = this.getFirstXMLChild();
        while (child != null) {
            Node nextSibling = child.getNextXMLSibling();
            if (child instanceof TextNode) {
                this.removeChild(child);
            }
            child = nextSibling;
        }
    }

    @Override
    public void resetPostLoadXML() {
        this.processDataDescription(this.getDataRoot());
        if (this.mDataWindow != null) {
            this.mDataWindow.updateAfterLoad();
        }
    }

    public Node resolveRef(String sSOM, Element contextNode, boolean bDataValue, boolean bDefault) {
        Node newNode = null;
        boolean bCreate = true;
        DataNode dataDescription = DataModel.getDataDesc(contextNode);
        if (dataDescription != null) {
            bCreate = this.mbDisableSchemaValidation;
            if (sSOM.startsWith("$data.")) {
                DataNode dataNode = (DataNode)this.resolveNodeCreate((String)"$data", (int)1, (boolean)false, (boolean)false, (boolean)false).object;
                String sRelSOM = sSOM.substring(6);
                DataNode dataDescForData = DataModel.getRootOfDataDescription(dataDescription);
                if (dataDescForData != null) {
                    newNode = this.createDataNodeFromDescription(dataDescForData, dataNode, sRelSOM, bDataValue, bDefault);
                }
            } else if (sSOM.startsWith("$record.")) {
                DataNode recordNode = (DataNode)this.resolveNodeCreate((String)"$record", (int)1, (boolean)false, (boolean)false, (boolean)false).object;
                String sRelSOM = sSOM.substring(8);
                DataNode dataDescRoot = DataModel.getRootOfDataDescription(dataDescription);
                DataNode dataDescForRecord = (DataNode)dataDescRoot.getFirstXFAChild();
                if (dataDescForRecord != null) {
                    newNode = this.createDataNodeFromDescription(dataDescForRecord, recordNode, sRelSOM, bDataValue, bDefault);
                }
            } else if (sSOM.startsWith("!connectionData.")) {
                String sRelSOM = sSOM.substring(16);
                DataNode connectionData = (DataNode)this.resolveNodeCreate((String)"!connectionData", (int)1, (boolean)false, (boolean)false, (boolean)false).object;
                DataNode dataDescForConnection = DataModel.getRootOfDataDescription(dataDescription);
                if (dataDescForConnection != null && connectionData != null) {
                    newNode = this.createDataNodeFromDescription(dataDescForConnection, connectionData, sRelSOM, bDataValue, bDefault);
                }
            } else {
                newNode = this.createDataNodeFromDescription(dataDescription, contextNode, sSOM, bDataValue, bDefault);
            }
        }
        if (bCreate && newNode == null) {
            Node oNode;
            this.mbIgnoreSchemaDuringCurNodeCreation = true;
            newNode = oNode = (Node)contextNode.resolveNodeCreate((String)sSOM, (int)1, (boolean)bDataValue, (boolean)bDefault, (boolean)true).object;
            this.mbIgnoreSchemaDuringCurNodeCreation = false;
        }
        return newNode;
    }

    Node createDataNodeFromDescription(DataNode dataDescriptionParent, Element dataParent, String sSom, boolean bDataValue, boolean bDefault) {
        ObjectHolder<Element> dataParentHolder = new ObjectHolder<Element>(dataParent);
        ObjectHolder<DataNode> dataDescriptionParentHolder = new ObjectHolder<DataNode>(dataDescriptionParent);
        ArrayList<String> nodesToCreate = new ArrayList<String>();
        if (!this.determineWhatToCreate(sSom, dataParentHolder, dataDescriptionParentHolder, nodesToCreate)) {
            return null;
        }
        dataDescriptionParent = (DataNode)dataDescriptionParentHolder.value;
        dataParent = (Element)dataParentHolder.value;
        for (int i = 0; i < nodesToCreate.size(); ++i) {
            Element newNode;
            DataNode dataDescriptionNode;
            String sNewNode = (String)nodesToCreate.get(i);
            int occIndex = 0;
            int nBraceStart = sNewNode.indexOf(91);
            if (nBraceStart != -1) {
                int nBraceEnd = sNewNode.indexOf(93);
                if (nBraceEnd != -1) {
                    String sNum = sNewNode.substring(nBraceStart + 1, nBraceEnd);
                    if (sNum.equals("*")) {
                        occIndex = -1;
                    } else {
                        try {
                            occIndex = Integer.parseInt(sNum);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                sNewNode = sNewNode.substring(0, nBraceStart);
            }
            if ((dataDescriptionNode = this.getDataDescriptionChild(dataDescriptionParent, sNewNode)) == null) {
                return null;
            }
            if (dataDescriptionNode.getXmlPeer() instanceof AttributeWrapper) {
                Element attrNode = this.getDataChild(dataParent, sNewNode);
                if (attrNode != null) {
                    newNode = attrNode;
                } else {
                    Element firstElement = DataModel.getFirstElementChild(dataParent);
                    newNode = this.createNodeFromDataDescription(dataDescriptionNode, dataParent, firstElement, bDefault);
                }
            } else {
                newNode = (DataNode)this.populateParent(dataParent, null, dataDescriptionParent, dataDescriptionNode, occIndex, bDefault);
            }
            this.clearDataDescriptionInfo(newNode);
            dataParent = newNode;
            if (dataParent == null) {
                return null;
            }
            dataDescriptionParent = dataDescriptionNode;
        }
        if (dataParent != null && dataParent.getClassTag() == XFA.DATAVALUETAG != bDataValue) {
            return null;
        }
        return dataParent;
    }

    private boolean determineWhatToCreate(String sSom, ObjectHolder<Element> dataParentHolder, ObjectHolder<DataNode> dataDescriptionParentHolder, List<String> nodesToCreate) {
        int i;
        ArrayList<String> nodeList;
        DataNode dataDescriptionParent;
        Element dataParent;
        block6: {
            String sNode;
            dataParent = (Element)dataParentHolder.value;
            dataDescriptionParent = (DataNode)dataDescriptionParentHolder.value;
            nodeList = new ArrayList<String>();
            IntegerHolder nOffset = new IntegerHolder();
            while ((sNode = DataModel.getSOMSection(sSom, nOffset)).length() != 0) {
                nodeList.add(sNode);
            }
            for (i = 0; i < nodeList.size(); ++i) {
                Element tmpNode = dataParent;
                String sTestNameExists = (String)nodeList.get(i);
                if ((dataParent = this.getDataChild(dataParent, sTestNameExists)) == null) {
                    dataParent = tmpNode;
                    break;
                }
                dataDescriptionParent = DataModel.getDataDesc(dataParent) != null ? DataModel.getDataDesc(dataParent) : this.getDataDescriptionChild(dataDescriptionParent, sTestNameExists);
                if (dataDescriptionParent != null) continue;
                return false;
            }
            if (dataParent != null && i == nodeList.size()) {
                do {
                    String sNodeName = (String)nodeList.get(--i);
                    dataParent = (DataNode)dataParent.getXFAParent();
                    dataDescriptionParent = (DataNode)dataDescriptionParent.getXFAParent();
                    if (sNodeName.indexOf(42) != -1) break block6;
                } while (i != 0);
                return false;
            }
        }
        while (i < nodeList.size()) {
            nodesToCreate.add((String)nodeList.get(i));
            ++i;
        }
        dataParentHolder.value = dataParent;
        dataDescriptionParentHolder.value = dataDescriptionParent;
        return true;
    }

    private Element getDataChild(Element parent, String sNewNodeRef) {
        if (sNewNodeRef.equals("$")) {
            return parent;
        }
        StringHolder sNewNode = new StringHolder(sNewNodeRef);
        int nIndex = this.getIndexFromString(sNewNode);
        return (DataNode)parent.locateChildByName(sNewNode.value.intern(), nIndex);
    }

    private int getIndexFromString(StringHolder sRef) {
        int nRet = 0;
        int nBraceStart = sRef.value.indexOf(91);
        if (nBraceStart != -1) {
            String sNum;
            int nBraceEnd = sRef.value.indexOf(93, nBraceStart);
            if (nBraceEnd != -1 && !"*".equals(sNum = sRef.value.substring(nBraceStart + 1, nBraceEnd))) {
                try {
                    nRet = Integer.parseInt(sNum);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            sRef.value = sRef.value.substring(0, nBraceStart);
        }
        return nRet;
    }

    private static String getSOMSection(String sSom, IntegerHolder nOffset) {
        if (nOffset.value >= sSom.length()) {
            return "";
        }
        StringBuilder sSection = new StringBuilder();
        while (nOffset.value < sSom.length()) {
            char cUni = sSom.charAt(nOffset.value);
            ++nOffset.value;
            if (cUni == '\\') {
                if (nOffset.value >= sSom.length()) continue;
                cUni = sSom.charAt(nOffset.value);
                ++nOffset.value;
                sSection.append(cUni);
                continue;
            }
            if (cUni == '.') {
                if (sSection.length() <= 0) continue;
                break;
            }
            sSection.append(cUni);
        }
        return sSection.toString();
    }

    private DataNode getDataDescriptionChild(DataNode parent, String sNewNodeRef) {
        if (sNewNodeRef.equals("$")) {
            return parent;
        }
        StringHolder sNewNode = new StringHolder(sNewNodeRef);
        int nIndex = this.getIndexFromString(sNewNode);
        return this.getDataDescriptionChild(parent, sNewNode.value, nIndex);
    }

    private DataNode getDataDescriptionChild(DataNode parent, String sNewNode, int nIndex) {
        String aNewNode = sNewNode.intern();
        for (DataNode child = (DataNode)parent.getFirstXFAChild(); child != null; child = (DataNode)child.getNextXFASibling()) {
            if (DataModel.isDataDescriptionNS(child.getNS())) {
                DataNode grandChild;
                if (!DataModel.isDataDescriptionGroup(child) || (grandChild = this.getDataDescriptionChild(child, sNewNode, nIndex)) == null) continue;
                return grandChild;
            }
            if (child.getName() != aNewNode) continue;
            int nMax = DataModel.getMaxOccurFromDataDescription(child, true);
            if (nMax < 0 || nMax >= nIndex) {
                return child;
            }
            nIndex -= nMax;
        }
        return null;
    }

    @Override
    public void serialize(OutputStream os, DOMSaveOptions options, int level, Node prevSibling) throws IOException {
        this.getXmlPeer().serialize(os, options, level, prevSibling);
    }

    void setAttributesAreValues(boolean bAttributesAreValues) {
        this.mbAttributesAreValues = bAttributesAreValues;
    }

    static boolean setDataDesc(DataNode desc, DataNode dataNode, boolean bDontAllowChangeType) {
        if (!bDontAllowChangeType && desc.getClassTag() != dataNode.getClassTag()) {
            if (dataNode.getClassTag() == XFA.DATAGROUPTAG) {
                dataNode = DataModel.changeType(dataNode, true);
            } else if (dataNode.getClassTag() == XFA.DATAVALUETAG) {
                dataNode = DataModel.changeType(dataNode, false);
            } else {
                ExFull ex = new ExFull(new MsgFormat(ResId.InvalidNodeTypeException, dataNode.getClassAtom()));
                Model model = dataNode.getModel();
                model.addXMLLoadErrorContext(dataNode, ex);
                model.addErrorList(ex, 3, dataNode);
                return false;
            }
        }
        if (dataNode.getClassTag() == XFA.DATAGROUPTAG) {
            if (dataNode.getDataDescription() == null) {
                dataNode.setDataDescription(desc);
                return true;
            }
        } else if (dataNode.getClassTag() == XFA.DATAVALUETAG && dataNode.getDataDescription() == null) {
            dataNode.setDataDescription(desc);
            return true;
        }
        return false;
    }

    static boolean setDataDesc(DataNode desc, DataNode dataNode) {
        return DataModel.setDataDesc(desc, dataNode, false);
    }

    void setDataWindowParameters(int nDataWindowRecordsBefore, int nDataWindowRecordsAfter) {
        this.mnDataWindowRecordsBefore = nDataWindowRecordsBefore;
        this.mnDataWindowRecordsAfter = nDataWindowRecordsAfter;
        this.mbDataWindowRecordsSpecified = true;
    }

    void setExcludeNSList(String newExcludeNSString) {
        String whiteSpace = "[\n\t\r ]+";
        String[] tokens = newExcludeNSString.split(whiteSpace);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].intern();
            this.mExcludeNSList.put(token, Boolean.TRUE);
        }
    }

    protected void setRangeOptions(String sRanges) {
        RecordRangeFilter poFilter = new RecordRangeFilter(this.mDataWindow, sRanges);
        this.mDataWindow.addFilter(poFilter);
    }

    protected void setRecordOptions(int recordLevel, String recordName) {
        this.mnRecordLevel = recordLevel;
        this.maRecordName = recordName == null ? null : recordName.intern();
    }

    void setStartNodeSOMString(String newSOMString) {
        this.mStartNodeSOMString = newSOMString;
    }

    public void setSourceSetLink(SourceSetLink sourceSetLink) {
        if (this.mSourceSetLink != null) {
            this.mSourceSetLink = null;
        }
        if (sourceSetLink != null) {
            this.mSourceSetLink = (SourceSetLink)sourceSetLink.clone();
        }
    }

    public void setSaveFormat(int format) {
        if (this.meFormat == format) {
            return;
        }
        DataNode data = this.getDataRoot();
        if (data == null) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataModel#setSaveFormat - no xfa:data node");
        }
        if (format != 0) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataModel#setSaveFormat - XPF format");
        }
        this.meFormat = format;
    }

    void setTransformations(DataTransformations transformations) {
        this.mTransformations = transformations;
    }

    void singleTextChild(TextNode child) {
    }

    void transformNode(Element parent, DataNode node) {
        boolean bFlatten;
        String sPictureFormat;
        int eOperation = 0;
        String aMappedName = "";
        String aNodeLocalName = node.getLocalName();
        eOperation = this.mTransformations.getOperation(aNodeLocalName, 1076494336);
        String aNameAttr = this.mTransformations.getNameAttr(aNodeLocalName);
        int attrIndex = -1;
        if (aNameAttr != "" && (attrIndex = node.findAttr(null, aNameAttr)) != -1) {
            node.setPrivateName(aMappedName);
        }
        if ((sPictureFormat = this.mTransformations.getPictureFormat(aNodeLocalName)) != "") {
            node.setPictureFormat(sPictureFormat, "", false);
        }
        boolean bExclude = eOperation == 0x220000 || eOperation == 0x220001 || this.excludeNS(node.getNS());
        boolean bl = bFlatten = eOperation == 0x220003;
        if (bFlatten) {
            Node child = node.getFirstXFAChild();
            while (child != null) {
                Node next = child.getNextXFASibling();
                DataModel.flattenNode(node, child);
                child = next;
            }
        }
        if (bExclude) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataModel#transformNode");
        }
        this.mTransformations.transform(node);
    }

    private boolean validateUsage(int nVersion, int nAvailability, boolean bFatalError, boolean bUpdateVersion) {
        boolean bRet;
        AppModel appModel = this.getAppModel();
        int eOutputBelow = appModel.getOutputBelow();
        int nTargetOutputVer = appModel.getVersionRestriction();
        boolean bl = bRet = !bFatalError;
        if (nTargetOutputVer != 0 && !this.isVersionCompatible(nVersion, nTargetOutputVer) && eOutputBelow != 0x7F0000) {
            if (bFatalError) {
                if (eOutputBelow == 8323074) {
                    bRet = true;
                }
            } else {
                bRet = false;
            }
        }
        return bRet;
    }

    @Override
    public boolean validateUsage(int nXFAVersion, int nAvailability, boolean bUpdateVersion) {
        return this.validateUsage(nXFAVersion, nAvailability, false, bUpdateVersion);
    }

    @Override
    public boolean validateUsageFailedIsFatal(int nXFAVersion, int nAvailability) {
        return this.validateUsage(nXFAVersion, nAvailability, true, false);
    }

    public void disableSchemaValidation(boolean bMode) {
        this.mbDisableSchemaValidation = bMode;
    }

    @Override
    public String getHeadNS() {
        return "http://www.xfa.org/schema/xfa-data/1.0/";
    }

    @Override
    public int getHeadVersion() {
        return 10;
    }

    public static Obj resolveAssociation(Element dataNode, String aAssociationName, BooleanHolder foundNullAssociation) {
        DataNode dataDesc;
        if (foundNullAssociation != null) {
            foundNullAssociation.value = false;
        }
        if ((dataDesc = DataModel.getDataDesc(dataNode)) != null) {
            for (DataNode child = (DataNode)dataDesc.getFirstXFAChild(); child != null; child = (DataNode)child.getNextXFASibling()) {
                int index;
                Element assoc = (Element)child.getXmlPeer();
                if (assoc.getNS() != "http://ns.adobe.com/data-description/" || assoc.getLocalName() != "association" || (index = assoc.findAttr("http://ns.adobe.com/data-description/", "name")) == -1 || !assoc.getAttr(index).getAttrValue().equals(aAssociationName)) continue;
                ArrayList<String> keyNodeAddressList = new ArrayList<String>();
                index = assoc.findAttr("http://ns.adobe.com/data-description/", "mappedBy");
                if (index != -1) {
                    String sReflectedAssoc = assoc.getAttrVal(index);
                    index = dataDesc.findAttr("http://ns.adobe.com/data-description/", "primaryKey");
                    StringTokenizer tokenizer = new StringTokenizer(index == -1 ? "" : dataDesc.getAttrVal(index), ",");
                    while (tokenizer.hasMoreTokens()) {
                        keyNodeAddressList.add(tokenizer.nextToken().trim());
                    }
                    Key primaryKey = dataNode.constructKey(keyNodeAddressList, dataDesc);
                    Element reflectedAssoc = (Element)DataModel.findAssociation(DataModel.getRootOfDataDescription(dataDesc), sReflectedAssoc);
                    index = reflectedAssoc.findAttr("http://ns.adobe.com/data-description/", "key");
                    tokenizer = new StringTokenizer(index == -1 ? "" : reflectedAssoc.getAttrVal(index), ",");
                    keyNodeAddressList.clear();
                    while (tokenizer.hasMoreTokens()) {
                        keyNodeAddressList.add(tokenizer.nextToken().trim());
                    }
                    StringHolder aTargetNamespacePrefix = new StringHolder();
                    StringHolder aTargetName = new StringHolder();
                    index = assoc.findAttr("http://ns.adobe.com/data-description/", "target");
                    String sTarget = index == -1 ? "" : assoc.getAttrVal(index);
                    Element.explodeQName(sTarget, aTargetNamespacePrefix, aTargetName);
                    String aTargetNamespaceURI = assoc.resolvePrefix(aTargetNamespacePrefix.value);
                    ArrayNodeList targetList = new ArrayNodeList();
                    Element dataRoot = dataNode.getModel().getAliasNode();
                    DataModel.getReflectedNodes(dataRoot, aTargetNamespaceURI, aTargetName.value, primaryKey, keyNodeAddressList, reflectedAssoc, targetList);
                    return targetList;
                }
                index = assoc.findAttr("http://ns.adobe.com/data-description/", "key");
                StringTokenizer tokenizer = new StringTokenizer(index == -1 ? "" : assoc.getAttrVal(index), ",");
                while (tokenizer.hasMoreTokens()) {
                    keyNodeAddressList.add(tokenizer.nextToken().trim());
                }
                Element sourceElem = dataNode;
                ArrayList<Key> keys = new ArrayList<Key>();
                sourceElem.constructKeys(keyNodeAddressList, assoc, keys);
                ArrayNodeList targetList = new ArrayNodeList();
                for (int j = 0; j < keys.size(); ++j) {
                    Element targetElem = sourceElem.getOwnerDocument().getElementByPKey((Key)keys.get(j));
                    if (targetElem == null) continue;
                    ((ListBase)targetList).append(targetElem.getXfaPeer());
                }
                if (((ListBase)targetList).length() == 1) {
                    return ((ListBase)targetList).item(0);
                }
                if (((ListBase)targetList).length() > 1) {
                    return targetList;
                }
                if (foundNullAssociation != null) {
                    foundNullAssociation.value = true;
                }
                return null;
            }
        }
        return null;
    }

    public static DataNode getRootOfDataDescription(Node dataDesc) {
        if (dataDesc == null) {
            return null;
        }
        if (DataModel.isDataDescriptionNode(dataDesc)) {
            return (DataNode)dataDesc;
        }
        return DataModel.getRootOfDataDescription(dataDesc.getXFAParent());
    }

    public static Node findAssociation(Node dataDesc, String aAssociationName) {
        int index;
        Element dataDescElement;
        if (dataDesc instanceof Element && (dataDescElement = (Element)dataDesc).getNS() == "http://ns.adobe.com/data-description/" && dataDesc.getName() == "association" && (index = dataDescElement.findAttr("http://ns.adobe.com/data-description/", "name")) != -1 && dataDescElement.getAttrVal(index).equals(aAssociationName)) {
            return dataDesc;
        }
        for (Node child = dataDesc.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            Node association = DataModel.findAssociation(child, aAssociationName);
            if (association == null) continue;
            return association;
        }
        return null;
    }

    public static void getReflectedNodes(Node dataNode, String aTargetNamespaceURI, String aTargetName, Key targetKey, List<String> oFKeyValueAddressList, Node namespaceContextNode, NodeList results) {
        Element domNode;
        if (dataNode instanceof DataNode && (domNode = (Element)((DataNode)dataNode).getXmlPeer()).getNS() == aTargetNamespaceURI && domNode.getName() == aTargetName) {
            ArrayList<Key> foreignKeys = new ArrayList<Key>();
            domNode.constructKeys(oFKeyValueAddressList, namespaceContextNode, foreignKeys);
            for (int i = 0; i < foreignKeys.size(); ++i) {
                if (!((Key)foreignKeys.get(i)).equals(targetKey)) continue;
                results.append(dataNode);
                break;
            }
            return;
        }
        for (Node child = dataNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            DataModel.getReflectedNodes(child, aTargetNamespaceURI, aTargetName, targetKey, oFKeyValueAddressList, namespaceContextNode, results);
        }
    }

    public static final class AttributeWrapper
    extends Element {
        final Attribute mAttribute;
        final Element mParent;
        private Element mXfaPeer;

        public AttributeWrapper(Attribute attribute, Element parent) {
            this.mAttribute = attribute;
            this.mParent = parent;
        }

        @Override
        public String getNS() {
            return this.mAttribute.getNS();
        }

        @Override
        public String getLocalName() {
            return this.mAttribute.getLocalName();
        }

        @Override
        public String getXMLName() {
            return this.mAttribute.getQName();
        }

        public String getValue() {
            return this.mAttribute.getAttrValue();
        }

        @Override
        public Element getXMLParent() {
            return this.mParent;
        }

        @Override
        public Element clone(Element parent, boolean deep) {
            return new AttributeWrapper(this.mAttribute, parent);
        }

        @Override
        public Element getXfaPeer() {
            return this.mXfaPeer;
        }

        @Override
        public void setXfaPeer(Element xfaPeer) {
            this.mXfaPeer = xfaPeer;
        }
    }

    private static class RecordRangeFilter
    extends DataWindowFilter {
        private final SortedMap<Integer, Integer> mRanges = new TreeMap<Integer, Integer>();

        RecordRangeFilter(DataWindow dataWindow, String sRanges) {
            super(dataWindow);
            this.setRanges(sRanges);
        }

        private void setRanges(String sRanges) {
            int offset;
            int tokenSeparator = 44;
            int rangeSeparator = 45;
            for (offset = 0; offset < sRanges.length() && Character.isWhitespace(sRanges.charAt(offset)); ++offset) {
            }
            while (offset < sRanges.length()) {
                String token;
                int index = sRanges.indexOf(44, offset);
                if (index == -1) {
                    token = sRanges.substring(offset);
                    offset = sRanges.length();
                } else {
                    token = sRanges.substring(offset, index);
                    offset = index + 1;
                }
                int nStart = 0;
                int nEnd = 0;
                index = token.indexOf(45);
                if (index != -1) {
                    if (index == 0) {
                        MsgFormatPos msg = new MsgFormatPos(ResId.MalformedOptionException);
                        msg.format("range");
                        throw new ExFull(msg);
                    }
                    String sStart = token.substring(0, index);
                    try {
                        nStart = Integer.parseInt(sStart);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    if (index == token.length() - 1) {
                        nEnd = -1;
                    } else {
                        String sEnd = token.substring(index + 1);
                        try {
                            nEnd = Integer.parseInt(sEnd);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    this.mRanges.put(nStart, nEnd);
                } else {
                    try {
                        nStart = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    this.mRanges.put(nStart, nStart);
                }
                while (offset < sRanges.length() && Character.isWhitespace(sRanges.charAt(offset))) {
                    ++offset;
                }
            }
        }

        @Override
        boolean filterRecord(DataNode dataGroup, int nAbsRecordIndex) {
            if (this.mRanges.isEmpty()) {
                return true;
            }
            for (Map.Entry<Integer, Integer> entry : this.mRanges.entrySet()) {
                if (nAbsRecordIndex < entry.getKey()) break;
                if (entry.getValue() == -1) {
                    return true;
                }
                if (nAbsRecordIndex > entry.getValue()) continue;
                return true;
            }
            return false;
        }
    }

    private static class RecordPseudoModel
    extends PseudoModel {
        private final DataWindow mDataWindow;

        public RecordPseudoModel(DataWindow dataWindow) {
            this.mDataWindow = dataWindow;
            this.setClass("recordPseudoModel");
        }

        @Override
        public String getClassAtom() {
            return super.getClassName();
        }

        @Override
        public ScriptTable getScriptTable() {
            if (!this.mDataWindow.isDefined()) {
                return super.getScriptTable();
            }
            return this.mDataWindow.record(0).getScriptTable();
        }

        @Override
        public Obj getAliasObject() {
            if (!this.mDataWindow.isDefined()) {
                return super.getAliasObject();
            }
            return this.mDataWindow.record(0);
        }

        @Override
        public Obj getScriptThis() {
            if (!this.mDataWindow.isDefined()) {
                return super.getScriptThis();
            }
            return this.mDataWindow.record(0);
        }
    }

    public static interface SourceSetLink {
        public boolean isSource(Node var1, String var2);

        public List<String> getColumnData(Node var1, String var2, String var3);

        public Object clone();
    }
}

