/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.connectionset.proxies;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.EventPseudoModel;
import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.connectionset.EffectiveInputPolicy;
import com.adobe.xfa.connectionset.proxies.ConnectionSetProxy;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.protocol.AuthenticationHandler;
import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.soap.SOAP;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.CharacterHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.Resolver;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class WSDLConnectionSetProxy
extends ConnectionSetProxy {
    private final ConnectionSetProxyHandler moHandler;
    private final Object moHandlerData;
    private String msConnectionName;
    private Element moWSDLConnectionNode;
    private String msSOAPFile;

    public WSDLConnectionSetProxy() {
        this(null, null);
    }

    public WSDLConnectionSetProxy(WSDLConnectionSetProxy oProxy) {
        this(oProxy.moHandler, oProxy.moHandlerData);
        this.msConnectionName = oProxy.msConnectionName;
        this.msSOAPFile = oProxy.msSOAPFile;
    }

    public WSDLConnectionSetProxy(ConnectionSetProxyHandler handler, Object inHandlerData) {
        this.moHandler = handler;
        this.moHandlerData = inHandlerData;
    }

    @Override
    public ConnectionSetProxy clone() {
        return new WSDLConnectionSetProxy(this);
    }

    private void createBasicWSSecurityHeader(ByteArrayOutputStream oHeaderStreamFile, String sUserId, String sPassword, boolean bDigest) {
        block5: {
            if (oHeaderStreamFile.size() > 0) {
                return;
            }
            String sEscapedUserid = this.escapePasswordCharacters(sUserId);
            String sEscapedPassword = this.escapePasswordCharacters(sPassword);
            String sXMLHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soap:Header xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ><wsse:Security><wsse:UsernameToken xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><wsse:Username>" + StringUtils.toXML(sEscapedUserid, false) + "</wsse:Username><wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">" + StringUtils.toXML(sEscapedPassword, false) + "</wsse:Password>" + "</wsse:UsernameToken></wsse:Security></soap:Header>";
            try {
                oHeaderStreamFile.write(sXMLHeader.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                assert (false);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    String escapePasswordCharacters(String sText) {
        StringBuilder sResult = new StringBuilder(sText);
        Storage oKeys = new Storage();
        oKeys.add("&");
        oKeys.add("<");
        oKeys.add(">");
        Storage oValues = new Storage();
        oValues.add("&amp;");
        oValues.add("&lt;");
        oValues.add("&gt;");
        int nKeys = oKeys.size();
        for (int i = 0; i < nKeys; ++i) {
            int nFoundAt;
            int nOffset = 0;
            String sKey = (String)oKeys.get(i);
            int nKeyLength = sKey.length();
            String sValue = (String)oValues.get(i);
            int nValueLength = sValue.length();
            while ((nFoundAt = sResult.indexOf(sKey, nOffset)) > -1) {
                sResult.replace(nFoundAt, nFoundAt + nKeyLength, sValue);
                nOffset = nFoundAt + nValueLength;
            }
        }
        return sResult.toString();
    }

    @Override
    public boolean execute(Element oWSDLConnectionNode, boolean bDynamicMerge) {
        TemplateModel oTemplateModel = null;
        EventPseudoModel oEventPseudoModel = null;
        assert (this.moOwner != null && this.moOwner.getAppModel() != null);
        if (this.moOwner != null && this.moOwner.getAppModel() != null) {
            oTemplateModel = TemplateModel.getTemplateModel(this.moOwner.getAppModel(), false);
            oEventPseudoModel = (EventPseudoModel)this.moOwner.getAppModel().lookupPseudoModel("$event");
        }
        assert (oTemplateModel != null && oEventPseudoModel != null);
        if (oTemplateModel == null || oEventPseudoModel == null) {
            return false;
        }
        this.moWSDLConnectionNode = oWSDLConnectionNode;
        this.msConnectionName = oWSDLConnectionNode.getName();
        String sSoapAction = this.getElementValue(oWSDLConnectionNode, XFA.SOAPACTIONTAG);
        String sSoapAddress = this.getElementValue(oWSDLConnectionNode, XFA.SOAPADDRESSTAG);
        String sWSDLAddress = this.getElementValue(oWSDLConnectionNode, XFA.WSDLADDRESSTAG);
        FormModel formModel = FormModel.getFormModel(this.moOwner.getAppModel(), true);
        assert (formModel != null);
        formModel.exportConnectionData(this.msConnectionName, oWSDLConnectionNode.getAttribute(XFA.DATADESCRIPTIONTAG, true, false).toString());
        SOAP oPreSOAPModel = this.setSOAPModelFromConnectionData(false);
        if (oPreSOAPModel == null) {
            return false;
        }
        boolean bLegacyPostExecute = oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_EVENTMODEL);
        this.notifyPreExecute(oPreSOAPModel);
        SOAP oSOAPModel = null;
        DataNode connectionDataNode = null;
        DataModel dataModel = null;
        if (oEventPseudoModel.cancelAction("execute")) {
            if (bLegacyPostExecute) {
                oEventPseudoModel.setCancelAction(false, "postExecute");
            } else {
                this.notifyPostExecute(oSOAPModel);
            }
            this.moWSDLConnectionNode = null;
            return false;
        }
        SOAP oResponseModel = null;
        try {
            byte[] bytes;
            DataNode wsdlDataNode;
            String sConnectionDataRoot;
            AuthenticationHandler.AuthenticationType eSOAPAuthType;
            AuthenticationHandler oAuthHandler;
            oSOAPModel = this.setSOAPModelFromConnectionData(true);
            if (oSOAPModel == null) {
                if (bLegacyPostExecute) {
                    oEventPseudoModel.setCancelAction(false, "postExecute");
                } else {
                    this.notifyPostExecute(oSOAPModel);
                }
                this.moWSDLConnectionNode = null;
                return false;
            }
            oResponseModel = oSOAPModel.sendRequest(sSoapAddress, sSoapAction);
            if (oResponseModel == null) {
                if (bLegacyPostExecute) {
                    oEventPseudoModel.setCancelAction(false, "postExecute");
                } else {
                    this.notifyPostExecute(oSOAPModel);
                }
                this.moWSDLConnectionNode = null;
                return false;
            }
            String sScheme = "";
            Protocol oProtocol = Resolver.getProtocol(sScheme);
            if (oProtocol != null && (oAuthHandler = oProtocol.getAuthenticationHandler()) != null && (eSOAPAuthType = oAuthHandler.getSOAPAuthType()) != AuthenticationHandler.AuthenticationType.NONE) {
                if (oResponseModel.getFaultNode() == null) {
                    oAuthHandler.setSOAPRequestStatus(AuthenticationHandler.SOAPRequestStatus.SOAPSUCCESS);
                } else {
                    oAuthHandler.setSOAPRequestStatus(AuthenticationHandler.SOAPRequestStatus.SOAPFAULT);
                    String sFaultCode = oResponseModel.getFaultCode();
                    String sResponse = oResponseModel.getFaultString();
                    oAuthHandler.setSOAPFaultString(sResponse);
                    oAuthHandler.setSOAPFaultString(sFaultCode);
                    MsgFormatPos oError = new MsgFormatPos(ResId.SoapFaultReported);
                    oError.format(sSoapAddress).format(sFaultCode).format(sResponse);
                    oAuthHandler.logMessage(oError);
                }
                oAuthHandler.checkSOAPAuthenticationStatus();
            }
            ByteArrayOutputStream oResponseBodyStream = new ByteArrayOutputStream();
            if (oResponseModel.getBodyNode() != null) {
                if (oResponseModel.getFaultNode() == null) {
                    this.fixupSOAPResponseModel(oResponseModel, oTemplateModel);
                }
                SOAP.exportContentsToXML(oResponseModel.getBodyNode(), oResponseBodyStream);
            }
            ByteArrayOutputStream oResponseHeaderStream = new ByteArrayOutputStream();
            if (oResponseModel.getHeaderNode() != null) {
                SOAP.exportContentsToXML(oResponseModel.getHeaderNode(), oResponseHeaderStream);
            }
            if ((connectionDataNode = (DataNode)(dataModel = DataModel.getDataModel(this.moOwner.getAppModel(), false, false)).resolveNode(sConnectionDataRoot = "!connectionData")) == null) {
                connectionDataNode = (DataNode)dataModel.createChild(false, "connectionData");
            }
            if ((wsdlDataNode = (DataNode)connectionDataNode.resolveNode(this.msConnectionName)) != null) {
                connectionDataNode.removeChild(wsdlDataNode);
            }
            wsdlDataNode = (DataNode)connectionDataNode.createChild(false, this.msConnectionName);
            if (oResponseHeaderStream.size() > 0) {
                Element headerNode = (Element)wsdlDataNode.createChild(false, "Header");
                bytes = oResponseHeaderStream.toByteArray();
                headerNode.loadXML((InputStream)new ByteArrayInputStream(bytes), false, false);
                bytes = null;
            }
            if (oResponseBodyStream.size() > 0) {
                Element bodyNode = (Element)wsdlDataNode.createChild(false, "Body");
                bytes = oResponseBodyStream.toByteArray();
                bodyNode.loadXML((InputStream)new ByteArrayInputStream(bytes), false, false);
                bytes = null;
            }
        }
        catch (ExFull oError) {
            if (bLegacyPostExecute) {
                oEventPseudoModel.setCancelAction(false, "postExecute");
            } else {
                this.notifyPostExecute(oSOAPModel);
            }
            this.moWSDLConnectionNode = null;
            dataModel = DataModel.getDataModel(this.moOwner.getAppModel(), true, false);
            String sConnectionDataRoot = "!connectionData";
            connectionDataNode = (DataNode)dataModel.resolveNode(sConnectionDataRoot);
            assert (connectionDataNode != null);
            dataModel.removeChild(connectionDataNode);
            throw oError;
        }
        this.notifyPostExecute(oResponseModel);
        ExFull oException = new ExFull();
        try {
            if (oResponseModel.getFaultNode() == null) {
                if (!bDynamicMerge) {
                    formModel.importConnectionData(this.msConnectionName);
                } else {
                    connectionDataNode.setWeight(1);
                    formModel.merge(false, true, this.msConnectionName, true, false, false);
                }
            }
        }
        catch (ExFull oEx) {
            oException = oEx;
        }
        dataModel.removeChild(connectionDataNode);
        this.moWSDLConnectionNode = null;
        if (oException.count() > 0) {
            throw oException;
        }
        return oResponseModel.getFaultNode() == null;
    }

    private void fixupSOAPResponseModel(SOAP oSOAPModel, Node oTemplateNode) {
        StringHolder sBodyFirstChildName = new StringHolder();
        FormModel.recurseConnectOnNode(oTemplateNode, this.msConnectionName, 6225921, new FixupSOAPHandler(), sBodyFirstChildName);
        if (sBodyFirstChildName.value != null && sBodyFirstChildName.value.length() > 0) {
            Element oBodyNode = oSOAPModel.getBodyNode();
            for (Node oChildNode = ((Node)oBodyNode).getFirstXMLChild(); oChildNode != null; oChildNode = oChildNode.getNextXMLSibling()) {
                if (!(oChildNode instanceof Element)) continue;
                ((Element)oChildNode).setName(sBodyFirstChildName.value);
                break;
            }
        }
    }

    private String getElementValue(Element oNode, int eTag) {
        String sRetValue = "";
        Element oChildNode = oNode.getElement(eTag, false, 0, false, false);
        if (oChildNode != null) {
            TextNode oText = oChildNode.getText(false, false, false);
            sRetValue = oText.getValue();
        }
        return sRetValue;
    }

    private void getEnvelopeContentsFromDataDOM(OutputStream oOutHeaderStream, OutputStream oOutBodyStream, String sConnectionName) {
        DataModel dataModel = DataModel.getDataModel(this.moOwner.getAppModel(), false, false);
        String sRef = "!connectionData." + sConnectionName;
        Node oResolvedNode = this.moOwner.getAppModel().resolveNode(sRef, true, false, false);
        if (oResolvedNode != null) {
            Node oHeader = oResolvedNode.getNodes().getNamedItem("Header");
            Node oBody = oResolvedNode.getNodes().getNamedItem("Body");
            if (oHeader instanceof Element) {
                ((Element)oHeader).saveXML(oOutHeaderStream, null);
            }
            if (oBody instanceof Element) {
                ((Element)oBody).saveXML(oOutBodyStream, null);
            }
        }
    }

    public Node getWSDLConnectionNode() {
        return this.moWSDLConnectionNode;
    }

    @Override
    public boolean handlesConnection(int eConnectionTag) {
        return eConnectionTag == XFA.WSDLCONNECTIONTAG;
    }

    private void notifyPostExecute(SOAP oSOAPModel) {
        if (this.moHandler != null) {
            this.moHandler.handleProxy(this, Notifications.POSTEXECUTE, oSOAPModel, this.moHandlerData);
        }
    }

    private void notifyPreExecute(SOAP oSOAPModel) {
        if (this.moHandler != null) {
            this.moHandler.handleProxy(this, Notifications.PREEXECUTE, oSOAPModel, this.moHandlerData);
        }
    }

    public void setSOAPFile(String inFile) {
        this.msSOAPFile = inFile;
    }

    private SOAP setSOAPModelFromConnectionData(boolean bAuthenticate) {
        SOAP oSOAPModel = null;
        if (StringUtils.isEmpty(this.msSOAPFile)) {
            AuthenticationHandler oAuthHandler;
            String sScheme;
            Protocol oProtocol;
            EffectiveInputPolicy oInputPolicy;
            Element oWSDLConnectionNode;
            Element oInputPolicyProp;
            ByteArrayOutputStream oHeaderStreamFile = new ByteArrayOutputStream();
            ByteArrayOutputStream oBodyStreamFile = new ByteArrayOutputStream();
            this.getEnvelopeContentsFromDataDOM(oHeaderStreamFile, oBodyStreamFile, this.msConnectionName);
            if (bAuthenticate && (oInputPolicyProp = (oWSDLConnectionNode = this.moWSDLConnectionNode).peekElement(XFA.EFFECTIVEINPUTPOLICYTAG, false, 0)) != null && (oInputPolicy = (EffectiveInputPolicy)oInputPolicyProp) != null && (oProtocol = Resolver.getProtocol(sScheme = "")) != null && (oAuthHandler = oProtocol.getAuthenticationHandler()) != null) {
                oAuthHandler.reset();
                BooleanHolder bHTTPS = new BooleanHolder();
                BooleanHolder bHTTPBasic = new BooleanHolder();
                BooleanHolder bHTTPDigest = new BooleanHolder();
                BooleanHolder bHTTPCert = new BooleanHolder();
                oInputPolicy.getTransportPolicy(bHTTPS, bHTTPBasic, bHTTPDigest, bHTTPCert);
                if (bHTTPCert.value) {
                    oAuthHandler.setTransportAuthType(AuthenticationHandler.AuthenticationType.CERTIFICATE);
                } else if (bHTTPDigest.value) {
                    oAuthHandler.setTransportAuthType(AuthenticationHandler.AuthenticationType.DIGEST);
                } else if (bHTTPBasic.value) {
                    oAuthHandler.setTransportAuthType(AuthenticationHandler.AuthenticationType.BASIC);
                }
                String sConnectionName = this.moWSDLConnectionNode.getName();
                String sSOAPAddress = this.getElementValue(this.moWSDLConnectionNode, XFA.SOAPADDRESSTAG);
                String sSOAPOperation = this.getElementValue(this.moWSDLConnectionNode, XFA.OPERATIONTAG);
                oAuthHandler.setConnectionName(sConnectionName);
                oAuthHandler.setSOAPAddress(sSOAPAddress);
                oAuthHandler.setSOAPOperation(sSOAPOperation);
                BooleanHolder bUsernameClearPwd = new BooleanHolder();
                BooleanHolder bUsernameHashPwd = new BooleanHolder();
                BooleanHolder bSOAPCert = new BooleanHolder();
                oInputPolicy.getSOAPPolicy(bUsernameClearPwd, bUsernameHashPwd, bSOAPCert);
                if (!bSOAPCert.value && (bUsernameClearPwd.value || bUsernameHashPwd.value)) {
                    if (bUsernameHashPwd.value) {
                        oAuthHandler.setSOAPAuthType(AuthenticationHandler.AuthenticationType.DIGEST);
                    } else if (bUsernameClearPwd.value) {
                        oAuthHandler.setSOAPAuthType(AuthenticationHandler.AuthenticationType.BASIC);
                    }
                    StringHolder sUserID = new StringHolder();
                    CharacterHolder sPassword = new CharacterHolder();
                    if (oAuthHandler.getBasicSOAPCredentials(sSOAPAddress, sConnectionName, sSOAPOperation, sUserID, sPassword)) {
                        oAuthHandler.setUserID(sUserID.value);
                        oAuthHandler.setPassword(sPassword);
                        this.createBasicWSSecurityHeader(oHeaderStreamFile, sUserID.value, sPassword.value == null ? null : new String(sPassword.value), bUsernameHashPwd.value);
                    }
                }
            }
            byte[] headerBytes = oHeaderStreamFile.toByteArray();
            oHeaderStreamFile = null;
            byte[] bodyBytes = oBodyStreamFile.toByteArray();
            oBodyStreamFile = null;
            oSOAPModel = SOAP.createFromXMLStreams(headerBytes.length > 0 ? new ByteArrayInputStream(headerBytes) : null, new ByteArrayInputStream(bodyBytes), "");
            headerBytes = null;
            bodyBytes = null;
            return oSOAPModel;
        }
        try {
            BufferedInputStream oStreamFile = new BufferedInputStream(new FileInputStream(this.msSOAPFile));
            oSOAPModel = SOAP.loadFromStream(oStreamFile, null);
        }
        catch (IOException e) {
            return null;
        }
        return oSOAPModel;
    }

    public static enum Notifications {
        PREEXECUTE,
        POSTEXECUTE;

    }

    private static class FixupSOAPHandler
    implements FormModel.ConnectHandler {
        private FixupSOAPHandler() {
        }

        @Override
        public boolean handleConnect(Node oNode, String sConnectionRootRef, String sConnectRef, String sConnectPicture, Object handlerData, ObjectHolder<DataNode> ioRecursingData) {
            assert (handlerData instanceof StringHolder);
            StringHolder sBodyFirstChildName = (StringHolder)handlerData;
            String sBodyRef = "Body.";
            int nBodyRefLen = sBodyRef.length();
            if (sConnectRef.startsWith(sBodyRef)) {
                int nFoundAt = sConnectRef.indexOf(46, nBodyRefLen);
                sBodyFirstChildName.value = nFoundAt >= 0 ? sConnectRef.substring(nBodyRefLen, nFoundAt) : sConnectRef.substring(nBodyRefLen);
                return false;
            }
            return true;
        }
    }

    public static interface ConnectionSetProxyHandler {
        public void handleProxy(ConnectionSetProxy var1, Notifications var2, SOAP var3, Object var4);
    }
}

