/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.agent.formprocessor;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Chars;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.LogMessage;
import com.adobe.xfa.LogMessenger;
import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.agent.Agent;
import com.adobe.xfa.agent.MessageHandlerXML;
import com.adobe.xfa.configuration.ConfigurationKey;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.connectionset.ConnectionSetModel;
import com.adobe.xfa.connectionset.ConnectionSetModelFactory;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.localeset.LocaleSetModelFactory;
import com.adobe.xfa.service.href.HrefService;
import com.adobe.xfa.service.storage.XMLStorage;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.TemplateModelFactory;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class FormProcessor
extends Agent {
    public static final int HREF_CACHE_SIZE = 51200;
    private static final int XML = 5;
    private static final int XDP = 6;
    private static final int Unknown = 7;
    private ByteArrayOutputStream moXMLMsgStream = null;

    public FormProcessor() {
        this(51200);
    }

    public FormProcessor(int cacheSize) {
        AppModel oAppModel = this.getAppModel();
        TemplateModelFactory oTemplateFactory = new TemplateModelFactory();
        oAppModel.addFactory(oTemplateFactory);
        DataModelFactory oDataFactory = new DataModelFactory();
        oAppModel.addFactory(oDataFactory);
        ConnectionSetModelFactory oConnectionSetFactory = new ConnectionSetModelFactory();
        oAppModel.addFactory(oConnectionSetFactory);
        LocaleSetModelFactory oLocaleSetFactory = new LocaleSetModelFactory();
        oAppModel.addFactory(oLocaleSetFactory);
        if (cacheSize < 0) {
            cacheSize = 51200;
        }
        HrefService oHrefService = new HrefService("present", cacheSize);
        oAppModel.setHrefHandler(oHrefService);
    }

    @Override
    public String getConfigSchemaName() {
        return "present";
    }

    String getConfigValue(String somExpr) {
        try {
            Node oContext = this.getContextNode();
            Node oValue = oContext.resolveNode(somExpr);
            if (oValue instanceof ConfigurationValue) {
                ConfigurationValue oConfigValue = (ConfigurationValue)oValue;
                return oConfigValue.getValue().getAttrValue();
            }
            throw new ExFull(ResId.InvalidSOMException, somExpr);
        }
        catch (ExFull oEx) {
            this.logException("getConfigValue", oEx);
            throw oEx;
        }
    }

    private void XMLFormAgentInit(String sDefaultConfig) {
        this.moXMLMsgStream = new ByteArrayOutputStream();
        MessageHandlerXML oXMLHandler = new MessageHandlerXML(this.moXMLMsgStream);
        LogMessenger oLogMessenger = this.getAppModel().getLogMessenger();
        oLogMessenger.addHandler(oXMLHandler, "");
        if (sDefaultConfig.length() > 0) {
            try {
                ByteArrayInputStream oFixStream = new ByteArrayInputStream(sDefaultConfig.getBytes("UTF-8"));
                this.setXFAInput(1, oFixStream);
                this.loadXFAModel(1, false);
            }
            catch (ExFull oEx) {
                this.logException("loadDefaultConfig", oEx);
            }
            catch (UnsupportedEncodingException e) {
                this.logException("loadDefaultConfig", new ExFull(e));
            }
        }
    }

    void clearMessages() {
        if (this.moXMLMsgStream.size() > 0) {
            this.moXMLMsgStream.reset();
            try {
                this.moXMLMsgStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<log>".getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
        }
    }

    public int execute(InputStream oTemplate, InputStream oXCI, InputStream oData, InputStream oXDC, OutputStream oOutput, OutputStream oInfo, String masterPassword, String userPassword) throws ExFull {
        ArrayList<String> oPacketList;
        ConfigurationValue oConfigurationValue;
        String sTempDirStr;
        this.XMLFormAgentInit("");
        int initCode = this.getCompletionStatus(this.getMessenger());
        if (initCode == 1) {
            if (this.getMessenger() != null) {
                this.getMessenger().flush();
                String sLogMessages = this.moXMLMsgStream.toString();
                if (sLogMessages.length() > 0) {
                    this.getProcessingInfoErrors(oInfo, sLogMessages);
                }
            }
            return initCode;
        }
        this.loadPacket(oXCI, 1, false);
        if (this.getConfigModel() == null && this.getMessenger() != null) {
            this.getMessenger().flush();
            String sLogMessages = this.moXMLMsgStream.toString();
            if (sLogMessages.length() > 0) {
                this.getProcessingInfoErrors(oInfo, sLogMessages);
            }
            return 1;
        }
        boolean bEncrypt = false;
        if (masterPassword != null && masterPassword.length() > 0) {
            this.getConfigModel().assignNode("present.pdf.encryption.masterPassword", masterPassword, 0);
            bEncrypt = true;
        }
        if (userPassword != null && userPassword.length() > 0) {
            this.getConfigModel().assignNode("present.pdf.encryption.userPassword", userPassword, 0);
            bEncrypt = true;
        }
        if (bEncrypt) {
            this.getConfigModel().assignNode("present.pdf.encryption.encrypt", "1", 0);
        }
        this.getConfigModel().ready(false);
        Node oContextNode = this.getContextNode();
        this.getConfigModel().setContext(oContextNode);
        Node oTempDir = null;
        if (oContextNode != null) {
            oTempDir = oContextNode.resolveNode("temp.uri");
        }
        if (oTempDir instanceof ConfigurationValue && oTempDir.getXFAChildCount() == 1 && !new File(sTempDirStr = (oConfigurationValue = (ConfigurationValue)oTempDir).getValue().toString()).isDirectory()) {
            MsgFormatPos oBadTempDirPos = new MsgFormatPos(ResId.XFAAgentBadTempDir, sTempDirStr);
            LogMessage oBadTempDirMessage = new LogMessage(oBadTempDirPos, 3);
            this.getMessenger().sendMessage(oBadTempDirMessage);
        }
        BooleanHolder oSaveAsXDP = new BooleanHolder();
        BooleanHolder oIsMergedXDP = new BooleanHolder();
        BooleanHolder oEmbedRenderedOutput = new BooleanHolder();
        this.checkXDPOptions(oSaveAsXDP, oIsMergedXDP, oEmbedRenderedOutput);
        if (oTemplate.markSupported()) {
            oTemplate.mark(4);
            try {
                if (oTemplate.read() == 37 && oTemplate.read() == 80 && oTemplate.read() == 68 && oTemplate.read() == 70) {
                    throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#execute - updatePDF");
                }
                oTemplate.reset();
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
        }
        try {
            if (oXDC != null) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#execute - load XDC packet");
            }
            if (this.loadPacket(oTemplate, 3, false) && this.getTemplateModel() != null) {
                this.getTemplateModel().ready(false);
            }
            if (this.loadPacket(oData, 2, oIsMergedXDP.value) && this.getDataModel() != null) {
                this.getDataModel().ready(false);
            }
        }
        catch (ExFull oEx) {
            this.logException("load", oEx);
            if (this.getMessenger() != null) {
                this.getMessenger().flush();
                String sLogMessages = this.moXMLMsgStream.toString();
                if (sLogMessages.length() > 0) {
                    this.getProcessingInfoErrors(oInfo, sLogMessages);
                }
            }
            return this.getCompletionStatus(this.getMessenger());
        }
        if (oSaveAsXDP.value && !oEmbedRenderedOutput.value) {
            oPacketList = new ArrayList<String>();
            if (oIsMergedXDP.value) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#execute - merge");
            }
        } else {
            String sOutputTo = this.getConfigValue("output.to");
            String sOutputUri = this.getConfigValue("output.uri");
            if (sOutputTo.equalsIgnoreCase("uri") && sOutputUri.length() > 0) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#execute - render1");
            }
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#execute - render2");
        }
        oPacketList.add("*");
        byte[] oResult = this.exportXDP(oPacketList);
        String sLogMessages = null;
        if (this.getMessenger() != null) {
            this.getMessenger().flush();
            sLogMessages = this.moXMLMsgStream.toString();
        }
        if (oResult.length > 0) {
            try {
                if (oOutput != null) {
                    oOutput.write(oResult);
                }
            }
            catch (IOException e) {
                this.logException("io", new ExFull(e));
            }
            this.getProcessingInfo(oInfo, sLogMessages, oIsMergedXDP.value);
        } else {
            this.getProcessingInfoErrors(oInfo, sLogMessages);
        }
        int status = this.getCompletionStatus(this.getMessenger());
        this.reset();
        return status;
    }

    String getMessages() {
        StringBuilder sLogMessages = new StringBuilder();
        if (this.getMessenger() != null) {
            this.getMessenger().flush();
            sLogMessages.append(this.moXMLMsgStream.toString());
        }
        if (sLogMessages.length() == 0) {
            sLogMessages.append("<log>");
        }
        sLogMessages.append("</log>");
        return sLogMessages.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadPacket(InputStream oInputStream, int eType, boolean bIsMergedXDP) {
        InputStream oStream = null;
        boolean bMustCloseStream = false;
        try {
            block44: {
                block46: {
                    block45: {
                        if (oInputStream == null) {
                            ConfigurationValue oConfigurationValue;
                            String sConfigSourceFile;
                            StringBuilder sURI = new StringBuilder();
                            switch (eType) {
                                case 1: {
                                    boolean bl = false;
                                    return bl;
                                }
                                case 4: {
                                    sURI.append(this.getXDCDest(false));
                                    if (sURI.length() != 0) break;
                                    boolean bl = false;
                                    return bl;
                                }
                                case 2: {
                                    sURI.append("datasets");
                                    break;
                                }
                                case 3: {
                                    sURI.append("template");
                                    break;
                                }
                                case 5: {
                                    sURI.append("sourceSet");
                                    break;
                                }
                                case 6: {
                                    sURI.append("connectionSet");
                                    break;
                                }
                            }
                            sURI.append('.');
                            sURI.append("uri");
                            Node oContextNode = this.getContextNode();
                            Node oResolvedNode = null;
                            if (oContextNode != null) {
                                oResolvedNode = oContextNode.resolveNode(sURI.toString());
                            }
                            if (oResolvedNode instanceof ConfigurationValue && (sConfigSourceFile = (oConfigurationValue = (ConfigurationValue)oResolvedNode).getValue().toString()).length() > 0) {
                                try {
                                    oStream = new FileInputStream(sConfigSourceFile);
                                    bMustCloseStream = true;
                                }
                                catch (IOException e) {
                                    throw new ExFull(e);
                                }
                            }
                        } else {
                            oStream = oInputStream;
                        }
                        if (oStream == null) break block44;
                        if (eType != 2) break block45;
                        int eFileType = this.identify(oStream);
                        if (eFileType == 6) {
                            StringBuilder sPackets2 = new StringBuilder("-");
                            sPackets2.append("config");
                            sPackets2.append(" -");
                            sPackets2.append("template");
                            sPackets2.append(" -");
                            sPackets2.append("sourceSet");
                            sPackets2.append(" -");
                            sPackets2.append("connectionSet");
                            sPackets2.append(" -");
                            sPackets2.append("xsl");
                            sPackets2.append(" -");
                            sPackets2.append("localeSet");
                            this.loadXDP(oStream, sPackets2.toString(), false);
                            break block46;
                        } else if (eFileType == 5) {
                            this.loadXDP(oStream, "datasets", false);
                        }
                        break block46;
                    }
                    String sPackets = "";
                    switch (eType) {
                        case 1: {
                            sPackets = "config";
                            break;
                        }
                        case 6: {
                            sPackets = "connectionSet";
                            break;
                        }
                        case 5: {
                            sPackets = "sourceSet";
                            break;
                        }
                        case 3: {
                            sPackets = "-config *";
                            break;
                        }
                        case 4: {
                            boolean sPackets2 = this.loadXDC(oStream);
                            return sPackets2;
                        }
                    }
                    this.loadXDP(oStream, sPackets, false);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (bMustCloseStream && oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    String getConfigPacketList() {
        Node oResolvedNode = null;
        Node oContextNode = this.getContextNode();
        if (oContextNode != null) {
            oResolvedNode = oContextNode.resolveNode("xdp.packets");
        }
        if (oResolvedNode instanceof ConfigurationValue) {
            ConfigurationValue oConfigurationValue = (ConfigurationValue)oResolvedNode;
            return oConfigurationValue.getValue().toString();
        }
        return "";
    }

    List<String> getPackets() {
        ArrayList<String> oPacketList = new ArrayList<String>();
        for (Node oChild = this.getAppModel().getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
            String sPacketName = oChild.getName();
            oPacketList.add(sPacketName);
        }
        return oPacketList;
    }

    byte[] exportXDP(List<String> packetList) {
        ByteArrayOutputStream oMemStream = new ByteArrayOutputStream();
        try {
            StringBuilder sPackets = new StringBuilder();
            for (int i = 0; i < packetList.size(); ++i) {
                if (i > 0) {
                    sPackets.append(' ');
                }
                sPackets.append(packetList.get(i));
            }
            this.saveXDP(oMemStream, sPackets.toString());
        }
        catch (ExFull oEx) {
            this.logException("exportXDP", oEx);
            throw oEx;
        }
        return oMemStream.toByteArray();
    }

    String logException(String sFunctionName, ExFull oEx) {
        oEx.resolve();
        StringBuilder sMsg = new StringBuilder("XMLForm, ");
        sMsg.append(sFunctionName);
        sMsg.append(" : ");
        int nId = 0;
        int n = oEx.count();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sMsg.append('\n');
            }
            nId = oEx.item(i).resId();
            sMsg.append(Integer.toString(nId));
            sMsg.append(", ");
            sMsg.append(oEx.item(i).text());
        }
        LogMessage oExceptionMessage = new LogMessage(nId, sMsg.toString(), 6);
        LogMessenger oMessenger = this.getMessenger();
        if (oMessenger != null) {
            oMessenger.sendMessage(oExceptionMessage);
        }
        return sMsg.toString();
    }

    private void getProcessingInfo(OutputStream oInfo, String sLogMessages, boolean bIsMergedXDP) {
        AppModel app = new AppModel(null);
        Document oDoc = app.getDocument();
        app.newDOM();
        Element oStatus = oDoc.createElementNS("", "status", null);
        oDoc.appendChild(oStatus, false);
        this.addProcInfoOutputUri(oStatus);
        this.addProcInfoMessages(oStatus, sLogMessages);
        ByteArrayOutputStream oOutput = new ByteArrayOutputStream();
        oDoc.saveAs(oOutput, oStatus, new DOMSaveOptions());
        if (oOutput.size() > 0) {
            try {
                if (oInfo != null) {
                    oInfo.write(oOutput.toByteArray());
                }
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
        }
    }

    private void getProcessingInfoErrors(OutputStream oInfo, String sLogMessages) {
        AppModel app = new AppModel(null);
        Document oDoc = app.getDocument();
        app.newDOM();
        Element oStatus = oDoc.createElementNS("", "status", null);
        oDoc.appendChild(oStatus);
        this.addProcInfoMessages(oStatus, sLogMessages);
        ByteArrayOutputStream oOutput = new ByteArrayOutputStream();
        oDoc.saveAs(oOutput, oStatus, new DOMSaveOptions());
        if (oOutput.size() > 0) {
            try {
                if (oInfo != null) {
                    oInfo.write(oOutput.toByteArray());
                }
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
        }
    }

    private void addProcInfoOutputUri(Element oParent) {
        Document oDoc = oParent.getOwnerDocument();
        Element oOut = oDoc.createElementNS("", "output", null);
        Element oOutTo = oDoc.createElementNS("", "to", null);
        TextNode oOutToText = oDoc.getAppModel().createTextNode(null, null, this.getConfigValue("output.to"));
        oOutTo.appendChild(oOutToText, false);
        oOut.appendChild(oOutTo, false);
        Element oOutUri = oDoc.createElementNS("", "uri", null);
        TextNode oOutUriText = oDoc.getAppModel().createTextNode(null, null, this.getConfigValue("output.uri"));
        oOutUri.appendChild(oOutUriText, false);
        oOut.appendChild(oOutUri, false);
        oParent.appendChild(oOut, false);
    }

    private void addProcInfoMessages(Element oParent, String sLogMessages) {
        if (sLogMessages.length() == 0) {
            return;
        }
        Document oDoc = oParent.getOwnerDocument();
        Element oMessages = oDoc.createElementNS("", "messages", null);
        Element oValidationErrors = oDoc.createElementNS("", "validationErrors", null);
        Element oValidationWarnings = oDoc.createElementNS("", "validationWarnings", null);
        Document oXMLMsgDoc = new AppModel(null).getDocument();
        try {
            ByteArrayInputStream oFixMemStream = new ByteArrayInputStream(sLogMessages.getBytes("UTF-8"));
            oXMLMsgDoc.load(oFixMemStream, null, false);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        Element oRoot = oXMLMsgDoc.getDocumentElement();
        Node oChild = null;
        if (oRoot != null) {
            oChild = ((Node)oRoot).getFirstXFAChild();
        }
        while (oChild != null) {
            if (oChild instanceof Element) {
                Element oMsgNode = (Element)oDoc.importNode(oChild, true);
                String sAttValue = "";
                int i = oMsgNode.findAttr("", "sev");
                if (i != 1) {
                    sAttValue = oMsgNode.getAttrVal(i);
                }
                if (sAttValue.equals("ve")) {
                    oValidationErrors.appendChild(oMsgNode, false);
                } else if (sAttValue.equals("vw")) {
                    oValidationWarnings.appendChild(oMsgNode, false);
                } else {
                    oMessages.appendChild(oMsgNode, false);
                }
            }
            oChild = oChild.getNextXFASibling();
        }
        oParent.appendChild(oMessages, false);
        oParent.appendChild(oValidationWarnings, false);
        oParent.appendChild(oValidationErrors, false);
    }

    int identify(InputStream is) {
        if (is.markSupported()) {
            is.mark(Integer.MAX_VALUE);
        }
        int eFType = 7;
        XMLStorage xml = new XMLStorage();
        AppModel oAppModel = new AppModel(null);
        try {
            xml.loadModel(oAppModel, is, "", null);
            if (is.markSupported()) {
                is.reset();
            }
        }
        catch (IOException e) {
            throw new ExFull(e);
        }
        catch (ExFull e) {
            if (e.getResId(0) == ResId.XFAAgentFailure) {
                return eFType;
            }
            throw e;
        }
        eFType = oAppModel.getFirstXFAChild() != null ? 6 : 5;
        return eFType;
    }

    public boolean loadXDP(InputStream is, String sPackets, boolean bReload) {
        return this.loadXFAModel(is, sPackets, bReload);
    }

    boolean loadXDC(InputStream is) {
        if (is != null) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#loadXDC");
        }
        return false;
    }

    String getTemplatePackageList() {
        StringBuilder sPackets = new StringBuilder();
        sPackets.append("template");
        sPackets.append(' ');
        sPackets.append("sourceSet");
        sPackets.append(' ');
        sPackets.append("connectionSet");
        sPackets.append(' ');
        sPackets.append("xsl");
        sPackets.append(' ');
        sPackets.append("localeSet");
        sPackets.append(' ');
        sPackets.append("datasets");
        return sPackets.toString();
    }

    void saveXDP(OutputStream oStream, String sPacketList) {
        Node oPackets;
        String sPackets;
        DataModel oDataModel;
        Node oTemplateOptions;
        Node oClone;
        assert (oStream != null);
        ArrayNodeList oNodesToSave = new ArrayNodeList();
        boolean bIncludeData = true;
        AppModel oAppModel = this.getAppModel();
        ConfigurationModel oConfigModel = ConfigurationModel.getConfigurationModel(oAppModel, false);
        TemplateModel oTemplateModel = TemplateModel.getTemplateModel(oAppModel, false);
        ConnectionSetModel oCSModel = ConnectionSetModel.getConnectionSetModel(oAppModel, false);
        oConfigModel.createElement("acrobat");
        Element oCommon = oConfigModel.createElement("common");
        Node oDataOptions = this.getContextNode().resolveNode("common.data");
        if (oDataOptions != null) {
            String sXSLFile;
            File oXSLFile;
            Node oConfigValue = oDataOptions.resolveNode("xsl.uri");
            if (oConfigValue instanceof ConfigurationValue && (oXSLFile = new File(sXSLFile = ((ConfigurationValue)oConfigValue).getValue().toString())).exists()) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#saveXDP - data input XSL");
            }
            oConfigValue = oDataOptions.resolveNode("outputXSL.uri");
            if (oConfigValue instanceof ConfigurationValue && (oXSLFile = new File(sXSLFile = ((ConfigurationValue)oConfigValue).getValue().toString())).exists()) {
                throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormProcessor#saveXDP - data input XSL");
            }
            oClone = oDataOptions.clone(null);
            oCommon.getNodes().append(oClone);
            ((ListBase)oNodesToSave).append(oConfigModel);
        }
        if ((oTemplateOptions = this.getContextNode().resolveNode("common.template")) instanceof ConfigurationKey) {
            oClone = oTemplateOptions.clone(null);
            oCommon.getNodes().append(oClone);
        }
        ((ListBase)oNodesToSave).append(oTemplateModel);
        if (oCSModel != null) {
            ((ListBase)oNodesToSave).append(oCSModel);
        }
        if (bIncludeData && (oDataModel = DataModel.getDataModel(oAppModel, false, false)) != null) {
            ((ListBase)oNodesToSave).append(oDataModel);
            oDataModel.getDataWindow().resetRecordDepth();
        }
        Element oUser = null;
        Element oMaster = null;
        Node oPDFEncryption = oConfigModel.resolveNode("$config.present.pdf.encryption");
        if (oPDFEncryption instanceof Element) {
            if (((Element)oPDFEncryption).isPropertySpecified(XFA.USERPASSWORDTAG, true, 0)) {
                oUser = ((Element)oPDFEncryption).getElement(XFA.USERPASSWORDTAG, false, 0, false, false);
                oUser.isHidden(true);
            }
            if (((Element)oPDFEncryption).isPropertySpecified(XFA.MASTERPASSWORDTAG, true, 0)) {
                oMaster = ((Element)oPDFEncryption).getElement(XFA.MASTERPASSWORDTAG, false, 0, false, false);
                oMaster.isHidden(true);
            }
        }
        if ((sPackets = sPacketList).length() == 0 && (oPackets = this.getContextNode().resolveNode("xdp.packets")) != null) {
            ConfigurationValue oPacketsValue = (ConfigurationValue)oPackets;
            sPackets = oPacketsValue.getValue().toString();
        }
        if (sPackets.length() != 0) {
            boolean bAllPackets = sPackets.equals("*");
            oNodesToSave = new ArrayNodeList();
            block0: for (Node oChild = oAppModel.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
                if (bAllPackets && !(oChild instanceof Chars)) {
                    ((ListBase)oNodesToSave).append(oChild);
                    continue;
                }
                StringTokenizer oToker = new StringTokenizer(sPackets);
                while (oToker.hasMoreTokens()) {
                    String sToken = oToker.nextToken();
                    if (!sToken.equals(oChild.getName())) continue;
                    ((ListBase)oNodesToSave).append(oChild);
                    continue block0;
                }
            }
        }
        XMLStorage oStorage = new XMLStorage();
        oStorage.saveAggregate("", oStream, oNodesToSave, "");
        if (oUser != null) {
            oUser.isHidden(false);
        }
        if (oMaster != null) {
            oMaster.isHidden(false);
        }
    }
}

