/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class Option {
    private static final int BOOL = 1;
    private static final int DOUBLE = 3;
    private static final int EMPTY = 0;
    private static final int INTEGER = 2;
    private static final int LITERAL = 5;
    private static final int STRING = 4;
    private boolean mbLocked;
    private int mnMatchingIndex;
    private String mOptionName;
    private String mString;
    private int mType;
    private String mValidValues;
    private Object mValue;

    public static int setOptionByArray(String packageName, Option[] options, String optionName, String optionValue, boolean bCritical) {
        Option option;
        String name = optionName;
        if (StringUtils.isEmpty(optionName)) {
            Option option2;
            int index = 0;
            while ((option2 = options[index]) != null) {
                option2.reset();
                ++index;
            }
            return -1;
        }
        int nPackageSeparatorOffset = optionName.indexOf(95);
        if (nPackageSeparatorOffset != -1) {
            if (nPackageSeparatorOffset == 0) {
                throw new ExFull(ResId.OptionWrongPackageException, optionName);
            }
            if (!optionName.substring(nPackageSeparatorOffset).equals(packageName)) {
                throw new ExFull(ResId.OptionWrongPackageException, optionName);
            }
            name = optionName.substring(nPackageSeparatorOffset + 1);
        }
        int index = 0;
        while ((option = options[index]) != null) {
            if (option.getName().equals(name)) {
                option.setValue(optionValue, bCritical);
                return index;
            }
            ++index;
        }
        throw new ExFull(ResId.InvalidOptionException, optionName);
    }

    public Option(Option src) {
        this.mType = src.mType;
        this.mValue = src.mValue;
        this.mString = src.mString;
        this.mOptionName = src.mOptionName;
        this.mValidValues = src.mValidValues;
        this.mnMatchingIndex = src.mnMatchingIndex;
        this.mbLocked = src.mbLocked;
    }

    public Option(String name, String validValues) {
        this.mOptionName = name;
        this.mValidValues = validValues;
        this.mType = 0;
        this.mnMatchingIndex = -1;
        this.mbLocked = false;
        this.mValue = null;
    }

    private void empty() {
        this.mnMatchingIndex = -1;
        if (this.mType == 4) {
            this.mString = "";
        }
        this.mType = 0;
        this.mValue = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Option right = (Option)object;
        if (this.mType != right.mType) {
            return false;
        }
        switch (this.mType) {
            case 0: {
                return true;
            }
            case 5: {
                return this.mnMatchingIndex == right.mnMatchingIndex;
            }
            case 1: {
                return this.getBool() == right.getBool();
            }
            case 2: {
                return this.getInteger() == right.getInteger();
            }
            case 3: {
                return this.getDouble() == right.getDouble();
            }
            case 4: {
                return this.getString().equals(right.getString());
            }
        }
        assert (false);
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 ^ this.mType;
        switch (this.mType) {
            case 0: {
                break;
            }
            case 5: {
                hash = hash * 31 ^ this.getMatchingIndex();
                break;
            }
            case 1: {
                hash = hash * 31 ^ Boolean.valueOf(this.getBool()).hashCode();
                break;
            }
            case 2: {
                hash = hash * 31 ^ this.getInteger();
                break;
            }
            case 3: {
                long bits = Double.doubleToLongBits(this.getDouble());
                hash = hash * 31 ^ (int)(bits ^ bits >>> 32);
                break;
            }
            case 4: {
                hash = hash * 31 ^ this.getString().hashCode();
            }
        }
        return hash;
    }

    public int getArgType() {
        return this.mType;
    }

    public boolean getBool() {
        if (this.mType != 1) {
            throw new ExFull(ResId.OptionMisuseException, this.getName());
        }
        Boolean b = (Boolean)this.mValue;
        return b;
    }

    public double getDouble() {
        if (this.mType != 3) {
            if (this.mType == 2) {
                return this.getInteger();
            }
            throw new ExFull(ResId.OptionMisuseException, this.getName());
        }
        Double d = (Double)this.mValue;
        return d;
    }

    public int getInteger() {
        if (this.mType != 2) {
            throw new ExFull(ResId.OptionMisuseException, this.getName());
        }
        Integer i = (Integer)this.mValue;
        return i;
    }

    public int getMatchingIndex() {
        return this.mnMatchingIndex;
    }

    public String getName() {
        return this.mOptionName;
    }

    public String getString() {
        if (this.mType != 4) {
            throw new ExFull(ResId.OptionMisuseException, this.getName());
        }
        return this.mString;
    }

    public boolean isSet() {
        return this.getMatchingIndex() != -1;
    }

    public void reset() {
        this.empty();
        this.mbLocked = false;
    }

    private void setBool(boolean b) {
        this.empty();
        this.mType = 1;
        this.mValue = b;
    }

    private void setDouble(double d) {
        this.empty();
        this.mType = 3;
        this.mValue = new Double(d);
    }

    private void setInteger(int i) {
        this.empty();
        this.mType = 2;
        this.mValue = i;
    }

    private void setString(String s) {
        this.empty();
        this.mType = 4;
        this.mString = s;
    }

    public void setValue(String value, boolean bCritical) {
        if (this.mbLocked) {
            if (bCritical) {
                Option oCheck = new Option(this);
                oCheck.mbLocked = false;
                oCheck.setValue(value, true);
                if (!this.equals(oCheck)) {
                    throw new ExFull(ResId.OptionLockedException, this.getName());
                }
            }
            return;
        }
        this.empty();
        int nIndex = 0;
        this.mbLocked = bCritical;
        String[] tokens = this.mValidValues.split("\\|");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.equals("%d")) {
                try {
                    int long_value = Integer.parseInt(value);
                    this.setInteger(long_value);
                    this.mnMatchingIndex = nIndex;
                    return;
                }
                catch (NumberFormatException n) {}
            } else {
                if (token.equals("%lf")) {
                    double double_value = Double.parseDouble(value);
                    if (!Double.isInfinite(double_value)) {
                        this.setDouble(double_value);
                    }
                    this.mnMatchingIndex = nIndex;
                    return;
                }
                if (token.equals("%s")) {
                    this.setString(value);
                    this.mnMatchingIndex = nIndex;
                    return;
                }
                if (token.equals("%b")) {
                    int c = 0;
                    if (value.length() == 1) {
                        c = value.charAt(0);
                    }
                    if (c == 49 || c == 48) {
                        this.setBool(c == 49);
                        this.mnMatchingIndex = nIndex;
                        return;
                    }
                } else if (token.equals(value)) {
                    this.mType = 5;
                    this.mnMatchingIndex = nIndex;
                    return;
                }
            }
            ++nIndex;
        }
        this.mbLocked = false;
        MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidOptionValueException);
        oMessage.format(this.getName());
        oMessage.format(value);
        throw new ExFull(oMessage);
    }
}

