/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.AttributeInfo;
import com.adobe.xfa.Chars;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.ChildRelnInfo;
import com.adobe.xfa.Comment;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Delta;
import com.adobe.xfa.Document;
import com.adobe.xfa.ElementNodeList;
import com.adobe.xfa.ElementScript;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.GenericAttribute;
import com.adobe.xfa.HrefHandler;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.NodeSchema;
import com.adobe.xfa.NodeValidationInfo;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.SaveNameSpaceChecker;
import com.adobe.xfa.Schema;
import com.adobe.xfa.SchemaPairs;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.XSLTranslator;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.dom.DOM;
import com.adobe.xfa.dom.NamespaceContextImpl;
import com.adobe.xfa.service.canonicalize.Canonicalize;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Key;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UuidFactory;
import com.adobe.xfa.ut.trace.Trace;
import com.adobe.xfa.ut.trace.TraceHandler;
import com.adobe.xfa.ut.trace.TraceTimer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.xml.sax.Attributes;

public class Element
extends Node {
    protected static final int TEXT = 0;
    protected static final int ATTRIBUTE = 1;
    protected static final int ELEMENT = 2;
    protected static final int ONEOF = 3;
    protected static final int CHILD = 4;
    protected static final int INVALID = 5;
    public static final int AttrIsDefault = 1;
    public static final int AttrIsFragment = 2;
    public static final int AttrIsTransient = 4;
    private static final GenericAttribute gsEmptyStringAttr = new GenericAttribute("", "");
    public static final int CREATEACTION = 1;
    private static final int APPENDACTION = 2;
    static final Trace oScriptTrace = new Trace("script", ResId.ScriptTraceHelp);
    protected String maName;
    private byte[] mAttrProperties;
    private Attribute[] mAttrs;
    private int nAttrs;
    private boolean mbInhibitPrettyPrint;
    private boolean mbIsFragment;
    private boolean mbIsHidden;
    private boolean mbIsIndexed;
    private boolean mbSaveXMLSaveTransient;
    private boolean mbTransparent;
    private EventManager.EventTable mEventTable;
    protected Node mFirstXMLChild;
    private String mLocalName;
    private Model mModel;
    private int mnLineNumber;
    private NodeSchema mNodeSchema;
    private String mQName;
    private boolean mbIsDataWindowRoot;
    protected String mURI;
    private static XPathFactory mXPathFactory;

    private static void removeNamespaceDef(Element element, String aPrefix) {
        SaveNameSpaceChecker checker = element.getOwnerDocument().getSaveChecker();
        if (checker != null) {
            checker.removePrefix(element, aPrefix);
        }
    }

    private static void addNamespaceDef(OutputStream outStream, DOMSaveOptions options, Element element, String aPrefix, String aNamespaceURI) {
        String string = aNamespaceURI = aNamespaceURI == null ? "" : aNamespaceURI;
        if (!Element.findNamespace(element, aPrefix, aNamespaceURI, options, true) && !Element.elementHasNamespacePrefixDeclared(element, aPrefix)) {
            element.getOwnerDocument().getSaveChecker().addPrefix(element, aPrefix, aNamespaceURI);
            try {
                outStream.write(Document.MarkupSpace);
                outStream.write(Document.MarkupXMLns);
                if (aPrefix != "") {
                    outStream.write(Document.MarkupColon);
                    outStream.write(aPrefix.getBytes("UTF-8"));
                }
                outStream.write(Document.MarkupAttrMiddle);
                outStream.write(aNamespaceURI.getBytes("UTF-8"));
                outStream.write(Document.MarkupDQuoteString);
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
        }
    }

    private static boolean elementHasNamespacePrefixDeclared(Element element, String aPrefix) {
        if (element == null) {
            return false;
        }
        String aFixedPrefix = aPrefix;
        if (aFixedPrefix == "") {
            aFixedPrefix = "xmlns";
        }
        int nSize = element.getNumAttrs();
        for (int nIndex = 0; nIndex < nSize; ++nIndex) {
            Attribute oAttr = element.getAttr(nIndex);
            if (!oAttr.isNameSpaceAttr() || oAttr.getLocalName() != aFixedPrefix) continue;
            return true;
        }
        return false;
    }

    private static boolean findNamespace(Element element, String aPrefix, String aNamespaceURI, DOMSaveOptions options, boolean bSuppressEmptyNSCheck) {
        Node stopNode;
        SaveNameSpaceChecker checker;
        if (aPrefix == "xml") {
            return true;
        }
        if (aNamespaceURI == null) {
            aNamespaceURI = "";
        }
        if ((checker = element.getOwnerDocument().getSaveChecker()) != null && checker.missingPrefix(element, aPrefix, aNamespaceURI, bSuppressEmptyNSCheck)) {
            return true;
        }
        String aFixedPrefix = aPrefix == "" ? "xmlns" : aPrefix;
        boolean bFindXsi = Element.isXsiNamespace(aNamespaceURI);
        Node node = stopNode = checker != null ? checker.stopNode() : null;
        while (element != null && element != stopNode) {
            if (element instanceof Document) {
                return false;
            }
            int nSize = element.getNumAttrs();
            for (int nIndex = 0; nIndex < nSize; ++nIndex) {
                Attribute attr = element.getAttr(nIndex);
                if (!attr.isNameSpaceAttr() || attr.getLocalName() != aFixedPrefix) continue;
                return bFindXsi ? Element.isXsiNamespace(attr.getAttrValue()) : aNamespaceURI == attr.getAttrValue();
            }
            element = Element.getXMLParent(element);
        }
        return false;
    }

    private static boolean isXsiNamespace(String aNamespaceURI) {
        return aNamespaceURI == "http://www.w3.org/2001/XMLSchema-instance" || aNamespaceURI.startsWith("http://www.w3.org/") && aNamespaceURI.endsWith("/XMLSchema-instance");
    }

    static Element getXMLParent(Node node) {
        if (node instanceof DualDomNode) {
            node = ((DualDomNode)((Object)node)).getXmlPeer();
        }
        if (node == null) {
            return null;
        }
        Element element = node.getXMLParent();
        if (element instanceof DualDomNode) {
            element = (Element)((DualDomNode)((Object)element)).getXmlPeer();
        }
        return element;
    }

    private static boolean displayNamespace(Attribute a, Element parent, DOMSaveOptions options, boolean bSuppressEmptyNSCheck) {
        String aPrefix = a.getLocalName();
        if (aPrefix == "xmlns") {
            aPrefix = "";
        }
        if ((parent = Element.getXMLParent(parent)) == null) {
            return true;
        }
        return !Element.findNamespace(parent, aPrefix, a.getAttrValue(), options, bSuppressEmptyNSCheck);
    }

    static boolean validateNodeSchema(Node node, NodeSchema nodeSchema, int nTargetVersion, int nTargetAvailability, List<NodeValidationInfo> validationInfos) {
        int eTag = node.getClassTag();
        ChildRelnInfo childRelnInfo = nodeSchema.getChildRelnInfo(eTag);
        if (childRelnInfo != null) {
            boolean bInvalid = false;
            int nVerIntro = childRelnInfo.getVersionIntroduced();
            int nAvail = childRelnInfo.getAvailability();
            Model model = node.getModel();
            if (model == null) {
                model = node.getXFAParent().getModel();
            }
            assert (model != null);
            if (!model.isVersionCompatible(nVerIntro, nTargetVersion)) {
                bInvalid = true;
            } else if ((nTargetAvailability & nAvail) == 0) {
                bInvalid = true;
            }
            if (bInvalid) {
                if (validationInfos != null) {
                    NodeValidationInfo nodeValidationInfo = new NodeValidationInfo(nVerIntro, nAvail, node);
                    validationInfos.add(nodeValidationInfo);
                }
                return false;
            }
        }
        return true;
    }

    protected Element() {
        super(null, null);
    }

    protected Element(Element parent, Node prevSibling) {
        super(parent, prevSibling);
        if (parent != null) {
            this.setModel(parent.getModel());
            this.setDocument(parent.getOwnerDocument());
        }
    }

    protected Element(Element parent, Node prevSibling, String uri, String name) {
        this(parent, prevSibling);
        if (uri == null && parent != null) {
            uri = parent.mURI;
        }
        String localName = null;
        if (name != null) {
            int nsSplit = (name = name.intern()).indexOf(58);
            if (nsSplit < 0) {
                localName = name;
            } else {
                localName = name.substring(nsSplit + 1);
                localName = localName.intern();
            }
        }
        uri = uri != null ? uri.intern() : null;
        this.setClass(name, XFA.INVALID_ELEMENT);
        this.mURI = uri;
        this.mQName = name;
        this.mLocalName = localName;
    }

    public Element(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int classTag, String className) {
        this(parent, prevSibling);
        if (uri == null && parent != null) {
            uri = parent.mURI;
        }
        if (uri != null) {
            uri = uri.intern();
        }
        this.mURI = uri;
        this.mLocalName = localName;
        this.mQName = qName;
        this.setClass(className, classTag);
        if (attributes != null) {
            this.assignAttrs(attributes);
        }
    }

    public void appendChild(Node child) {
        Node lastChild;
        if (child.getXMLParent() != null) {
            child.remove();
        }
        Node currentChild = lastChild = this.getFirstXMLChild();
        while (currentChild != null) {
            if ((currentChild = currentChild.getNextXMLSibling()) == null) continue;
            lastChild = currentChild;
        }
        if (lastChild == null) {
            this.setFirstChild(child);
        } else {
            lastChild.setNextXMLSibling(child);
        }
        child.setXMLParent(this);
        this.setChildListModified(true);
        if (child instanceof Element) {
            ((Element)child).setNS(this.getNS());
            if (child.getModel() != this.getModel() || child.getOwnerDocument() != this.getOwnerDocument()) {
                this.updateModelAndDocument(child);
            }
        }
        if (this instanceof DualDomNode && child instanceof DualDomNode) {
            Element dualDomParent = (Element)((DualDomNode)((Object)this)).getXmlPeer();
            Node domPeer = ((DualDomNode)((Object)child)).getXmlPeer();
            if (domPeer.getModel() != this.getModel() || domPeer.getOwnerDocument() != this.getOwnerDocument()) {
                this.updateModelAndDocument(domPeer);
            }
            if (domPeer instanceof DataModel.AttributeWrapper) {
                DataModel.AttributeWrapper wrapper = (DataModel.AttributeWrapper)domPeer;
                Attribute attr = dualDomParent.setAttribute(wrapper.getNS(), wrapper.getXMLName(), wrapper.getLocalName(), wrapper.getValue(), false);
                DataModel.AttributeWrapper xmlPeer = new DataModel.AttributeWrapper(attr, dualDomParent);
                xmlPeer.setXfaPeer((Element)child);
                ((DualDomNode)((Object)child)).setXmlPeer(xmlPeer);
            } else {
                dualDomParent.appendChild(domPeer);
            }
        }
        if (child instanceof Element && this.getOwnerDocument() != null) {
            this.getOwnerDocument().indexSubtree((Element)child, false);
        }
        this.setDirty();
        if (!child.isMute()) {
            child.notifyPeers(3, this.getClassAtom(), this);
        }
        if (!this.isMute()) {
            this.notifyPeers(4, child.getClassAtom(), child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChild(Node child, boolean bValidate) {
        if (bValidate) {
            this.isValidChild(child.getClassTag(), ResId.InvalidChildAppendException, true, false);
        }
        if (child == this) {
            throw new ExFull(new MsgFormat(ResId.HierarchyRequestException, child.getName()));
        }
        boolean bIsDefault = child.isDefault(false);
        if (bIsDefault) {
            this.mute();
        }
        try {
            if (!child.isDefault(true)) {
                this.makeNonDefault(false);
            }
            if (child.getXMLParent() != null) {
                child.remove();
            }
            this.appendChild(child);
        }
        finally {
            if (bIsDefault) {
                this.unMute();
            }
        }
    }

    public final void appendPI(String aPiName, String sData) {
        assert (aPiName != null);
        new ProcessingInstruction(this, null, aPiName, sData);
        this.setDirty();
    }

    public final void appendPI(String aPiName, String sPropName, String sData) {
        assert (aPiName != null);
        String sTemp = sPropName + " " + sData;
        new ProcessingInstruction(this, null, aPiName, sTemp);
        this.setDirty();
    }

    final void applyXSL(InputStream xsl, OutputStream out) {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        this.saveXML(tempStream, null);
        ByteArrayInputStream oMemStream = new ByteArrayInputStream(tempStream.toByteArray());
        XSLTranslator translator = new XSLTranslator(xsl);
        translator.process(oMemStream, out);
    }

    private final void assignAttrs(Attributes attributes) {
        int newAttributeCount = attributes.getLength();
        if (newAttributeCount == 0) {
            return;
        }
        Model m = this.getModel();
        NodeSchema schema = this.getNodeSchema();
        this.ensureAttributeCapacity(this.nAttrs + newAttributeCount);
        int namespaceDeclarationCount = this.nAttrs;
        for (int i = 0; i < newAttributeCount; ++i) {
            Attribute attribute = this.createAttribute(attributes.getLocalName(i), attributes.getURI(i), attributes.getQName(i), attributes.getValue(i), schema);
            if (m != null) {
                m.saveProtoInformation(this, attribute.getLocalName(), i == 0);
            }
            int position = this.nAttrs;
            if (attribute.isNameSpaceAttr()) {
                if (i != 0) {
                    System.arraycopy(this.mAttrs, namespaceDeclarationCount, this.mAttrs, namespaceDeclarationCount + 1, this.nAttrs - namespaceDeclarationCount);
                    System.arraycopy(this.mAttrProperties, namespaceDeclarationCount, this.mAttrProperties, namespaceDeclarationCount + 1, this.nAttrs - namespaceDeclarationCount);
                    position = namespaceDeclarationCount;
                }
                ++namespaceDeclarationCount;
            }
            this.mAttrs[position] = attribute;
            this.mAttrProperties[position] = 0;
            ++this.nAttrs;
        }
    }

    @Override
    public final Node assignNode(String sSOMExpression, String sValue, int eMode) {
        Node node = null;
        switch (eMode) {
            case 0: {
                SOMParser.SomResultInfo result = this.resolveNodeCreate(sSOMExpression, 1, true, false, false);
                node = (Node)result.object;
                if (node == null) {
                    throw new ExFull(new MsgFormat(ResId.HierarchyRequestException, sSOMExpression));
                }
                Arg arg = new Arg();
                arg.setString(sValue);
                if (!StringUtils.isEmpty(result.propertyName)) {
                    node.setScriptProperty(result.propertyName, arg, false);
                    break;
                }
                node.setScriptProperty("value", arg, false);
                break;
            }
            case 3: {
                SOMParser.SomResultInfo result = this.resolveNodeCreate(sSOMExpression, 2, true, false, false);
                node = (Node)result.object;
                if (node == null) {
                    throw new ExFull(new MsgFormat(ResId.HierarchyRequestException, sSOMExpression));
                }
                Arg arg = new Arg();
                arg.setString(sValue);
                if (!StringUtils.isEmpty(result.propertyName)) {
                    node.setScriptProperty(result.propertyName, arg, false);
                    break;
                }
                node.setScriptProperty("value", arg, false);
                break;
            }
            case 1: 
            case 2: {
                ArrayList<SOMParser.SomResultInfo> result = new ArrayList<SOMParser.SomResultInfo>();
                SOMParser oParser = new SOMParser(null);
                oParser.setOptions(true, true, false);
                oParser.resolve(this, sSOMExpression, result);
                if (result.size() != 0) {
                    if (eMode != 1) break;
                    throw new ExFull(new MsgFormat(ResId.NodeAlreadyExistException, sSOMExpression));
                }
                node = this.assignNode(sSOMExpression, sValue, 0);
            }
        }
        this.setDirty();
        return null;
    }

    protected void childRemoved(Node child) {
        if (!child.isDefault(true)) {
            this.makeNonDefault(false);
        }
    }

    @Override
    public Node clone(Element parent) {
        return this.clone(parent, true);
    }

    public Element clone(Element parent, boolean deep) {
        return this.cloneHelper(parent, deep, null, null);
    }

    private Element cloneHelper(Element parent, boolean deep, NodeList ancestors, NodeList leafs) {
        Node newPeer;
        Element newNode;
        Node srcPeer;
        if (ancestors != null && leafs != null) {
            boolean bContinue = false;
            int nLeafs = leafs.length();
            int i = 0;
            for (i = 0; i < nLeafs; ++i) {
                Element leaf = (Element)leafs.item(i);
                if (this != leaf) continue;
                leafs.remove(this);
                return this.clone(parent, true);
            }
            int nAncestors = ancestors.length();
            for (i = 0; i < nAncestors; ++i) {
                Element poAncestors = (Element)ancestors.item(i);
                if (this != poAncestors) continue;
                ancestors.remove(this);
                bContinue = true;
                break;
            }
            if (!bContinue) {
                return null;
            }
        }
        if (this.getModel() == null || this.getClassTag() == XFA.INVALID_ELEMENT) {
            assert (!(this instanceof DualDomNode));
            srcPeer = this;
            newNode = new Element(parent, null, this.getNS(), this.getLocalName(), this.getXMLName(), null, this.getClassTag(), this.getClassName());
            this.copyContent(newNode, false);
            newPeer = newNode;
        } else {
            Model newModel;
            Model model = parent != null ? parent.getModel() : this.getModel();
            newNode = this.getModel().getSchema().getInstance(this.getClassTag(), model, parent, null, true);
            if (newNode instanceof Model && (newModel = (Model)newNode).getAppModel() == null) {
                newModel.setAppModel(model.getAppModel());
            }
            if (this instanceof DualDomNode) {
                newPeer = ((DualDomNode)((Object)newNode)).getXmlPeer();
                if (newPeer != null) {
                    newPeer.remove();
                }
                srcPeer = ((DualDomNode)((Object)this)).getXmlPeer();
                newPeer = Element.importDomNode(parent, this, false);
                newPeer.setXfaPeer(newNode);
                ((DualDomNode)((Object)newNode)).setXmlPeer(newPeer);
            } else {
                newNode.setDOMProperties(this.mURI, this.getLocalName(), this.getXMLName(), null);
                srcPeer = this;
                this.copyContent(newNode, false);
                newPeer = newNode;
            }
        }
        if (deep) {
            for (Node srcDomChild = ((Node)srcPeer).getFirstXMLChild(); srcDomChild != null; srcDomChild = srcDomChild.getNextXMLSibling()) {
                if (!(srcDomChild instanceof ProcessingInstruction) && !(srcDomChild instanceof Comment)) continue;
                Node newDomChild = newNode.getOwnerDocument().importNode(srcDomChild, true);
                ((Element)newPeer).appendChild(newDomChild);
            }
            for (Node srcChild = this.getFirstXMLChild(); srcChild != null; srcChild = srcChild.getNextXMLSibling()) {
                if (srcChild instanceof ProcessingInstruction || srcChild instanceof Comment) continue;
                if (srcChild instanceof Element && ancestors != null && leafs != null) {
                    ((Element)srcChild).cloneHelper(newNode, true, ancestors, leafs);
                    continue;
                }
                srcChild.clone(newNode);
            }
        }
        if (this.getLocked()) {
            newNode.setLocked(true);
        }
        return newNode;
    }

    protected static Node importDomNode(Element parent, Node node, boolean bXMLDeep) {
        Node retDomNode;
        Node domPeer = ((DualDomNode)((Object)node)).getXmlPeer();
        if (parent != null) {
            Element parentPeer = (Element)((DualDomNode)((Object)parent)).getXmlPeer();
            if (domPeer instanceof DataModel.AttributeWrapper) {
                DataModel.AttributeWrapper wrapper = (DataModel.AttributeWrapper)domPeer;
                Attribute attr = parentPeer.setAttribute(wrapper.getNS(), wrapper.getLocalName(), wrapper.getXMLName(), wrapper.getValue(), false);
                retDomNode = new DataModel.AttributeWrapper(attr, parentPeer);
            } else {
                retDomNode = parentPeer.getOwnerDocument().importNode(domPeer, bXMLDeep);
                parentPeer.appendChild(retDomNode);
            }
        } else if (domPeer instanceof DataModel.AttributeWrapper) {
            DataModel.AttributeWrapper wrapper = (DataModel.AttributeWrapper)domPeer;
            StringAttr attr = new StringAttr(wrapper.getNS(), wrapper.getLocalName(), wrapper.getXMLName(), wrapper.getValue(), false);
            retDomNode = new DataModel.AttributeWrapper(attr, null);
        } else {
            retDomNode = domPeer.getOwnerDocument().importNode(domPeer, bXMLDeep);
        }
        return retDomNode;
    }

    public void copyContent(Element newNode, boolean deep) {
        Node child;
        newNode.isFragment(this.isFragment(), false);
        if (this.nAttrs != 0) {
            newNode.nAttrs = this.nAttrs;
            newNode.mAttrs = (Attribute[])this.mAttrs.clone();
            newNode.mAttrProperties = (byte[])this.mAttrProperties.clone();
            int nAttrs = this.getNumAttrs();
            int i = 0;
            while (i < nAttrs) {
                int n = i++;
                newNode.mAttrProperties[n] = (byte)(newNode.mAttrProperties[n] & 2);
            }
        }
        if (deep && child != null) {
            for (child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                if (child instanceof Element) {
                    ((Element)child).clone(newNode, true);
                    continue;
                }
                child.clone(newNode);
            }
        }
        newNode.maName = this.maName;
        if (this.getLocked()) {
            newNode.setLocked(true);
        }
    }

    private final Attribute createAttribute(String localName, String NS, String qName, String value, NodeSchema schema) {
        AttributeInfo info;
        int eTag = XFA.INVALID_ELEMENT;
        boolean bXFAAttr = localName == qName;
        Model m = this.getModel();
        if (!bXFAAttr) {
            if (m != null && m.isCompatibleNS(NS)) {
                bXFAAttr = true;
            }
            if (localName.equals("rid")) {
                bXFAAttr = true;
            }
        }
        Attribute defaultAttribute = null;
        boolean bValidAttr = true;
        if (bXFAAttr && (eTag = XFA.getAttributeTag(localName)) != XFA.INVALID_ELEMENT && (info = schema.getAttributeInfo(eTag)) != null) {
            defaultAttribute = info.getDefault();
            bValidAttr = this.isValidAttr(eTag, true, null);
        }
        if (defaultAttribute == null) {
            defaultAttribute = gsEmptyStringAttr;
        }
        value = this.internAttributeValue(defaultAttribute, value);
        Attribute a = null;
        try {
            a = ((Attribute)defaultAttribute).newAttribute(NS, localName, qName, value, false);
        }
        catch (ExFull ex) {
            if (ex.hasResId(ResId.InvalidPropertyValueException) || ex.hasResId(ResId.InvalidEnumeratedValue)) {
                m.addXMLLoadErrorContext(this.getLineNumber(), this.getOwnerDocument().getParseFileName(), ex);
                m.addErrorList(ex, 3, this);
                a = defaultAttribute;
            }
            a = gsEmptyStringAttr.newAttribute(NS, localName, qName, value, false);
        }
        if (bXFAAttr && a.getLocalName() == "name") {
            this.maName = a.getAttrValue();
        }
        if (eTag != XFA.INVALID_ELEMENT && bValidAttr) {
            return a;
        }
        if (eTag == XFA.INVALID_ELEMENT) {
            if (qName == "xmlns" || qName.startsWith("xmlns:")) {
                return a;
            }
            if (qName == "urn:oasis:names:tc:xliff:document:1.1" || qName.startsWith("xliff:")) {
                return a;
            }
        }
        if (!(!bXFAAttr || this.getClassTag() == XFA.INVALID_ELEMENT || m == null || bValidAttr && this.isValidAttr(eTag, false, null))) {
            String sLine = Integer.toString(this.getLineNumber());
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidAttributeLoadException);
            message.format(localName);
            message.format(this.getLocalName());
            message.format(sLine);
            m.addErrorList(new ExFull(message), 3, this);
        }
        return a;
    }

    private String internAttributeValue(Attribute defaultAttribute, String value) {
        int maxLengthToIntern = 9;
        if (value.length() <= 9 || defaultAttribute instanceof EnumValue) {
            Model m = this.getModel();
            value = m != null ? m.intern(value) : value.intern();
        }
        return value;
    }

    public Attribute defaultAttribute(int eTag) {
        int thisTag = this.getElementClass();
        if (thisTag == XFA.INVALID_ELEMENT || thisTag == XFA.DSIGDATATAG) {
            return gsEmptyStringAttr;
        }
        return this.getModel().getSchema().defaultAttribute(eTag, thisTag);
    }

    public int defaultElement() {
        if (this.isValidElement(XFA.TEXTNODETAG, false)) {
            return XFA.TEXTNODETAG;
        }
        return XFA.SCHEMA_DEFAULTTAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node defaultElement(int eTag, int nOccurrence) {
        boolean previousWillDirty = this.getWillDirty();
        this.setWillDirty(false);
        try {
            Node ret = this.defaultElementImpl(eTag, nOccurrence, true);
            if (ret != null) {
                if (this.isTransient()) {
                    ret.isTransient(true, true);
                } else if (ret.isTransient()) {
                    ret.isTransient(false, false);
                }
                if (this.isFragment()) {
                    if (ret instanceof Element) {
                        ((Element)ret).isFragment(true, true);
                    } else if (ret instanceof TextNode) {
                        ((TextNode)ret).isFragment(true);
                    }
                }
                ret.makeDefault();
            }
            Node node = ret;
            return node;
        }
        finally {
            this.setWillDirty(previousWillDirty);
        }
    }

    Node createDefaultElement(int eTag, int nOccurrence) {
        Node ret = this.defaultElementImpl(eTag, nOccurrence, false);
        ret.makeDefault();
        return ret;
    }

    protected Node defaultElementImpl(int eTag, int nOccurrence, boolean bAppend) {
        if (eTag == XFA.SCHEMA_DEFAULTTAG) {
            eTag = this.defaultElement();
        }
        if (eTag == XFA.SCHEMA_DEFAULTTAG) {
            return null;
        }
        Element parent = bAppend ? this : null;
        Node node = eTag == XFA.TEXTNODETAG ? this.getModel().createTextNode(parent, null, "") : this.getModel().createNode(eTag, parent, "", this.mURI, false);
        node.isTransient(true, false);
        return node;
    }

    public final String establishID() {
        String aID;
        String sID = this.getID();
        if (!StringUtils.isEmpty(sID)) {
            return sID;
        }
        sID = this.getName();
        if (StringUtils.isEmpty(sID)) {
            sID = this.getClassAtom();
        }
        sID = sID + "_ID";
        Document doc = this.getOwnerDocument();
        if (doc.idValueInUse(aID = sID)) {
            sID = UuidFactory.getUuid();
        }
        this.setID(sID);
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Arg evaluate(String sEvalText, String sEvalTypeText, int executeReason, boolean bReportNonFatalErrors) {
        boolean bTrace = oScriptTrace.isEnabled(2);
        Arg returnCode = new Arg();
        if (StringUtils.isEmpty(sEvalTypeText)) {
            sEvalTypeText = "formcalc";
        } else if (sEvalTypeText.startsWith("application/x-")) {
            sEvalTypeText = sEvalTypeText.substring("application/x-".length());
        }
        Model model = this.getModel();
        ScriptHandler handler = model.getScriptHandler(sEvalTypeText);
        if (handler == null) {
            MsgFormatPos msg = new MsgFormatPos(ResId.UnknownScriptLanguageException);
            msg.format(sEvalTypeText);
            msg.format(this.getSOMExpression());
            ExFull err = new ExFull(msg);
            this.getModel().addErrorList(err, 3, this);
        } else {
            AppModel appModel = this.getAppModel();
            Node prevContext = appModel.getContext();
            try {
                appModel.setContext(this);
                String sLocale = this.getInstalledLocale();
                long before = 0L;
                if (bTrace || TraceHandler.scriptLoggingEnabled()) {
                    MsgFormatPos msg = new MsgFormatPos(ResId.ScriptTraceExecute);
                    msg.format(sEvalTypeText);
                    msg.format(sEvalText);
                    msg.format(this.getSOMExpression());
                    msg.format(ScriptHandler.executeReasonToString(executeReason));
                    TraceHandler.reportScriptInfo(msg.toString());
                    if (bTrace) {
                        oScriptTrace.trace(2, msg);
                    }
                    before = System.currentTimeMillis();
                }
                TraceTimer scriptOnlyTimer = new TraceTimer(TraceHandler.TimingType.XFA_SCRIPTS_ONLY_TIMING);
                try {
                    handler.execute(sEvalText, sLocale, returnCode, executeReason);
                }
                finally {
                    scriptOnlyTimer.stopTiming();
                }
                if ((bTrace || TraceHandler.scriptLoggingEnabled()) && before != 0L) {
                    long after = System.currentTimeMillis();
                    MsgFormatPos msg1 = new MsgFormatPos(ResId.ScriptTraceReturnValue);
                    msg1.format(returnCode.getAsString(false));
                    String sMSecs = Long.toString(after - before);
                    MsgFormatPos msg2 = new MsgFormatPos(ResId.ScriptTraceTime);
                    msg2.format(sMSecs);
                    TraceHandler.reportScriptInfo(msg1.toString());
                    TraceHandler.reportScriptInfo(msg2.toString());
                    TraceHandler.reportScriptInfo("\n");
                    if (bTrace) {
                        oScriptTrace.trace(2, msg1);
                        oScriptTrace.trace(2, msg2);
                    }
                }
            }
            catch (ExFull ex) {
                if (ex.getResId(0) == ResId.SOFTWARE_FAILURE) {
                    throw ex;
                }
                if (bReportNonFatalErrors || handler.wasFatalError()) {
                    MsgFormatPos msg = new MsgFormatPos(ResId.ScriptFailure);
                    msg.format(sEvalTypeText);
                    msg.format(this.getSOMExpression());
                    msg.format(sEvalText);
                    ExFull err = new ExFull(msg);
                    err.insert(ex, true);
                    model.addErrorList(err, 3, this);
                }
                returnCode.setException(ex);
            }
            catch (OutOfMemoryError ex) {
                MsgFormatPos msg = new MsgFormatPos(ResId.ScriptFailure);
                msg.format(sEvalTypeText);
                msg.format(this.getSOMExpression());
                msg.format(sEvalText);
                msg.format(ex.toString());
                ExFull err = new ExFull(msg);
                throw err;
            }
            finally {
                appModel.setContext(prevContext);
            }
        }
        return returnCode;
    }

    private void extendAttributes(Attribute newAttr) {
        this.ensureAttributeCapacity(this.nAttrs + 1);
        this.mAttrs[this.nAttrs] = newAttr;
        ++this.nAttrs;
        Element e = this.getXmlPeerElement();
        if (this.getOwnerDocument() != null && this.getOwnerDocument().isId(e.getNSInternal(), e.getLocalName(), newAttr.getNS(), newAttr.getLocalName())) {
            if (this.getOwnerDocument().idValueInUse(newAttr.getAttrValue())) {
                throw new ExFull(ResId.DOM_DUPLICATE_ID_ERR);
            }
            this.getOwnerDocument().indexNode(this, false);
        }
    }

    private void ensureAttributeCapacity(int capacity) {
        if (capacity == 0) {
            return;
        }
        if (this.mAttrs != null) {
            if (capacity <= this.mAttrs.length) {
                return;
            }
            capacity = capacity * 3 / 2 + 1;
        }
        Attribute[] replacementAttrs = new Attribute[capacity];
        byte[] replacementProperties = new byte[capacity];
        if (this.mAttrs != null && this.nAttrs > 0) {
            System.arraycopy(this.mAttrs, 0, replacementAttrs, 0, this.nAttrs);
            System.arraycopy(this.mAttrProperties, 0, replacementProperties, 0, this.nAttrs);
        }
        this.mAttrs = replacementAttrs;
        this.mAttrProperties = replacementProperties;
    }

    public final int findAttr(String URI2, String name) {
        int nAttrs = this.getNumAttrs();
        for (int i = 0; i < nAttrs; ++i) {
            boolean nsMatch;
            Attribute attribute = this.getAttr(i);
            if (URI2 == null) {
                nsMatch = true;
            } else {
                String attributeNS = attribute.getNS();
                if (URI2 == "") {
                    nsMatch = StringUtils.isEmpty(attributeNS);
                } else {
                    boolean bl = nsMatch = attributeNS == URI2;
                }
            }
            if (!nsMatch || name != attribute.getName() && name != attribute.getQName()) continue;
            return i;
        }
        return -1;
    }

    protected final ProtoableNode findExternalProto(int eClassTag, int eAltClassTag, String urlRef, boolean bPeek) {
        assert (this instanceof ProtoableNode);
        if (StringUtils.isEmpty(urlRef)) {
            return null;
        }
        AppModel appModel = this.getAppModel();
        HrefHandler hrefHandler = appModel.getHrefHandler();
        if (hrefHandler == null) {
            return null;
        }
        Node target = null;
        try {
            AppModel fragAppModel = hrefHandler.loadFragment((ProtoableNode)this);
            String sFragId = null;
            int nSharp = urlRef.indexOf(35);
            sFragId = nSharp >= 0 ? urlRef.substring(nSharp + 1) : "som($template.#subform.#subform)";
            if (!sFragId.toLowerCase().startsWith("som")) {
                Model doc = hrefHandler.getDocument(fragAppModel);
                Element element = doc.getNode(sFragId);
                if (element == null) {
                    return null;
                }
                target = element;
            } else {
                NodeList list;
                int nParen = sFragId.indexOf(40);
                if (nParen >= 0) {
                    sFragId = sFragId.substring(nParen + 1, sFragId.length() - 1);
                }
                if (!sFragId.startsWith("$")) {
                    sFragId = "$template.#subform.." + sFragId;
                }
                if ((list = fragAppModel.resolveNodes(sFragId, bPeek, false, false)) == null) {
                    return null;
                }
                if (list.length() != 1) {
                    return null;
                }
                target = (Node)list.item(0);
            }
            List<ExFull> errs = fragAppModel.getErrorList();
            List<Element> contextErrs = fragAppModel.getErrorContextList();
            if (errs.size() > 0) {
                boolean bFatal = false;
                for (int i = 0; i < errs.size(); ++i) {
                    this.getModel().addErrorList(errs.get(i), 0, contextErrs.get(i));
                    if (!errs.get(i).hasResId(ResId.CircularProtoException)) continue;
                    bFatal = true;
                }
                fragAppModel.clearErrorList();
                if (bFatal) {
                    if (target instanceof ProtoableNode) {
                        ProtoableNode.releaseExternalProtos((ProtoableNode)target);
                    }
                    return null;
                }
            }
        }
        catch (ExFull ex) {
            this.getModel().addErrorList(ex, 0, this);
        }
        if (target instanceof ProtoableNode) {
            for (Element parentCheck = this.getXFAParent(); parentCheck != null; parentCheck = parentCheck.getXFAParent()) {
                if (parentCheck != target) continue;
                MsgFormatPos message = new MsgFormatPos(ResId.CircularProtoException, this.getSOMExpression());
                throw new ExFull(message);
            }
            ProtoableNode protoableNode = (ProtoableNode)target;
            if (protoableNode.isSameClass(eClassTag) || protoableNode.isSameClass(eAltClassTag)) {
                return protoableNode;
            }
        }
        return null;
    }

    protected final ProtoableNode findInternalProto(int eClassTag, int eAltClassTag, Node contextNode, String sReference, boolean bPeek) {
        Node target = null;
        if (StringUtils.isEmpty(sReference)) {
            return null;
        }
        if (sReference.startsWith("#")) {
            Element e;
            String protoID = sReference.substring(1);
            List<ProtoableNode> protos = this.getModel().getProtoList();
            for (int i = 0; protos != null && i < protos.size(); ++i) {
                ProtoableNode node = protos.get(i);
                if (!node.getID().equals(protoID)) continue;
                target = node;
                break;
            }
            if (target == null && (e = this.getModel().getNode(protoID)) != null) {
                target = e;
            }
        } else {
            String sSOMExpression = sReference;
            if (sSOMExpression.startsWith("som(") && sSOMExpression.endsWith(")")) {
                sSOMExpression = sSOMExpression.substring(4, sSOMExpression.length() - 1);
            }
            target = contextNode.resolveNode(sSOMExpression, bPeek, false, false);
        }
        if (target instanceof ProtoableNode) {
            for (Element parentCheck = this.getXFAParent(); parentCheck != null; parentCheck = parentCheck.getXFAParent()) {
                if (parentCheck != target) continue;
                MsgFormatPos message = new MsgFormatPos(ResId.CircularProtoException, this.getSOMExpression());
                throw new ExFull(message);
            }
            ProtoableNode protoableNode = (ProtoableNode)target;
            if (protoableNode.isSameClass(eClassTag) || protoableNode.isSameClass(eAltClassTag)) {
                return protoableNode;
            }
        }
        return null;
    }

    public final int findSchemaAttr(String name) {
        int nAttrs = this.getNumAttrs();
        for (int i = 0; i < nAttrs; ++i) {
            Attribute attribute = this.getAttr(i);
            if (name != attribute.getName() || !attribute.isSchemaAttr()) continue;
            return i;
        }
        return -1;
    }

    final void forceID(String sID) {
        Attribute idAttr = this.getAttribute(XFA.IDTAG, true, false);
        if (idAttr != null) {
            this.removeAttr(null, "id");
        }
        if (sID.length() > 0) {
            this.setID(sID);
        }
    }

    public final void foundBadAttribute(int eTag, String attrValue) {
        String attrName = this.getAtom(eTag);
        MsgFormatPos warning = new MsgFormatPos(ResId.FoundBadAttributeException);
        warning.format(attrValue);
        warning.format(attrName);
        warning.format(this.getClassAtom());
        warning.format(this.getName());
        this.getModel().addErrorList(new ExFull(warning), 3, this);
    }

    public final void foundBadAttribute(String attrName, String attrValue) {
        MsgFormatPos warning = new MsgFormatPos(ResId.FoundBadAttributeException);
        warning.format(attrValue);
        warning.format(attrName);
        warning.format(this.getClassAtom());
        warning.format(this.getName());
        this.getModel().addErrorList(new ExFull(warning), 3, this);
    }

    @Override
    public final NodeList getAll(boolean bByName) {
        if (bByName && this.getName() == "") {
            MsgFormatPos message = new MsgFormatPos(ResId.NoNameException);
            message.format("index").format("classIndex");
            throw new ExFull(message);
        }
        Element parent = this.getXFAParent();
        if (parent != null) {
            int eType = parent.getSchemaType(this.getClassTag());
            if (eType == 0 || eType == 2) {
                ArrayNodeList retList = new ArrayNodeList();
                for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!this.isSameClass(child.getClassTag())) continue;
                    retList.append(child);
                }
                return retList;
            }
            if (eType == 3) {
                ArrayNodeList retList = new ArrayNodeList();
                retList.append(this);
                return retList;
            }
        }
        return super.getAll(bByName);
    }

    public AppModel getAppModel() {
        Model model = this.getModel();
        assert (model != null);
        return model.getAppModel();
    }

    public String getAtom(int eTag) {
        if (this.mModel == null) {
            return XFA.getAtom(eTag);
        }
        return this.mModel.getSchema().getAtom(eTag);
    }

    public final Attribute getAttr(int n) {
        return this.getXmlPeerElement().mAttrs[n];
    }

    public Attribute getAttribute(int eAttributeTag) {
        return this.getAttribute(eAttributeTag, false, false);
    }

    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        String aPropertyName = this.getAtom(eTag);
        int attr = this.findSchemaAttr(aPropertyName);
        if (attr != -1) {
            return this.getAttr(attr);
        }
        Attribute defaultAttribute = null;
        boolean bNoSchema = false;
        if (this.getElementClass() == XFA.INVALID_ELEMENT || this.getElementClass() == XFA.DSIGDATATAG) {
            bNoSchema = true;
        } else {
            AttributeInfo info = this.getNodeSchema().getAttributeInfo(eTag);
            if (info != null) {
                defaultAttribute = info.getDefault();
            }
        }
        if (defaultAttribute == null && !bNoSchema) {
            if (bValidate) {
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
                message.format(this.getClassAtom());
                message.format(aPropertyName);
                throw new ExFull(message);
            }
            return null;
        }
        if (bPeek) {
            return null;
        }
        if (bNoSchema) {
            return gsEmptyStringAttr;
        }
        return defaultAttribute;
    }

    public Attribute getAttributeByName(String aAttrName, boolean bSearchProto) {
        Attribute attr = null;
        if (aAttrName != null) {
            int n = this.getNumAttrs();
            for (int i = 0; i < n; ++i) {
                if (!this.getAttrName(i).equals(aAttrName)) continue;
                attr = this.getAttr(i);
                break;
            }
        }
        return attr;
    }

    public final int getAttrIndex(Attribute attr) {
        int n = this.getNumAttrs();
        for (int i = 0; i < n; ++i) {
            if (this.getAttr(i) != attr) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    public final String getAttrName(int index) {
        Attribute attribute = this.getAttr(index);
        String name = attribute.getName();
        if (StringUtils.isEmpty(name)) {
            name = attribute.getQName();
        }
        return name;
    }

    public final String getAttrNS(int index) {
        return this.getAttr(index).getNS();
    }

    public final boolean getAttrProp(int attrIndex, int eProp) {
        return (this.getXmlPeerElement().mAttrProperties[attrIndex] & eProp) != 0;
    }

    public final String getAttrQName(int index) {
        return this.getAttr(index).getQName();
    }

    public final String getAttrVal(int index) {
        return this.getAttr(index).getAttrValue();
    }

    public final Node getXMLChild(int n) {
        Node child = this.getFirstXMLChild();
        for (int i = 0; i < n; ++i) {
            child = child.getNextXMLSibling();
        }
        return child;
    }

    public final Node getXFAChild(int n) {
        Node child = this.getFirstXFAChild();
        for (int i = 0; i < n; ++i) {
            child = child.getNextXFASibling();
        }
        return child;
    }

    public final ChildReln getChildReln(int eTag) {
        ChildRelnInfo info = this.getNodeSchema().getChildRelnInfo(eTag);
        if (info != null) {
            return info.getRelationship();
        }
        return null;
    }

    public final NodeList getClassAll() {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Element#getClassAll");
    }

    public final int getClassIndex() {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Element#getClassIndex");
    }

    @Override
    public final String getClassName() {
        String name = super.getClassAtom();
        if (name == null) {
            return this.mLocalName;
        }
        return name;
    }

    int getDefaultOneOfTag() {
        int eOneOfChild = XFA.SCHEMA_DEFAULTTAG;
        NodeSchema nodeSchema = this.getNodeSchema();
        SchemaPairs children = nodeSchema.getValidChildren();
        if (children != null) {
            int eOneOfChildDefault = this.defaultElement();
            boolean bFound = false;
            for (int i = 0; i < children.size(); ++i) {
                ChildReln reln = (ChildReln)children.value(i);
                int eTag = children.key(i);
                if (reln.getOccurrence() != 4) continue;
                if (eOneOfChildDefault == eTag) {
                    bFound = true;
                    eOneOfChild = eTag;
                    break;
                }
                if (bFound) continue;
                bFound = true;
                eOneOfChild = eTag;
            }
            if (!bFound) {
                eOneOfChild = eOneOfChildDefault;
            }
        }
        return eOneOfChild;
    }

    public void getDeltas(Element delta, XFAList list) {
        if (delta != null && this.isSameClass(delta) && this.getName() == delta.getName()) {
            SchemaPairs attrs = this.getNodeSchema().getValidAttributes();
            if (attrs != null) {
                Attribute localeDelta = null;
                if (list != null) {
                    for (int i = 0; i < attrs.size(); ++i) {
                        int eTag = attrs.key(i);
                        if (eTag == XFA.NAMETAG) continue;
                        Attribute deltaAttr = delta.getAttribute(eTag, true, false);
                        if (eTag == XFA.LOCALETAG) {
                            localeDelta = deltaAttr;
                            continue;
                        }
                        if (deltaAttr == null) continue;
                        Attribute attr = this.getAttribute(eTag, false, false);
                        Delta newDelta = new Delta(this, delta, attr, deltaAttr, XFA.getString(eTag));
                        list.append(newDelta);
                    }
                } else {
                    localeDelta = delta.getAttribute(XFA.LOCALETAG, true, false);
                }
                if (localeDelta != null) {
                    this.setAttribute(localeDelta, XFA.LOCALETAG);
                }
            }
            ElementNodeList children = new ElementNodeList(this);
            ElementNodeList deltaChildren = new ElementNodeList(delta);
            for (Node deltaChild = delta.getFirstXFAChild(); deltaChild != null; deltaChild = deltaChild.getNextXFASibling()) {
                Node targetChild = null;
                boolean bIsContainerChild = deltaChild.isContainer();
                int eClassTag = deltaChild.getClassTag();
                ChildReln childReln = this.getChildReln(eClassTag);
                if (childReln != null) {
                    Integer nOccurrence;
                    if (childReln.getOccurrence() == 4) {
                        targetChild = this.getOneOfChild(false, false);
                        if (targetChild == null || !targetChild.isSameClass(eClassTag)) {
                            if (list != null) {
                                Delta newDelta = new Delta(this, delta, targetChild, deltaChild, "");
                                list.append(newDelta);
                            }
                            targetChild = null;
                        }
                    } else if (childReln.getMax() != -1) {
                        if (eClassTag == XFA.TEXTNODETAG) {
                            targetChild = this.getText(false, false, false);
                        } else {
                            nOccurrence = deltaChildren.getOccurrence(deltaChild);
                            if (nOccurrence != null) {
                                targetChild = this.getElement(eClassTag, false, nOccurrence, false, false);
                            }
                        }
                    } else {
                        nOccurrence = deltaChildren.getOccurrence(deltaChild);
                        if (nOccurrence != null) {
                            targetChild = children.getNamedItem(deltaChild.getName(), deltaChild.getClassAtom(), nOccurrence);
                        }
                        if (list != null && targetChild == null && !bIsContainerChild) {
                            targetChild = null;
                            Delta newDelta = new Delta(this, delta, targetChild, deltaChild, "");
                            list.append(newDelta);
                        }
                    }
                }
                if (targetChild == null) continue;
                if (targetChild instanceof TextNode) {
                    ((TextNode)targetChild).getDeltas((TextNode)deltaChild, list);
                    continue;
                }
                if (!(targetChild instanceof Element) || !(deltaChild instanceof Element)) continue;
                ((Element)targetChild).getDeltas((Element)deltaChild, list);
            }
        }
    }

    private Element getXmlPeerElement() {
        return this instanceof DualDomNode ? (Element)((DualDomNode)((Object)this)).getXmlPeer() : this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        String sGetFunc;
        ScriptDynamicPropObj desc;
        if (StringUtils.isEmpty(sPropertyName)) {
            return null;
        }
        int nAvail = 63;
        int nVersion = 10;
        int eType = 5;
        int eTag = XFA.getTag(sPropertyName);
        if (eTag != XFA.INVALID_ELEMENT) {
            AttributeInfo attrInfo = this.getNodeSchema().getAttributeInfo(eTag);
            if (attrInfo != null) {
                nAvail = attrInfo.getAvailability();
                nVersion = attrInfo.getVersionIntroduced();
                eType = 1;
            } else {
                ChildRelnInfo childInfo = this.getNodeSchema().getChildRelnInfo(eTag);
                if (childInfo != null) {
                    nAvail = childInfo.getAvailability();
                    nVersion = childInfo.getVersionIntroduced();
                    ChildReln reln = childInfo.getRelationship();
                    if (reln != null) {
                        eType = reln.getMax() == -1 ? 4 : (reln.getOccurrence() == 4 ? 3 : 2);
                    }
                }
            }
        }
        if ((desc = super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek, nVersion, nAvail)) != null) {
            return desc;
        }
        if (eType == 3) {
            Node oneOf = this.getOneOfChild(bPeek, false);
            if (oneOf == null || oneOf.getClassTag() != eTag) return null;
            sGetFunc = "locateOneOf";
            return new ElementScriptDynamicPropObj(sGetFunc, eType == 1 ? "setProp" : null, nVersion, nAvail);
        } else {
            if (eType != 1 && eType != 0 && eType != 2) return null;
            if (bPeek && !this.isPropertySpecified(eTag, true, 0)) {
                return null;
            }
            sGetFunc = bPeek ? "locatePropPeek" : "locateProp";
        }
        return new ElementScriptDynamicPropObj(sGetFunc, eType == 1 ? "setProp" : null, nVersion, nAvail);
    }

    public Element getElement(int eTag, boolean bPeek, int nOccurrence, boolean bReturnDefault, boolean bValidate) {
        return this.getElementLocal(eTag, bPeek, nOccurrence, bReturnDefault, bValidate);
    }

    public final Element getElement(int eElementTag, int nOccurrence) {
        return this.getElement(eElementTag, false, nOccurrence, false, false);
    }

    public final Node getNode(int eTag, int nOccurrence) {
        Node child = this.locateChildByClass(eTag, nOccurrence);
        if (child != null) {
            return child;
        }
        if (eTag == XFA.TEXTNODETAG) {
            return this.getText(true, false, false);
        }
        return this.getElement(eTag, true, nOccurrence, false, false);
    }

    public final Element getElementLocal(int eTag, boolean bPeek, int nOccurrence, boolean bReturnDefault, boolean bValidate) {
        Node child;
        if (bValidate) {
            ChildReln validChild = this.getChildReln(eTag);
            if (validChild == null || validChild.getOccurrence() == 4 || validChild.getMax() == -1) {
                String aPropertyName = this.getAtom(eTag);
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
                message.format(this.getClassAtom());
                message.format(aPropertyName);
                throw new ExFull(message);
            }
            if (validChild != null && validChild.getMax() <= nOccurrence) {
                throw new ExFull(new IndexOutOfBoundsException(""));
            }
        } else assert (this.getModel() != null);
        if ((child = this.locateChildByClass(eTag, nOccurrence)) instanceof Element) {
            return (Element)child;
        }
        if ((!bPeek || bReturnDefault) && (child = this.defaultElement(eTag, nOccurrence)) instanceof Element) {
            return (Element)child;
        }
        return null;
    }

    public final int getElementClass() {
        return this.getClassTag();
    }

    public final int getEnum(int ePropertyTag) {
        EnumValue eNum = (EnumValue)this.getAttribute(ePropertyTag);
        return eNum.getInt();
    }

    public final EnumAttr getEnum(String sPropertyName) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Element#getEnum(String)");
    }

    @Override
    public EventManager.EventTable getEventTable(boolean bCreate) {
        if (bCreate && this.mEventTable == null) {
            this.mEventTable = new EventManager.EventTable();
        }
        return this.mEventTable;
    }

    protected final String getEventScript(Element element) {
        if (element == null) {
            Attribute attr = this.findEventAttribute(this, "script");
            return attr == null ? "" : attr.getAttrValue();
        }
        Node firstChild = element.getFirstXMLChild();
        return firstChild == null ? "" : firstChild.getData();
    }

    protected final String getEventContentType(Element element) {
        Element node = element == null ? this : element;
        Attribute attr = this.findEventAttribute(node, "contentType");
        return attr == null ? "" : attr.getAttrValue();
    }

    protected final String getEvent() {
        Attribute attr = this.findEventAttribute(this, "event");
        return attr == null ? "" : attr.getAttrValue();
    }

    private Attribute findEventAttribute(Element element, String attrName) {
        int len = element.getNumAttrs();
        for (int i = 0; i < len; ++i) {
            Attribute attr = element.getAttr(i);
            if (!attr.getLocalName().equals(attrName) || !attr.getNS().startsWith("http://www.xfa.org/schema/xfa-events/")) continue;
            return attr;
        }
        return null;
    }

    @Override
    public Node getFirstXMLChild() {
        return this.mFirstXMLChild;
    }

    @Override
    public final Node getSibling(int index, boolean bByName, boolean bExceptionIfNotFound) {
        if (bByName) assert (this.getName() != "");
        Element parent = this.getXMLParent();
        if (parent != null) {
            boolean bError = false;
            ChildReln reln = parent.getChildReln(this.getClassTag());
            if (reln != null) {
                int nMaxOccur = reln.getMax();
                if (nMaxOccur == -1) {
                    return super.getSibling(index, bByName, bExceptionIfNotFound);
                }
                if (nMaxOccur == 1) {
                    if (index == 0) {
                        return this;
                    }
                    bError = true;
                } else if (nMaxOccur <= index) {
                    bError = true;
                } else {
                    return parent.getElement(this.getClassTag(), index);
                }
            }
            if (bError) {
                if (bExceptionIfNotFound) {
                    throw new ExFull(new IndexOutOfBoundsException(""));
                }
                return null;
            }
        }
        return super.getSibling(index, bByName, bExceptionIfNotFound);
    }

    @Override
    public Node getFirstXFAChild() {
        if (this.mFirstXMLChild != null && this.mFirstXMLChild.getClassTag() == XFA.INVALID_ELEMENT) {
            return this.mFirstXMLChild.getNextXFASibling();
        }
        return this.mFirstXMLChild;
    }

    public final String getID() {
        if (this.isValidAttr(XFA.IDTAG, false, null)) {
            Attribute attr = this.getAttribute(XFA.IDTAG);
            return attr == null ? "" : attr.getAttrValue();
        }
        return "";
    }

    @Override
    public final int getIndex(boolean bByName) {
        if (bByName && this.getName() == "") {
            MsgFormatPos message = new MsgFormatPos(ResId.NoNameException);
            message.format("all");
            message.format("getIndex");
            throw new ExFull(message);
        }
        Element parent = this.getXFAParent();
        if (parent != null) {
            int eType = parent.getSchemaType(this.getClassTag());
            if (eType == 0 || eType == 2) {
                int nFound = 0;
                for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!this.isSameClass(child)) continue;
                    if (child == this) {
                        return nFound;
                    }
                    ++nFound;
                }
                return nFound;
            }
            if (eType == 3) {
                return 0;
            }
        }
        return super.getIndex(bByName);
    }

    public final String getInheritedNS() {
        String ns = this.getNS();
        Element check = this;
        while (ns == null) {
            if (check.getXFAParent() == null) continue;
            check = check.getXFAParent();
            ns = check.getNS();
        }
        return ns;
    }

    public final String getInstalledLocale() {
        Attribute attr;
        if (this.isPropertySpecified(XFA.LOCALETAG, true, 0) && (attr = this.getAttribute(XFA.LOCALETAG, true, false)) != null && !attr.isEmpty()) {
            String sLocale = attr.toString();
            if (sLocale.equals("ambient")) {
                sLocale = this.getModel().getCachedLocale();
            }
            return sLocale;
        }
        Element parent = this.getXFAParent();
        if (parent != null) {
            return parent.getInstalledLocale();
        }
        return this.getModel().getCachedLocale();
    }

    public final boolean isInstalledLocaleAmbient() {
        Attribute attr;
        if (this.isPropertySpecified(XFA.LOCALETAG, true, 0) && (attr = this.getAttribute(XFA.LOCALETAG, true, false)) != null && !attr.isEmpty()) {
            return attr.toString().equals("ambient");
        }
        Element parent = this.getXFAParent();
        if (parent != null) {
            return parent.isInstalledLocaleAmbient();
        }
        return false;
    }

    boolean getIsDataWindowRoot() {
        return this.mbIsDataWindowRoot;
    }

    public boolean getIsNull() {
        return false;
    }

    @Override
    public final Node getLastXMLChild() {
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (child.getNextXMLSibling() != null) continue;
            return child;
        }
        return null;
    }

    public final int getLineNumber() {
        return this.mnLineNumber;
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    @Override
    public final Model getModel() {
        return this.mModel;
    }

    @Override
    public String getName() {
        ProtoableNode proto;
        if (this.maName != null) {
            return this.maName;
        }
        if (this instanceof ProtoableNode && (proto = ((ProtoableNode)this).getProto()) != null) {
            return proto.getName();
        }
        if (this.getElementClass() == XFA.INVALID_ELEMENT) {
            return this.getLocalName();
        }
        return "";
    }

    public void privateSetName(String name) {
        if (!this.isValidAttr(XFA.NAMETAG, false, null)) {
            return;
        }
        StringAttr a = new StringAttr("name", name);
        this.updateAttribute(a);
        this.maName = a.getAttrValue();
    }

    @Override
    public NodeList getNodes() {
        return new ElementNodeList(this);
    }

    public final NodeSchema getNodeSchema() {
        if (this.mNodeSchema != null) {
            return this.mNodeSchema;
        }
        return this.calcNodeSchema();
    }

    private final NodeSchema calcNodeSchema() {
        if (this.mNodeSchema == null && this.mModel != null) {
            if (this.getClassTag() == XFA.INVALID_ELEMENT) {
                return Schema.nullSchema();
            }
            this.mNodeSchema = this.mModel.getSchema().getNodeSchema(this.getClassTag());
        }
        if (this.mNodeSchema != null) {
            return this.mNodeSchema;
        }
        if (this.mModel instanceof AppModel && this instanceof Model) {
            return ((Model)this).getSchema().getNodeSchema(this.getClassTag());
        }
        return Schema.nullSchema();
    }

    public String getNS() {
        return this.mURI;
    }

    final String getNSInternal() {
        return this.mURI;
    }

    public final int getNumAttrs() {
        if (this instanceof DualDomNode) {
            Node peerNode = ((DualDomNode)((Object)this)).getXmlPeer();
            if (peerNode instanceof Element) {
                return ((Element)peerNode).nAttrs;
            }
            return 0;
        }
        return this.nAttrs;
    }

    public final Node getOneOfChild() {
        return this.getOneOfChild(false, false);
    }

    public Node getOneOfChild(boolean bPeek, boolean bReturnDefault) {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int eTag = child.getClassTag();
            if (eTag == XFA.INVALID_ELEMENT) {
                return null;
            }
            ChildReln childReln = this.getChildReln(eTag);
            if (childReln == null || childReln.getOccurrence() != 4) continue;
            return child;
        }
        if (!bPeek || bReturnDefault) {
            int eOneOfChild = this.getDefaultOneOfTag();
            if (eOneOfChild == XFA.SCHEMA_DEFAULTTAG) {
                return null;
            }
            if (eOneOfChild == XFA.TEXTNODETAG) {
                return this.getModel().createTextNode(this, this.getLastXMLChild(), "");
            }
            return this.defaultElement(eOneOfChild, 0);
        }
        return null;
    }

    void getPI(List<String> pis, boolean bCheckProtos) {
        for (Node node = this.getFirstXMLChild(); node != null; node = node.getNextXMLSibling()) {
            if (!(node instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)node;
            String sTemp = pi.getName() + ' ' + pi.getData();
            pis.add(sTemp);
        }
    }

    public void getPI(String aPiName, List<String> pis, boolean bCheckProtos) {
        assert (aPiName != null);
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            ProcessingInstruction pi;
            if (!(child instanceof ProcessingInstruction) || (pi = (ProcessingInstruction)child).getName() != aPiName) continue;
            pis.add(pi.getData());
        }
    }

    public void optimizeNameSpace(int eAttributeTag, boolean bDeleteIfNotNeeded) {
        if (eAttributeTag == XFA.RIDTAG) {
            String sNSAlias = "xmlns:xliff";
            boolean bNeeded = true;
            if (bDeleteIfNotNeeded) {
                bNeeded = this.pruneNameSpaceDefn(this, sNSAlias, "urn:oasis:names:tc:xliff:document:1.1");
            }
            if (bNeeded) {
                this.setAttribute("", sNSAlias, "xliff", "urn:oasis:names:tc:xliff:document:1.1");
            }
        }
    }

    public void getPI(String aPiName, String sPropName, List<String> pis, boolean bCheckProtos) {
        assert (aPiName != null);
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            String sNodeValue;
            String[] sProp;
            ProcessingInstruction pi;
            if (!(child instanceof ProcessingInstruction) || (pi = (ProcessingInstruction)child).getName() != aPiName || !(sProp = (sNodeValue = pi.getData()).split("[ \t]"))[0].equals(sPropName)) continue;
            int skip = StringUtils.skipUntil(sNodeValue, " \t", 0);
            String sReturn = sNodeValue.substring(skip, sNodeValue.length()).trim();
            pis.add(sReturn);
        }
    }

    public final String getPrefix() {
        int colon;
        String qName = this.getXMLName();
        if (qName != null && (colon = qName.indexOf(58)) > 0) {
            return qName.substring(0, colon).intern();
        }
        return "";
    }

    @Override
    public final Object getProperty(int ePropTag, int nOccurrence) {
        int ePropType = this.getSchemaType(ePropTag);
        if (ePropType == 2) {
            return this.getElement(ePropTag, false, nOccurrence, false, false);
        }
        if (ePropType == 0) {
            return this.getText(false, false, false);
        }
        if (ePropType == 1) {
            return this.getAttribute(ePropTag);
        }
        if (ePropType == 3) {
            String aPropertyName = XFA.getString(ePropTag);
            throw new ExFull(ResId.InvalidGetOneOfException, aPropertyName);
        }
        String aPropertyName = XFA.getString(ePropTag);
        MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
        message.format(this.getClassName());
        message.format(aPropertyName);
        throw new ExFull(message);
    }

    @Override
    public final Object getProperty(String propertyName, int nOccurrence) {
        int eTag = XFA.getTag(propertyName.intern());
        if (eTag != XFA.INVALID_ELEMENT) {
            return this.getProperty(eTag, nOccurrence);
        }
        MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
        message.format(this.getClassName());
        message.format(propertyName);
        throw new ExFull(message);
    }

    public boolean getSaveXMLSaveTransient() {
        return this.mbSaveXMLSaveTransient;
    }

    Schema getSchema() {
        return this.getModel().getSchema();
    }

    public int getSchemaType(int eTag) {
        if (this.getElementClass() == XFA.INVALID_ELEMENT) {
            return 1;
        }
        if (this.getModel() == null) {
            return 5;
        }
        ChildReln reln = this.getChildReln(eTag);
        if (reln != null) {
            if (reln.getMax() == -1) {
                return 4;
            }
            if (reln.getOccurrence() == 4) {
                return 3;
            }
            if (eTag == XFA.TEXTNODETAG) {
                return 0;
            }
            return 2;
        }
        if (this.getNodeSchema().getAttributeInfo(eTag) != null) {
            return 1;
        }
        return 5;
    }

    @Override
    public ScriptFuncObj getScriptMethodInfo(String sFunctionName) {
        ScriptFuncObj scriptFunc = null;
        Model model = this.getModel();
        if (model != null) {
            scriptFunc = super.getScriptMethodInfo(sFunctionName);
        }
        return scriptFunc;
    }

    @Override
    protected ScriptPropObj getScriptProp(String aPropertyName) {
        ScriptPropObj scriptProp = null;
        Model model = this.getModel();
        if (model != null) {
            scriptProp = super.getScriptProp(aPropertyName);
        }
        return scriptProp;
    }

    @Override
    public ScriptTable getScriptTable() {
        return ElementScript.getScriptTable();
    }

    public TextNode getText(boolean bPeek, boolean bReturnDefault, boolean bValidate) {
        TextNode child;
        if (bValidate) {
            ChildReln validChild = this.getChildReln(XFA.TEXTNODETAG);
            if (validChild == null) {
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
                message.format(this.getClassAtom());
                message.format("#text");
                throw new ExFull(message);
            }
        } else assert (this.getModel() != null);
        if ((child = (TextNode)this.locateChildByClass(XFA.TEXTNODETAG, 0)) != null) {
            return child;
        }
        if (!bPeek || bReturnDefault) {
            return (TextNode)this.defaultElement(XFA.TEXTNODETAG, 0);
        }
        return null;
    }

    final int getValidOccurrence(int eTag) {
        ChildReln validChild = this.getChildReln(eTag);
        if (validChild != null) {
            return validChild.getOccurrence();
        }
        return 2;
    }

    public String getXMLName() {
        return this.mQName;
    }

    public void setXMLName(String name) {
        this.mQName = name;
        if (this instanceof DualDomNode) {
            ((Element)((DualDomNode)((Object)this)).getXmlPeer()).mQName = this.mQName;
        }
        this.setDirty();
    }

    public String getXPath(Map<String, String> prefixList, Element contextNode) {
        StringBuilder sPrefix = new StringBuilder();
        Element common = null;
        if (contextNode != null && (common = this.getCommonAncestor(contextNode)) != null) {
            Element current = contextNode;
            if (common != current) {
                sPrefix.append("..");
                current = current.getXFAParent();
            }
            while (common != current) {
                sPrefix.append("/..");
                current = current.getXFAParent();
            }
        }
        StringBuilder sXPathExp = new StringBuilder();
        String sCurrentPrefix = "a";
        for (Element current = this; current != common && !(current instanceof Document); current = current.getXFAParent()) {
            StringBuilder sPath = new StringBuilder("/");
            if (current instanceof Element) {
                Element element = current;
                String sNodePrefix = element.getPrefix();
                String sNodeNSURI = element.getNS();
                if (sNodeNSURI != null && sNodeNSURI.length() != 0) {
                    String sUsedPrefix = prefixList.get(sNodeNSURI);
                    if (sUsedPrefix != null) {
                        if (sNodePrefix.length() != 0) {
                            while (prefixList.containsValue(sCurrentPrefix)) {
                                sCurrentPrefix = this.bumpString(sCurrentPrefix);
                            }
                            sUsedPrefix = sCurrentPrefix;
                        } else {
                            sUsedPrefix = sNodePrefix;
                        }
                        prefixList.put(sNodeNSURI, sUsedPrefix);
                    }
                    if (sUsedPrefix != null && sUsedPrefix.length() != 0) {
                        sPath.append(sUsedPrefix);
                        sPath.append(':');
                    }
                }
                sPath.append(current.getLocalName());
                int index = current.getIndex(false);
                sPath.append('[');
                sPath.append(index + 1);
                sPath.append(']');
            }
            sXPathExp.insert(0, sPath);
        }
        sXPathExp.insert(0, sPrefix);
        return sXPathExp.toString();
    }

    private static XPathFactory getXPathFactory() {
        if (mXPathFactory == null) {
            mXPathFactory = XPathFactory.newInstance();
        }
        return mXPathFactory;
    }

    private Element getCommonAncestor(Element pOther) {
        Element parent2;
        Element parent1;
        ArrayList<Element> list1 = new ArrayList<Element>();
        ArrayList<Element> list2 = new ArrayList<Element>();
        for (parent1 = this; parent1 != null; parent1 = parent1.getXFAParent()) {
            list1.add(parent1);
        }
        for (parent2 = pOther; parent2 != null; parent2 = parent2.getXFAParent()) {
            list2.add(parent2);
        }
        parent1 = (Element)list1.get(list1.size() - 1);
        if (parent1 != (parent2 = (Element)list2.get(list2.size() - 1))) {
            return null;
        }
        Element common = null;
        while (parent1 == parent2) {
            common = parent1;
            list1.remove(list1.size() - 1);
            list2.remove(list2.size() - 1);
            if (list1.size() == 0 || list2.size() == 0) break;
            parent1 = (Element)list1.get(list1.size() - 1);
            parent2 = (Element)list2.get(list2.size() - 1);
        }
        return common;
    }

    String bumpString(String input) {
        StringBuilder buffer = new StringBuilder(input);
        for (int nPos = input.length() - 1; nPos >= 0; --nPos) {
            if (buffer.charAt(nPos) == 'z') {
                buffer.setCharAt(nPos, 'a');
                continue;
            }
            buffer.setCharAt(nPos, (char)(buffer.charAt(nPos) + '\u0001'));
            return input;
        }
        input = input + 'a';
        return input;
    }

    public Attribute getXsiNilAttribute() {
        Element e = this.getXmlPeerElement();
        for (int i = 0; i < e.nAttrs; ++i) {
            Attribute a = e.getAttr(i);
            if (!a.isXSINilAttr()) continue;
            return a;
        }
        return null;
    }

    public void removeXsiNilAttribute() {
        Element e = this.getXmlPeerElement();
        for (int i = 0; i < e.nAttrs; ++i) {
            Attribute a = this.getAttr(i);
            if (!a.isXSINilAttr()) continue;
            e.removeAttr(i);
        }
    }

    public final void setXsiNilAttribute(String aValue) {
        Element e = this.getXmlPeerElement();
        for (int i = 0; i < e.nAttrs; ++i) {
            Attribute a = e.getAttr(i);
            if (!a.isXSINilAttr()) continue;
            e.mAttrs[i] = new GenericAttribute(a.getName(), a.getLocalName(), a.getQName(), aValue, false);
            return;
        }
        e.extendAttributes(new GenericAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", aValue, false));
    }

    public final boolean inhibitPrettyPrint() {
        return this.mbInhibitPrettyPrint;
    }

    public final void inhibitPrettyPrint(boolean bInhibit) {
        this.mbInhibitPrettyPrint = bInhibit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChild(Node newChild, Node refNode, boolean bValidate) {
        if (refNode != null) assert (refNode.getOwnerDocument() == this.getOwnerDocument());
        if (bValidate) {
            this.isValidChild(newChild.getClassTag(), ResId.InvalidChildInsertException, true, false);
        }
        if (newChild == this || newChild == refNode) {
            throw new ExFull(ResId.HierarchyRequestException, newChild.getName());
        }
        boolean bIsDefault = newChild.isDefault(false);
        try {
            if (bIsDefault) {
                this.mute();
            }
            if (!newChild.isDefault(true)) {
                this.makeNonDefault(false);
            }
            if (newChild.getXMLParent() != null) {
                newChild.remove();
            }
            if (newChild.getModel() != this.getModel() || newChild.getOwnerDocument() != this.getOwnerDocument()) {
                this.updateModelAndDocument(newChild);
            }
            boolean bAddedLocally = true;
            if (refNode == null) {
                this.appendChild(newChild);
                bAddedLocally = false;
            } else {
                if (this instanceof DualDomNode && newChild instanceof DualDomNode) {
                    Element domParentNode = (Element)((DualDomNode)((Object)this)).getXmlPeer();
                    Node domNewNode = ((DualDomNode)((Object)newChild)).getXmlPeer();
                    Node domRefNode = ((DualDomNode)((Object)refNode)).getXmlPeer();
                    if (domNewNode.getModel() != this.getModel() || domNewNode.getOwnerDocument() != this.getOwnerDocument()) {
                        this.updateModelAndDocument(domNewNode);
                    }
                    if (domNewNode instanceof DataModel.AttributeWrapper) {
                        DataModel.AttributeWrapper wrapper = (DataModel.AttributeWrapper)domNewNode;
                        Attribute attr = domParentNode.setAttribute(wrapper.getNS(), wrapper.getXMLName(), wrapper.getLocalName(), wrapper.getValue(), false);
                        DataModel.AttributeWrapper xmlPeer = new DataModel.AttributeWrapper(attr, domParentNode);
                        xmlPeer.setXfaPeer((Element)newChild);
                        ((DualDomNode)((Object)newChild)).setXmlPeer(xmlPeer);
                    } else {
                        domParentNode.insertChild(domNewNode, domRefNode, false);
                    }
                }
                if (refNode == this.mFirstXMLChild) {
                    this.mFirstXMLChild = newChild;
                    newChild.setNextXMLSibling(refNode);
                    newChild.setXMLParent(this);
                } else {
                    Node nextChild;
                    Node child = this.mFirstXMLChild;
                    while (child != null && (nextChild = child.getNextXMLSibling()) != refNode) {
                        child = nextChild;
                    }
                    if (child != null) {
                        child.setNextXMLSibling(newChild);
                        newChild.setNextXMLSibling(refNode);
                        newChild.setXMLParent(this);
                    }
                }
            }
            if (bAddedLocally) {
                if (newChild.getModel() != this.getModel()) {
                    this.updateModelAndDocument(newChild);
                }
                if (!newChild.isMute()) {
                    newChild.notifyPeers(3, this.getClassAtom(), this);
                }
                if (!this.isMute()) {
                    this.notifyPeers(4, newChild.getClassAtom(), newChild);
                }
            }
        }
        finally {
            if (bIsDefault) {
                this.unMute();
            }
        }
        if (newChild instanceof Element) {
            this.getOwnerDocument().indexSubtree((Element)newChild, false);
        }
        this.setDirty();
    }

    void insertPI(String aPiName, String sPropName, String sData, Node refChild) {
        this.isValidChild(refChild.getClassTag(), ResId.InvalidChildInsertException, false, false);
        if (refChild == this) {
            throw new ExFull(new MsgFormat(ResId.HierarchyRequestException, refChild.getName()));
        }
        if (refChild.getXFAParent() != this) {
            throw new ExFull(ResId.InsertFailedException);
        }
        String sTemp = sPropName + " " + sData;
        new ProcessingInstruction(this, refChild.getPreviousXMLSibling(), aPiName, sTemp);
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    boolean isFragment() {
        return this.mbIsFragment;
    }

    public void isFragment(boolean bFragment, boolean bSetChildren) {
        Element parent;
        this.mbIsFragment = bFragment;
        if (!bFragment && (parent = this.getXMLParent()) != null && parent.isFragment()) {
            parent.isFragment(false, false);
        }
        if (!bSetChildren) {
            return;
        }
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child instanceof Element) {
                ((Element)child).isFragment(bFragment, true);
                continue;
            }
            if (!(child instanceof TextNode)) continue;
            ((TextNode)child).isFragment(bFragment);
        }
        for (int i = 0; i < this.getNumAttrs(); ++i) {
            this.setAttrProp(i, 2, bFragment);
        }
    }

    public final boolean isHidden() {
        return this.mbIsHidden;
    }

    public final void isHidden(boolean bHidden) {
        if (!bHidden && this.isHidden()) {
            this.mbIsHidden = bHidden;
        }
        if (bHidden && !this.isHidden()) {
            this.mbIsHidden = bHidden;
            for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof Element)) continue;
                ((Element)child).isHidden(true);
            }
        }
    }

    protected boolean isIndexable() {
        for (Element node = this; node != null; node = node.getXFAParent()) {
            if (node.getClassTag() == XFA.INVALID_ELEMENT) continue;
            return node.childrenAreIndexable();
        }
        return true;
    }

    protected boolean childrenAreIndexable() {
        return true;
    }

    public final boolean isIndexed() {
        return this.mbIsIndexed;
    }

    @Override
    public final boolean isLeaf() {
        return this.getFirstXFAChild() == null;
    }

    @Override
    boolean isLikeNode(Node node, boolean bByName) {
        if (this == node) {
            return true;
        }
        if (!super.isLikeNode(node, bByName)) {
            return false;
        }
        Element parent = this.getXFAParent();
        return parent == null || parent.getSchemaType(this.getClassTag()) == parent.getSchemaType(node.getClassTag());
    }

    public boolean isNameSpaceAttr() {
        return this.getXMLName().startsWith("xmlns:");
    }

    @Override
    public final boolean isPropertySpecified(int ePropTag, boolean bCheckProtos, int nOccurrence) {
        int eType = this.getSchemaType(ePropTag);
        if (eType == 1 || eType == 0 || eType == 2) {
            return this.isSpecified(ePropTag, eType, bCheckProtos, nOccurrence);
        }
        return false;
    }

    @Override
    public final boolean isPropertySpecified(String propertyName, boolean bCheckProtos, int nOccurrence) {
        int ePropTag = XFA.getTag(propertyName.intern());
        if (ePropTag == XFA.INVALID_ELEMENT) {
            return false;
        }
        return this.isPropertySpecified(ePropTag, bCheckProtos, nOccurrence);
    }

    public final boolean isPropertyValid(int ePropTag) {
        if (this.isValidAttr(ePropTag, false, null)) {
            return true;
        }
        return this.isValidElement(ePropTag, false);
    }

    final boolean isPropertyValid(String propertyName) {
        int ePropTag = XFA.getTag(propertyName);
        if (ePropTag == XFA.INVALID_ELEMENT) {
            return false;
        }
        return this.isPropertyValid(ePropTag);
    }

    @Override
    public boolean isSpecified(int eTag, boolean bCheckProtos, int nOccurrence) {
        int eType = this.getSchemaType(eTag);
        return this.isSpecified(eTag, eType, bCheckProtos, nOccurrence);
    }

    public boolean isSpecified(int eTag, int eType, boolean bCheckProtos, int nOccurrence) {
        ChildReln validChild;
        if (eType == 5) {
            return false;
        }
        if (eType == 1) {
            String aPropName = this.getAtom(eTag);
            return this.findSchemaAttr(aPropName) != -1;
        }
        if (this.getFirstXFAChild() == null) {
            return false;
        }
        if (nOccurrence > 0 && (validChild = this.getChildReln(eTag)) != null && validChild.getMax() <= nOccurrence) {
            return false;
        }
        if (eType == 3) {
            if (nOccurrence > 0) {
                return false;
            }
            Node oneOf = this.getOneOfChild(true, false);
            return oneOf != null && oneOf.getClassTag() == eTag;
        }
        Node child = this.locateChildByClass(eTag, nOccurrence);
        return child != null && !child.isDefault(true);
    }

    @Override
    public final boolean isSpecified(String sPropertyName, boolean bCheckProtos, int nOccurrence) {
        int ePropTag = XFA.getTag(sPropertyName);
        if (ePropTag == XFA.INVALID_ELEMENT) {
            return false;
        }
        return this.isSpecified(ePropTag, bCheckProtos, nOccurrence);
    }

    @Override
    public final void isTransient(boolean bTransient, boolean bSetChildren) {
        super.isTransient(bTransient, bSetChildren);
        if (this instanceof DualDomNode) {
            ((DualDomNode)((Object)this)).getXmlPeer().isTransient(bTransient, bSetChildren);
        }
        for (int i = 0; i < this.getNumAttrs(); ++i) {
            this.setAttrProp(i, 4, bTransient);
        }
    }

    @Override
    public boolean isTransparent() {
        int eType;
        Element parent = this.getXFAParent();
        if (parent != null && ((eType = parent.getSchemaType(this.getClassTag())) == 0 || eType == 2 || eType == 3)) {
            return false;
        }
        if (this.isContainer() && this.getName() == "") {
            return true;
        }
        return this.mbTransparent;
    }

    public boolean isValidAttr(int eTag, boolean bReport, String value) {
        if (this.getElementClass() == XFA.INVALID_ELEMENT) {
            return false;
        }
        Model model = this.getModel();
        if (model == null) {
            assert (false);
            return false;
        }
        AttributeInfo info = this.getNodeSchema().getAttributeInfo(eTag);
        if (info == null) {
            return false;
        }
        int nVersionIntroduced = info.getVersionIntroduced();
        int nAvailability = info.getAvailability();
        if (value != null) {
            EnumValue eTest = null;
            Attribute defaultAttribute = info.getDefault();
            if (defaultAttribute instanceof EnumValue) {
                try {
                    eTest = (EnumValue)defaultAttribute.newAttribute(value);
                }
                catch (ExFull ex) {
                    // empty catch block
                }
            }
            if (eTest != null) {
                nVersionIntroduced = eTest.getAttr().getVersionIntro();
                nAvailability = eTest.getAttr().getAvailability();
            }
        }
        if (!model.validateUsage(nVersionIntroduced, nAvailability, bReport)) {
            if (bReport) {
                MsgFormatPos reason = new MsgFormatPos(ResId.InvalidAttributeVersionException);
                reason.format(this.getAtom(eTag));
                reason.format(this.getClassAtom());
                ExFull ex = new ExFull(reason);
                if (model.validateUsageFailedIsFatal(nVersionIntroduced, nAvailability)) {
                    throw ex;
                }
                model.addErrorList(ex, 3, this);
            } else if (model.validateUsageFailedIsFatal(nVersionIntroduced, nAvailability)) {
                return false;
            }
            if (model.isLoading()) {
                return false;
            }
        }
        if (bReport && info.getVersionDeprecated() != 0) {
            int nTargetVer = model.getCurrentVersion();
            if (info.getVersionDeprecated() <= nTargetVer) {
                MsgFormatPos reason = new MsgFormatPos(ResId.DeprecatedAttributeException, this.getAtom(eTag));
                reason.format(this.getClassAtom());
                ExFull ex = new ExFull(reason);
                model.addXMLLoadErrorContext(this, ex);
            }
        }
        return true;
    }

    public boolean isValidChild(int eTag, int nError, boolean bBeforeInsert, boolean bOccurrenceErrorOnly) {
        ChildReln validChild;
        if (this.getElementClass() == XFA.INVALID_ELEMENT) {
            return true;
        }
        Model model = this.getModel();
        if (model == null) {
            assert (false);
            return false;
        }
        ChildRelnInfo info = this.getNodeSchema().getChildRelnInfo(eTag);
        if (info == null) {
            if (nError != 0 && !bOccurrenceErrorOnly) {
                MsgFormatPos message = new MsgFormatPos(nError, this.getClassAtom());
                String name = null;
                name = eTag == XFA.INVALID_ELEMENT ? this.getClassName() : this.getAtom(eTag);
                message.format(name);
                throw new ExFull(message);
            }
            return false;
        }
        if (!model.validateUsage(info.getVersionIntroduced(), info.getAvailability(), true)) {
            MsgFormatPos reason = new MsgFormatPos(ResId.InvalidChildVersionException, this.getAtom(eTag));
            reason.format(this.getClassAtom());
            if (model.validateUsageFailedIsFatal(info.getVersionIntroduced(), info.getAvailability()) || model.isLoading()) {
                if (nError != 0 && !bOccurrenceErrorOnly) {
                    MsgFormatPos message = new MsgFormatPos(nError, this.getClassAtom());
                    message.format(this.getAtom(eTag));
                    ExFull error = new ExFull(message);
                    error.insert(new ExFull(reason), true);
                    throw error;
                }
                return false;
            }
            model.addErrorList(new ExFull(reason), 3, this);
        }
        if (model.isLoading() && info.getVersionDeprecated() != 0) {
            int nTargetVer = model.getCurrentVersion();
            if (info.getVersionDeprecated() <= nTargetVer) {
                MsgFormatPos reason = new MsgFormatPos(ResId.DeprecatedChildException, this.getAtom(eTag));
                reason.format(this.getClassAtom());
                ExFull ex = new ExFull(reason);
                model.addXMLLoadErrorContext(this, ex);
            }
        }
        if ((validChild = info.getRelationship()).getOccurrence() == 1) {
            int index = 0;
            if (!bBeforeInsert) {
                ++index;
            }
            if (this.locateChildByClass(eTag, index) == null) {
                return true;
            }
            if (nError != 0) {
                MsgFormatPos e1 = new MsgFormatPos(nError, this.getClassAtom());
                e1.format(this.getAtom(eTag));
                ExFull error = new ExFull(e1);
                ExFull message2 = new ExFull(ResId.OccurrenceViolationException, this.getAtom(eTag));
                error.insert(message2, true);
                throw error;
            }
            return false;
        }
        if (this.getFirstXFAChild() != null && validChild.getOccurrence() == 4) {
            boolean bOneOfAllowed = !bBeforeInsert;
            for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                int childTag = child.getClassTag();
                if (childTag == XFA.INVALID_ELEMENT || this.getValidOccurrence(childTag) != 4) continue;
                if (bOneOfAllowed) {
                    bOneOfAllowed = false;
                    continue;
                }
                if (nError != 0) {
                    MsgFormatPos message = new MsgFormatPos(nError, this.getClassName());
                    message.format(this.getAtom(eTag));
                    ExFull error = new ExFull(message);
                    ExFull message2 = new ExFull(ResId.OccurrenceViolationException, XFA.getAtom(eTag));
                    error.insert(message2, true);
                    throw error;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isValidElement(int eTag, boolean bReport) {
        Model model = this.getModel();
        if (model == null) {
            assert (false);
            return false;
        }
        ChildRelnInfo info = this.getNodeSchema().getChildRelnInfo(eTag);
        if (info != null) {
            if (!model.validateUsage(info.getVersionIntroduced(), info.getAvailability(), bReport)) {
                if (bReport) {
                    MsgFormatPos reason = new MsgFormatPos(ResId.InvalidChildVersionException, this.getAtom(eTag));
                    reason.format(this.getClassAtom());
                    if (model.validateUsageFailedIsFatal(info.getVersionIntroduced(), info.getAvailability())) {
                        throw new ExFull(reason);
                    }
                    model.addErrorList(new ExFull(reason), 3, this);
                } else if (model.validateUsageFailedIsFatal(info.getVersionIntroduced(), info.getAvailability())) {
                    return false;
                }
            }
            if (bReport && info.getVersionDeprecated() != 0) {
                int nTargetVer = model.getCurrentVersion();
                if (info.getVersionDeprecated() <= nTargetVer) {
                    MsgFormatPos reason = new MsgFormatPos(ResId.DeprecatedChildException, this.getAtom(eTag));
                    reason.format(this.getClassAtom());
                    ExFull ex = new ExFull(reason);
                    model.addXMLLoadErrorContext(this, ex);
                }
            }
            return true;
        }
        if (this.getClassTag() == XFA.INVALID_ELEMENT) {
            return true;
        }
        if (this.isSameClass(XFA.XFATAG)) {
            return eTag == XFA.DSIGDATATAG || eTag == XFA.PACKETTAG;
        }
        return false;
    }

    public void loadXML(InputStream is, boolean bIgnoreAggregatingTag, boolean bReplaceContent) {
        this.loadXML(is, bIgnoreAggregatingTag, bReplaceContent ? ReplaceContent.AllContent : ReplaceContent.None);
    }

    public void loadXML(InputStream is, boolean bIgnoreAggregatingTag, ReplaceContent eReplaceContent) {
        Model model = this.getModel();
        assert (model != null);
        model.loadXMLImpl(this, is, bIgnoreAggregatingTag, eReplaceContent);
    }

    @Override
    public void makeDefault() {
        super.makeDefault();
        int n = this.getNumAttrs();
        for (int i = 0; i < n; ++i) {
            this.setAttrProp(i, 1, true);
        }
    }

    @Override
    public void makeNonDefault(boolean bRecursive) {
        super.makeNonDefault(bRecursive);
        if (this.getModel() != null && !this.getModel().isLoading()) {
            this.setDirty();
        }
        if (this.isFragment()) {
            this.isFragment(false, false);
            this.isTransient(false, false);
        }
    }

    @Override
    public void setDefaultFlag(boolean bDefaultNode, boolean bSetChildren) {
        if (this.isDefault(false) != bDefaultNode || bSetChildren) {
            super.setDefaultFlag(bDefaultNode, bSetChildren);
            int n = this.getNumAttrs();
            for (int i = 0; i < n; ++i) {
                this.setAttrProp(i, 1, false);
            }
        }
    }

    public Attribute newAttribute(int eTag, String value) {
        if (this.getClassTag() == XFA.INVALID_ELEMENT || this.isSameClass(XFA.DSIGDATATAG)) {
            return new StringAttr("", value);
        }
        return this.getModel().getSchema().newAttribute(eTag, value, this.getClassTag());
    }

    public final Attribute peekAttribute(int eAttributeTag) {
        return this.getAttribute(eAttributeTag, true, false);
    }

    public final Element peekElement(int eElementTag, boolean bReturnDefault, int nOccurrence) {
        return this.getElement(eElementTag, true, nOccurrence, bReturnDefault, false);
    }

    @Override
    public final Node peekOneOfChild(boolean bReturnDefault) {
        return this.getOneOfChild(true, bReturnDefault);
    }

    @Override
    public final Object peekProperty(int ePropTag, int nOccurrence) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Element#peekProperty(int, int)");
    }

    @Override
    public final Object peekProperty(String propertyName, int nOccurrence) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Element#peekProperty(String, int)");
    }

    @Override
    public void postSave() {
    }

    @Override
    public void preSave(boolean bSaveXMLScript) {
    }

    public final void removeAttr(int index) {
        assert (index >= 0 || index < this.getNumAttrs());
        Element e = this.getXmlPeerElement();
        Attribute attr = e.getAttr(index);
        if (this.getOwnerDocument() != null && this.getOwnerDocument().isId(this.getNSInternal(), this.getLocalName(), attr.getNS(), attr.getLocalName())) {
            this.getOwnerDocument().deindexNode(this, false);
        }
        if (attr.getLocalName() == "name") {
            this.maName = null;
        }
        if (index != e.nAttrs - 1) {
            System.arraycopy(e.mAttrs, index + 1, e.mAttrs, index, e.nAttrs - index - 1);
            System.arraycopy(e.mAttrProperties, index + 1, e.mAttrProperties, index, e.nAttrs - index - 1);
        }
        --e.nAttrs;
        e.mAttrs[e.nAttrs] = null;
        e.mAttrProperties[e.nAttrs] = 0;
        this.notifyPeers(1, attr.getLocalName(), this);
        this.setDirty();
    }

    public final void removeAttr(String URI2, String name) {
        int attr = this.findAttr(URI2, name);
        if (attr != -1) {
            this.removeAttr(attr);
        }
    }

    public final void removeChild(Node child) {
        if (child == null) {
            return;
        }
        Element parent = this.getXFAParent();
        this.setDirty();
        if (child instanceof Element && this.getOwnerDocument() != null) {
            this.getOwnerDocument().deindexSubtree((Element)child, false);
        }
        EventManager.resetEventTable(child.getEventTable(false));
        Node previous = null;
        Node next = null;
        Node iter = this.getFirstXMLChild();
        while (iter != null) {
            next = iter.getNextXMLSibling();
            if (next == child) {
                previous = iter;
                break;
            }
            iter = next;
        }
        if (previous == null && this.getFirstXMLChild() != child) {
            throw new ExFull(ResId.RemoveFailedException);
        }
        next = child.getNextXMLSibling();
        if (previous != null) {
            previous.setNextXMLSibling(next);
        } else {
            this.setFirstChild(next);
        }
        if (child instanceof DualDomNode) {
            Element parent2;
            DualDomNode dualDomChild = (DualDomNode)((Object)child);
            Node peer = dualDomChild.getXmlPeer();
            if (peer instanceof DataModel.AttributeWrapper) {
                DataModel.AttributeWrapper attr = (DataModel.AttributeWrapper)peer;
                Element elem = (Element)((DualDomNode)((Object)parent)).getXmlPeer();
                elem.removeAttr(attr.getNS(), attr.getLocalName());
            } else if (peer != null && (parent2 = peer.getXMLParent()) != null) {
                parent2.removeChild(peer);
            }
        }
        child.setNextXMLSibling(null);
        child.setXMLParent(null);
        this.setChildListModified(true);
    }

    public final void removePI(String aPiName) {
        assert (aPiName != null);
        Node node = this.getFirstXMLChild();
        while (node != null) {
            ProcessingInstruction pi;
            if (node instanceof ProcessingInstruction && (pi = (ProcessingInstruction)node).getName() == aPiName) {
                node = node.getNextXMLSibling();
                pi.getXMLParent().removeChild(pi);
                continue;
            }
            node = node.getNextXMLSibling();
        }
    }

    public final void removePI(String aPiName, String sPropName) {
        assert (aPiName != null);
        Node node = this.getFirstXMLChild();
        while (node != null) {
            String sNodeValue;
            String[] vals;
            ProcessingInstruction pi;
            if (node instanceof ProcessingInstruction && (pi = (ProcessingInstruction)node).getName() == aPiName && (vals = (sNodeValue = pi.getData()).split(" "))[0].equals(sPropName)) {
                node = node.getNextXMLSibling();
                pi.getXMLParent().removeChild(pi);
                continue;
            }
            node = node.getNextXMLSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeWhiteSpace() {
        boolean bSetLoading = this.getWillDirty();
        if (bSetLoading) {
            this.setWillDirty(false);
        }
        try {
            Node childNode = this.getFirstXMLChild();
            while (childNode != null) {
                Node nextSibling = childNode.getNextXMLSibling();
                if (childNode instanceof Chars && ((Chars)childNode).isXMLSpace()) {
                    this.removeChild(childNode);
                }
                childNode = nextSibling;
            }
        }
        finally {
            if (bSetLoading) {
                this.setWillDirty(true);
            }
        }
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        if (oldChild == null) {
            return null;
        }
        Node nextChild = oldChild.getNextXMLSibling();
        this.removeChild(oldChild);
        this.insertChild(newChild, nextChild, false);
        return oldChild;
    }

    public void resetPostLoadXML() {
    }

    protected void resolveAndEnumerateChildren(NodeList properties, NodeList children, boolean bAllProperties, boolean bFirstDefaultOnly) {
        SchemaPairs validChildren = this.getNodeSchema().getValidChildren();
        block0: for (int i = 0; validChildren != null && i < validChildren.size(); ++i) {
            int eTag = validChildren.key(i);
            ChildReln childR = (ChildReln)validChildren.value(i);
            int nMax = childR.getMax();
            if (nMax == -1 || childR.getOccurrence() == 4) continue;
            for (int nProtoIndex = 0; nProtoIndex < nMax; ++nProtoIndex) {
                Node child = eTag == XFA.TEXTNODETAG ? this.getText(true, false, false) : this.getElement(eTag, true, nProtoIndex, false, false);
                if (child == null && bAllProperties) {
                    if (bFirstDefaultOnly && nProtoIndex == 1) continue block0;
                    child = this.createDefaultElement(eTag, nProtoIndex);
                }
                if (child == null) continue block0;
                properties.append(child);
            }
        }
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int eType = this.getSchemaType(child.getClassTag());
            if (eType != 4) continue;
            children.append(child);
        }
    }

    protected NodeList enumerateChildren() {
        ListBase children = null;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int eType = this.getSchemaType(child.getClassTag());
            if (eType != 4) continue;
            if (children == null) {
                children = new ArrayNodeList();
            }
            children.append(child);
        }
        return children;
    }

    protected NodeList enumerateProperties() {
        ListBase properties = null;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int eType = this.getSchemaType(child.getClassTag());
            if (eType != 0 && eType != 2) continue;
            if (properties == null) {
                properties = new ArrayNodeList();
            }
            properties.append(child);
        }
        return properties;
    }

    public NodeList resolveAndEnumerateChildren(boolean bAllProperties, boolean bFirstDefaultOnly) {
        int eTag;
        ArrayNodeList list = new ArrayNodeList();
        Node oneOfChild = this.getOneOfChild(true, false);
        this.resolveAndEnumerateChildren(list, list, bAllProperties, bFirstDefaultOnly);
        if (oneOfChild != null) {
            ((ListBase)list).append(oneOfChild);
        } else if (bAllProperties && (eTag = this.getDefaultOneOfTag()) != XFA.SCHEMA_DEFAULTTAG) {
            Element defaultElement = this.getModel().createElement(eTag, null);
            ((ListBase)list).append(defaultElement);
        }
        return list;
    }

    public SOMParser.SomResultInfo resolveNodeCreate(String somNodesInput, int eAction, boolean bLeaf, boolean bDefault, boolean bNoProperties) {
        boolean bHasStar;
        String somNodes = somNodesInput.startsWith("!") ? "xfa.datasets." + somNodesInput.substring(1) : somNodesInput;
        ArrayList<SOMParser.SomResultInfo> result = new ArrayList<SOMParser.SomResultInfo>();
        SOMParser parser = new SOMParser(null);
        parser.setOptions(true, true, bNoProperties);
        parser.resolve(this, somNodes, null, result, null);
        for (int i = result.size(); i > 0; --i) {
            if (((SOMParser.SomResultInfo)result.get((int)(i - 1))).object instanceof Node) continue;
            result.remove(i - 1);
        }
        int nFoundAt = somNodes.indexOf(42);
        boolean bl = bHasStar = nFoundAt >= 0;
        if (bHasStar && result.size() == 1 && eAction == 1) {
            eAction = 2;
        }
        if (eAction == 2 || result.size() == 0 && eAction == 1) {
            String sNodesExist = null;
            Element parent = this;
            nFoundAt = 0;
            int nNextFoundAt = 0;
            if (somNodes.length() > 2 && somNodes.charAt(0) == '$' && somNodes.charAt(1) != '.') {
                String sShortCutName;
                nNextFoundAt = somNodes.indexOf(46, 1);
                if (nNextFoundAt < 0) {
                    nNextFoundAt = somNodes.length();
                }
                if ((parent = (Element)this.resolveNode(sShortCutName = somNodes.substring(0, nNextFoundAt), false, false, false)) == null) {
                    String sModelAlias = sShortCutName.substring(1);
                    AppModel appModel = this.getAppModel();
                    List<ModelFactory> factories = appModel.factories();
                    for (int i = 0; i < factories.size(); ++i) {
                        ModelFactory factory = factories.get(i);
                        if (!factory.rootName().equals(sModelAlias)) continue;
                        factory.createDOM((Element)appModel.getXmlPeer());
                        parent = (Element)this.resolveNode(sShortCutName, false, false, false);
                        assert (parent != null);
                        break;
                    }
                    if (parent == null) {
                        MsgFormatPos message = new MsgFormatPos(ResId.CantCreateSOMExpression);
                        message.format(somNodes);
                        throw new ExFull(message);
                    }
                }
                if (parent.getModel() != this.getModel()) {
                    return parent.resolveNodeCreate(somNodes, eAction, bLeaf, false, false);
                }
            }
            boolean bLookUp = true;
            while ((nNextFoundAt = SOMParser.findDot(somNodes, nFoundAt + 1)) > 0) {
                sNodesExist = somNodes.substring(0, nNextFoundAt);
                if (bHasStar && eAction == 2 && somNodes.indexOf(42, nNextFoundAt) < 0 && somNodes.indexOf(42, nFoundAt) >= 0) {
                    sNodesExist = somNodes.substring(0, nFoundAt);
                    break;
                }
                Element tmpNode = parent;
                parent = (Element)this.resolveNode(sNodesExist, true, true, false);
                if (parent == null) {
                    sNodesExist = somNodes.substring(0, nFoundAt);
                    parent = tmpNode;
                    break;
                }
                bLookUp = false;
                nFoundAt = nNextFoundAt;
            }
            int nStart = 0;
            if (sNodesExist != null && sNodesExist.length() > 0) {
                nStart = sNodesExist.length() + 1;
            }
            String sNodesCreate = somNodes.substring(nStart, somNodes.length());
            boolean bIsLeaf = false;
            while (sNodesCreate.length() > 0) {
                int eTag;
                int numToCreate;
                String aNewNode = null;
                nFoundAt = SOMParser.findDot(sNodesCreate, 0);
                if (nFoundAt > 0) {
                    aNewNode = sNodesCreate.substring(0, nFoundAt).intern();
                    sNodesCreate = sNodesCreate.substring(aNewNode.length() + 1, sNodesCreate.length());
                } else {
                    aNewNode = sNodesCreate.intern();
                    sNodesCreate = "";
                    if (bLeaf) {
                        bIsLeaf = true;
                    }
                }
                if (aNewNode == "$") continue;
                int absNumToCreate = 0;
                int nBraceStart = aNewNode.indexOf(91);
                if (nBraceStart >= 0) {
                    nFoundAt = aNewNode.indexOf(93);
                    if (nFoundAt >= 0) {
                        String sNum = aNewNode.substring(nBraceStart + 1, nFoundAt);
                        try {
                            absNumToCreate = Integer.parseInt(sNum);
                        }
                        catch (NumberFormatException e) {
                            nFoundAt = 0;
                        }
                    } else {
                        MsgFormatPos message = new MsgFormatPos(ResId.CantCreateSOMExpression);
                        message.format(somNodes);
                        throw new ExFull(message);
                    }
                    aNewNode = aNewNode.substring(0, nBraceStart).intern();
                }
                if (aNewNode.indexOf("\\.") != -1) {
                    aNewNode = SOMParser.unescapeSomName(aNewNode).intern();
                }
                while (bLookUp && parent != null && !parent.canCreateChild(bIsLeaf, aNewNode)) {
                    parent = parent.getXFAParent();
                }
                bLookUp = false;
                if (parent == null) {
                    MsgFormatPos message = new MsgFormatPos(ResId.CantCreateSOMExpression);
                    message.format(somNodes);
                    throw new ExFull(message);
                }
                boolean bFoundTransient = false;
                for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    Element element;
                    if (!(child instanceof Element) || (element = (Element)child).getName() != aNewNode) continue;
                    if (element.isDefault(false)) {
                        element.makeNonDefault(false);
                        parent = element;
                        bFoundTransient = true;
                        break;
                    }
                    if (absNumToCreate <= 0) continue;
                    --absNumToCreate;
                }
                if (bFoundTransient) continue;
                if (!parent.canCreateChild(bIsLeaf, aNewNode) && numToCreate == 1 && (eTag = XFA.getTag(aNewNode)) != XFA.INVALID_ELEMENT && parent.isValidAttr(eTag, false, null)) {
                    Arg initValue = new Arg();
                    return new SOMParser.SomResultInfo(parent, aNewNode, 0, initValue);
                }
                Element newNode = null;
                for (numToCreate = 1 + absNumToCreate; numToCreate > 0 && parent.canCreateChild(bIsLeaf, aNewNode); --numToCreate) {
                    newNode = (Element)parent.createChild(bIsLeaf, aNewNode);
                    if (newNode != null) continue;
                    MsgFormatPos message = new MsgFormatPos(ResId.CantCreateSOMExpression);
                    message.format(somNodes);
                    throw new ExFull(message);
                }
                parent = newNode;
            }
            return new SOMParser.SomResultInfo(parent);
        }
        if (result.size() != 1) {
            throw new ExFull(ResId.SOMTypeException);
        }
        return (SOMParser.SomResultInfo)result.get(0);
    }

    void restoreDelta(Element delta) {
        Element parent = this.getXFAParent();
        if (parent != null) {
            delta.remove();
            parent.insertChild(delta, this, false);
            delta.makeNonDefault(false);
            this.remove();
        }
    }

    public void saveXML(OutputStream outFile, DOMSaveOptions options) {
        this.saveXML(outFile, options, false);
    }

    public void saveXML(OutputStream outFile, DOMSaveOptions options, boolean bSaveXMLScript) {
        Document doc = this.getOwnerDocument();
        AppModel appModel = this.getAppModel();
        if (appModel != null) {
            appModel.preSaveXML();
        }
        this.preSave(bSaveXMLScript);
        if (options == null) {
            options = new DOMSaveOptions();
            options.setSaveTransient(true);
        }
        doc.saveAs(outFile, this, options);
    }

    public void saveFilteredXML(NodeList nodeList, OutputStream outFile, DOMSaveOptions options) {
        Element clonedRoot = this.filterClone(nodeList);
        if (clonedRoot != null) {
            clonedRoot.saveXML(outFile, options);
        }
    }

    private boolean isElementEmpty(DOMSaveOptions options) {
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (child instanceof Element) {
                if (!options.canBeSaved(((Element)child).isFragment(), child.isDefault(false), child.isTransient())) continue;
                return false;
            }
            if (child instanceof Chars) {
                Chars chars = (Chars)child;
                if (StringUtils.isEmpty(chars.getText()) || !options.canBeSaved(false, child.isDefault(false), child.isTransient())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void serialize(OutputStream outStream, DOMSaveOptions options, int level, Node prevSibling) throws IOException {
        if (!options.canBeSaved(this.isFragment(), this.isDefault(false), this.isTransient())) {
            return;
        }
        if (options.getIgnoreExtraRootData() && this.getAppModel().getDocument().isAllDataRootsEmpty() && this.getAppModel().getDocument().getAddedRootData() == this) {
            return;
        }
        int eDisplayFormat = options.getDisplayFormat();
        if (level != 0 || prevSibling != null) {
            if (options.getDisplayFormat() == 2) {
                if (prevSibling == null || !(prevSibling instanceof Chars) || ((Chars)prevSibling).isXMLSpace()) {
                    options.writeIndent(outStream, level);
                }
            } else if (level == 0 && (options.getFormatOutside() || options.getDisplayFormat() == 1)) {
                outStream.write(Document.MarkupReturn);
            }
        }
        outStream.write(Document.MarkupStartTag);
        String qName = this.getXMLName();
        String ns = this.getNSInternal();
        String prefix = this.getPrefix();
        outStream.write(qName.getBytes("UTF-8"));
        int nAttrs = this.getNumAttrs();
        for (int i = 0; i < nAttrs; ++i) {
            Attribute a = this.getAttr(i);
            if (a.isNameSpaceAttr() || a.getPrefix() == "") continue;
            Element.addNamespaceDef(outStream, options, this, a.getPrefix(), a.getNS());
        }
        this.saveAttributesToStream(outStream, options);
        Element.addNamespaceDef(outStream, options, this, prefix, ns);
        if (this.isElementEmpty(options)) {
            if (options.getDisplayFormat() == 1) {
                outStream.write(Document.MarkupReturn);
            }
            if (options.getExpandElement()) {
                outStream.write(Document.MarkupEndTag);
                outStream.write(Document.MarkupCloseTag);
                outStream.write(qName.getBytes("UTF-8"));
                if (options.getDisplayFormat() == 1) {
                    outStream.write(Document.MarkupReturn);
                }
                outStream.write(Document.MarkupEndTag);
            } else {
                outStream.write(Document.MarkupEndTag2);
            }
        } else {
            if (options.getDisplayFormat() == 1) {
                outStream.write(Document.MarkupReturn);
            }
            outStream.write(Document.MarkupEndTag);
            if (this.inhibitPrettyPrint() && options.getDisplayFormat() == 2) {
                options.setDisplayFormat(0);
            }
            Node prevChild = null;
            for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                child.serialize(outStream, options, level + 1, prevChild);
                prevChild = child;
            }
            if (options.getDisplayFormat() == 2 && (prevChild instanceof Element || prevChild instanceof Chars && prevChild.getPreviousXMLSibling() != null && ((Chars)prevChild).isXMLSpace()) && (prevSibling == null || !(prevSibling instanceof Chars) || ((Chars)prevSibling).isXMLSpace())) {
                options.writeIndent(outStream, level);
            }
            outStream.write(Document.MarkupCloseTag);
            outStream.write(qName.getBytes("UTF-8"));
            if (options.getDisplayFormat() == 1) {
                outStream.write(Document.MarkupReturn);
            }
            outStream.write(Document.MarkupEndTag);
            Element.removeNamespaceDef(this, prefix);
            for (int i = 0; i < nAttrs; ++i) {
                Attribute attr = this.getAttr(i);
                if (attr.isNameSpaceAttr() || attr.getPrefix() == "") continue;
                Element.removeNamespaceDef(this, attr.getPrefix());
            }
        }
        options.setDisplayFormat(eDisplayFormat);
    }

    private void saveAttributesToStream(OutputStream outStream, DOMSaveOptions options) throws IOException {
        int nAttrs = this.getNumAttrs();
        if (options.getCanonicalizeNamespaceOrder()) {
            int i;
            int nDefaultNamespaceIndex = -1;
            ArrayList<Integer> namespaceAttrIndexes = null;
            for (i = 0; i < nAttrs; ++i) {
                Attribute attr = this.getAttr(i);
                if (!attr.isNameSpaceAttr()) continue;
                if (attr.getQName() == "xmlns") {
                    nDefaultNamespaceIndex = i;
                    continue;
                }
                if (namespaceAttrIndexes == null) {
                    namespaceAttrIndexes = new ArrayList<Integer>(nAttrs);
                }
                namespaceAttrIndexes.add(i);
            }
            if (nDefaultNamespaceIndex >= 0) {
                this.saveAttributeToStream(nDefaultNamespaceIndex, outStream, options);
            }
            if (namespaceAttrIndexes != null) {
                Integer[] indexes = new Integer[namespaceAttrIndexes.size()];
                namespaceAttrIndexes.toArray(indexes);
                if (indexes.length > 1) {
                    Arrays.sort(indexes, new Comparator<Integer>(){

                        @Override
                        public int compare(Integer o1, Integer o2) {
                            return StringUtils.UCS_CODEPOINT_COMPARATOR.compare(Element.this.getAttrName(o1), Element.this.getAttrName(o2));
                        }
                    });
                }
                for (int i2 = 0; i2 < indexes.length; ++i2) {
                    this.saveAttributeToStream(indexes[i2], outStream, options);
                }
            }
            for (i = 0; i < nAttrs; ++i) {
                Attribute attr = this.getAttr(i);
                if (attr.isNameSpaceAttr()) continue;
                this.saveAttributeToStream(i, outStream, options);
            }
        } else {
            for (int i = 0; i < nAttrs; ++i) {
                this.saveAttributeToStream(i, outStream, options);
            }
        }
    }

    private void saveAttributeToStream(int attrIndex, OutputStream outStream, DOMSaveOptions options) throws IOException {
        Attribute a = this.getAttr(attrIndex);
        if (!options.canBeSaved(this.getAttrProp(attrIndex, 2), this.getAttrProp(attrIndex, 1), this.getAttrProp(attrIndex, 4))) {
            return;
        }
        if (!a.isNameSpaceAttr() || Element.displayNamespace(a, this, options, false)) {
            outStream.write(Document.MarkupSpace);
            outStream.write(a.getQName().getBytes("UTF-8"));
            outStream.write(Document.MarkupAttrMiddle);
            String aValue = StringUtils.toXML(a.getAttrValue(), true);
            if (aValue.length() > 0) {
                outStream.write(aValue.getBytes("UTF-8"));
            }
            outStream.write(Document.MarkupDQuoteString);
        }
    }

    public void setAttribute(Attribute attr, int eTag) {
        String aPropertyName = this.getAtom(eTag);
        if (eTag == XFA.IDTAG && this.isPropertySpecified(XFA.IDTAG, true, 0)) {
            throw new ExFull(new MsgFormat(ResId.ImmutableAttributeException, aPropertyName));
        }
        if (attr == null) {
            this.removeAttr(null, XFA.getString(eTag));
            this.makeNonDefault(false);
            this.setDirty();
            return;
        }
        if (!this.isValidAttr(eTag, true, null)) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(this.getClassAtom());
            message.format(aPropertyName);
            throw new ExFull(message);
        }
        Attribute defaultAttribute = this.defaultAttribute(eTag);
        Attribute newValue = attr;
        if (defaultAttribute.getClass() != attr.getClass() || defaultAttribute instanceof EnumValue && ((EnumValue)attr).getType() != ((EnumValue)defaultAttribute).getType()) {
            newValue = defaultAttribute.newAttribute(attr.getNS(), aPropertyName, aPropertyName, attr.toString());
        }
        if (eTag == XFA.NAMETAG) {
            this.maName = attr.toString();
        }
        String aAttrName = this.getAtom(eTag);
        if (newValue.getName() != aAttrName) {
            newValue = newValue.newAttribute(attr.getNS(), aPropertyName, aPropertyName, attr.toString());
        }
        newValue.normalize();
        this.updateAttribute(newValue);
        this.makeNonDefault(false);
        if (!this.isMute() && !this.getModel().isLoading()) {
            this.notifyPeers(1, aAttrName, newValue);
        }
        this.setDirty();
    }

    public final void setAttribute(int eVal, int eTag) {
        EnumAttr value = EnumAttr.getEnum(eVal);
        this.setAttribute(EnumValue.getEnum(eTag, value), eTag);
    }

    public final Attribute setAttribute(String nameSpace, String qName, String localName, String value) {
        return this.setAttribute(nameSpace, qName, localName, value, true);
    }

    public final Attribute setAttribute(String nameSpace, String qName, String localName, String value, boolean internSymbols) {
        Attribute a;
        if (internSymbols) {
            if (nameSpace != null) {
                nameSpace = nameSpace.intern();
            }
            if (qName != null) {
                qName = qName.intern();
            }
            if (localName != null) {
                localName = localName.intern();
            }
        }
        int n = this.findAttr(nameSpace, qName);
        Element e = this.getXmlPeerElement();
        if (n != -1) {
            Attribute existingAttribute = e.mAttrs[n];
            if (this.getOwnerDocument().isId(e.getNSInternal(), e.getLocalName(), existingAttribute.getNS(), existingAttribute.getLocalName())) {
                throw new ExFull(ResId.DOM_MODIFY_ID_ERR);
            }
            a = existingAttribute.newAttribute(nameSpace, localName, qName, value = this.internAttributeValue(existingAttribute, value), internSymbols);
            if (a.getLocalName() == "name") {
                this.maName = a.toString();
            }
            e.mAttrs[n] = a;
        } else {
            a = this.createAttribute(localName, nameSpace, qName, value, this.getNodeSchema());
            e.extendAttributes(a);
        }
        this.setDirty();
        return a;
    }

    public final void setAttrProp(int attrIndex, int eProp, boolean bValue) {
        Element e = this.getXmlPeerElement();
        int n = attrIndex;
        e.mAttrProperties[n] = (byte)(e.mAttrProperties[n] & ~eProp);
        if (bValue) {
            int n2 = attrIndex;
            e.mAttrProperties[n2] = (byte)(e.mAttrProperties[n2] | eProp);
        }
    }

    protected void setClass(Element parent, int eTag) {
    }

    public void setDOMProperties(String uri, String localName, String qName, Attributes attributes) {
        if (uri != null) {
            this.setNameSpaceURI(uri, false, false, false);
        }
        this.setLocalName(localName);
        this.setXMLName(qName);
        if (attributes != null) {
            this.assignAttrs(attributes);
        }
    }

    public Node setElement(Node child, int eTag, int nOccurrence) {
        ChildReln validChild;
        if (child != null) {
            eTag = child.getClassTag();
        }
        if ((validChild = this.getChildReln(eTag)) == null || validChild.getMax() == -1) {
            String aPropertyName = this.getAtom(eTag);
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(this.getClassAtom());
            message.format(aPropertyName);
            throw new ExFull(message);
        }
        if (validChild.getOccurrence() == 4) {
            String aPropertyName = this.getAtom(eTag);
            throw new ExFull(new MsgFormat(ResId.InvalidSetOneOfException, aPropertyName));
        }
        if (validChild.getMax() <= nOccurrence) {
            throw new ExFull(new IndexOutOfBoundsException(""));
        }
        if (child == null) {
            Element existingChild = this.getElementLocal(eTag, true, nOccurrence, false, false);
            if (existingChild != null) {
                existingChild.remove();
            }
            this.makeNonDefault(false);
            this.setDirty();
            return null;
        }
        Node oldChild = this.locateChildByClass(child.getClassTag(), nOccurrence);
        if (oldChild == child) {
            return null;
        }
        if (nOccurrence > 0 && oldChild == null) {
            this.getElement(child.getClassTag(), false, nOccurrence - 1, false, false);
        }
        boolean bCloned = false;
        if (child.getXFAParent() != null) {
            child = child.clone(this);
            bCloned = true;
        }
        if (oldChild == null) {
            if (!bCloned) {
                this.appendChild(child, false);
            }
        } else {
            this.insertChild(child, oldChild, false);
            oldChild.remove();
        }
        if (child instanceof Element) {
            ((Element)child).makeNonDefault(true);
        }
        this.makeNonDefault(false);
        this.setDirty();
        return child;
    }

    final void setFirstChild(Node child) {
        this.mFirstXMLChild = child;
    }

    final void setID(String sId) {
        this.setAttribute(new StringAttr("id", sId), XFA.IDTAG);
    }

    public final void setIsIndexed(boolean bIsIndexed) {
        this.mbIsIndexed = bIsIndexed;
    }

    public final void setLineNumber(int nLineNumber) {
        this.mnLineNumber = nLineNumber;
    }

    public void setLocalName(String name) {
        if (this.mLocalName != name) {
            String string = this.mLocalName = name != null ? name.intern() : null;
            if (this instanceof DualDomNode) {
                ((Element)((DualDomNode)((Object)this)).getXmlPeer()).mLocalName = this.mLocalName;
            }
        }
        this.setDirty();
    }

    public final void setModel(Model model) {
        this.mModel = model;
    }

    @Override
    public void setName(String name) {
        this.setAttribute(new StringAttr("name", name), XFA.NAMETAG);
    }

    protected final void setNameSpaceURI(String uri, boolean bBypassPrefixChecks, boolean bApplyToChildren, boolean bRemovePrefix) {
        boolean bScrubPrefix = bRemovePrefix;
        this.mURI = uri;
        if (this instanceof Model) {
            ((Element)((Model)this).getXmlPeer()).mURI = this.mURI;
        }
        if (!bBypassPrefixChecks) {
            Attribute poDefaultNSAttr;
            Attribute poNSAttr;
            int index;
            String aPrefix = this.getPrefix();
            String aNameAtom = "xmlns";
            if (aPrefix != "") {
                int nAttrs = this.getNumAttrs();
                for (int i = 0; i < nAttrs; ++i) {
                    Attribute poAttr = this.getAttr(i);
                    if (poAttr.isNameSpaceAttr() || poAttr.getPrefix() != aPrefix) continue;
                    this.getXmlPeerElement().mAttrs[i] = poAttr.newAttribute(this.mURI, poAttr.getLocalName(), poAttr.getQName(), poAttr.getAttrValue(), false);
                }
                aNameAtom = aPrefix;
            }
            if ((index = this.findAttr(null, aNameAtom)) != -1 && (poNSAttr = this.getAttr(index)).isNameSpaceAttr()) {
                if (bScrubPrefix) {
                    this.removeAttr(index);
                } else {
                    this.setAttribute(poNSAttr.getNS(), poNSAttr.getQName(), poNSAttr.getLocalName(), this.mURI, false);
                }
            }
            if (bScrubPrefix && aNameAtom != "xmlns" && (index = this.findAttr(null, "xmlns")) != -1 && (poDefaultNSAttr = this.getAttr(index)).isNameSpaceAttr()) {
                this.removeAttr(index);
            }
            if (bScrubPrefix) {
                this.mQName = this.mLocalName;
                if (this instanceof Model) {
                    ((Element)((Model)this).getXmlPeer()).mQName = this.mQName;
                }
            }
            if (bApplyToChildren) {
                for (Node poChild = this.getFirstXFAChild(); poChild != null; poChild = poChild.getNextXFASibling()) {
                    if (!(poChild instanceof Element)) continue;
                    ((Element)poChild).setNameSpaceURI(this.mURI, bBypassPrefixChecks, bApplyToChildren, bRemovePrefix);
                }
            }
        }
        this.setDirty();
    }

    public final void setNS(String sNS) {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Element)) continue;
            Element e = (Element)child;
            e.setNS(sNS);
            if (e.mURI != null) continue;
            e.mURI = sNS;
        }
        if (this.mURI == null) {
            this.mURI = sNS;
        }
    }

    final void setNS(Model model) {
        String sNS = null;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Element)) continue;
            Element e = (Element)child;
            if (sNS == null) {
                sNS = model.getNS();
            }
            e.setNS(sNS);
            if (e.mURI != null) continue;
            e.mURI = sNS;
        }
        if (this.mURI == null) {
            if (sNS == null) {
                sNS = model.getNS();
            }
            this.mURI = sNS;
        }
    }

    final void setNSPrefix(String aPrefix, String aNS) {
        if (aPrefix != "" && aNS != "") {
            String sAttr = "xmlns:" + aPrefix;
            this.setAttribute("", sAttr, aPrefix, aNS);
        }
    }

    public Node setOneOfChild(Node child) {
        ChildReln validChild;
        if (child != null && ((validChild = this.getChildReln(child.getClassTag())) == null || validChild.getOccurrence() != 4)) {
            throw new ExFull(new MsgFormat(ResId.InvalidSetOneOfException, child.getClassAtom()));
        }
        Node otherChild = this.getFirstXFAChild();
        while (otherChild != null) {
            Node nextSibling = otherChild.getNextXFASibling();
            if (otherChild == child) {
                child = null;
            } else {
                ChildReln childReln = this.getChildReln(otherChild.getClassTag());
                if (childReln.getOccurrence() == 4) {
                    otherChild.remove();
                    break;
                }
            }
            otherChild = nextSibling;
        }
        if (child != null) {
            if (child.getXFAParent() != null) {
                child = child.clone(this);
            } else {
                this.appendChild(child);
            }
        }
        this.makeNonDefault(false);
        return child;
    }

    public final void setProperty(Object property, int ePropertyTag) {
        boolean bElement = false;
        if (property == null) {
            if (this.isValidAttr(ePropertyTag, false, null)) {
                bElement = false;
            } else if (this.isValidElement(ePropertyTag, false)) {
                bElement = true;
            }
        } else if (property instanceof Element) {
            bElement = true;
        } else if (property instanceof Attribute) {
            bElement = false;
        } else {
            return;
        }
        if (bElement) {
            Element node = (Element)property;
            this.setElement(node, ePropertyTag, 0);
        } else {
            Attribute attr = (Attribute)property;
            this.setAttribute(attr, ePropertyTag);
        }
    }

    public final void setProperty(Object property, String propertyName) {
        String aPropertyName = propertyName.intern();
        int eTag = XFA.getTag(aPropertyName);
        if (eTag == XFA.INVALID_ELEMENT) {
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(this.getClassName());
            message.format(propertyName);
            throw new ExFull(message);
        }
        this.setProperty(property, eTag);
    }

    public final void setQName(String name) {
        if (this.mQName != name) {
            String string = this.mQName = name != null ? name.intern() : null;
            if (this instanceof DualDomNode) {
                ((Element)((DualDomNode)((Object)this)).getXmlPeer()).mQName = this.mQName;
            }
        }
        this.setDirty();
    }

    public void setSaveXMLSaveTransient(boolean bSaveTransient) {
        this.mbSaveXMLSaveTransient = bSaveTransient;
    }

    public final void setTransparent(boolean isTransparent) {
        this.mbTransparent = isTransparent;
    }

    protected final void updateAttribute(Attribute newValue) {
        int index = this.findAttr(null, newValue.getLocalName());
        if (newValue.getLocalName() == "rid") {
            newValue = newValue.newAttribute("urn:oasis:names:tc:xliff:document:1.1", "rid", "xliff:rid", newValue.getAttrValue());
        }
        Element e = this.getXmlPeerElement();
        if (index != -1) {
            if (this.getOwnerDocument() != null && this.getOwnerDocument().isId(e.getNSInternal(), e.getLocalName(), newValue.getNS(), newValue.getLocalName())) {
                throw new ExFull(ResId.DOM_MODIFY_ID_ERR);
            }
            e.mAttrs[index] = newValue;
        } else {
            e.extendAttributes(newValue);
        }
    }

    protected final void updateAttributeInternal(Attribute newValue) {
        int index = this.findAttr(null, newValue.getLocalName());
        this.getXmlPeerElement().mAttrs[index] = newValue;
    }

    @Override
    public void updateFromPeer(Object peer, int eventType, String arg1, Object arg2) {
        if (eventType != 3) {
            this.makeNonDefault(false);
        }
        super.updateFromPeer(peer, eventType, arg1, arg2);
    }

    private Element filterClone(NodeList keepNodes) {
        ArrayNodeList ancestors = new ArrayNodeList();
        ((ListBase)ancestors).append(this);
        int nKeepNodes = keepNodes.length();
        for (int i = 0; i < nKeepNodes; ++i) {
            for (Element keepNodesParent = ((Node)keepNodes.item(i)).getXFAParent(); keepNodesParent != null; keepNodesParent = keepNodesParent.getXFAParent()) {
                boolean found = false;
                int nAncestors = ((ListBase)ancestors).length();
                for (int j = 0; j < nAncestors; ++j) {
                    Obj ancestor = ((ListBase)ancestors).item(j);
                    if (keepNodesParent != ancestor) continue;
                    found = true;
                }
                if (found) continue;
                ((ListBase)ancestors).append(keepNodesParent);
            }
        }
        NodeList leaf = (NodeList)keepNodes.clone();
        return this.cloneHelper(null, true, ancestors, leaf);
    }

    private final void updateModelAndDocument(Node newChild) {
        if (newChild instanceof Element) {
            Element e = (Element)newChild;
            e.setModel(this.getModel());
            e.setDocument(this.getOwnerDocument());
            for (Node child = e.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                this.updateModelAndDocument(child);
            }
        }
    }

    @Override
    final boolean useNameInSOM() {
        int eType;
        Element oParent = this.getXFAParent();
        if (oParent != null && ((eType = oParent.getSchemaType(this.getClassTag())) == 0 || eType == 2 || eType == 3)) {
            return false;
        }
        return this.getName() != "";
    }

    public boolean processTextChildrenDuringParse() {
        return this.getClassTag() != XFA.INVALID_ELEMENT;
    }

    private boolean pruneNameSpaceDefn(Element element, String sNSAlias, String sNS) {
        int len = element.getNumAttrs();
        int nAttrToRemove = -1;
        for (int i = 0; i < len; ++i) {
            Attribute attr = element.getAttr(i);
            if (attr.getNS() != null && attr.getNS().equals(sNS)) {
                return true;
            }
            if (!attr.getQName().equals(sNSAlias)) continue;
            nAttrToRemove = i;
        }
        for (Node child = element.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element) || !this.pruneNameSpaceDefn((Element)child, sNSAlias, sNS)) continue;
            return true;
        }
        if (nAttrToRemove > -1) {
            element.removeAttr(nAttrToRemove);
        }
        return false;
    }

    @Override
    protected boolean compareVersions(Node rollbackElement, Node container, Node.ChangeLogger changeLogger, Object userData) {
        int eType;
        Node child;
        boolean bMatches = true;
        if (this.getClassTag() != rollbackElement.getClassTag()) {
            if (changeLogger != null) {
                if (this.isContainer()) {
                    changeLogger.logChildChange(container, this, userData);
                } else {
                    changeLogger.logPropChange(container, Element.getPropName(this.getXFAParent(), XFA.INVALID_ELEMENT), Element.getNodeAsXML(this), userData);
                }
            }
            return false;
        }
        assert (rollbackElement instanceof Element);
        Element rollback = (Element)rollbackElement;
        Node containerNode = this.isContainer() ? this : container;
        SchemaPairs attrs = this.getNodeSchema().getValidAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                int eTag = attrs.key(i);
                if (this.compareVersionsAttrHelper(rollback, eTag)) continue;
                bMatches = false;
                if (changeLogger == null) continue;
                changeLogger.logPropChange(containerNode, Element.getPropName(this, eTag), this.getAttribute(eTag).getAttrValue(), userData);
            }
        }
        if (!bMatches && changeLogger == null) {
            return false;
        }
        SchemaPairs children = this.getNodeSchema().getValidChildren();
        boolean bSchemaDefinesValidOneOf = false;
        if (children != null) {
            int nChildren = children.size();
            for (int i = 0; i < nChildren; ++i) {
                int eTag = children.key(i);
                ChildReln childR = (ChildReln)children.value(i);
                if (childR.getOccurrence() == 4) {
                    bSchemaDefinesValidOneOf = true;
                    continue;
                }
                if (childR.getMax() == -1) continue;
                long nMax = childR.getMax();
                for (int nOccurrenceIndex = 0; nOccurrenceIndex < (int)nMax; ++nOccurrenceIndex) {
                    Node thisChild = this.getNode(eTag, nOccurrenceIndex);
                    Node rollbackChild = rollback.getNode(eTag, nOccurrenceIndex);
                    if (thisChild == null && rollbackChild == null) break;
                    if (thisChild == null) {
                        thisChild = this.defaultElement(eTag, nOccurrenceIndex);
                    }
                    if (rollbackChild == null) {
                        rollbackChild = rollback.defaultElement(eTag, nOccurrenceIndex);
                    }
                    if (thisChild == null || rollbackChild == null) {
                        bMatches = false;
                        if (changeLogger == null) break;
                        if (thisChild == null) {
                            changeLogger.logPropChange(containerNode, Element.getPropName((Element)rollbackChild, XFA.INVALID_ELEMENT), "", userData);
                            break;
                        }
                        changeLogger.logPropChange(containerNode, Element.getPropName(this, XFA.INVALID_ELEMENT), Element.getNodeAsXML(thisChild), userData);
                        break;
                    }
                    bMatches &= thisChild.compareVersions(rollbackChild, containerNode, changeLogger, userData);
                }
                if (bMatches || changeLogger != null) continue;
                return false;
            }
        }
        if (bSchemaDefinesValidOneOf) {
            Node rollbackOneOf;
            Node sourceOneOf = this.getOneOfChild(false, true);
            if (sourceOneOf == null != ((rollbackOneOf = rollback.getOneOfChild(false, true)) == null)) {
                bMatches = false;
                if (changeLogger != null) {
                    if (sourceOneOf == null) {
                        changeLogger.logPropChange(containerNode, Element.getPropName((Element)rollbackOneOf, XFA.INVALID_ELEMENT), "", userData);
                    } else {
                        changeLogger.logPropChange(containerNode, Element.getPropName(this, XFA.INVALID_ELEMENT), Element.getNodeAsXML(sourceOneOf), userData);
                    }
                }
            } else if (sourceOneOf != null) {
                bMatches &= sourceOneOf.compareVersions(rollbackOneOf, containerNode, changeLogger, userData);
            }
            if (!bMatches && changeLogger == null) {
                return false;
            }
        }
        ArrayNodeList sourceChildList = new ArrayNodeList();
        ArrayNodeList rollbackChildList = new ArrayNodeList();
        boolean bFoundSourceOneOf = false;
        boolean bFoundRollbackOneOf = false;
        for (child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            eType = this.getSchemaType(child.getClassTag());
            if (eType == 4) {
                ((ListBase)sourceChildList).append(child);
                continue;
            }
            if (eType == 3) {
                if (!bFoundSourceOneOf) {
                    bFoundSourceOneOf = true;
                    continue;
                }
                ((ListBase)sourceChildList).append(child);
                continue;
            }
            if (eType != 5) continue;
            ((ListBase)sourceChildList).append(child);
        }
        for (child = rollback.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            eType = this.getSchemaType(child.getClassTag());
            if (eType == 4) {
                ((ListBase)rollbackChildList).append(child);
                continue;
            }
            if (eType == 3) {
                if (!bFoundRollbackOneOf) {
                    bFoundRollbackOneOf = true;
                    continue;
                }
                ((ListBase)rollbackChildList).append(child);
                continue;
            }
            if (eType != 5) continue;
            ((ListBase)rollbackChildList).append(child);
        }
        bMatches &= this.compareVersionsListHelper(sourceChildList, rollbackChildList, containerNode, changeLogger, userData);
        ArrayList<String> sourcePIs = new ArrayList<String>();
        ArrayList<String> rollbackPIs = new ArrayList<String>();
        this.getPI(sourcePIs, true);
        rollback.getPI(rollbackPIs, true);
        return bMatches &= this.compareVersionsPIHelper(sourcePIs, rollbackPIs, containerNode, changeLogger, userData);
    }

    protected boolean compareVersionsCanonically(Node rollbackElement, Node container, Node.ChangeLogger changeLogger, Object userData) {
        String sCanonicalSource = "";
        String sCanonicalRollback = "";
        Canonicalize c = new Canonicalize(this, false, true);
        byte[] buffer = c.canonicalize(4, null);
        try {
            sCanonicalSource = new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        Canonicalize cRollBack = new Canonicalize(rollbackElement, false, true);
        buffer = cRollBack.canonicalize(4, null);
        try {
            sCanonicalRollback = new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (!sCanonicalSource.equals(sCanonicalRollback)) {
            if (changeLogger != null) {
                String sPropName = this.getModel().getSchema().getAtom(XFA.XMLMULTISELECTNODETAG);
                changeLogger.logPropChange(container, sPropName, sCanonicalSource, userData);
            }
            return false;
        }
        return true;
    }

    protected boolean compareVersionsAttrHelper(Element oRollback, int eTag) {
        if (eTag == XFA.USETAG || eTag == XFA.USEHREFTAG) {
            return true;
        }
        if (eTag == XFA.CHECKSUMTAG) {
            return true;
        }
        return this.compareVersionsAttr(oRollback, eTag);
    }

    public boolean compareVersionsAttr(Element oRollback, int eTag) {
        String aAttrName = this.getAtom(eTag);
        Attribute sourceAttr = this.getAttributeByName(aAttrName, true);
        Attribute rollbackAttr = oRollback.getAttributeByName(aAttrName, true);
        if (sourceAttr == null && rollbackAttr == null) {
            return true;
        }
        String sSourceValue = sourceAttr != null ? sourceAttr.getAttrValue() : this.getAttribute(eTag, false, false).getAttrValue();
        String sRollbackValue = rollbackAttr != null ? rollbackAttr.getAttrValue() : oRollback.getAttribute(eTag, false, false).getAttrValue();
        return sSourceValue.equals(sRollbackValue);
    }

    private boolean compareVersionsListHelper(NodeList sourceList, NodeList rollbackList, Node container, Node.ChangeLogger changeLogger, Object userData) {
        boolean bMatches = true;
        int nSourceChildren = sourceList.length();
        int nRollbackChildren = rollbackList.length();
        for (int i = 0; i < nSourceChildren || i < nRollbackChildren; ++i) {
            if (i >= nSourceChildren) {
                bMatches = false;
                if (changeLogger != null) {
                    changeLogger.logChildChange(container, (Node)rollbackList.item(i), userData);
                }
            } else if (i >= nRollbackChildren) {
                bMatches = false;
                if (changeLogger != null) {
                    changeLogger.logChildChange(container, (Node)sourceList.item(i), userData);
                }
            } else {
                Node sourceChild = (Node)sourceList.item(i);
                Node rollbackChild = (Node)rollbackList.item(i);
                bMatches &= sourceChild.compareVersions(rollbackChild, container, changeLogger, userData);
            }
            if (bMatches || changeLogger != null) continue;
            return false;
        }
        return bMatches;
    }

    private boolean compareVersionsPIHelper(List<String> sourcePIs, List<String> rollbackPIs, Node container, Node.ChangeLogger changeLogger, Object userData) {
        boolean bMatches = true;
        int nSourcePIs = sourcePIs.size();
        int nRollbackPIs = rollbackPIs.size();
        for (int i = 0; i < nSourcePIs || i < nRollbackPIs; ++i) {
            if (i >= nSourcePIs) {
                bMatches = false;
                if (changeLogger != null) {
                    changeLogger.logPropChange(container, this.getPIName(this, rollbackPIs.get(i)), "", userData);
                }
            } else if (i >= nRollbackPIs) {
                bMatches = false;
                if (changeLogger != null) {
                    changeLogger.logPropChange(container, this.getPIName(this, sourcePIs.get(i)), Element.getPIAsXML(sourcePIs.get(i)), userData);
                }
            } else if (!sourcePIs.get(i).equals(rollbackPIs.get(i))) {
                bMatches = false;
                if (changeLogger != null) {
                    changeLogger.logPropChange(container, this.getPIName(this, sourcePIs.get(i)), Element.getPIAsXML(sourcePIs.get(i)), userData);
                }
            }
            if (bMatches || changeLogger != null) continue;
            return false;
        }
        return bMatches;
    }

    public void connectPeerToDocument() {
        DualDomNode dualDomNode = (DualDomNode)((Object)this);
        assert (dualDomNode.getXmlPeer() != null);
        this.connectPeerToParent();
        Element parent = this.getXFAParent();
        Node peer = parent != null ? ((DualDomNode)((Object)parent)).getXmlPeer() : dualDomNode.getXmlPeer();
        Document doc = peer.getOwnerDocument();
        Element oldRoot = doc.getDocumentElement();
        if (oldRoot != null) {
            doc.removeChild(oldRoot);
        }
        doc.appendChild(peer);
    }

    protected void connectPeerToParent() {
        assert (this instanceof DualDomNode);
        Element domPeer = (Element)((DualDomNode)((Object)this)).getXmlPeer();
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof DualDomNode)) continue;
            assert (child instanceof Element);
            Node domChild = ((DualDomNode)((Object)child)).getXmlPeer();
            Element domParent = domChild.getXMLParent();
            if (domParent == null) {
                ((Element)child).connectPeerToParent();
                continue;
            }
            if (domParent == domPeer) continue;
            domPeer.appendChild(domChild);
        }
        Element parent = this.getXFAParent();
        if (parent != null) {
            assert (!(domPeer instanceof DataModel.AttributeWrapper));
            Element destination = (Element)((DualDomNode)((Object)parent)).getXmlPeer();
            if (destination != domPeer.getXMLParent()) {
                destination.appendChild(domPeer);
            }
        }
    }

    public final void setIsDataWindowRoot(boolean bIsRoot) {
        this.mbIsDataWindowRoot = bIsRoot;
    }

    public Key constructKey(List<String> nodeAddressList, Node namespaceContextNode) {
        ArrayList<Key> keyList = new ArrayList<Key>();
        this.constructKeys(nodeAddressList, namespaceContextNode, keyList);
        if (keyList.size() > 0) {
            return (Key)keyList.get(0);
        }
        return new Key();
    }

    public void constructKeys(List<String> nodeAddressList, Node namespaceContextNode, List<Key> keys) {
        XPath evaluator = Element.getXPathFactory().newXPath();
        org.w3c.dom.Node contextNode = DOM.attach(this);
        if (namespaceContextNode != null) {
            evaluator.setNamespaceContext(new NamespaceContextImpl(DOM.attach(namespaceContextNode)));
        }
        for (int i = 0; i < nodeAddressList.size(); ++i) {
            int j;
            org.w3c.dom.NodeList nodeList;
            try {
                nodeList = (org.w3c.dom.NodeList)evaluator.evaluate(nodeAddressList.get(i), contextNode, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                throw new ExFull(ResId.XPATH_ERROR, ex.getMessage());
            }
            if (i == 0) {
                for (j = 0; j < nodeList.getLength(); ++j) {
                    keys.add(new Key(nodeAddressList.size()));
                }
            } else if (nodeList.getLength() < keys.size()) {
                Element.trimToSize(keys, nodeList.getLength());
            }
            for (j = 0; j < nodeList.getLength() && j < keys.size(); ++j) {
                org.w3c.dom.Node node = nodeList.item(j);
                if (node instanceof Attr) {
                    keys.get(j).appendValue(node.getNodeValue());
                    continue;
                }
                if (node instanceof org.w3c.dom.Element) {
                    org.w3c.dom.Node text = node.getFirstChild();
                    if (text == null) {
                        Element.trimToSize(keys, j);
                        continue;
                    }
                    keys.get(j).appendValue(text.getNodeValue());
                    continue;
                }
                Element.trimToSize(keys, j);
            }
        }
    }

    private static <T> void trimToSize(List<T> list, int length) {
        while (list.size() > length) {
            list.remove(list.size() - 1);
        }
    }

    public static void explodeQName(String aQName, StringHolder aPrefix, StringHolder aLocalName) {
        int nOffset = aQName.indexOf(58);
        if (nOffset > -1) {
            aPrefix.value = aQName.substring(0, nOffset).intern();
            aLocalName.value = aQName.substring(nOffset + 1).intern();
        } else {
            aPrefix.value = "";
            aLocalName.value = aQName;
        }
    }

    public String resolvePrefix(String aPrefix) {
        int nSize = this.getNumAttrs();
        for (int nIndex = 0; nIndex < nSize; ++nIndex) {
            Attribute attr = this.getAttr(nIndex);
            if (!attr.isNameSpaceAttr() || aPrefix != attr.getLocalName()) continue;
            return attr.getAttrValue();
        }
        if (this.getXFAParent() == null) {
            return "";
        }
        return this.getXFAParent().resolvePrefix(aPrefix);
    }

    private static class ElementScriptDynamicPropObj
    extends ScriptDynamicPropObj {
        private final String msGetFunc;
        private final String msSetFunc;

        ElementScriptDynamicPropObj(String sGetFunc, String sSetFunc, int nXFAVersion, int nAvailability) {
            super(nXFAVersion, nAvailability);
            this.msGetFunc = sGetFunc;
            this.msSetFunc = sSetFunc;
        }

        @Override
        public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
            if (this.msGetFunc == "locateOneOf") {
                return ElementScript.locateOneOf(scriptThis, retValue, sPropertyName);
            }
            if (this.msGetFunc == "locatePropPeek") {
                return ElementScript.locatePropPeek(scriptThis, retValue, sPropertyName);
            }
            if (this.msGetFunc == "locateProp") {
                return ElementScript.locateProp(scriptThis, retValue, sPropertyName);
            }
            assert (false);
            return false;
        }

        @Override
        public boolean invokeSetProp(Obj scriptThis, Arg propertyValue, String sPropertyName) {
            if (this.msSetFunc == "setProp") {
                return ElementScript.setProp(scriptThis, propertyValue, sPropertyName);
            }
            assert (false);
            return false;
        }

        @Override
        public boolean hasSetter() {
            return this.msSetFunc != null;
        }
    }

    public static enum ReplaceContent {
        None,
        XFAContent,
        AllContent;

    }

    public static interface DualDomNode {
        public Node getXmlPeer();

        public void setXmlPeer(Node var1);
    }
}

