/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFWindowsLaunchParameters;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFUtils;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFWindowsLaunchParameters
extends XPDFCosObject {
    private PDFWindowsLaunchParameters pdfWindowsLaunchParameters;

    public XPDFWindowsLaunchParameters(PDFWindowsLaunchParameters pdfWindowsLaunchParameters) {
        this.pdfWindowsLaunchParameters = pdfWindowsLaunchParameters;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String[] x;
        AttributesImpl att = new AttributesImpl();
        if (this.pdfWindowsLaunchParameters.hasName()) {
            x = XPDFUtils.asStringToXPDF(this.pdfWindowsLaunchParameters.getName());
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Name_enc", "Name_enc", "CDATA", x[1]);
            }
        } else {
            throw new PDFInvalidDocumentException("Missing /F key in a Windows Launch Parameters dictionary");
        }
        att.addAttribute("", "Name", "Name", "CDATA", x[0]);
        if (this.pdfWindowsLaunchParameters.hasDir()) {
            x = XPDFUtils.asStringToXPDF(this.pdfWindowsLaunchParameters.getDir());
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Dir_enc", "Dir_enc", "CDATA", x[1]);
            }
            att.addAttribute("", "Dir", "Dir", "CDATA", x[0]);
        }
        if (this.pdfWindowsLaunchParameters.hasAction()) {
            x = XPDFUtils.asStringToXPDF(this.pdfWindowsLaunchParameters.getAction());
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Action_enc", "Action_enc", "CDATA", x[1]);
            }
            att.addAttribute("", "Action", "Action", "CDATA", x[0]);
        }
        if (this.pdfWindowsLaunchParameters.hasParams()) {
            x = XPDFUtils.asStringToXPDF(this.pdfWindowsLaunchParameters.getName());
            if (!"ASCII".equals(x[1]) && !"PDFDocEncoding".equals(x[1])) {
                att.addAttribute("", "Params_enc", "Params_enc", "CDATA", x[1]);
            }
            att.addAttribute("", "Params", "Params", "CDATA", x[0]);
        }
        ch.element(parentName, att);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String params;
        String action;
        String dir;
        String name = att.getValue("Name");
        if (name != null) {
            this.pdfWindowsLaunchParameters.setName(XPDFUtils.asStringFromXPDF(name, att.getValue("Name_enc"), eh));
        }
        if ((dir = att.getValue("Dir")) != null) {
            this.pdfWindowsLaunchParameters.setDir(XPDFUtils.asStringFromXPDF(dir, att.getValue("Dir_enc"), eh));
        }
        if ((action = att.getValue("Action")) != null) {
            this.pdfWindowsLaunchParameters.setAction(XPDFUtils.asStringFromXPDF(action, att.getValue("Action_enc"), eh));
        }
        if ((params = att.getValue("Params")) != null) {
            this.pdfWindowsLaunchParameters.setParams(XPDFUtils.asStringFromXPDF(params, att.getValue("Params_enc"), eh));
        }
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfWindowsLaunchParameters.hasName()) {
            eh.XPDFError("Missing 'Name' attribute.");
        }
    }
}

