/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.MetadataOptions;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.util.UUID;
import com.adobe.internal.xmp.XMPConst;
import com.adobe.internal.xmp.XMPDateTime;
import com.adobe.internal.xmp.XMPDateTimeFactory;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPIterator;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPUtils;
import com.adobe.internal.xmp.options.IteratorOptions;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import com.adobe.internal.xmp.properties.XMPProperty;
import com.adobe.internal.xmp.properties.XMPPropertyInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

class DocumentMetadataImpl
implements XMPConst,
DocumentMetadata,
DocumentListener {
    private static final String NS_DC_SUBJECT = "subject";
    private static final String NS_DC_CREATOR = "creator";
    private static final String NS_DC_DESCRIPTION = "description";
    private static final String NS_DC_TITLE = "title";
    private static final String NS_DC_FORMAT = "format";
    private static final String NS_PDF_KEYWORDS = "Keywords";
    private static final String NS_PDF_AUTHOR = "Author";
    private static final String NS_PDF_PRODUCER = "Producer";
    private static final String NS_PDF_CREATOR = "Creator";
    private static final String NS_PDF_CREATION_DATE = "CreationDate";
    private static final String NS_PDF_MOD_DATE = "ModDate";
    private static final String NS_XMP_METADATA_DATE = "MetadataDate";
    private static final String NS_PDF_TRAPPED = "Trapped";
    private static final String XMP_NS_XMP_MM_DOCUMENTID = "DocumentID";
    private static final String XMP_NS_XMP_MM_INSTANCEID = "InstanceID";
    private static final long XMP_PADDING = 2048L;
    private XMPMeta xmpMeta;
    private PDFDocument pdfDocument;
    private XMPService.XMPServiceListener xmpService;
    private boolean xmpWasValid;
    private DocumentMetadata.SynchronizationSource initialSynchOption;
    private DocumentMetadata.DocInfoConformanceState initialDocInfoMatchState;
    MetadataOptions options;
    static final Object LISTENER_KEY = DocumentMetadataImpl.class;
    private DocumentListenerProperties listenerProperties;
    private boolean dirty;
    private long originalXMPSize;
    private boolean internalXMPDirty;
    private boolean docInfoDirty;

    DocumentMetadataImpl(XMPService.XMPServiceListener serviceListener, PDFDocument pdfDocument, MetadataOptions options) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        this.xmpService = serviceListener;
        this.xmpService.registerListener(LISTENER_KEY, this);
        this.pdfDocument = pdfDocument;
        this.setOptions(options);
        this.buildInitialInternalXMP();
    }

    @Override
    public MetadataOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(MetadataOptions options) {
        this.options = options;
        if (this.options.getAutoUpdate() || this.options.getRemoveFiltersFromXMP() && this.options.getFilterRemovalMarksXMPDirty()) {
            this.xmpService.holdStrongly(LISTENER_KEY, true);
        } else {
            this.xmpService.holdStrongly(LISTENER_KEY, false);
        }
    }

    @Override
    public DocumentListenerProperties getProperties() {
        if (this.listenerProperties == null) {
            this.listenerProperties = new DocumentListenerProperties();
        }
        return this.listenerProperties;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        DocumentMessage.MessageType type = message.getMessageType();
        if (type != DocumentMessage.CLOSE && (type == DocumentMessage.FINISH || type == DocumentMessage.SAVE)) {
            try {
                this.commit(message.documentDirty() || message.listenersDirty());
            }
            catch (PDFException e) {
                throw new PDFUnableToCompleteOperationException("Error during commit of XMP data to PDF document.", e);
            }
        }
    }

    private void markInternalXMPDirty(boolean dirty) {
        if (this.internalXMPDirty == dirty) {
            return;
        }
        this.internalXMPDirty = dirty;
        this.masterDirtyProcess();
    }

    private boolean isInternalXMPDirty() {
        return this.internalXMPDirty;
    }

    private void markDocInfoDirty(boolean dirty) {
        if (this.docInfoDirty == dirty) {
            return;
        }
        if (!this.initialDocInfoMatchState.docInfoExists()) {
            return;
        }
        this.docInfoDirty = dirty;
        this.masterDirtyProcess();
    }

    private boolean isDocInfoDirty() {
        return this.docInfoDirty;
    }

    private void masterDirtyProcess() {
        if (this.dirty == (this.docInfoDirty || this.internalXMPDirty)) {
            return;
        }
        this.dirty = this.docInfoDirty || this.internalXMPDirty;
        this.xmpService.markDirty(LISTENER_KEY, this.dirty);
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void buildInitialInternalXMP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        PDFMetadata pdfMetadata = this.pdfDocument.requireCatalog().getMetadata();
        try {
            this.buildInternalXMPFromXMP(pdfMetadata);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        PDFDocumentInfo pdfDocInfo = this.pdfDocument.getDocumentInfo();
        this.initialDocInfoMatchState = this.docInfoConformantToXMP(pdfDocInfo);
        if (!this.initialDocInfoMatchState.everythingConforms()) {
            this.markInternalXMPDirty(true);
        }
        this.initialSynchOption = this.getInitialMasterSource(pdfDocInfo);
        if (this.xmpMeta == null) {
            this.xmpMeta = XMPMetaFactory.create();
        }
        if (this.initialSynchOption == SYNCHRONIZATION_SOURCE_DOCINFO) {
            this.addDocInfoToInternalXMP(this.initialDocInfoMatchState, pdfDocInfo, true, true);
        } else if (this.options.getCompareMoreThanModDate() && this.initialSynchOption == SYNCHRONIZATION_SOURCE_EQUAL) {
            this.addDocInfoToInternalXMP(this.initialDocInfoMatchState, pdfDocInfo, false, !this.options.getXMPIsMasterSourceIfModDatesEqual());
        } else if (this.initialSynchOption == SYNCHRONIZATION_SOURCE_XMP) {
            this.markDocInfoDirty(true);
        }
        try {
            this.makeKeywordsConformant();
        }
        catch (XMPException e) {
            this.xmpWasValid = false;
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildInternalXMPFromXMP(PDFMetadata pdfMetadata) throws IOException {
        boolean xmpWasValid = false;
        ByteArrayInputStream is = null;
        ByteArrayOutputStream outStm = null;
        try {
            if (pdfMetadata != null) {
                outStm = new ByteArrayOutputStream(pdfMetadata.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pdfMetadata.getLength());
                pdfMetadata.getStreamData(outStm);
                is = new ByteArrayInputStream(outStm.toByteArray());
                this.originalXMPSize = outStm.size();
                this.xmpWasValid = true;
                ParseOptions options = this.options.getXMPParseOptions();
                if (options == null) {
                    options = new ParseOptions();
                }
                this.xmpMeta = XMPMetaFactoryMonitor.parse(is, options, this.pdfDocument);
            }
        }
        catch (Exception e) {
            this.xmpWasValid = false;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (outStm != null) {
                    outStm.close();
                }
            }
        }
        return xmpWasValid;
    }

    private void addDocInfoToInternalXMP(DocumentMetadata.DocInfoConformanceState docInfoConformanceState, PDFDocumentInfo pdfDocInfo, boolean docInfoMaster, boolean docInfoOverride) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        List<String[]> docInfoProps;
        if (pdfDocInfo == null) {
            return;
        }
        int choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.TITLE), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setTitle(pdfDocInfo.getTitle());
        } else if (choice < 0) {
            this.removeTitle();
        }
        choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.AUTHOR), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setAuthor(pdfDocInfo.getAuthor());
        } else if (choice < 0) {
            this.removeAuthors();
        }
        choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.SUBJECT), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setSubject(pdfDocInfo.getSubject());
        } else if (choice < 0) {
            this.removeSubject();
        }
        choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.KEYWORDS), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setKeywords(pdfDocInfo.getKeywords());
        } else if (choice < 0) {
            this.removeKeywords();
        }
        choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CREATOR), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setCreator(pdfDocInfo.getCreator());
        } else if (choice < 0) {
            this.removeCreator();
        }
        choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.PRODUCER), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setProducer(pdfDocInfo.getProducer());
        } else if (choice < 0) {
            this.removeProducer();
        }
        choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CREATION_DATE), docInfoMaster, docInfoOverride);
        if (choice > 0) {
            this.setCreationDate(pdfDocInfo.getCreationDate());
        }
        if ((choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.TRAPPED), docInfoMaster, docInfoOverride)) > 0) {
            this.setTrapped(pdfDocInfo.getTrapped());
        }
        if ((choice = this.chooseDocInfo(docInfoConformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.MODIFICATION_DATE), docInfoMaster, docInfoOverride)) > 0) {
            ASDate diModDate = pdfDocInfo.getModificationDate();
            this.setModificationDate(diModDate);
            this.setMetadataDate(diModDate);
        }
        if ((docInfoProps = pdfDocInfo.getCustomProperties()) != null) {
            for (int idx = 0; idx < docInfoProps.size(); ++idx) {
                String[] property = docInfoProps.get(idx);
                String name = property[0];
                String diValue = property[1];
                String xmpValue = this.getCustomProperty(name);
                if (this.chooseDocInfo(xmpValue != null, diValue != null, xmpValue != null ? xmpValue.equals(diValue) : null == diValue, docInfoMaster, docInfoOverride) <= 0) continue;
                this.addCustomProperty(name, diValue);
            }
        }
    }

    private int chooseDocInfo(DocumentMetadata.DocInfoConformanceState.EntryConformanceState entryState, boolean docInfoMaster, boolean docInfoOverride) {
        return this.chooseDocInfo(entryState.getXMPEntryExists(), entryState.getDocInfoEntryExists(), entryState.getBothEqual(), docInfoMaster, docInfoOverride);
    }

    private int chooseDocInfo(boolean xmpExists, boolean docInfoExists, boolean bothEqual, boolean docInfoMaster, boolean docInfoOverride) {
        if (docInfoMaster) {
            if (docInfoExists) {
                return 1;
            }
            return -1;
        }
        int caseValue = (xmpExists ? 4 : 0) + (docInfoExists ? 2 : 0) + (docInfoOverride ? 1 : 0);
        switch (caseValue) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                this.markInternalXMPDirty(true);
                return 1;
            }
            case 3: {
                this.markInternalXMPDirty(true);
                return 1;
            }
            case 4: {
                this.markInternalXMPDirty(true);
                return 0;
            }
            case 5: {
                this.markInternalXMPDirty(true);
                return 0;
            }
            case 6: {
                if (bothEqual) {
                    return 0;
                }
                this.markInternalXMPDirty(true);
                return 0;
            }
            case 7: {
                if (bothEqual) {
                    return 0;
                }
                this.markInternalXMPDirty(true);
                return 1;
            }
        }
        return 0;
    }

    private DocumentMetadata.SynchronizationSource getInitialMasterSource(PDFDocumentInfo docInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            if (docInfo != null) {
                return SYNCHRONIZATION_SOURCE_DOCINFO;
            }
            return SYNCHRONIZATION_SOURCE_NEW;
        }
        if (docInfo == null) {
            return SYNCHRONIZATION_SOURCE_XMP;
        }
        ASDate xmpModDate = this.getModificationASDate(true);
        ASDate docInfoModDate = docInfo.getModificationDate();
        if (docInfoModDate == null) {
            return SYNCHRONIZATION_SOURCE_XMP;
        }
        if (xmpModDate == null) {
            return SYNCHRONIZATION_SOURCE_DOCINFO;
        }
        if (docInfoModDate.equals(xmpModDate)) {
            return SYNCHRONIZATION_SOURCE_EQUAL;
        }
        if (docInfoModDate.after(xmpModDate)) {
            return SYNCHRONIZATION_SOURCE_DOCINFO;
        }
        return SYNCHRONIZATION_SOURCE_XMP;
    }

    private DocumentMetadata.DocInfoConformanceState docInfoConformantToXMP(PDFDocumentInfo pdfDocInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidXMLException {
        DocumentMetadata.DocInfoConformanceState matchState = new DocumentMetadata.DocInfoConformanceState(this.xmpWasValid, pdfDocInfo != null);
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState titleState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.TITLE);
        try {
            String xmpEntry = this.getTitle();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getTitle();
            titleState.setXMPEntryExists(xmpEntry != null);
            titleState.setDocInfoEntryExists(diEntry != null);
            titleState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            titleState.setError(true);
        }
        catch (Exception e) {
            titleState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState authorState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.AUTHOR);
        try {
            String xmpEntry = this.getAuthor();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getAuthor();
            authorState.setXMPEntryExists(xmpEntry != null);
            authorState.setDocInfoEntryExists(diEntry != null);
            if (!this.isAuthorArrayWithMultipleItems()) {
                authorState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
            } else {
                authorState.setBothEqual(false);
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            authorState.setError(true);
        }
        catch (Exception e) {
            authorState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState subjectState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.SUBJECT);
        try {
            String xmpEntry = this.getSubject();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getSubject();
            subjectState.setXMPEntryExists(xmpEntry != null);
            subjectState.setDocInfoEntryExists(diEntry != null);
            subjectState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            subjectState.setError(true);
        }
        catch (Exception e) {
            subjectState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState keywordState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.KEYWORDS);
        try {
            String xmpEntry = this.getKeywordsAsString();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getKeywords();
            keywordState.setXMPEntryExists(xmpEntry != null);
            keywordState.setDocInfoEntryExists(diEntry != null);
            keywordState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            keywordState.setError(true);
        }
        catch (Exception e) {
            keywordState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState creatorState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CREATOR);
        try {
            String xmpEntry = this.getCreator();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getCreator();
            creatorState.setXMPEntryExists(xmpEntry != null);
            creatorState.setDocInfoEntryExists(diEntry != null);
            creatorState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            creatorState.setError(true);
        }
        catch (Exception e) {
            creatorState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState producerState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.PRODUCER);
        try {
            String xmpEntry = this.getProducer();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getProducer();
            producerState.setXMPEntryExists(xmpEntry != null);
            producerState.setDocInfoEntryExists(diEntry != null);
            producerState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            producerState.setError(true);
        }
        catch (Exception e) {
            producerState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState trappedState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.TRAPPED);
        try {
            String xmpEntry = this.getTrapped();
            String diEntry = pdfDocInfo == null ? null : pdfDocInfo.getTrapped();
            trappedState.setXMPEntryExists(xmpEntry != null);
            trappedState.setDocInfoEntryExists(diEntry != null);
            trappedState.setBothEqual(DocumentMetadataImpl.equalStrings(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            trappedState.setError(true);
        }
        catch (Exception e) {
            trappedState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState creationDateState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CREATION_DATE);
        try {
            ASDate xmpEntry = this.getCreationASDate();
            ASDate diEntry = pdfDocInfo == null ? null : pdfDocInfo.getCreationDate();
            creationDateState.setXMPEntryExists(xmpEntry != null);
            creationDateState.setDocInfoEntryExists(diEntry != null);
            creationDateState.setBothEqual(DocumentMetadataImpl.equalDates(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            creationDateState.setError(true);
        }
        catch (Exception e) {
            creationDateState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState modificationDateState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.MODIFICATION_DATE);
        try {
            ASDate xmpEntry = this.getModificationASDate();
            ASDate diEntry = pdfDocInfo == null ? null : pdfDocInfo.getModificationDate();
            modificationDateState.setXMPEntryExists(xmpEntry != null);
            modificationDateState.setDocInfoEntryExists(diEntry != null);
            modificationDateState.setBothEqual(DocumentMetadataImpl.equalDates(diEntry, xmpEntry));
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            modificationDateState.setError(true);
        }
        catch (Exception e) {
            modificationDateState.setError(true);
        }
        DocumentMetadata.DocInfoConformanceState.EntryConformanceState customPropertyState = matchState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CUSTOM_PROPERTIES);
        try {
            List<String> xmpEntry = this.getCustomPropertyNames();
            List<String[]> diEntry = pdfDocInfo == null ? null : pdfDocInfo.getCustomProperties();
            customPropertyState.setXMPEntryExists(xmpEntry != null && !xmpEntry.isEmpty());
            customPropertyState.setDocInfoEntryExists(diEntry != null && !diEntry.isEmpty());
            if (diEntry == null || xmpEntry == null) {
                if ((diEntry == null || diEntry.isEmpty()) && (xmpEntry == null || xmpEntry.isEmpty())) {
                    customPropertyState.setBothEqual(true);
                }
            } else {
                ArrayList<String> docInfoPropsNames = new ArrayList<String>(diEntry.size());
                for (int i = 0; i < diEntry.size(); ++i) {
                    docInfoPropsNames.add(diEntry.get(i)[0]);
                }
                if (docInfoPropsNames.equals(xmpEntry)) {
                    boolean allPropertiesIdentical = true;
                    for (int i = 0; i < docInfoPropsNames.size(); ++i) {
                        String[] docInfoProperty = diEntry.get(i);
                        String name = docInfoProperty[0];
                        String value = docInfoProperty[1];
                        if (DocumentMetadataImpl.equalStrings(this.getCustomProperty(name), value)) continue;
                        allPropertiesIdentical = false;
                        break;
                    }
                    customPropertyState.setBothEqual(allPropertiesIdentical);
                }
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            this.xmpWasValid = false;
            customPropertyState.setError(true);
        }
        catch (Exception e) {
            customPropertyState.setError(true);
        }
        return matchState;
    }

    private static final boolean equalStrings(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null;
        }
        return s1.equals(s2);
    }

    private static final boolean equalDates(ASDate d1, ASDate d2) {
        if (d1 == null || d2 == null) {
            return d1 == null && d2 == null;
        }
        return d1.equals(d2);
    }

    @Override
    public DocumentMetadata.SynchronizationSource getInitialSynchronizationSource() {
        return this.initialSynchOption;
    }

    @Override
    public DocumentMetadata.DocInfoConformanceState initialDocInfoConformanceState() {
        return this.initialDocInfoMatchState;
    }

    @Override
    public boolean wasInitialXMPValid() {
        return this.xmpWasValid;
    }

    @Override
    public void commit() throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException {
        this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(boolean documentDirty) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        try {
            if (this.xmpMeta == null) {
                throw new PDFUnableToCompleteOperationException("Internal XMP representation is empty.");
            }
            this.autoUpdate(documentDirty);
            if (this.isDirty()) {
                try {
                    PDFDocumentInfo docInfo = this.pdfDocument.getDocumentInfo();
                    this.updateDocInfo(docInfo, this.isDocInfoDirty());
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFUnableToCompleteOperationException("XMP data could not be retrieved.", e);
                }
            }
            PDFMetadata pdfMetadata = this.pdfDocument.requireCatalog().getMetadata();
            if (this.isInternalXMPDirty() || this.options.getRemoveFiltersFromXMP() && this.options.getFilterRemovalMarksXMPDirty() && pdfMetadata != null && (pdfMetadata.hasOutputFilters() || pdfMetadata.hasInputFilters())) {
                this.updateDocXMP(pdfMetadata);
            }
        }
        finally {
            this.markInternalXMPDirty(false);
            this.buildInitialInternalXMP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDocXMP(PDFMetadata pdfMetadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidXMLException {
        OutputByteStream obs = null;
        OutputStream os = null;
        InputByteStream ibs = null;
        try {
            obs = this.pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, this.originalXMPSize + 2048L);
            os = obs.toOutputStream();
            XMPMetaFactoryMonitor.serialize(this.xmpMeta, os, new SerializeOptions().setIndent("   ").setUseCanonicalFormat(true), this.pdfDocument);
            int i = 0;
            while ((long)i < 2048L) {
                os.write(32);
                ++i;
            }
            os.close();
            os = null;
            ibs = obs.closeAndConvert();
            obs = null;
            if (pdfMetadata != null) {
                pdfMetadata.setStreamData(ibs.toInputStream());
                if (this.options.getRemoveFiltersFromXMP()) {
                    pdfMetadata.removeOutputFilters();
                }
                ibs = null;
            } else {
                pdfMetadata = PDFMetadata.newInstance(this.pdfDocument, ibs);
                ibs = null;
                this.pdfDocument.requireCatalog().setMetadata(pdfMetadata);
            }
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException("Could not serialize XMP", e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to serialize XMP data.", e);
        }
        finally {
            try {
                try {
                    if (obs != null) {
                        obs.close();
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    finally {
                        if (ibs != null) {
                            ibs.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Error trying to close streams.", e);
            }
        }
    }

    private void autoUpdate(boolean documentDirty) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        if (this.options.getAutoUpdate() && (documentDirty || this.options.getForceUpdateOnSave())) {
            this.setModificationDate(new ASDate());
            if (this.options.getDocumentIdGenerator() != null) {
                this.updateIDs(this.options.getDocumentIdGenerator());
            }
        }
    }

    @Override
    public void importXMP(InputStream xmp) throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        try {
            this.xmpMeta = XMPMetaFactoryMonitor.parse(xmp, new ParseOptions(), this.pdfDocument);
            this.markInternalXMPDirty(true);
        }
        catch (XMPException e) {
            throw new PDFInvalidXMLException("Unable to parse XMP", e);
        }
    }

    @Override
    public void exportXMP(OutputStream xmp) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            XMPMetaFactoryMonitor.serialize(this.xmpMeta, xmp, new SerializeOptions().setIndent("   ").setUseCanonicalFormat(true), this.pdfDocument);
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getHeaderAttributesAsString() {
        return this.xmpMeta.getPacketHeader();
    }

    @Override
    public String[] getHeaderAttributesAsArray() {
        String headerAttributes = this.getHeaderAttributesAsString();
        if (headerAttributes == null) {
            return new String[0];
        }
        return headerAttributes.split(" ");
    }

    @Override
    public void updateIDs(Random r) throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.markInternalXMPDirty(true);
        try {
            if (!this.xmpMeta.doesPropertyExist("http://ns.adobe.com/xap/1.0/mm/", XMP_NS_XMP_MM_DOCUMENTID)) {
                this.xmpMeta.setProperty("http://ns.adobe.com/xap/1.0/mm/", XMP_NS_XMP_MM_DOCUMENTID, UUID.createUUID(), new PropertyOptions());
            }
            this.xmpMeta.setProperty("http://ns.adobe.com/xap/1.0/mm/", XMP_NS_XMP_MM_INSTANCEID, UUID.createUUID(), new PropertyOptions());
            this.xmpMeta.setProperty("http://purl.org/dc/elements/1.1/", NS_DC_FORMAT, "application/pdf", new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getDocumentID() throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            return this.xmpMeta.getPropertyString("http://ns.adobe.com/xap/1.0/mm/", XMP_NS_XMP_MM_DOCUMENTID);
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getInstanceID() throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            return this.xmpMeta.getPropertyString("http://ns.adobe.com/xap/1.0/mm/", XMP_NS_XMP_MM_INSTANCEID);
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public void setKeywords(List<?> keywords) throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.removeKeywords();
        Iterator<?> i = keywords.iterator();
        while (i.hasNext()) {
            String keyWord = (String)i.next();
            boolean setNow = !i.hasNext();
            this.addKeyword(keyWord, setNow);
        }
    }

    @Override
    public void setKeywords(String keywords) throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.removeKeywords();
        try {
            if (keywords.length() != 0) {
                XMPUtils.separateArrayItems(this.xmpMeta, "http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, keywords, new PropertyOptions(), false);
            }
            this.xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_KEYWORDS, keywords, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public List<String> getKeywordsAsList() throws PDFUnableToCompleteOperationException {
        return this.getKeywordsAsList(this.xmpMeta);
    }

    private List<String> getKeywordsAsList(XMPMeta meta) throws PDFUnableToCompleteOperationException {
        LinkedList<String> result = new LinkedList<String>();
        if (meta == null) {
            return result;
        }
        try {
            int numKeywords = meta.countArrayItems("http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT);
            for (int i = 1; i <= numKeywords; ++i) {
                XMPProperty prop = meta.getArrayItem("http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, i);
                result.add(prop.getValue());
            }
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
        return result;
    }

    @Override
    public String getKeywordsAsString() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_KEYWORDS);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public void addKeyword(String s) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.addKeyword(s, true);
    }

    void addKeyword(String s, boolean setProperty) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        try {
            if (s == null || s.equals("")) {
                return;
            }
            this.markInternalXMPDirty(true);
            this.xmpMeta.appendArrayItem("http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, new PropertyOptions().setArray(true), s, new PropertyOptions());
            if (setProperty) {
                String newKeywords = XMPUtils.catenateArrayItems(this.xmpMeta, "http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, "; ", "\"", false);
                this.xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_KEYWORDS, newKeywords, new PropertyOptions());
            }
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public void removeKeywords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_KEYWORDS);
        this.xmpMeta.deleteProperty("http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT);
    }

    @Override
    public void removeKeyword(String s) throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.markInternalXMPDirty(true);
        List<String> keywords = this.getKeywordsAsList();
        Iterator<String> i = keywords.iterator();
        while (i.hasNext()) {
            String keyword = i.next();
            if (!keyword.equals(s)) continue;
            i.remove();
        }
        this.setKeywords(keywords);
    }

    private boolean areKeywordsConformant() throws XMPException, PDFUnableToCompleteOperationException {
        String newKeywords;
        XMPMeta tempMeta_PDFKeywords = XMPMetaFactory.create();
        XMPMeta tempMeta_DCSubject = XMPMetaFactory.create();
        String stringKeywords = this.getKeywordsAsString();
        if (stringKeywords != null && stringKeywords.length() != 0) {
            XMPUtils.separateArrayItems(tempMeta_PDFKeywords, "http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, this.getKeywordsAsString(), new PropertyOptions(), false);
        }
        if ((newKeywords = XMPUtils.catenateArrayItems(this.xmpMeta, "http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, "; ", "\"", false)) != null && newKeywords.length() != 0) {
            XMPUtils.separateArrayItems(tempMeta_DCSubject, "http://purl.org/dc/elements/1.1/", NS_DC_SUBJECT, newKeywords, new PropertyOptions(), false);
        }
        List<String> keywords_PDFKeywords = this.getKeywordsAsList(tempMeta_PDFKeywords);
        List<String> keywords_DCSubject = this.getKeywordsAsList(tempMeta_DCSubject);
        return keywords_PDFKeywords.equals(keywords_DCSubject);
    }

    private void makeKeywordsConformant() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidXMLException, XMPException {
        if (this.xmpMeta == null) {
            return;
        }
        if (this.areKeywordsConformant()) {
            return;
        }
        List<String> keywordList = this.getKeywordsAsList();
        String keywordString = this.getKeywordsAsString();
        this.removeKeywords();
        this.addKeyword(keywordString);
        Iterator<String> i = keywordList.iterator();
        while (i.hasNext()) {
            String keyWord = i.next();
            boolean setNow = !i.hasNext();
            this.addKeyword(keyWord, setNow);
        }
    }

    public boolean isAuthorArrayWithMultipleItems() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return false;
        }
        try {
            int numAuthors = this.xmpMeta.countArrayItems("http://purl.org/dc/elements/1.1/", NS_DC_CREATOR);
            return numAuthors > 1;
        }
        catch (XMPException e) {
            return false;
        }
    }

    @Override
    public String getAuthor() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_AUTHOR);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public List<String> getAuthors() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        try {
            int numAuthors = this.xmpMeta.countArrayItems("http://purl.org/dc/elements/1.1/", NS_DC_CREATOR);
            for (int i = 1; i <= numAuthors; ++i) {
                XMPProperty prop = this.xmpMeta.getArrayItem("http://purl.org/dc/elements/1.1/", NS_DC_CREATOR, i);
                result.add(prop.getValue());
            }
        }
        catch (XMPException e) {
            return null;
        }
        return result;
    }

    @Override
    public void setAuthor(String s) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.removeAuthors();
        this.addAuthor(s);
    }

    @Override
    public void addAuthor(String s) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        try {
            this.markInternalXMPDirty(true);
            this.xmpMeta.appendArrayItem("http://purl.org/dc/elements/1.1/", NS_DC_CREATOR, new PropertyOptions().setArray(true).setArrayOrdered(true), s, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public void removeAuthors() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://purl.org/dc/elements/1.1/", NS_DC_CREATOR);
    }

    @Override
    public void setSubject(String s) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setLocalizedText("http://purl.org/dc/elements/1.1/", NS_DC_DESCRIPTION, null, "x-default", s, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getSubject() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getLocalizedText("http://purl.org/dc/elements/1.1/", NS_DC_DESCRIPTION, "", "x-default");
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void removeSubject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://purl.org/dc/elements/1.1/", NS_DC_DESCRIPTION);
    }

    @Override
    public void setTitle(String s) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setLocalizedText("http://purl.org/dc/elements/1.1/", NS_DC_TITLE, null, "x-default", s, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getTitle() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getLocalizedText("http://purl.org/dc/elements/1.1/", NS_DC_TITLE, "", "x-default");
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void removeTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://purl.org/dc/elements/1.1/", NS_DC_TITLE);
    }

    @Override
    public void setProducer(String s) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_PRODUCER, s, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getProducer() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_PRODUCER);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void removeProducer() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_PRODUCER);
    }

    @Override
    public void setCreator(String s) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_CREATOR, s, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getCreator() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_CREATOR);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void removeCreator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_CREATOR);
    }

    private XMPDateTime makeXMPDateTimeFromDate(Date date) {
        return this.makeXMPDateTimeFromASDate(new ASDate(date));
    }

    private XMPDateTime makeXMPDateTimeFromASDate(ASDate asDate) {
        Date date = asDate.toDate();
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance(Locale.US);
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        calendar.setTimeZone(asDate.getTimeZone());
        calendar.setTime(date);
        calendar.set(14, 0);
        XMPDateTime xmpDate = XMPDateTimeFactory.createFromCalendar(calendar);
        if (!asDate.hasTimeZone()) {
            xmpDate.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return xmpDate;
    }

    private ASDate getASDateFromXMPDateTime(XMPDateTime xmpDate, boolean removeMillis) {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance(Locale.US);
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        TimeZone timeZone = xmpDate.hasTimeZone() ? xmpDate.getTimeZone() : new SimpleTimeZone(0, "GMT+00:00");
        cal.setTimeZone(timeZone);
        cal.set(xmpDate.getYear(), xmpDate.getMonth() - 1, xmpDate.getDay(), xmpDate.getHour(), xmpDate.getMinute(), xmpDate.getSecond());
        if (!removeMillis) {
            cal.set(14, xmpDate.getNanoSecond() / 1000000);
        }
        return new ASDate(cal.getTime(), timeZone);
    }

    @Override
    public Date getCreationDate() throws PDFUnableToCompleteOperationException {
        ASDate asDate = this.getCreationASDate();
        if (asDate == null) {
            return null;
        }
        return asDate.toDate();
    }

    @Override
    public void setCreationDate(Date date) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        XMPDateTime xmpDate = this.makeXMPDateTimeFromDate(date);
        if (xmpDate == null) {
            return;
        }
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setPropertyDate("http://ns.adobe.com/pdf/1.3/", NS_PDF_CREATION_DATE, xmpDate, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public ASDate getCreationASDate() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPDateTime xmpDate = this.xmpMeta.getPropertyDate("http://ns.adobe.com/pdf/1.3/", NS_PDF_CREATION_DATE);
            if (xmpDate != null) {
                return this.getASDateFromXMPDateTime(xmpDate, false);
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void setCreationDate(ASDate date) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        XMPDateTime xmpDate = this.makeXMPDateTimeFromASDate(date);
        if (xmpDate == null) {
            return;
        }
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setPropertyDate("http://ns.adobe.com/pdf/1.3/", NS_PDF_CREATION_DATE, xmpDate, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public Date getModificationDate() throws PDFUnableToCompleteOperationException {
        ASDate asDate = this.getModificationASDate(false);
        if (asDate == null) {
            return null;
        }
        return asDate.toDate();
    }

    @Override
    public void setModificationDate(Date date) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        XMPDateTime xmpDate = this.makeXMPDateTimeFromDate(date);
        if (xmpDate == null) {
            return;
        }
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setPropertyDate("http://ns.adobe.com/pdf/1.3/", NS_PDF_MOD_DATE, xmpDate, new PropertyOptions());
            this.setMetadataDate(date);
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public ASDate getModificationASDate() throws PDFUnableToCompleteOperationException {
        return this.getModificationASDate(false);
    }

    private ASDate getModificationASDate(boolean removeMillis) throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPDateTime xmpDate = this.xmpMeta.getPropertyDate("http://ns.adobe.com/pdf/1.3/", NS_PDF_MOD_DATE);
            if (xmpDate != null) {
                return this.getASDateFromXMPDateTime(xmpDate, removeMillis);
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void setModificationDate(ASDate date) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        XMPDateTime xmpDate = this.makeXMPDateTimeFromASDate(date);
        if (xmpDate == null) {
            return;
        }
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setPropertyDate("http://ns.adobe.com/pdf/1.3/", NS_PDF_MOD_DATE, xmpDate, new PropertyOptions());
            this.setMetadataDate(date);
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    private void setMetadataDate(Date date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        XMPDateTime xmpDate = this.makeXMPDateTimeFromDate(date);
        if (xmpDate == null) {
            return;
        }
        try {
            this.xmpMeta.setPropertyDate("http://ns.adobe.com/xap/1.0/", NS_XMP_METADATA_DATE, xmpDate, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    private void setMetadataDate(ASDate date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        XMPDateTime xmpDate = this.makeXMPDateTimeFromASDate(date);
        if (xmpDate == null) {
            return;
        }
        try {
            this.xmpMeta.setPropertyDate("http://ns.adobe.com/xap/1.0/", NS_XMP_METADATA_DATE, xmpDate, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public ASDate getMetadataASDate() throws PDFUnableToCompleteOperationException {
        return this.getMetadataASDate(false);
    }

    private ASDate getMetadataASDate(boolean removeMillis) throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPDateTime xmpDate = this.xmpMeta.getPropertyDate("http://ns.adobe.com/xap/1.0/", NS_XMP_METADATA_DATE);
            if (xmpDate != null) {
                return this.getASDateFromXMPDateTime(xmpDate, removeMillis);
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public String getTrapped() throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_TRAPPED);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void setTrapped(String s) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.markInternalXMPDirty(true);
        try {
            this.xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", NS_PDF_TRAPPED, s, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public List<String> getCustomPropertyNames() throws PDFUnableToCompleteOperationException {
        LinkedList<String> result = new LinkedList<String>();
        if (this.xmpMeta == null) {
            return result;
        }
        IteratorOptions io = new IteratorOptions().setJustLeafnodes(true).setJustChildren(true).setOmitQualifiers(true);
        try {
            XMPIterator i = this.xmpMeta.iterator("http://ns.adobe.com/pdfx/1.3/", null, io);
            while (i.hasNext()) {
                XMPPropertyInfo pi = (XMPPropertyInfo)i.next();
                String path = pi.getPath();
                path = path.substring(path.indexOf(58) + 1);
                result.add(path);
            }
        }
        catch (XMPException e) {
            return null;
        }
        return result;
    }

    @Override
    public String getCustomProperty(String propName) throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty("http://ns.adobe.com/pdfx/1.3/", propName);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void addCustomProperty(String propName, String value) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        try {
            this.markInternalXMPDirty(true);
            this.xmpMeta.setProperty("http://ns.adobe.com/pdfx/1.3/", propName, value, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public void removeCustomProperty(String propName) {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty("http://ns.adobe.com/pdfx/1.3/", propName);
    }

    @Override
    public String getProperty(String schemaNS, String propName) throws PDFUnableToCompleteOperationException {
        if (this.xmpMeta == null) {
            return null;
        }
        try {
            XMPProperty prop = this.xmpMeta.getProperty(schemaNS, propName);
            if (prop != null) {
                return prop.getValue();
            }
            return null;
        }
        catch (XMPException e) {
            return null;
        }
    }

    @Override
    public void addProperty(String schemaNS, String propName, String value) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        try {
            this.markInternalXMPDirty(true);
            this.xmpMeta.setProperty(schemaNS, propName, value, new PropertyOptions());
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public void removeProperty(String schemaNS, String propName) {
        this.markInternalXMPDirty(true);
        this.xmpMeta.deleteProperty(schemaNS, propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerNameSpace(String schemaNS, String suggestedPrefix) throws PDFUnableToCompleteOperationException {
        String prefix = null;
        try {
            Class<DocumentMetadataImpl> clazz = DocumentMetadataImpl.class;
            synchronized (DocumentMetadataImpl.class) {
                prefix = XMPMetaFactoryMonitor.getSchemaRegistry(this.pdfDocument).registerNamespace(schemaNS, suggestedPrefix);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
        {
            return prefix.substring(0, prefix.length() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getAllNamespaces() throws XMPException {
        Map namespaceMap = null;
        Class<DocumentMetadataImpl> clazz = DocumentMetadataImpl.class;
        synchronized (DocumentMetadataImpl.class) {
            namespaceMap = XMPMetaFactoryMonitor.getSchemaRegistry(this.pdfDocument).getNamespaces();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            HashMap<String, String> namespacesInDoc = new HashMap<String, String>();
            Iterator entries = namespaceMap.entrySet().iterator();
            try {
                while (entries.hasNext()) {
                    Map.Entry nsEntry = entries.next();
                    String namespace = (String)nsEntry.getKey();
                    String namespacePrefix = (String)nsEntry.getValue();
                    namespacePrefix = namespacePrefix.substring(0, namespacePrefix.length() - 1);
                    IteratorOptions io = new IteratorOptions().setJustLeafnodes(true).setJustChildren(true).setOmitQualifiers(true);
                    XMPIterator i = this.xmpMeta.iterator(namespace, null, io);
                    if (!i.hasNext()) continue;
                    namespacesInDoc.put(namespace, namespacePrefix);
                }
            }
            catch (XMPException e) {
                return null;
            }
            return namespacesInDoc;
        }
    }

    @Override
    public Map<String, String> getPropertiesForNamespace(String namespace) throws PDFUnableToCompleteOperationException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.xmpMeta == null) {
            return properties;
        }
        IteratorOptions io = new IteratorOptions().setJustLeafnodes(true).setJustChildren(false).setOmitQualifiers(true);
        try {
            XMPIterator i = this.xmpMeta.iterator(namespace, null, io);
            while (i.hasNext()) {
                XMPPropertyInfo pi = (XMPPropertyInfo)i.next();
                String propertyKey = pi.getPath();
                propertyKey = propertyKey.substring(propertyKey.indexOf(58) + 1);
                String propertyValue = pi.getValue();
                properties.put(propertyKey, propertyValue);
            }
        }
        catch (XMPException e) {
            return null;
        }
        return properties;
    }

    @Override
    public Map<String, Map<String, String>> getPropertiesForAllRegisteredNamespaces() throws PDFUnableToCompleteOperationException, XMPException {
        Map<String, String> namespaceMap = this.getAllNamespaces();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (this.xmpMeta == null) {
            return result;
        }
        for (Map.Entry<String, String> nsEntry : namespaceMap.entrySet()) {
            String namespace = nsEntry.getKey();
            result.put(namespace, this.getPropertiesForNamespace(namespace));
        }
        return result;
    }

    @Override
    public Map<String, Map<String, String>> getNamespaceQualifierMap() throws XMPException, PDFUnableToCompleteOperationException {
        HashMap<String, Map<String, String>> namespaceQualifierMap = new HashMap<String, Map<String, String>>();
        Map<String, String> namespaceMap = this.getAllNamespaces();
        if (this.xmpMeta == null) {
            return null;
        }
        for (Map.Entry<String, String> nsEntry : namespaceMap.entrySet()) {
            String namespace = nsEntry.getKey();
            HashMap<String, String> propertyAsQualiifer = new HashMap<String, String>();
            IteratorOptions io = new IteratorOptions().setJustLeafnodes(true).setJustChildren(false).setOmitQualifiers(false);
            try {
                XMPIterator i = this.xmpMeta.iterator(namespace, null, io);
                while (i.hasNext()) {
                    XMPPropertyInfo pi = (XMPPropertyInfo)i.next();
                    if (!pi.getOptions().isQualifier()) continue;
                    String propertyKey = pi.getPath();
                    propertyKey = propertyKey.substring(propertyKey.indexOf(58) + 1);
                    String propertyValue = pi.getValue();
                    propertyAsQualiifer.put(propertyKey, propertyValue);
                }
            }
            catch (XMPException e) {
                return null;
            }
            if (propertyAsQualiifer.isEmpty()) continue;
            namespaceQualifierMap.put(namespace, propertyAsQualiifer);
        }
        return namespaceQualifierMap;
    }

    @Override
    public Map<String, Set<String>> getNamespaceQualifierSet() throws PDFUnableToCompleteOperationException, XMPException {
        HashMap<String, Set<String>> nsQualifierSet = new HashMap<String, Set<String>>();
        Map<String, Map<String, String>> qualifierMap = this.getNamespaceQualifierMap();
        for (Map.Entry<String, Map<String, String>> qualifierMapEntry : qualifierMap.entrySet()) {
            HashSet<String> qualiiferProperties = new HashSet<String>();
            for (Map.Entry<String, String> entry : qualifierMapEntry.getValue().entrySet()) {
                String key = entry.getKey();
                key = key.substring(key.indexOf(58) + 1);
                qualiiferProperties.add(key);
            }
            nsQualifierSet.put(qualifierMapEntry.getKey(), qualiiferProperties);
        }
        return nsQualifierSet;
    }

    private void updateDocInfo(PDFDocumentInfo docInfo, boolean forceUpdate) throws PDFInvalidParameterException, PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        List<String> xmpProps;
        if (this.xmpMeta == null) {
            throw new PDFInvalidParameterException("Metadata is Null or parsed meta data is Null.");
        }
        if (docInfo == null) {
            docInfo = PDFDocumentInfo.newInstance(this.pdfDocument);
            this.pdfDocument.setDocumentInfo(docInfo);
        }
        String title = this.getTitle();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(title, docInfo.getTitle())) {
            docInfo.setTitle(title);
        }
        if (this.isAuthorArrayWithMultipleItems()) {
            docInfo.setAuthor(null);
        } else {
            String author = this.getAuthor();
            if (forceUpdate || !DocumentMetadataImpl.equalObjects(author, docInfo.getAuthor())) {
                docInfo.setAuthor(author);
            }
        }
        String subject = this.getSubject();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(subject, docInfo.getSubject())) {
            docInfo.setSubject(this.getSubject());
        }
        String keywords = this.getKeywordsAsString();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(keywords, docInfo.getKeywords())) {
            docInfo.setKeywords(this.getKeywordsAsString());
        }
        String creator = this.getCreator();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(creator, docInfo.getCreator())) {
            docInfo.setCreator(this.getCreator());
        }
        String producer = this.getProducer();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(producer, docInfo.getProducer())) {
            docInfo.setProducer(this.getProducer());
        }
        ASDate creationDate = this.getCreationASDate();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(creationDate, docInfo.getCreationDate())) {
            docInfo.setCreationDate(creationDate);
        }
        String trapped = this.getTrapped();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(trapped, docInfo.getTrapped())) {
            docInfo.setTrapped(trapped);
        }
        ASDate modificationDate = this.getModificationASDate();
        if (forceUpdate || !DocumentMetadataImpl.equalObjects(modificationDate, docInfo.getModificationDate())) {
            docInfo.setModificationDate(modificationDate);
        }
        if ((xmpProps = this.getCustomPropertyNames()) == null) {
            docInfo.setCustomProperties(null);
        } else {
            ArrayList<String[]> newDocInfoProps = new ArrayList<String[]>();
            for (int idx = 0; idx < xmpProps.size(); ++idx) {
                String name = xmpProps.get(idx);
                String value = this.getCustomProperty(name);
                String[] property = new String[]{name, value};
                newDocInfoProps.add(property);
            }
            List<String[]> oldDocInfoProps = docInfo.getCustomProperties();
            HashMap<String, String> oldDocInfoPropMap = new HashMap<String, String>();
            for (int idx = 0; idx < oldDocInfoProps.size(); ++idx) {
                String[] prop = oldDocInfoProps.get(idx);
                String key = prop[0];
                String value = prop[1];
                oldDocInfoPropMap.put(key, value);
            }
            if (forceUpdate || !newDocInfoProps.equals(oldDocInfoProps)) {
                docInfo.setCustomProperties(newDocInfoProps, oldDocInfoPropMap);
            }
        }
        this.markDocInfoDirty(false);
    }

    private static final boolean equalObjects(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }
}

