/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMovie;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationStamp
extends XFDFAnnotation {
    static final String ATTR_ICON = "icon";
    static final String ELEM_STAMP = "stamp";

    XFDFAnnotationStamp(PDFAnnotationStamp pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
    }

    XFDFAnnotationStamp(PDFDocument pdfDocument) throws PDFIOException {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        if (this.pdfAnnot instanceof PDFAnnotationMovie && ((PDFAnnotationMovie)this.pdfAnnot).hasRotation()) {
            annotsAtts.addAttribute("", "rotation", "rotation", "CDATA", Integer.toString(((PDFAnnotationMovie)this.pdfAnnot).getRotation()));
        }
        if (this.pdfAnnot.dictionaryContains(ASName.k_Name)) {
            annotsAtts.addAttribute("", ATTR_ICON, ATTR_ICON, "CDATA", ((PDFAnnotationStamp)this.pdfAnnot).getIconNameAsString());
        }
        try {
            handler.startElement("", ELEM_STAMP, ELEM_STAMP, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_STAMP, ELEM_STAMP);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to create XFDF element", e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationStamp stampAnnot = PDFAnnotationStamp.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(stampAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            int attrInd;
            this.fillMarkupAttributes(stampAnnot, elemAttrs);
            int iconInd = XFDFAnnotationStamp.findAttribute(ATTR_ICON, elemAttrs);
            if (iconInd >= 0) {
                stampAnnot.setIconName(elemAttrs.getValue(iconInd));
            }
            if ((attrInd = XFDFAnnotationStamp.findAttribute("rotation", elemAttrs)) != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                stampAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    stampAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(stampAnnot, gotPage)) {
                this.pdfAnnot = stampAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

