/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationCaret
extends XFDFAnnotation {
    static final String ELEM_CARET = "caret";
    static final String ATTR_SYMBOL = "symbol";
    private static final String ATTR_ROTATION = "rotation";

    XFDFAnnotationCaret(PDFAnnotationCaret pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationCaret(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addFringeXFDFAttribute(annotsAtts);
        if (((PDFAnnotationCaret)this.pdfAnnot).hasSymbol()) {
            ASName symbol = ((PDFAnnotationCaret)this.pdfAnnot).getSymbol();
            if (symbol != null) {
                annotsAtts.addAttribute("", ATTR_SYMBOL, ATTR_SYMBOL, "CDATA", symbol.asString(true));
            }
        } else if (this.pdfAnnot instanceof PDFAnnotationCaret && ((PDFAnnotationCaret)this.pdfAnnot).hasRotation()) {
            annotsAtts.addAttribute("", ATTR_ROTATION, ATTR_ROTATION, "CDATA", Integer.toString(((PDFAnnotationCaret)this.pdfAnnot).getRotation()));
        }
        try {
            handler.startElement("", ELEM_CARET, ELEM_CARET, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.createXFDFDefaultAppearance(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_CARET, ELEM_CARET);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationCaret caretAnnot = PDFAnnotationCaret.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(caretAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillCommonAttributes(caretAnnot, elemAttrs);
            this.fillMarkupAttributes(caretAnnot, elemAttrs);
            this.fillFringeAttribute(caretAnnot, elemAttrs);
            int attrInd = XFDFAnnotationCaret.findAttribute(ATTR_SYMBOL, elemAttrs);
            if (attrInd >= 0) {
                ASName symbol = ASName.create(elemAttrs.getValue(attrInd));
                caretAnnot.setSymbol(symbol);
            }
            if ((attrInd = XFDFAnnotationCaret.findAttribute(ATTR_ROTATION, elemAttrs)) != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                caretAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    caretAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(caretAnnot, gotPage)) {
                this.pdfAnnot = caretAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

