/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.pdftoolkit.core.util.EncodedData;
import com.adobe.internal.pdftoolkit.core.util.Encoding;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.pdf.utils.UTF16Support;
import com.adobe.internal.pdftoolkit.services.javascript.EventObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler.GibsonLiveObject;
import com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler.GibsonXFALevelScope;
import com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler.ScriptObject;
import com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler.XFAScriptHandler;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class JavaScriptHandler
extends XFAScriptHandler {
    public static Map<String, Script> compiledScriptMap = new HashMap<String, Script>();
    private static final int maxMapSize = 4096;
    private GibsonXFALevelScope xfaTopScope;
    private HashMap<AppModel, XFAObjectMapImpl> xfaObjectMaps;

    public JavaScriptHandler(DocumentContext oDocContext) {
        super(oDocContext);
        if (this.xfaObjectMaps == null) {
            this.xfaObjectMaps = new HashMap();
        }
        this.addXFAObjectToMap(this.getAppModel(), this.newLiveObject(this, this.getAppModel(), this.getAppModel()), this.getAppModel());
        com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler acrobatJsHandler = com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler.getRegisteredInstance(this.moDocContext.mpdDoc);
        if (acrobatJsHandler != null) {
            this.setAcrobatJSHandler(acrobatJsHandler);
        }
    }

    @Override
    public JavaScriptHandler clone() {
        JavaScriptHandler oNewScriptHandler = new JavaScriptHandler(this.moDocContext);
        oNewScriptHandler.moDocContext = this.moDocContext;
        oNewScriptHandler.xfaTopScope = this.xfaTopScope;
        oNewScriptHandler.setDebugger(this.getDebugger());
        oNewScriptHandler.acrobatJSHandler = this.acrobatJSHandler;
        oNewScriptHandler.xfaObjectMaps = this.xfaObjectMaps;
        return oNewScriptHandler;
    }

    public void getScriptMode(AppModel poAppModel, XFAObjectMapImpl poMap) {
        TemplateModel templateModel = TemplateModel.getTemplateModel(poAppModel, false);
        if (templateModel != null) {
            poMap.bStrictScopeMode = false;
            poMap.nLegacyMode = 21;
            poMap.bLegacyModeSet = true;
            if (!templateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
                poMap.nLegacyMode = 28;
                poMap.bStrictScopeMode = true;
            } else {
                ArrayList<String> pis = new ArrayList<String>();
                templateModel.getPI("acrobat", "JavaScript", pis, false);
                for (int i = 0; i < pis.size(); ++i) {
                    if (!((String)pis.get(i)).trim().equals("strictScoping")) continue;
                    poMap.bStrictScopeMode = true;
                    break;
                }
            }
            if (!poMap.bStrictScopeMode) {
                poMap.nLegacyMode = 21;
            }
        }
    }

    public XFAObjectMapImpl getObjectMap(AppModel poAppModel, boolean create) {
        XFAObjectMapImpl pRet = this.xfaObjectMaps.get(poAppModel);
        if (pRet != null) {
            if (!pRet.bLegacyModeSet) {
                this.getScriptMode(poAppModel, pRet);
            }
            return pRet;
        }
        if (create && poAppModel != null) {
            XFAObjectMapImpl pNewMapImpl = new XFAObjectMapImpl();
            pNewMapImpl.poMap = new IdentityHashMap();
            pNewMapImpl.appModelESObj = null;
            pNewMapImpl.bLegacyModeSet = false;
            pNewMapImpl.bStrictScopeMode = false;
            pNewMapImpl.nLegacyMode = 21;
            this.getScriptMode(poAppModel, pNewMapImpl);
            this.xfaObjectMaps.put(poAppModel, pNewMapImpl);
            return pNewMapImpl;
        }
        return null;
    }

    public GibsonLiveObject createXFAObject(JavaScriptHandler handler, Obj poObjectImpl, boolean bIsScriptObject, boolean bContextNode, AppModel poAppModelImpl) {
        GibsonLiveObject esoXFA = null;
        XFAObjectMapImpl pObjectMap = this.getObjectMap(poAppModelImpl, true);
        if (bIsScriptObject) {
            esoXFA = new GibsonLiveObject(handler, poObjectImpl, poAppModelImpl);
            if (pObjectMap.nLegacyMode < 28) {
                this.ESObjectSetGetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Get);
                this.ESObjectSetSetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Set);
                this.ESRegisterPropResolve(esoXFA, GibsonLiveObject.XFAObjectProc.Resolve);
            } else {
                this.ESObjectSetGetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Resolve28);
            }
        } else {
            boolean bStrictScoping = false;
            if (poObjectImpl != poAppModelImpl && pObjectMap.bStrictScopeMode) {
                bStrictScoping = true;
            }
            if (pObjectMap.nLegacyMode >= 28 && poObjectImpl.isSameClass(XFA.SCRIPTTAG)) {
                bStrictScoping = false;
            }
            if (bContextNode && bStrictScoping && pObjectMap.nLegacyMode >= 28) {
                esoXFA = new GibsonLiveObject(handler, poObjectImpl, poAppModelImpl);
                this.ESRegisterPropResolve(esoXFA, GibsonLiveObject.XFAObjectProc.Resolve28);
            } else {
                esoXFA = this.findESObjectInMap(poObjectImpl, poAppModelImpl);
                if (esoXFA != null) {
                    return esoXFA;
                }
                esoXFA = new GibsonLiveObject(handler, poObjectImpl, poAppModelImpl);
                this.addXFAObjectToMap(poObjectImpl, esoXFA, poAppModelImpl);
                if (pObjectMap.nLegacyMode < 28 || !bStrictScoping) {
                    this.ESObjectSetGetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Get);
                    this.ESObjectSetSetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Set);
                    this.ESRegisterPropResolve(esoXFA, GibsonLiveObject.XFAObjectProc.Resolve);
                } else {
                    this.ESObjectSetGetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Get28);
                    this.ESObjectSetSetProc(esoXFA, GibsonLiveObject.XFAObjectProc.Set28);
                }
            }
        }
        this.createScriptObject(poObjectImpl);
        return esoXFA;
    }

    private GibsonLiveObject findESObjectInMap(Obj poXFAObjectImpl, AppModel poAppModel) {
        XFAObjectMapImpl poMapImpl = this.getObjectMap(poAppModel, false);
        if (poMapImpl != null) {
            if (poXFAObjectImpl == poAppModel && poMapImpl.appModelESObj != null) {
                return poMapImpl.appModelESObj;
            }
            if (poMapImpl.poMap != null) {
                return (GibsonLiveObject)((Object)poMapImpl.poMap.get(poXFAObjectImpl));
            }
        }
        return null;
    }

    private void addXFAObjectToMap(Obj poXFAObjectImpl, GibsonLiveObject eso, AppModel poAppModel) {
        XFAObjectMapImpl poMapImpl = this.getObjectMap(poAppModel, true);
        if (poMapImpl != null) {
            if (poXFAObjectImpl == poAppModel) {
                poMapImpl.appModelESObj = eso;
            }
            if (poMapImpl.poMap != null) {
                poMapImpl.poMap.put(poXFAObjectImpl, eso);
            }
        }
    }

    @Override
    public void removeReference(Node poNodeImpl) {
        if (poNodeImpl != null) {
            XFAObjectMapImpl poMap = this.getObjectMap(poNodeImpl.getOwnerDocument().getAppModel(), false);
            if (poMap != null) {
                poMap.poMap.remove(poNodeImpl);
            }
            for (Node oNext = poNodeImpl.getFirstXMLChild(); oNext != null; oNext = oNext.getNextXMLSibling()) {
                this.removeReference(oNext);
            }
        }
    }

    private void ESObjectSetSetProc(GibsonLiveObject esoXFA, GibsonLiveObject.XFAObjectProc setPropProc) {
        esoXFA.setSetPropProc(setPropProc);
    }

    private void ESObjectSetGetProc(GibsonLiveObject esoXFA, GibsonLiveObject.XFAObjectProc getPropProc) {
        esoXFA.setGetPropProc(getPropProc);
    }

    private void ESRegisterPropResolve(GibsonLiveObject esoXFA, GibsonLiveObject.XFAObjectProc resolvePropProc) {
        esoXFA.setResolvePropProc(resolvePropProc);
    }

    @Override
    public void executeOrSyntaxCheck(String script, Arg returnCode, int eReason, boolean syntaxCheckOnly, String locale) {
        if (!(this.moDocContext.getAllowFormUpdate() && this.moDocContext.getProcessingOptions().scriptExecutionEnabled() && this.moDocContext.getProcessingOptions().acrobatJavaScriptExecutionEnabled())) {
            if (eReason == 2) {
                returnCode.setBool(true);
            } else {
                ExFull oException = new ExFull(ResId.OPERATION_CANCELLED);
                returnCode.setException(oException);
            }
            return;
        }
        EventObject esoEvent = JSUtils.setEventTargetToDoc(this.getAcrobatJSHandler());
        this.convertTrigger(eReason, esoEvent);
        try {
            this.execute(script, returnCode, eReason, syntaxCheckOnly);
        }
        catch (ExFull oException) {
            try {
                if (oException.getMessage() != null) {
                    throw new ExFull(oException.getMessage() + "\n" + oException.toString(), ResId.ScriptHandlerError);
                }
                throw new ExFull(oException.toString(), ResId.ScriptHandlerError);
            }
            catch (Throwable throwable) {
                oException.resolve();
                throw throwable;
            }
        }
        this.moDocContext.contentChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sScript, Arg oReturnCode, int eReason, boolean bSyntaxCheckOnly) {
        this.clearError();
        int nScriptID = -1;
        ScriptDebugger oDebugger = this.getDebugger();
        if (oDebugger != null) assert (false);
        String oScriptID = "";
        if (oDebugger != null) {
            oScriptID = "#" + nScriptID;
        }
        Script oScript = null;
        Context ctx = this.getAcrobatJSHandler().getContextFactory().enterContext();
        ctx.setOptimizationLevel(0);
        try {
            boolean bSuccess;
            try {
                if (!compiledScriptMap.containsKey(sScript)) {
                    if (compiledScriptMap.size() == 4096) {
                        compiledScriptMap.clear();
                    }
                    oScript = ctx.compileString(sScript, oScriptID, 1, null);
                    compiledScriptMap.put(sScript, oScript);
                } else {
                    oScript = compiledScriptMap.get(sScript);
                }
            }
            catch (RhinoException oError) {
                this.setError((Exception)((Object)oError));
            }
            boolean bl = bSuccess = oScript != null;
            if (oScript != null && !bSyntaxCheckOnly) {
                if (oDebugger != null) {
                    assert (false);
                } else {
                    bSuccess = false;
                    try {
                        GibsonXFALevelScope topScope;
                        this.xfaTopScope = topScope = new GibsonXFALevelScope(this, this.moDocContext.moAppModel);
                        topScope.setParentScope(null);
                        topScope.setPrototype((Scriptable)this.getAcrobatJSHandler().getDocLevelScope());
                        Object oResult = oScript.exec(ctx, (Scriptable)this.xfaTopScope);
                        if (!(oResult instanceof Undefined)) {
                            oReturnCode.assign(this.variantToArg(oResult));
                            bSuccess = true;
                        }
                    }
                    catch (RhinoException f) {
                        this.setError((Exception)((Object)f));
                    }
                    catch (ExFull g) {
                        this.setError(g);
                    }
                }
            }
            if (!bSuccess) {
                StringBuilder sError;
                Exception error = this.getError();
                String sErrorText = null;
                if (error instanceof JavaScriptException) {
                    sError = new StringBuilder(((JavaScriptException)error).getMessage());
                    sErrorText = sError.toString();
                } else if (error instanceof WrappedException) {
                    sError = new StringBuilder(((WrappedException)error).getMessage());
                    String sRhinoPrefix = "Wrapped ";
                    int nErrorPrefix = sError.indexOf("Wrapped ");
                    if (nErrorPrefix >= 0) {
                        sError.replace(0, nErrorPrefix + "Wrapped ".length(), "");
                    }
                    String sRhinoSuffix = "\n (#";
                    int nLineNumberSuffix = sError.indexOf("\n (#");
                    if (nLineNumberSuffix >= 0) {
                        sError.delete(nLineNumberSuffix + 1, sError.length());
                    }
                    if (sError.charAt(sError.length() - 1) == '\n') {
                        sError.setLength(sError.length() - 1);
                    }
                    sErrorText = sError.toString();
                } else if (error instanceof RhinoException) {
                    sError = new StringBuilder(((RhinoException)((Object)error)).getMessage());
                    String sRhinoPrefix = "Error: ";
                    int nErrorPrefix = sError.indexOf("Error: ");
                    if (nErrorPrefix >= 0) {
                        sError.delete(0, nErrorPrefix + "Error: ".length());
                    }
                    sErrorText = sError.toString();
                    int nErrorLine = ((RhinoException)((Object)error)).lineNumber();
                    if (bSyntaxCheckOnly) {
                        MsgFormat oFmt = new MsgFormat(ResId.ScriptHandlerError, sErrorText);
                        ScriptHandler.ScriptException oScriptEx = new ScriptHandler.ScriptException(oFmt, nErrorLine, 8);
                        throw oScriptEx;
                    }
                } else if (error instanceof ExFull) {
                    sErrorText = error.toString();
                }
                if (sErrorText != null) {
                    Arg arg = this.variantToArg(sErrorText);
                    oReturnCode.assign(arg);
                    throw new ExFull(new MsgFormat(ResId.ScriptHandlerError, sErrorText));
                }
            }
            if (bSyntaxCheckOnly) {
                return;
            }
            if (oDebugger != null) assert (false);
        }
        finally {
            if (null != Context.getCurrentContext()) {
                Context.exit();
            }
        }
    }

    public GibsonLiveObject newLiveObject(JavaScriptHandler handler, Obj xfaObject, AppModel moAppModel) {
        return this.createXFAObject(handler, xfaObject, false, false, moAppModel);
    }

    private void convertTrigger(int eReason, EventObject esoEvent) {
        JSUtils.ESTriggerType asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_EXTERNAL_STR;
        JSUtils.ESTrigger asaKeyName = JSUtils.ESTrigger.ESTRIGGER_EXEC_STR;
        switch (eReason) {
            case 0: {
                break;
            }
            case 1: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_CALCULATE_STR;
                break;
            }
            case 2: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_VALIDATE_STR;
                break;
            }
            case 3: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_INIT_STR;
                break;
            }
            case 23: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_FOCUS_STR;
                break;
            }
            case 24: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_BLUR_STR;
                break;
            }
            case 25: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_MOUSEENTER_STR;
                break;
            }
            case 26: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_MOUSEEXIT_STR;
                break;
            }
            case 27: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_KEYSTROKE_STR;
                break;
            }
            case 28: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_MOUSEUP_STR;
                break;
            }
            case 4: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_WILLSAVE_STR;
                break;
            }
            case 5: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_DIDSAVE_STR;
                break;
            }
            case 6: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_WILLPRINT_STR;
                break;
            }
            case 7: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_DIDPRINT_STR;
                break;
            }
            case 8: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
            case 29: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_KEYSTROKE_STR;
                break;
            }
            case 9: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
            case 10: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_CLOSE_STR;
                break;
            }
            case 30: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_MOUSEUP_STR;
                break;
            }
            case 31: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_MOUSEDOWN_STR;
                break;
            }
            case 11: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_WILLSAVE_STR;
                break;
            }
            case 12: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_WILLSAVE_STR;
                break;
            }
            case 13: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
            case 14: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
            case 17: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_WILLSAVE_STR;
                break;
            }
            case 18: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
            case 19: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
            case 20: {
                asaKeyType = JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR;
                asaKeyName = JSUtils.ESTrigger.ESTRIGGER_OPEN_STR;
                break;
            }
        }
        esoEvent.setType(asaKeyType.getValue());
        esoEvent.setName(asaKeyName.getValue());
    }

    public GibsonLiveObject getAppModelLiveObject() {
        return this.findESObjectInMap(this.getAppModel(), this.getAppModel());
    }

    public Arg variantToArg(Object variant) {
        Arg arg = new Arg();
        if (variant == null) {
            arg.setNull();
        } else if (variant instanceof Undefined) {
            arg.empty();
        } else if (variant instanceof Boolean) {
            arg.setBool((boolean)((Boolean)variant));
        } else if (variant instanceof Integer) {
            arg.setInteger((int)((Integer)variant));
        } else if (variant instanceof Double) {
            arg.setDouble(new Double((Double)variant));
        } else if (variant instanceof String) {
            arg.setString((String)variant);
        } else if (variant instanceof GibsonLiveObject) {
            arg.setObject(((GibsonLiveObject)((Object)variant)).getXFAObject());
        } else {
            arg.setVoid(variant);
        }
        return arg;
    }

    public Object argToVariant(Arg arg, AppModel moAppModel) {
        Object variant = null;
        switch (arg.getArgType()) {
            case 1: {
                variant = Undefined.instance;
                break;
            }
            case 2: {
                variant = null;
                break;
            }
            case 3: {
                variant = (boolean)arg.getBool();
                break;
            }
            case 4: {
                variant = (int)arg.getInteger();
                break;
            }
            case 5: {
                variant = new Double(arg.getDouble(false));
                break;
            }
            case 6: {
                String inStr = arg.getString();
                if (inStr == null) {
                    variant = inStr;
                    break;
                }
                byte[] utf16Value = UTF16Support.toUTF16(inStr);
                int numChars = utf16Value.length + Math.max(utf16Value.length / 8, 1);
                char[] result = new char[numChars];
                EncodedData<char[]> encInfo = new EncodedData<char[]>(Encoding.Unicode, numChars, result);
                PDFDocEncoding.convertUTF16ToPDFDocEncoding(utf16Value, encInfo);
                int outByteSize = encInfo.getEncodedDataLength() * 2;
                byte[] textOut = new byte[outByteSize];
                EncodedData<byte[]> outEncInfo = new EncodedData<byte[]>(Encoding.Unicode, outByteSize, textOut);
                PDFDocEncoding.encToUCSStrInternal(encInfo, outEncInfo);
                try {
                    variant = new String(textOut, 0, outEncInfo.getEncodedDataLength(), "UTF-16");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            case 7: {
                Obj oObj = arg.getObject();
                if (oObj == null) {
                    variant = null;
                    break;
                }
                GibsonLiveObject oXFALiveObject = this.newLiveObject(this, oObj, moAppModel);
                variant = oXFALiveObject;
                break;
            }
            case 8: {
                throw new EvaluatorException(arg.getException().toString());
            }
            default: {
                assert (false);
                break;
            }
        }
        return variant;
    }

    private void createScriptObject(Obj object) {
        TextNode oText;
        Element oNode;
        Element oParent;
        if (object.isSameClass(XFA.SCRIPTTAG) && (oParent = (oNode = (Element)object).getXFAParent()) != null && oParent.isSameClass(XFA.VARIABLESTAG) && (oText = (TextNode)oNode.getProperty(XFA.TEXTNODETAG, 0)) != null) {
            String sScript = oText.getValue();
            this.compileObject(object, sScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileObject(Obj object, String sScript) {
        this.clearError();
        Script oScript = null;
        Context ctx = Context.getCurrentContext();
        int nLevel = ctx.getOptimizationLevel();
        try {
            ctx.setOptimizationLevel(-1);
            if (!compiledScriptMap.containsKey(sScript)) {
                if (compiledScriptMap.size() == 4096) {
                    compiledScriptMap.clear();
                }
                oScript = ctx.compileString(sScript, null, 1, null);
                compiledScriptMap.put(sScript, oScript);
            } else {
                oScript = compiledScriptMap.get(sScript);
            }
        }
        catch (RhinoException oError) {
            this.setError((Exception)((Object)oError));
        }
        finally {
            ctx.setOptimizationLevel(nLevel);
        }
        boolean bSuccess = oScript != null;
        boolean bRet = false;
        if (!bSuccess) {
            String sError = "";
            Exception error = this.getError();
            if (error instanceof RhinoException) {
                sError = ((RhinoException)((Object)error)).getMessage();
            }
            throw new ExFull(new MsgFormat(ResId.ScriptHandlerError, sError));
        }
        GibsonLiveObject liveObject = this.findESObjectInMap(object, this.getAppModel());
        ScriptObject oScriptObj = new ScriptObject(oScript);
        liveObject.setScriptObject(oScriptObj);
        bRet = true;
        return bRet;
    }

    @Override
    protected void clearExecutionContexts() {
        this.xfaObjectMaps.clear();
        if (null != Context.getCurrentContext()) {
            Context.exit();
        }
    }

    public GibsonXFALevelScope getXFALevelScope() {
        return this.xfaTopScope;
    }

    public class XFAObjectMapImpl {
        private IdentityHashMap<Obj, GibsonLiveObject> poMap;
        private GibsonLiveObject appModelESObj;
        private boolean bStrictScopeMode;
        private int nLegacyMode;
        private boolean bLegacyModeSet;

        public boolean bStrictScopeMode() {
            return this.bStrictScopeMode;
        }
    }
}

