/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler;

import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.xfa.impl.JavaScriptHandler;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ut.ExFull;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class GibsonXFALevelScope
extends ScriptableObject {
    private static final long serialVersionUID = 1853010678358666589L;
    private static final String EVENT = "event";
    private static final String CLASSNAME = "GibsonXFALevelScope";
    private static final Map<String, Object> mStandardObjects;
    private static final Method mInvokeMethod;
    private transient AppModel moAppModel;
    private transient JavaScriptHandler moHandler;

    public GibsonXFALevelScope(Object oHandler, Obj oXFAObject) {
        assert (oHandler instanceof JavaScriptHandler);
        this.moHandler = (JavaScriptHandler)oHandler;
        assert (oXFAObject instanceof AppModel);
        this.moAppModel = (AppModel)oXFAObject;
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public Object get(String name, Scriptable start) {
        if (EVENT.equals(name)) {
            return this.moHandler.getAcrobatJSHandler().getDocLevelScope().get(name, start);
        }
        if (name.equals("XFAObject")) {
            return Undefined.instance;
        }
        if (!mStandardObjects.containsKey(name)) {
            if (name.equals("xfa")) {
                return this.moHandler.getAppModelLiveObject();
            }
            if (this.moAppModel != null) {
                try {
                    ScriptFuncObj scriptFuncObj = this.moAppModel.getContext().getScriptMethodInfo(name);
                    if (scriptFuncObj != null && !this.moAppModel.getContext().validateUsageFailedIsFatal(scriptFuncObj.getXFAVersion(), scriptFuncObj.getAvailability())) {
                        return new FunctionObject(name, (Member)mInvokeMethod, (Scriptable)this);
                    }
                    Object obj = super.get(name, start);
                    if (obj != Scriptable.NOT_FOUND) {
                        return obj;
                    }
                    SOMParser oParser = new SOMParser(null);
                    ArrayList<SOMParser.SomResultInfo> oResult = new ArrayList<SOMParser.SomResultInfo>();
                    oParser.resolve(this.moAppModel.getContext(), name, oResult);
                    if (oResult.size() == 1) {
                        return this.moHandler.argToVariant(((SOMParser.SomResultInfo)oResult.get((int)0)).value, this.moAppModel);
                    }
                }
                catch (ExFull oEx) {
                    this.moHandler.throwError(oEx);
                }
            }
        }
        return Scriptable.NOT_FOUND;
    }

    public void put(String name, Scriptable start, Object value) {
        if (EVENT.equals(name)) {
            Doc gibsonScope = this.moHandler.getAcrobatJSHandler().getDocLevelScope();
            gibsonScope.put(name, (Scriptable)gibsonScope, value);
        } else {
            block6: {
                if (name.equals("XFAObject")) {
                    return;
                }
                if (!(value instanceof IdFunctionObject) && !mStandardObjects.containsKey(name) && this.moAppModel != null) {
                    try {
                        this.moAppModel.getContext().setScriptProperty(name, this.moHandler.variantToArg(value), false);
                        return;
                    }
                    catch (ExFull oEx) {
                        if (oEx.firstResId() != 0) break block6;
                        this.moHandler.throwError(oEx);
                    }
                }
            }
            super.put(name, start, value);
        }
    }

    public static Object invoke(Context cx, Scriptable obj, Object[] args, Function func) {
        GibsonXFALevelScope oThis = (GibsonXFALevelScope)obj;
        try {
            DependencyTracker oDependencyTracker = oThis.moHandler.getAppModel().dependencyTracker();
            Arg oRetVal = new Arg();
            String sFunctionName = ((FunctionObject)func).getFunctionName();
            Arg[] oArgs = new Arg[args.length];
            for (int i = 0; i < args.length; ++i) {
                oArgs[i] = oThis.moHandler.variantToArg(args[i]);
            }
            oThis.moAppModel.getContext().invokeFunction(oRetVal, sFunctionName, oArgs, oDependencyTracker, false);
            ScriptDebugger oDebugger = oThis.moHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.resolvedValue(sFunctionName, oRetVal);
            }
            return oThis.moHandler.argToVariant(oRetVal, oThis.moAppModel);
        }
        catch (ExFull oEx) {
            oThis.moHandler.throwError(oEx);
            return Undefined.instance;
        }
    }

    static {
        Method m;
        block2: {
            mStandardObjects = new HashMap<String, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("Infinity", null);
                    this.put("NaN", null);
                    this.put("Math", null);
                    this.put("Output", null);
                    this.put("StopIteration", null);
                    this.put("undefined", null);
                }
            };
            m = null;
            try {
                m = GibsonXFALevelScope.class.getMethod("invoke", Context.class, Scriptable.class, Object[].class, Function.class);
            }
            catch (NoSuchMethodException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        mInvokeMethod = m;
    }
}

