/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CBarcodeField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CButtonField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CComboField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CLstBxField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFieldEnumProc;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CRadioField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CSigField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CTextField;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CPDFields {
    private boolean m_bIsDead = false;
    private PDFDocument m_pdForm;
    private boolean m_bLoaded;
    private boolean m_bInEnumCPDFields;
    private LinkedHashMap<String, CPDField> m_mapEStr2Fld = new LinkedHashMap();
    private Map<Integer, CPDField> m_mapCosHash2Fld = new HashMap<Integer, CPDField>();
    static final int kRadioButton = 32768;
    static final int kPushButton = 65536;

    CPDFields(PDFDocument pdd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.m_pdForm = pdd;
        this.m_bLoaded = false;
        String esRoot = "";
        CPDField pRootCPDFld = new CPDField(this, null, esRoot);
        this.m_mapEStr2Fld.put(esRoot, pRootCPDFld);
        this.m_bInEnumCPDFields = false;
    }

    boolean isDead() {
        return this.m_bIsDead;
    }

    public PDFDocument getPDDoc() {
        return this.m_pdForm;
    }

    public boolean enumCPDFields(boolean bTerminalsOnly, CPDFieldEnumProc proc, Object clientData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        return this.enumCPDFields(bTerminalsOnly, proc, clientData, null, false, true);
    }

    boolean enumCPDFields(boolean bTerminalsOnly, CPDFieldEnumProc proc, Object clientData, CPDField pPrevCPDFld, boolean bIncludeRoot, boolean bLoadCWidgets) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (this.m_bInEnumCPDFields) {
            return false;
        }
        this.m_bInEnumCPDFields = true;
        this.loadAllCPDFields(bLoadCWidgets);
        Iterator<Map.Entry<String, CPDField>> iter = this.m_mapEStr2Fld.entrySet().iterator();
        if (pPrevCPDFld != null) {
            Map.Entry<String, CPDField> val;
            while (iter.hasNext() && (val = iter.next()).getKey() != pPrevCPDFld.getName()) {
            }
        } else if (!bIncludeRoot && iter.hasNext()) {
            iter.next();
        }
        while (iter.hasNext()) {
            CPDField pCPDFld = iter.next().getValue();
            if (bTerminalsOnly && !pCPDFld.isTerminal()) continue;
            boolean bRet = false;
            try {
                bRet = proc.invoke(pCPDFld, clientData);
            }
            catch (PDFSecurityException e) {
                this.m_bInEnumCPDFields = false;
                throw e;
            }
            if (bRet) continue;
            this.m_bInEnumCPDFields = false;
            return false;
        }
        this.m_bInEnumCPDFields = false;
        return true;
    }

    private void loadAllCPDFields(boolean bLoadCWidgets) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (!this.m_bLoaded) {
            PDFInteractiveForm coAF = this.m_pdForm.getInteractiveForm();
            if (coAF != null) {
                this.recursivelyGenerateCPDFields(null, coAF.getDictionaryArrayValue(ASName.k_Fields), bLoadCWidgets);
            }
            this.m_bLoaded = true;
        }
    }

    private void recursivelyGenerateCPDFields(CPDField pParent, CosArray coFlds, boolean bLoadCWidgets) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (coFlds != null) {
            int nFlds = coFlds.size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pParentR;
                CosDictionary coFld = (CosDictionary)coFlds.get(i);
                CosObject coT = coFld.get(ASName.k_T);
                if (coT == null || coT.getType() != 4) continue;
                String cesT = ((CosString)coT).asString();
                if (pParent != null) {
                    String cesFull = pParent.getName();
                    cesFull = cesFull + ".";
                    cesT = cesFull = cesFull + cesT;
                }
                if ((pParentR = this.loadOneCPDField(cesT, coFld, bLoadCWidgets)) == null) continue;
                this.recursivelyGenerateCPDFields(pParentR, coFld.getCosArray(ASName.k_Kids), bLoadCWidgets);
            }
        }
    }

    private CPDField loadOneCPDField(String esFldName, CosDictionary coFld, boolean bLoadCWidgets) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        CPDField pCPDFld = this.m_mapEStr2Fld.get(esFldName);
        if (pCPDFld == null) {
            String es = esFldName;
            CosObject coFT = AFUtils.AFCosObjInheritedValue(coFld, ASName.k_FT, false);
            if (coFT != null && coFT.getType() == 3) {
                ASName asaType = ((CosName)coFT).nameValue();
                if (asaType == ASName.k_Tx) {
                    CosArray coKids;
                    boolean bBarcodeDetected = false;
                    if (coFld.get(ASName.k_PMD) != null) {
                        bBarcodeDetected = true;
                    } else if (coFld.get(ASName.create("DataPrep")) != null && (coKids = coFld.getCosArray(ASName.k_Kids)) != null) {
                        CosDictionary coPMD;
                        CosDictionary coEntry = coKids.getCosDictionary(0);
                        if (coEntry != null && (coPMD = coEntry.getCosDictionary(ASName.k_PMD)) != null) {
                            bBarcodeDetected = true;
                        }
                        assert (bBarcodeDetected);
                    }
                    pCPDFld = bBarcodeDetected ? new CBarcodeField(this, PDFFieldNode.getInstance(coFld, true), es) : new CTextField(this, PDFFieldNode.getInstance(coFld, true), es);
                } else if (asaType == ASName.k_Sig) {
                    pCPDFld = new CSigField(this, PDFFieldNode.getInstance(coFld, true), es);
                } else {
                    CosObject coFlags = AFUtils.AFCosObjInheritedValue(coFld, ASName.k_Ff, false);
                    int nFlags = 0;
                    if (coFlags != null && coFlags.getType() == 1) {
                        nFlags = coFlags.intValue();
                    }
                    if (asaType == ASName.k_Btn) {
                        pCPDFld = (nFlags & 0x10000) > 0 ? new CButtonField(this, PDFFieldNode.getInstance(coFld, true), es) : ((nFlags & 0x8000) > 0 ? new CRadioField(this, PDFFieldNode.getInstance(coFld, true), es) : new CChkBxField(this, PDFFieldNode.getInstance(coFld, true), es));
                    } else if (asaType == ASName.k_Ch) {
                        pCPDFld = (nFlags & 0x20000) > 0 ? new CComboField(this, PDFFieldNode.getInstance(coFld, true), es) : new CLstBxField(this, PDFFieldNode.getInstance(coFld, true), es);
                    }
                }
                if (pCPDFld != null && bLoadCWidgets) {
                    int nWidgets = pCPDFld.getNumWidgets();
                    for (int iWidget = 0; iWidget < nWidgets; ++iWidget) {
                        pCPDFld.getWidget(iWidget);
                    }
                }
            } else {
                pCPDFld = this.isFieldTerminal(coFld) ? null : new CPDField(this, PDFFieldNode.getInstance(coFld, true), es);
            }
            if (pCPDFld != null) {
                this.m_mapEStr2Fld.put(es, pCPDFld);
                this.m_mapCosHash2Fld.put(coFld.getObjNum(), pCPDFld);
                pCPDFld.postConstructionHeavyDutyWork();
            }
        }
        return pCPDFld;
    }

    private boolean isFieldTerminal(CosDictionary coFld) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean isTerminal = false;
        if (coFld != null) {
            int nArrayLen;
            CosObject coChildren = coFld.get(ASName.k_Kids);
            boolean bIsArray = coChildren != null && coChildren.getType() == 5;
            int n = nArrayLen = bIsArray ? ((CosArray)coChildren).size() : 0;
            if (bIsArray && nArrayLen > 0) {
                CosDictionary coChild = ((CosArray)coChildren).getCosDictionary(0);
                if (coChild.get(ASName.k_T).getType() != 4 && coChild.getName(ASName.k_Subtype) == ASName.k_Widget) {
                    isTerminal = true;
                }
            } else if (coFld.get(ASName.k_Subtype) != null && coFld.getName(ASName.k_SubType) == ASName.k_Widget) {
                isTerminal = true;
            }
        } else assert (false);
        return isTerminal;
    }

    CPDField getRootCPDField() {
        return this.m_mapEStr2Fld.values().iterator().next();
    }

    private String assembleFullFieldNameFromCos(CosDictionary coFld) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject coT;
        String esFull = null;
        CosObject coParent = coFld.get(ASName.k_Parent);
        if (coParent != null && coParent.getType() == 6) {
            esFull = this.assembleFullFieldNameFromCos((CosDictionary)coParent);
        }
        if ((coT = coFld.get(ASName.k_T)) != null && coT.getType() == 4) {
            String cesT = ((CosString)coT).textValue();
            if (esFull != null) {
                String cesFull = esFull;
                cesFull = cesFull + ".";
                esFull = cesFull = cesFull + cesT;
            } else {
                esFull = cesT;
            }
        }
        return esFull;
    }

    public CPDField getCPDField(String somExpr) {
        try {
            CPDField cpdField = this.m_mapEStr2Fld.get(somExpr);
            if (cpdField == null && !this.m_bLoaded) {
                this.loadAllCPDFields(true);
                return this.getCPDField(somExpr);
            }
            return cpdField;
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new RuntimeException(e);
        }
        catch (PDFFontException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public CPDField getCPDField(CosDictionary coFld, boolean bNullIfDeleted) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (bNullIfDeleted && coFld.containsKey(ASName.create("renaming"))) {
            return null;
        }
        if (bNullIfDeleted && coFld.containsKey(ASName.create("removed"))) {
            return null;
        }
        if (coFld.get(ASName.k_T) == null) {
            CosObject coParent = coFld.get(ASName.k_Parent);
            if (coParent.getType() == 6) {
                return this.getCPDField((CosDictionary)coParent, true);
            }
            return null;
        }
        CPDField pCPDFld = this.m_mapCosHash2Fld.get(coFld.getObjNum());
        if (pCPDFld == null) {
            String esFldName = this.assembleFullFieldNameFromCos(coFld);
            if (esFldName == null) {
                return null;
            }
            pCPDFld = this.loadOneCPDField(esFldName, coFld, false);
        } else if (pCPDFld.getCosObject() != coFld) {
            String esFldName = this.assembleFullFieldNameFromCos(coFld);
            if (esFldName == null) {
                return null;
            }
            pCPDFld = this.loadOneCPDField(esFldName, coFld, false);
        }
        return pCPDFld;
    }
}

