/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;

public class XFADOMService {
    public static boolean isXFADOMCreated(PDFDocument pdfDoc) {
        XFADOMServiceListener xfaDOMServiceListener = XFAInternalUtils.getXFADOMServiceListener(pdfDoc);
        return xfaDOMServiceListener != null ? xfaDOMServiceListener.getXFADOM() != null : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XFADOM getXFADOM(PDFDocument pdfDoc, XFAProcessingOptions xfaProcessingOptions, boolean isRollbackDoc, DocModAnalyzerParams.DocModAnalysisMode docMDPSetting, boolean useCachedDOM) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFADOMServiceListener xfaDOMServiceListener = XFADOMService.procureXFADOMServiceListener(pdfDoc, xfaProcessingOptions, !useCachedDOM);
        XFADOM cachedXFADOM = xfaDOMServiceListener.getXFADOM();
        XFADOM xfaDOM = null;
        if (xfaProcessingOptions == null) {
            xfaProcessingOptions = new XFAProcessingOptions(false, false);
        }
        if (cachedXFADOM != null && useCachedDOM) {
            if (!xfaProcessingOptions.createFormDOMEnabled()) {
                return cachedXFADOM;
            }
            if (cachedXFADOM.formModelExists()) {
                return cachedXFADOM;
            }
        }
        if (xfaProcessingOptions.createFormDOMEnabled()) {
            DocumentContext docContext = null;
            if (cachedXFADOM != null && useCachedDOM) {
                cachedXFADOM.savePacketsDirtyState();
                try {
                    docContext = XFADOMService.createXFADocumentContext(pdfDoc, isRollbackDoc, docMDPSetting, xfaProcessingOptions);
                }
                finally {
                    cachedXFADOM.restorePacketsDirtyState();
                }
                cachedXFADOM.setFormModel(FormModel.getFormModel(cachedXFADOM.getAppModel(), false));
                xfaDOM = cachedXFADOM;
            } else {
                xfaDOMServiceListener.setXFADOM(null);
                docContext = XFADOMService.createXFADocumentContext(pdfDoc, isRollbackDoc, docMDPSetting, xfaProcessingOptions);
                xfaDOM = new XFADOM(pdfDoc, docContext);
            }
            if (XFAService.getDocumentType(pdfDoc).isDynamic()) {
                docContext.iterateAndProtectFieldMDPFields();
            }
        } else {
            try {
                xfaDOM = new XFADOM(pdfDoc);
            }
            catch (PDFInvalidXMLException e) {
                throw new PDFInvalidDocumentException("Could not create an XFADOM", e);
            }
        }
        if (xfaProcessingOptions.xfaDOMCachingEnabled()) {
            xfaDOMServiceListener.setXFADOM(xfaDOM);
        }
        xfaDOMServiceListener.setXfaOptions(xfaProcessingOptions);
        return xfaDOM;
    }

    public static XFADOM getXFADOM(PDFDocument pdfDoc, XFAProcessingOptions xfaProcessingOptions, boolean isRollbackDoc, boolean useCachedDOM) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return XFADOMService.getXFADOM(pdfDoc, xfaProcessingOptions, isRollbackDoc, DocModAnalyzerParams.DocModAnalysisMode.MDPAllowDefaultPlusComments, useCachedDOM);
    }

    public static XFADOM getXFADOMFromCache(PDFDocument pdfDoc) {
        XFADOMServiceListener xfaDOMServiceListener = XFAInternalUtils.getXFADOMServiceListener(pdfDoc);
        return xfaDOMServiceListener != null ? xfaDOMServiceListener.getXFADOM() : null;
    }

    public static void holdXFADOMWeakly(PDFDocument pdfDoc) {
        pdfDoc.getListenerRegistry().holdStrongly(XFADOMServiceListener.class, false);
    }

    public static XFADOM getXFADOM(PDFDocument pdfDoc, XFAProcessingOptions xfaProcessingOptions) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return XFADOMService.getXFADOM(pdfDoc, xfaProcessingOptions, false, true);
    }

    public static void releaseCachedXFADOM(PDFDocument pdfDoc) {
        pdfDoc.getListenerRegistry().deregisterListener(XFADOMServiceListener.class);
        XFAPlugin.docClose(pdfDoc);
    }

    public static XFADOMServiceListener procureXFADOMServiceListener(PDFDocument pdfDocument, XFAProcessingOptions xfaProcessingOptions, boolean forceCreate) {
        DocumentListenerRegistry registry = pdfDocument.getListenerRegistry();
        XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
        if (serviceListener == null || forceCreate) {
            serviceListener = new XFADOMServiceListener(pdfDocument, null, xfaProcessingOptions);
        }
        return serviceListener;
    }

    static boolean isDocCertified(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalog = pdfDoc.requireCatalog();
        PDFPermissions perms = catalog.getPermissions();
        if (perms != null) {
            return perms.dictionaryContains(ASName.k_DocMDP);
        }
        return false;
    }

    protected static DocumentContext createXFADocumentContext(PDFDocument pdfDoc, boolean isRollbackDoc, DocModAnalyzerParams.DocModAnalysisMode docMDPSetting, XFAProcessingOptions xfaProcessingOptions) throws PDFInvalidDocumentException {
        DocumentContext oContext = null;
        BooleanHolder bContextCreated = new BooleanHolder(false);
        try {
            XFAPlugin.docPermsReady(pdfDoc);
            oContext = DocumentContext.find(pdfDoc, false, bContextCreated);
            if (oContext != null) {
                oContext.isRollbackDoc(isRollbackDoc);
                oContext.setMDPSetting(docMDPSetting);
                oContext.setProcessingOptions(xfaProcessingOptions);
                XFAPlugin.processXFA(pdfDoc);
                return oContext;
            }
            return null;
        }
        catch (ExFull e) {
            try {
                if (oContext != null && bContextCreated.value) {
                    oContext.destroy();
                }
            }
            catch (ExFull f) {
                // empty catch block
            }
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static XFAProcessingOptions getXFAProcessingOptions(PDFDocument pdfDoc) {
        XFADOMServiceListener xfaDOMServiceListener = XFAInternalUtils.getXFADOMServiceListener(pdfDoc);
        return xfaDOMServiceListener != null ? xfaDOMServiceListener.getXFAProcessingOptions() : null;
    }

    public static XFADOM ensureXFADOMCreated(PDFDocument pdfDoc) throws PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException {
        XFADOM xfaDOM = XFADOMService.getXFADOMFromCache(pdfDoc);
        if (xfaDOM == null) {
            return XFADOMService.getXFADOM(pdfDoc, new XFAProcessingOptions(false, false), false, false);
        }
        return xfaDOM;
    }

    public static boolean isFormDomCreated(PDFDocument pdfDoc) {
        XFADOM xfaDom = XFADOMService.getXFADOMFromCache(pdfDoc);
        return xfaDom != null && xfaDom.formModelExists();
    }
}

