/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.DisplayArea;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.FactoryInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.MetaData;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentTextItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFDisplayArea;
import com.adobe.internal.pdftoolkit.services.swf.SWFDocumentContext;
import com.adobe.internal.pdftoolkit.services.swf.SWFFactory;
import com.adobe.internal.pdftoolkit.services.swf.SWFGraphicsState;
import com.adobe.internal.pdftoolkit.services.swf.SWFTextState;
import com.adobe.internal.pdftoolkit.services.swf.SWFVersion;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFSprite;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFUtils;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFWriter;
import flash.swf.SwfUtils;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineTag;
import flash.swf.types.Matrix;
import flash.swf.types.Shape;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SWFDocument
implements DocumentInterface<SWFGraphicsState, SWFTextState, SWFContentItem, SWFDisplayArea> {
    private SWFSprite rootSprite = null;
    private DisplayArea<SWFGraphicsState, SWFTextState, SWFContentItem> displayArea = null;
    private SWFVersion version;
    private PDFDocument pdfDoc;
    private MetaData metadata = null;
    private List<SWFDisplayArea> displayAreaList = null;
    private SWFFactory factory = null;

    public SWFDocument(PDFDocument pdfDoc, SWFVersion version) {
        this.version = version;
        this.pdfDoc = pdfDoc;
    }

    public void serializeDisplayArea(SWFDisplayArea displayArea, ByteWriter byteWriter) {
        SWFSprite rootSprite = SWFUtils.createDefineSprite("Graphic");
        SWFDocumentContext context = new SWFDocumentContext(rootSprite, displayArea.getBBox()[3] - displayArea.getBBox()[1]);
        double degreeAngle = displayArea.getDisplayRotation();
        double radianAngle = Math.toRadians(displayArea.getDisplayRotation());
        SWFSprite transformedSprite = null;
        Matrix matrix = new Matrix();
        if (radianAngle != 0.0) {
            transformedSprite = SWFUtils.createDefineSprite("transformedSprite");
            matrix.setRotate(Math.sin(radianAngle), -1.0 * Math.sin(radianAngle));
            matrix.setScale(Math.cos(radianAngle), Math.cos(radianAngle));
            if (degreeAngle == 90.0) {
                matrix.translateX = SwfUtils.toTwips((double)(displayArea.getBBox()[3] - displayArea.getBBox()[1]));
            } else if (degreeAngle == 180.0) {
                matrix.translateX = SwfUtils.toTwips((double)(displayArea.getBBox()[2] - displayArea.getBBox()[0]));
                matrix.translateY = SwfUtils.toTwips((double)(displayArea.getBBox()[3] - displayArea.getBBox()[1]));
            } else if (degreeAngle == 270.0) {
                matrix.translateY = SwfUtils.toTwips((double)(displayArea.getBBox()[2] - displayArea.getBBox()[0]));
            }
        }
        if (displayArea.getBBox()[0] != 0.0 || displayArea.getBBox()[1] != 0.0) {
            if (transformedSprite == null) {
                transformedSprite = SWFUtils.createDefineSprite("transformedSprite");
            }
            int xTranslationDirection = degreeAngle == 0.0 || degreeAngle == 90.0 ? -1 : 1;
            int yTranslationDirection = degreeAngle == 90.0 || degreeAngle == 180.0 ? -1 : 1;
            matrix.translateX = matrix.translateX + xTranslationDirection * SwfUtils.toTwips((double)displayArea.getBBox()[degreeAngle == 0.0 || degreeAngle == 180.0 ? 0 : 1]);
            matrix.translateY = matrix.translateY + yTranslationDirection * SwfUtils.toTwips((double)displayArea.getBBox()[degreeAngle == 90.0 || degreeAngle == 270.0 ? 0 : 1]);
        }
        if (transformedSprite != null) {
            SWFUtils.placeObject((DefineTag)transformedSprite.getDefineSprite(), matrix, rootSprite);
            context.setDefineSprite(transformedSprite);
        }
        ContentItemsList<SWFGraphicsState, SWFContentItem> contentItemsList = displayArea.getContentItems();
        Iterator<SWFContentItem> itr = contentItemsList.iterator();
        while (itr.hasNext()) {
            ((AbstractContentItem)((Object)itr.next())).writeToDisplayArea(context);
        }
        this.rootSprite = rootSprite;
        this.displayArea = displayArea;
        SWFDocument.trimGlyphShapeTables(context);
        context.destroy();
        this.makeSWF(byteWriter);
    }

    private static void trimGlyphShapeTables(SWFDocumentContext writer) {
        Set<Map.Entry<String, SWFContentTextItem.SWFDefineFont3>> entries = writer.getSWFFontsLoaded().entrySet();
        Iterator<Map.Entry<String, SWFContentTextItem.SWFDefineFont3>> itr = entries.iterator();
        SWFContentTextItem.SWFDefineFont3 font = null;
        int index = 0;
        while (itr.hasNext()) {
            font = itr.next().getValue();
            ((DefineFont3)font).glyphShapeTable = font.glyphShapeTable.toArray(new Shape[font.glyphShapeTable.size()]);
            Iterator<Character> codeTableItr = font.codeTable.iterator();
            index = 0;
            ((DefineFont3)font).codeTable = new char[font.codeTable.size()];
            while (codeTableItr.hasNext()) {
                ((DefineFont3)font).codeTable[index++] = codeTableItr.next().charValue();
            }
        }
    }

    @Override
    public List<SWFDisplayArea> getDisplayAreaList() {
        return this.displayAreaList;
    }

    @Override
    public MetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public FactoryInterface<SWFGraphicsState, SWFTextState, SWFContentItem, SWFDisplayArea> getFactory() {
        return this.factory == null ? (this.factory = new SWFFactory()) : this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSWF(ByteWriter byteWriter) {
        OutputByteStream obs = null;
        OutputStream os = null;
        try {
            obs = this.pdfDoc.getStreamManager().getUnregisteredOutputByteStream(byteWriter);
            os = obs.toOutputStream();
            int width = (int)Math.ceil(this.displayArea.getBBox()[2] - this.displayArea.getBBox()[0]);
            int height = (int)Math.ceil(this.displayArea.getBBox()[3] - this.displayArea.getBBox()[1]);
            if (this.displayArea.getDisplayRotation() != 0.0 && this.displayArea.getDisplayRotation() / 90.0 % 2.0 != 0.0) {
                width += height;
                height = width - height;
                width -= height;
            }
            SWFWriter swfw = new SWFWriter(width, height, this.version.getVersion());
            swfw.write(this.rootSprite.getDefineSprite(), os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                try {
                    if (os != null) {
                        os.flush();
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    finally {
                        if (obs != null) {
                            obs.close();
                        }
                    }
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void setDisplayAreaList(List<SWFDisplayArea> displayAreaList) {
        this.displayAreaList = displayAreaList;
    }

    @Override
    public void setMetadata(MetaData docInfo) {
        this.metadata = docInfo;
    }
}

