/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityKeyPasswordInterface;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.security.SecurityLocation;
import com.adobe.internal.pdftoolkit.services.security.SecurityProviders;

public class SecurityKeyPassword
implements SecurityKey {
    SecurityKeyPasswordInterface mRealKey;

    private SecurityKeyPassword(SecurityKeyPasswordInterface realKey) {
        this.mRealKey = realKey;
    }

    public byte[] getOwnerPassword() throws PDFInvalidDocumentException, PDFSecurityException {
        try {
            return this.mRealKey.getOwnerPassword();
        }
        catch (PDFParseException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public byte[] getUserPassword() throws PDFInvalidDocumentException, PDFSecurityException {
        try {
            return this.mRealKey.getUserPassword();
        }
        catch (PDFParseException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static SecurityKeyPassword newInstance(PDFDocument pdfDoc, byte[] password) throws PDFSecurityException {
        if (password == null) {
            return SecurityKeyPassword.newInstance(pdfDoc);
        }
        SecurityKeyPasswordInterface securityKeyHandle = SecurityLocation.getSecurityKeyPassword();
        return new SecurityKeyPassword(securityKeyHandle.makeSecurityKey(pdfDoc.getCosDocument(), password, null));
    }

    public static SecurityKeyPassword newInstance(PDFDocument pdfDoc, byte[] password, SecurityProviders providers) throws PDFSecurityException {
        if (password == null) {
            return SecurityKeyPassword.newInstance(pdfDoc, providers);
        }
        SecurityKeyPasswordInterface securityKeyHandle = SecurityLocation.getSecurityKeyPassword();
        return new SecurityKeyPassword(securityKeyHandle.makeSecurityKey(pdfDoc.getCosDocument(), password, providers));
    }

    public static SecurityKeyPassword newInstance(PDFDocument pdfDoc) throws PDFSecurityException {
        byte[] password = new byte[]{};
        return SecurityKeyPassword.newInstance(pdfDoc, password);
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mRealKey.getSecurityManager();
    }

    public static SecurityKeyPassword newInstance(PDFDocument pdfDoc, SecurityProviders providers) throws PDFSecurityException {
        byte[] password = new byte[]{};
        return SecurityKeyPassword.newInstance(pdfDoc, password);
    }
}

