/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentPathItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DisplayArea;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.PrimitiveContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class OverlappingObjectsDetector {
    private static final double pathThicknessThreshold = 2.0;
    private boolean nonOverlappedTextFound = false;
    private ASRectangle overlappingRectangle = null;
    private DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>> displayArea = null;
    private boolean fullPageRaster = false;
    private GraphicsContext context = new GraphicsContext();
    private Map<HashSet<Integer>, Rectangle2D> overlappingBounds = null;
    private int[] boundingBoxIndices;
    private List<BoundingBoxInfo> boundingBoxes;
    boolean[][] objectsOverlappingInfo;
    private boolean firstIteration = true;

    OverlappingObjectsDetector() {
    }

    boolean textRemainsNonOverlapped() {
        return this.nonOverlappedTextFound;
    }

    boolean rasterFullPage() {
        return this.fullPageRaster;
    }

    Map<HashSet<Integer>, Rectangle2D> getOverlappingBoundingBoxes() {
        return this.overlappingBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<HashSet<Integer>, Rectangle2D> scan(PDFPage pdfPage, DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>> displayArea, int lastID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        this.displayArea = displayArea;
        this.boundingBoxIndices = new int[lastID + 1];
        this.boundingBoxes = new ArrayList<BoundingBoxInfo>();
        this.boundingBoxes.add(null);
        this.objectsOverlappingInfo = new boolean[lastID + 1][2];
        this.scanForOverlappingRegions(displayArea);
        boolean overlapped = true;
        while (overlapped) {
            overlapped = this.iterateAndMergeRegions(displayArea);
        }
        try {
            if (this.fullPageRaster) {
                Map<HashSet<Integer>, Rectangle2D> map = null;
                return map;
            }
            PDFRectangle pageCropBox = pdfPage.getCropBox();
            HashMap<HashSet<Integer>, Rectangle2D> overlappingBounds = new HashMap<HashSet<Integer>, Rectangle2D>();
            for (int i = 0; i < this.boundingBoxIndices.length; ++i) {
                if (this.boundingBoxIndices[i] <= 0) continue;
                HashSet ids = this.boundingBoxes.get(this.boundingBoxIndices[i]).ids;
                Iterator itr = ids.iterator();
                while (itr.hasNext()) {
                    this.objectsOverlappingInfo[((Integer)itr.next()).intValue()][0] = true;
                }
                overlappingBounds.put(ids, this.boundingBoxes.get(this.boundingBoxIndices[i]).rect);
                if (!this.boundingBoxes.get(this.boundingBoxIndices[i]).rect.contains(pageCropBox.left(), pageCropBox.bottom(), pageCropBox.width(), pageCropBox.height())) continue;
                this.fullPageRaster = true;
                this.overlappingBounds = null;
                Map<HashSet<Integer>, Rectangle2D> map = null;
                return map;
            }
            this.overlappingBounds = overlappingBounds;
            HashMap<HashSet<Integer>, Rectangle2D> hashMap = this.overlappingBounds;
            return hashMap;
        }
        finally {
            this.overlappingRectangle = null;
            this.boundingBoxes = null;
            this.boundingBoxIndices = null;
            this.context.destroy();
            this.displayArea = null;
        }
    }

    private void scanForOverlappingRegions(DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>> displayArea) {
        ContentItemsList<GraphicsState, ContentItem<GraphicsState>> contentItems = displayArea.getContentItems();
        Iterator<ContentItem<GraphicsState>> itr = contentItems.iterator();
        ContentItem<GraphicsState> item = null;
        while (itr.hasNext()) {
            item = itr.next();
            if (this.boundingBoxIndices[item.getID()] < 0) continue;
            switch (item.getType()) {
                case Path: {
                    if (this.firstIteration && this.IsIgnorableWhiteFillPath((ContentPathItem)item)) {
                        this.boundingBoxIndices[item.getID()] = -2;
                        break;
                    }
                }
                case Image: {
                    this.checkForOverlap(this.displayArea, item);
                    break;
                }
                case Text: {
                    this.nonOverlappedTextFound = true;
                    this.checkForOverlap(this.displayArea, item);
                    break;
                }
                case XObject: {
                    this.scanForOverlappingRegions((XObject)item);
                }
            }
        }
    }

    private boolean checkForOverlap(DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>> displayArea, ContentItem<GraphicsState> item1) {
        ContentItemsList<GraphicsState, ContentItem<GraphicsState>> contentItems = displayArea.getContentItems();
        Iterator<ContentItem<GraphicsState>> itr = contentItems.iterator();
        ContentItem<GraphicsState> item2 = null;
        boolean overlapping = false;
        int id1 = item1.getID();
        BoundingBoxInfo info1 = this.boundingBoxIndices[id1] > 0 ? this.boundingBoxes.get(this.boundingBoxIndices[id1]) : null;
        Rectangle2D rect1 = info1 != null ? info1.rect : ((PrimitiveContentItem)item1).getBoundingBox(this.context);
        BoundingBoxInfo info2 = null;
        ContentItem<GraphicsState> prevItem = null;
        while (itr.hasNext()) {
            item2 = itr.next();
            int id2 = item2.getID();
            if (item2.getType() == ContentType.XObject) {
                overlapping = this.checkForOverlap((XObject)item2, item1) || overlapping;
                info1 = this.boundingBoxIndices[id1] > 0 ? this.boundingBoxes.get(this.boundingBoxIndices[id1]) : null;
                rect1 = info1 != null ? info1.rect : rect1;
                prevItem = item2;
                continue;
            }
            if (this.firstIteration && this.boundingBoxIndices[id2] == 0 && item2.getType() == ContentType.Path && this.canPathBeSafelyIgnored((ContentPathItem)item2, prevItem)) {
                this.boundingBoxIndices[item2.getID()] = -2;
            }
            if (id2 == id1 + 1 && this.boundingBoxIndices[id1] == 0 && item1.getType() == ContentType.Path && this.IsIgnorableWhiteFillPath((ContentPathItem)item1)) {
                this.boundingBoxIndices[item1.getID()] = -2;
            }
            info2 = null;
            if (this.boundingBoxIndices[id2] > 0) {
                info2 = this.boundingBoxes.get(this.boundingBoxIndices[id2]);
            }
            if (this.boundingBoxIndices[id1] < 0 || this.boundingBoxIndices[id2] < 0 || id1 == id2) {
                prevItem = item2;
                this.checkOverlapWithText(id1, id2, info1, info2, rect1, item1, item2);
                continue;
            }
            switch (item2.getType()) {
                case Text: {
                    this.nonOverlappedTextFound = true;
                    if (info1 == null && info2 == null) break;
                }
                case Path: 
                case Image: {
                    Rectangle2D rect2;
                    if (item1.getType() == ContentType.Text && info1 == null && info2 == null) {
                        this.checkOverlapWithText(id1, id2, info1, info2, rect1, item1, item2);
                        break;
                    }
                    Rectangle2D rectangle2D = rect2 = info2 != null ? info2.rect : ((PrimitiveContentItem)item2).getBoundingBox(this.context);
                    if (rect1 == null || rect2 == null || !this.doBBoxesOverlap(rect1, rect2) || !(this.overlappingRectangle.width() > 2.0) || !(this.overlappingRectangle.height() > 2.0)) break;
                    info1 = this.mergeInfos(info1, info2, id1, id2, rect1, rect2);
                    rect1 = info1.rect;
                    overlapping = true;
                    break;
                }
            }
            prevItem = item2;
        }
        if (displayArea == this.displayArea) {
            this.firstIteration = false;
        }
        return overlapping;
    }

    private void checkOverlapWithText(int id1, int id2, BoundingBoxInfo info1, BoundingBoxInfo info2, Rectangle2D rect1, ContentItem<GraphicsState> item1, ContentItem<GraphicsState> item2) {
        if (id1 != id2 && item1.getType() == ContentType.Text && info1 == null && info2 == null) {
            Rectangle2D rect2 = ((PrimitiveContentItem)item2).getBoundingBox(this.context);
            if (rect1 != null && rect2 != null && this.doBBoxesOverlap(rect1, rect2) && this.overlappingRectangle.width() > 0.0 && this.overlappingRectangle.height() > 0.0) {
                this.objectsOverlappingInfo[id2][1] = true;
            }
        }
    }

    private boolean iterateAndMergeRegions(DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>> displayArea) {
        BoundingBoxInfo info1 = null;
        boolean overlapping = false;
        for (int i = 0; i < this.boundingBoxIndices.length; ++i) {
            if (this.boundingBoxIndices[i] <= 0) continue;
            info1 = this.boundingBoxes.get(this.boundingBoxIndices[i]);
            overlapping = this.checkRegionsOverlapping(this.displayArea, info1, i) || overlapping;
        }
        return overlapping;
    }

    private boolean checkRegionsOverlapping(DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>> displayArea, BoundingBoxInfo info1, int id1) {
        this.fullPageRaster = true;
        this.nonOverlappedTextFound = false;
        Rectangle2D rect1 = info1.rect;
        BoundingBoxInfo info2 = null;
        ContentItemsList<GraphicsState, ContentItem<GraphicsState>> contentItems = displayArea.getContentItems();
        Iterator<ContentItem<GraphicsState>> itr2 = contentItems.iterator();
        boolean overlapping = false;
        boolean hasNonOverlappingObject = false;
        while (itr2.hasNext()) {
            Rectangle2D rect2;
            hasNonOverlappingObject = false;
            info2 = null;
            ContentItem<GraphicsState> item2 = itr2.next();
            int id2 = item2.getID();
            if (item2.getType() == ContentType.XObject) {
                boolean fullPageRasterOld = this.fullPageRaster;
                boolean foundTextOld = this.nonOverlappedTextFound;
                overlapping = this.checkRegionsOverlapping((DisplayArea)((Object)item2), info1, id1) || overlapping;
                this.fullPageRaster = fullPageRasterOld && this.fullPageRaster;
                this.nonOverlappedTextFound = foundTextOld || this.nonOverlappedTextFound;
                info1 = this.boundingBoxes.get(this.boundingBoxIndices[id1]);
                rect1 = info1.rect;
                continue;
            }
            if (this.boundingBoxIndices[id2] == -1) continue;
            if (this.boundingBoxIndices[id2] > 0) {
                info2 = this.boundingBoxes.get(this.boundingBoxIndices[id2]);
                rect2 = info2.rect;
            } else {
                rect2 = ((PrimitiveContentItem)item2).getBoundingBox(this.context);
                hasNonOverlappingObject = true;
            }
            if (info1 == info2) continue;
            if (rect2 != null && this.doBBoxesOverlap(rect1, rect2)) {
                info1 = this.mergeInfos(info1, info2, -10, id2, rect1, rect2);
                rect1 = info1.rect;
                overlapping = true;
                hasNonOverlappingObject = false;
            }
            if (!hasNonOverlappingObject || rect2 != null && (!(rect2.getWidth() > 0.0) || !(rect2.getHeight() > 0.0))) continue;
            this.fullPageRaster = false;
            if (item2.getType() != ContentType.Text) continue;
            this.nonOverlappedTextFound = true;
        }
        return overlapping;
    }

    private BoundingBoxInfo mergeInfos(BoundingBoxInfo info1, BoundingBoxInfo info2, int id1, int id2, Rectangle2D rect1, Rectangle2D rect2) {
        if (info1 != null && info2 != null) {
            this.boundingBoxes.set(this.boundingBoxIndices[id2], null);
            this.boundingBoxIndices[id2] = -1;
            info1.ids.addAll(info2.ids);
            info1.rect = rect1.createUnion(rect2);
        } else if (info1 != null) {
            this.boundingBoxIndices[id2] = -1;
            info1.ids.add(id2);
            info1.rect = rect1.createUnion(rect2);
        } else if (info2 != null) {
            this.boundingBoxIndices[id1] = this.boundingBoxIndices[id2];
            this.boundingBoxIndices[id2] = -1;
            info2.ids.add(id1);
            info2.rect = rect1.createUnion(rect2);
        } else {
            info1 = new BoundingBoxInfo(id1, rect1);
            this.boundingBoxes.add(info1);
            this.boundingBoxIndices[id1] = this.boundingBoxes.size() - 1;
            this.boundingBoxIndices[id2] = -1;
            info1.ids.add(id2);
            info1.rect = rect1.createUnion(rect2);
        }
        return info1 != null ? info1 : info2;
    }

    private boolean canPathBeSafelyIgnored(ContentPathItem<GraphicsState> item, ContentItem<GraphicsState> prevItem) {
        return this.isAThinPath(item) || this.pathHasNoFillAndThinStroke(item) || this.IsAConsecutiveDuplicatePath(item, prevItem);
    }

    private boolean isAThinPath(ContentPathItem<GraphicsState> item) {
        Rectangle2D boundingBox = item.getBoundingBox(this.context);
        return boundingBox.getWidth() <= 2.0 || boundingBox.getHeight() <= 2.0;
    }

    private boolean pathHasNoFillAndThinStroke(ContentPathItem<GraphicsState> item) {
        PathPainting paintType = item.getPathPaintingType();
        if (!paintType.isFill() && paintType.isStroke()) {
            return ((GraphicsState)item.getGState()).getLineWidth() <= 2.0;
        }
        return false;
    }

    private boolean IsAConsecutiveDuplicatePath(ContentPathItem<GraphicsState> item, ContentItem<GraphicsState> prevItem) {
        if (prevItem == null || prevItem.getType() != ContentType.Path) {
            return false;
        }
        ContentPathItem prevPathItem = (ContentPathItem)prevItem;
        if (item.getPathPaintingType() != prevPathItem.getPathPaintingType()) {
            return false;
        }
        if (!item.getBoundingBox(this.context).equals(prevPathItem.getBoundingBox(this.context))) {
            return false;
        }
        if (!((GraphicsState)item.getGState()).equals(prevPathItem.getGState())) {
            return false;
        }
        return GraphicsUtils.equalPaths(item.getPath(), prevPathItem.getPath());
    }

    private boolean IsIgnorableWhiteFillPath(ContentPathItem<GraphicsState> item) {
        boolean ignore = false;
        PathPainting paintType = item.getPathPaintingType();
        if (paintType.isFill()) {
            double[] fillColor = ((GraphicsState)item.getGState()).getFillColorValues();
            if (fillColor != null && fillColor[0] == 1.0 && fillColor[1] == 1.0 && fillColor[2] == 1.0) {
                ignore = true;
            }
            if (ignore && paintType.isStroke() && ((GraphicsState)item.getGState()).getLineWidth() > 2.0) {
                ignore = false;
            }
        }
        return ignore;
    }

    private boolean doBBoxesOverlap(Rectangle2D b1, Rectangle2D b2) {
        this.overlappingRectangle = new ASRectangle(Math.max(b1.getMinX(), b2.getMinX()), Math.max(b1.getMinY(), b2.getMinY()), Math.min(b1.getMaxX(), b2.getMaxX()), Math.min(b1.getMaxY(), b2.getMaxY()));
        return !(this.overlappingRectangle.left() >= this.overlappingRectangle.right()) && !(this.overlappingRectangle.bottom() >= this.overlappingRectangle.top());
    }

    private class BoundingBoxInfo {
        private HashSet<Integer> ids;
        private Rectangle2D rect;

        private BoundingBoxInfo(int id, Rectangle2D rect) {
            this.rect = rect;
            if (this.ids == null) {
                this.ids = new HashSet();
            }
            this.ids.add(id);
        }
    }

    private static class GraphicsContext
    extends DocumentContext {
        private GraphicsContext() {
        }

        @Override
        public void graphicsStateChanged() {
        }

        @Override
        public void destroy() {
        }
    }
}

