/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.filter.spi.ImageFilterInterface;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImageColorSpace;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.handler.PDFColorSpaceContainer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ImageRedactor {
    private static final Set<ASName> unsupportedDecodeFilters = new HashSet<ASName>();
    private static final Set<ASName> unsupportedEncodeFilters = new HashSet<ASName>();
    private static final double INTERSECTION_AREA_THRESHOLD = 0.8;
    private Integer bitsPerComponent = 8;
    private static final byte[] preBitsArray = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};
    private static final byte[] postBitsArray = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
    private PDFDocument pdfDocument;
    private RedactionHandler redactionHandler;
    private PDFFilterList outputFilterList;
    private boolean isResetFilter = false;
    private boolean isJPXDecodeFilter = false;
    private ASArray outputFilters;

    ImageRedactor(PDFDocument pdfDocument, RedactionHandler redactionHandler) {
        this.pdfDocument = pdfDocument;
        this.redactionHandler = redactionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean redactXObjectImage(ASMatrix currCTM, PDFXObjectImage xImage, Area redactionArea) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, IOException {
        int width = xImage.getWidth();
        int height = xImage.getHeight();
        redactionArea = this.transformRedactionArea(redactionArea, currCTM, height, width);
        redactionArea = this.subtractRedactionArea(redactionArea, width, height);
        this.isResetFilter = false;
        this.isJPXDecodeFilter = false;
        if (this.getOutputFilterList(xImage.getInputFilters())) {
            return true;
        }
        InputByteStream decodedImageByteStream = null;
        if (this.isJPXDecodeFilter) {
            decodedImageByteStream = this.getJPXDecodeInputStream(this.pdfDocument, this.redactionHandler, xImage);
        } else {
            decodedImageByteStream = xImage.getCosStream().getStreamDecoded();
            this.bitsPerComponent = xImage.getBitsPerComponent();
        }
        int numberOfComponents = 1;
        PDFColorSpace colorSpace = xImage.getColorSpace();
        if (colorSpace == null) {
            if (!this.isJPXDecodeFilter && !xImage.getIsImageMask()) {
                throw new PDFInvalidDocumentException("Color Space (required entry) is missing in " + xImage.getCosStream().getObjNum() + " image.");
            }
        } else {
            numberOfComponents = colorSpace instanceof PDFColorSpaceIndexed ? 1 : colorSpace.getNumberOfComponents();
        }
        Double modifiedWidth = new Double(decodedImageByteStream.length() * 8L / (long)(numberOfComponents * this.bitsPerComponent * height));
        Double modifiedHeight = new Double(decodedImageByteStream.length() * 8L / (long)(numberOfComponents * this.bitsPerComponent * width));
        width = modifiedWidth.intValue();
        height = modifiedHeight.intValue();
        ArrayList<ImageAreaRange> imageRangeList = new ArrayList<ImageAreaRange>();
        HashMap<Integer, ArrayList<XRange>> xRangeMap = new HashMap<Integer, ArrayList<XRange>>();
        OutputByteStream outputByteStream = null;
        this.divideAndRedactImage(redactionArea, 0, 0, width, height, imageRangeList);
        this.insertImageRanges(imageRangeList, xRangeMap);
        try {
            outputByteStream = xImage.getPDFDocument().getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, decodedImageByteStream.length());
            IO.copy(decodedImageByteStream, outputByteStream);
            this.updateImage(numberOfComponents, outputByteStream, height, width, xRangeMap, decodedImageByteStream);
            if (this.isResetFilter) {
                xImage.getCosStream().setOutputFiltersList(this.outputFilterList.getCosArray());
            }
            xImage.getCosStream().newDataDecoded(outputByteStream.closeAndConvert());
            outputByteStream = null;
        }
        finally {
            try {
                if (outputByteStream != null) {
                    outputByteStream.close();
                }
            }
            finally {
                decodedImageByteStream.close();
            }
        }
        return false;
    }

    private void insertImageRanges(ArrayList<ImageAreaRange> imageRangeList, Map<Integer, ArrayList<XRange>> xRangeMap) {
        if (!imageRangeList.isEmpty()) {
            for (ImageAreaRange imageRange : imageRangeList) {
                if (imageRange == null) continue;
                XRange xRange = new XRange();
                int minX = imageRange.getMinX();
                int maxX = imageRange.getMaxX();
                xRange.setXRange(minX, maxX);
                for (int i = imageRange.getMinY(); i < imageRange.getMaxY(); ++i) {
                    ArrayList<XRange> xRangeList = xRangeMap.get(i);
                    if (xRangeList == null) {
                        xRangeList = new ArrayList();
                        xRangeMap.put(i, xRangeList);
                    }
                    int size = xRangeList.size();
                    XRange lastXRange = null;
                    if (size != 0) {
                        lastXRange = xRangeList.get(size - 1);
                    }
                    if (lastXRange != null && lastXRange.getMaxX() == minX) {
                        lastXRange.setMaxX(maxX);
                        continue;
                    }
                    if (lastXRange != null && lastXRange.getMinX() <= minX && lastXRange.getMaxX() >= maxX) continue;
                    xRangeList.add(xRange);
                }
            }
        }
    }

    private void divideAndRedactImage(Area redactionArea, int minX, int minY, int maxX, int maxY, ArrayList<ImageAreaRange> imageRangeList) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        if (redactionArea.contains(rectangle)) {
            ImageAreaRange imageAreaRange = new ImageAreaRange();
            imageAreaRange.setRange(minX, minY, maxX, maxY);
            imageRangeList.add(imageAreaRange);
            return;
        }
        if (!redactionArea.intersects(rectangle)) {
            return;
        }
        if (maxX - minX <= 1 && maxY - minY <= 1) {
            if (redactionArea.intersects(rectangle)) {
                Area pixelArea = new Area(rectangle);
                pixelArea.intersect(redactionArea);
                Rectangle2D pixelRectangle = pixelArea.getBounds2D();
                if (pixelRectangle.getHeight() * pixelRectangle.getWidth() > 0.8) {
                    ImageAreaRange imageAreaRange = new ImageAreaRange();
                    imageAreaRange.setRange(minX, minY, maxX, maxY);
                    imageRangeList.add(imageAreaRange);
                }
            }
            return;
        }
        if (maxX - minX == 1) {
            int currentY = maxY - minY;
            currentY = currentY % 2 == 0 ? currentY / 2 + minY : currentY / 2 + minY + 1;
            this.divideAndRedactImage(redactionArea, minX, minY, maxX, currentY, imageRangeList);
            this.divideAndRedactImage(redactionArea, minX, currentY, maxX, maxY, imageRangeList);
            return;
        }
        if (maxY - minY == 1) {
            int currentX = maxX - minX;
            currentX = currentX % 2 == 0 ? currentX / 2 + minX : currentX / 2 + minX + 1;
            this.divideAndRedactImage(redactionArea, minX, minY, currentX, maxY, imageRangeList);
            this.divideAndRedactImage(redactionArea, currentX, minY, maxX, maxY, imageRangeList);
            return;
        }
        int relativeXPosition = maxX - minX;
        int relativeYPosition = maxY - minY;
        int currentX = minX;
        int currentY = minY;
        currentX = relativeXPosition % 2 == 0 ? (currentX += relativeXPosition / 2) : currentX + relativeXPosition / 2 + 1;
        currentY = relativeYPosition % 2 == 0 ? (currentY += relativeYPosition / 2) : currentY + relativeYPosition / 2 + 1;
        this.divideAndRedactImage(redactionArea, minX, minY, currentX, currentY, imageRangeList);
        this.divideAndRedactImage(redactionArea, minX, currentY, currentX, maxY, imageRangeList);
        this.divideAndRedactImage(redactionArea, currentX, minY, maxX, currentY, imageRangeList);
        this.divideAndRedactImage(redactionArea, currentX, currentY, maxX, maxY, imageRangeList);
    }

    private void updateImage(int numberOfComponents, OutputByteStream byteStream, int height, int width, Map<Integer, ArrayList<XRange>> rangeMap, InputByteStream decodedImageByteStream) throws IOException {
        long position = (long)((double)(width * numberOfComponents * this.bitsPerComponent) / 8.0);
        for (int i = 0; i < height; ++i) {
            long currentPosition = (long)i * position;
            int bitsInSinglePixel = numberOfComponents * this.bitsPerComponent;
            ArrayList<XRange> xRangeForCurrentRow = rangeMap.get(i);
            if (xRangeForCurrentRow == null) continue;
            for (XRange currentXRange : xRangeForCurrentRow) {
                long bitsToBeProcessed;
                int minX = currentXRange.getMinX();
                long bitsToSeek = (long)(minX * bitsInSinglePixel) + currentPosition * 8L;
                long bytesToSeek = bitsToSeek / 8L;
                int preBitsToReset = (int)(bitsToSeek % 8L);
                byteStream.seek(bytesToSeek);
                boolean isMultipleByte = true;
                if (preBitsToReset != 0) {
                    decodedImageByteStream.seek(bytesToSeek);
                    Byte currentByte = (byte)decodedImageByteStream.read();
                    byteStream.write(preBitsArray[preBitsToReset] & currentByte);
                    bitsToBeProcessed = (currentXRange.getMaxX() - currentXRange.getMinX()) * bitsInSinglePixel - preBitsToReset;
                    if (bytesToSeek == 0L || currentXRange.getMaxX() - minX <= 8) {
                        isMultipleByte = false;
                    }
                } else {
                    bitsToBeProcessed = (currentXRange.getMaxX() - currentXRange.getMinX()) * bitsInSinglePixel;
                }
                int bytesToBeProcessed = (int)(bitsToBeProcessed / 8L);
                int postBitsToReset = (int)(bitsToBeProcessed % 8L);
                byteStream.write(new byte[bytesToBeProcessed], 0, bytesToBeProcessed);
                if (postBitsToReset <= 0 || postBitsToReset >= 8) continue;
                long postBitsPosition = currentPosition + (long)bytesToBeProcessed + (long)(currentXRange.getMinX() * bitsInSinglePixel / 8);
                if (!isMultipleByte) continue;
                decodedImageByteStream.seek(postBitsPosition);
                Byte currentByte = (byte)decodedImageByteStream.read();
                byteStream.seek(postBitsPosition);
                byteStream.write(postBitsArray[postBitsToReset] & currentByte);
            }
        }
    }

    private InputByteStream getJPXDecodeInputStream(PDFDocument pdfDocument, RedactionHandler redactionHandler, PDFXObjectImage xImage) throws PDFIOException, PDFSecurityException, IOException, PDFInvalidDocumentException {
        CustomDecodeFilter customDecodeFilter;
        InputStream imageStream = xImage.getCosStream().getStreamEncoded().toInputStream();
        CustomFilterRegistry customFilterRegistry = pdfDocument.getCosDocument().getOptions().getCustomFilterRegistry();
        if (customFilterRegistry != null && (customDecodeFilter = customFilterRegistry.getRegisteredDecodeFilterByName(ASName.k_JPXDecode)) instanceof ImageFilterInterface) {
            ImageFilterInterface imageFilterInterface = (ImageFilterInterface)customDecodeFilter;
            ImageFilterInterface.ImageInfo imageInfo = imageFilterInterface.getImageInfo(imageStream);
            this.bitsPerComponent = imageInfo.getBitDepth();
            int numberOfColorComponents = imageInfo.getNumberOfColorComponents();
            xImage.setBitsPerComponent(this.bitsPerComponent);
            PDFColorSpaceContainer colorSpaceContainer = new PDFColorSpaceContainer();
            if (redactionHandler.getColorSpaceBasedOnColorComponents(numberOfColorComponents, colorSpaceContainer)) {
                xImage.setColorSpace(colorSpaceContainer.getPDFColorSpace());
                FilterParams filterParams = new FilterParams();
                filterParams.put("BitsPerComponent", this.bitsPerComponent);
                filterParams.put("Components", numberOfColorComponents);
                imageStream = xImage.getCosStream().getStreamEncoded().toInputStream();
                InputStream decodedStream = null;
                try {
                    decodedStream = imageFilterInterface.decode(imageStream, filterParams);
                    OutputByteStream decodedImageByteStream = pdfDocument.getStreamManager().getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, ByteWriterFactory.Fixed.GROWABLE, -1L, false);
                    IO.copy(decodedStream, decodedImageByteStream);
                    return decodedImageByteStream.closeAndConvert();
                }
                catch (CustomFilterException e) {
                    throw new PDFInvalidContentException("While decoding with JPXDecode filter in Image Redaction, CustomFilterException has occured", e);
                }
            }
        }
        return null;
    }

    private Area transformRedactionArea(Area redactionArea, ASMatrix currCTM, int height, int width) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AffineTransform ctm = new AffineTransform();
        Area currentRedactionArea = null;
        ctm.setTransform(currCTM.geta(), currCTM.getb(), currCTM.getc(), currCTM.getd(), currCTM.getx(), currCTM.gety());
        if (height != 0 && width != 0) {
            AffineTransform imageCTM = new AffineTransform(1.0 / (double)width, 0.0, 0.0, -1.0 / (double)height, 0.0, 1.0);
            try {
                currentRedactionArea = new Area(redactionArea);
                ctm.concatenate(imageCTM);
                currentRedactionArea.transform(ctm.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new PDFIOException(e);
            }
        }
        return currentRedactionArea;
    }

    private Area subtractRedactionArea(Area redactionArea, int width, int height) {
        Area imageArea = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        imageArea.intersect(redactionArea);
        return imageArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setXobjectImageWhite(PDFXObjectImage xImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFInvalidParameterException {
        int width = xImage.getWidth();
        int height = xImage.getHeight();
        xImage.setSMask(null);
        xImage.setMask(null);
        xImage.removeValue(ASName.k_OC);
        xImage.removeValue(ASName.k_StructParent);
        xImage.removeValue(ASName.k_Metadata);
        xImage.removeValue(ASName.k_OPI);
        xImage.removeValue(ASName.k_ID);
        xImage.removeValue(ASName.k_Decode);
        xImage.removeValue(ASName.k_Alternates);
        xImage.removeValue(ASName.k_Interpolate);
        int bitsPerComponent = 8;
        xImage.setBitsPerComponent(bitsPerComponent);
        PDFColorSpace colorSpace = xImage.getColorSpace();
        if (colorSpace == null) {
            colorSpace = PDFColorSpaceDeviceGray.newInstance(xImage.getPDFDocument());
        }
        int numberOfComponents = 0;
        numberOfComponents = colorSpace instanceof PDFColorSpaceIndexed ? 1 : colorSpace.getNumberOfComponents();
        try (OutputByteStream outputByteStream = null;){
            int rowValue = width * numberOfComponents * bitsPerComponent / 8;
            outputByteStream = xImage.getPDFDocument().getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, rowValue * height);
            for (int i = 0; i < height; ++i) {
                outputByteStream.write(new byte[rowValue], 0, rowValue);
            }
            PDFFilterList outputFilterList = PDFFilterList.newInstance(xImage.getPDFDocument());
            outputFilterList.add(PDFFilterFlate.newInstance(xImage.getPDFDocument(), null));
            xImage.getCosStream().setOutputFiltersList(outputFilterList.getCosArray());
            xImage.getCosStream().newDataDecoded(outputByteStream.closeAndConvert());
            outputByteStream = null;
        }
    }

    private boolean getOutputFilterList(PDFFilterList inputFilterList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.outputFilterList = PDFFilterList.newInstance(this.pdfDocument);
        if (inputFilterList != null && !inputFilterList.isEmpty()) {
            Iterator iterator = inputFilterList.iterator();
            CustomFilterRegistry customFilterRegistry = this.pdfDocument.getCosDocument().getOptions().getCustomFilterRegistry();
            while (iterator.hasNext()) {
                PDFFilter filter = (PDFFilter)iterator.next();
                if (filter == null || !this.addToOutputFilters(filter.getFilterName(), customFilterRegistry, filter, true)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InlineImageContainer redactInlineImage(InlineImage inlineImage, ASMatrix currCTM, Area redactionArea, PDFColorSpaceMap colorSpaceMap, ASDictionary imageDict, InputByteStream byteStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFInvalidParameterException {
        InlineImageContainer inlineImageContainer = new InlineImageContainer();
        int width = inlineImage.getWidth();
        int height = inlineImage.getHeight();
        redactionArea = this.transformRedactionArea(redactionArea, currCTM, height, width);
        redactionArea = this.subtractRedactionArea(redactionArea, width, height);
        int bitsPerComponent = inlineImage.getBitsPerComponent();
        int numberOfComponents = 1;
        PDFColorSpace pdfColorSpace = null;
        ASName deviceCSName = null;
        if (imageDict.containsKey(ASName.k_ColorSpace) || imageDict.containsKey(ASName.k_CS)) {
            InlineImageColorSpace cs = inlineImage.getColorSpace();
            if (cs.isIndexedColorSpace()) {
                cs = cs.getIndexedColorSpaceBase();
            }
            if (cs.isDeviceColorSpace()) {
                deviceCSName = cs.getDeviceColorSpaceName();
                pdfColorSpace = deviceCSName == ASName.k_DeviceRGB ? PDFColorSpaceDeviceRGB.newInstance(this.pdfDocument) : (deviceCSName == ASName.k_DeviceCMYK ? PDFColorSpaceDeviceCMYK.newInstance(this.pdfDocument) : PDFColorSpaceDeviceGray.newInstance(this.pdfDocument));
                numberOfComponents = pdfColorSpace.getNumberOfComponents();
            } else if (cs.isExistingResourceColorSpaceName() || cs.isNewResourceColorSpace()) {
                ASName csName = null;
                if (cs.isExistingResourceColorSpaceName() && colorSpaceMap != null) {
                    csName = cs.getExistingResourceColorSpaceName();
                    pdfColorSpace = colorSpaceMap.get(csName);
                } else if (cs.isNewResourceColorSpace()) {
                    pdfColorSpace = cs.getNewResourceColorSpace();
                }
                if (pdfColorSpace instanceof PDFColorSpaceIndexed) {
                    pdfColorSpace = ((PDFColorSpaceIndexed)pdfColorSpace).getBaseColorSpace();
                } else if (pdfColorSpace instanceof PDFColorSpaceSeparation) {
                    pdfColorSpace = ((PDFColorSpaceSeparation)pdfColorSpace).getAlternateColorSpace();
                }
            }
        }
        if (this.getOutputFilters((ASObject)inlineImage.getStreamFilters())) {
            inlineImageContainer.setIsInlineImageRedacted(true);
        }
        imageDict.put(ASName.k_F, this.outputFilters);
        inlineImageContainer.setInlineImageDictionary(imageDict);
        ASArray filtersDecodeParams = this.getFiltersDecodeParams(inlineImage.getStreamFiltersDecodeParams());
        ArrayList<ImageAreaRange> imageRangeList = new ArrayList<ImageAreaRange>();
        HashMap<Integer, ArrayList<XRange>> xRangeMap = new HashMap<Integer, ArrayList<XRange>>();
        this.divideAndRedactImage(redactionArea, 0, 0, width, height, imageRangeList);
        this.insertImageRanges(imageRangeList, xRangeMap);
        OutputByteStream outputByteStream = null;
        InputStream decodedStream = inlineImage.getImageData();
        try {
            outputByteStream = this.pdfDocument.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, decodedStream.available());
            IO.copy(decodedStream, outputByteStream);
            outputByteStream = this.updateInlineImage(outputByteStream, byteStream, width, height, numberOfComponents, bitsPerComponent, xRangeMap, inlineImage.isImageMask());
            InputByteStream inputByteStream = outputByteStream.closeAndConvert();
            outputByteStream = null;
            inlineImageContainer.setImage(InlineImage.newInstance(this.outputFilters, filtersDecodeParams, inputByteStream, height, width, bitsPerComponent, pdfColorSpace, inlineImage.getIntent(), false, false, inlineImage.getImageDecodeArray()));
        }
        finally {
            if (outputByteStream != null) {
                outputByteStream.close();
            }
            if (decodedStream != null) {
                decodedStream.close();
            }
        }
        return inlineImageContainer;
    }

    private OutputByteStream updateInlineImage(OutputByteStream outputByteStream, InputByteStream byteStream, int width, int height, int numberOfComponents, int bitsPerComponent, Map<Integer, ArrayList<XRange>> xRangeMap, boolean imageMask) throws IOException {
        int totalBits = numberOfComponents * bitsPerComponent;
        if (imageMask) {
            double rowValue = Math.ceil((double)(width * numberOfComponents * bitsPerComponent) / 8.0);
            int bitsToSeek = 0;
            int preBitsToReset = 0;
            int bytesToSeek = 0;
            int range = 0;
            int bitsToBeProcessed = 0;
            int bytesToBeProcessed = 0;
            int postBitsToReset = 0;
            for (int i = 0; i < height; ++i) {
                Double currentPosition = (double)i * rowValue;
                ArrayList<XRange> xRangeForCurrentRow = xRangeMap.get(i);
                if (xRangeForCurrentRow == null) continue;
                for (XRange currentXRange : xRangeForCurrentRow) {
                    byte currentByte;
                    bitsToSeek = currentXRange.getMinX() * totalBits;
                    preBitsToReset = bitsToSeek % 8;
                    bytesToSeek = bitsToSeek / 8;
                    outputByteStream.seek((long)bytesToSeek + currentPosition.longValue());
                    range = currentXRange.getMaxX() - currentXRange.getMinX();
                    if (preBitsToReset != 0) {
                        preBitsToReset = 8 - preBitsToReset;
                        range -= preBitsToReset;
                        byteStream.seek(bytesToSeek);
                        currentByte = (byte)byteStream.read();
                        outputByteStream.write(preBitsArray[preBitsToReset] & currentByte);
                    }
                    if (range > 0) {
                        bitsToBeProcessed = range * totalBits;
                        bytesToBeProcessed = bitsToBeProcessed / 8;
                        postBitsToReset = bitsToBeProcessed % 8;
                    }
                    outputByteStream.write(new byte[bytesToBeProcessed], 0, bytesToBeProcessed);
                    if (postBitsToReset <= 0 || postBitsToReset >= 8) continue;
                    byteStream.seek(bytesToSeek + bytesToBeProcessed);
                    currentByte = (byte)byteStream.read();
                    outputByteStream.write(postBitsArray[postBitsToReset] & currentByte);
                }
            }
        } else {
            int rowValue = width * numberOfComponents;
            long bytesToSeek = 0L;
            long bytesToBeProcessed = 0L;
            for (int i = 0; i < height; ++i) {
                long currentPosition = i * rowValue;
                ArrayList<XRange> xRangeForCurrentRow = xRangeMap.get(i);
                if (xRangeForCurrentRow == null) continue;
                Iterator<XRange> xRangeIterator = xRangeForCurrentRow.iterator();
                currentPosition = currentPosition * (long)bitsPerComponent / 8L;
                while (xRangeIterator.hasNext()) {
                    XRange currentXRange = xRangeIterator.next();
                    bytesToSeek = (long)(currentXRange.getMinX() * totalBits / 8) + currentPosition;
                    bytesToBeProcessed = (currentXRange.getMaxX() - currentXRange.getMinX()) * totalBits / 8;
                    outputByteStream.seek(bytesToSeek);
                    outputByteStream.write(new byte[(int)bytesToBeProcessed], 0, (int)bytesToBeProcessed);
                }
            }
        }
        return outputByteStream;
    }

    private boolean getOutputFilters(ASObject currentFilters) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASArray filters;
        this.outputFilters = new ASArray();
        CustomFilterRegistry customFilterRegistry = this.pdfDocument.getCosDocument().getOptions().getCustomFilterRegistry();
        if (currentFilters instanceof ASName) {
            if (this.addToOutputFilters((ASName)currentFilters, customFilterRegistry, null, false)) {
                return true;
            }
        } else if (currentFilters instanceof ASArray && (filters = (ASArray)currentFilters) != null && !filters.isEmpty()) {
            for (ASObject filterObject : filters) {
                if (!(filterObject instanceof ASName) || !this.addToOutputFilters((ASName)filterObject, customFilterRegistry, null, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean addToOutputFilters(ASName filterName, CustomFilterRegistry customFilterRegistry, PDFFilter filter, boolean isXobjectImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (customFilterRegistry != null) {
            if (!customFilterRegistry.isDecodeFilterRegistered(filterName) && unsupportedDecodeFilters.contains(filterName)) {
                return true;
            }
            if (filterName == ASName.k_JPXDecode) {
                this.isJPXDecodeFilter = true;
            }
            if (!customFilterRegistry.isEncodeFilterRegistered(filterName) && unsupportedEncodeFilters.contains(filterName)) {
                if (isXobjectImage) {
                    this.outputFilterList.add(PDFFilterFlate.newInstance(this.pdfDocument, null));
                    this.isResetFilter = true;
                } else {
                    this.outputFilters.add(ASName.k_FlateDecode);
                }
            } else if (isXobjectImage) {
                this.outputFilterList.add(filter);
            } else {
                this.outputFilters.add(filterName);
            }
        } else {
            if (unsupportedDecodeFilters.contains(filterName)) {
                return true;
            }
            if (filterName == ASName.k_JPXDecode) {
                this.isJPXDecodeFilter = true;
            }
            if (unsupportedEncodeFilters.contains(filterName)) {
                if (isXobjectImage) {
                    this.outputFilterList.add(PDFFilterFlate.newInstance(this.pdfDocument, null));
                    this.isResetFilter = true;
                } else {
                    this.outputFilters.add(ASName.k_FlateDecode);
                }
            } else if (isXobjectImage) {
                this.outputFilterList.add(filter);
            } else {
                this.outputFilters.add(filterName);
            }
        }
        return false;
    }

    private ASArray getFiltersDecodeParams(Object decodeParams) {
        if (decodeParams instanceof ASDictionary) {
            ASArray filtersDecodeParams = new ASArray();
            filtersDecodeParams.add((ASDictionary)decodeParams);
            return filtersDecodeParams;
        }
        if (decodeParams instanceof ASArray) {
            return (ASArray)decodeParams;
        }
        return null;
    }

    static {
        unsupportedDecodeFilters.add(ASName.k_JBIG2Decode);
        unsupportedDecodeFilters.add(ASName.k_JPXDecode);
        unsupportedEncodeFilters.add(ASName.k_DCTDecode);
        unsupportedEncodeFilters.add(ASName.k_JBIG2Decode);
        unsupportedEncodeFilters.add(ASName.k_JPXDecode);
        unsupportedEncodeFilters.add(ASName.k_CCITTFaxDecode);
    }

    static class InlineImageContainer {
        private boolean isInlineImageRedacted = false;
        private ASDictionary imageDict;
        private InlineImage image;

        InlineImageContainer() {
        }

        boolean getIsInlineImageRedacted() {
            return this.isInlineImageRedacted;
        }

        void setIsInlineImageRedacted(boolean isInlineImageRedacted) {
            this.isInlineImageRedacted = isInlineImageRedacted;
        }

        ASDictionary getInlineImageDictionary() {
            return this.imageDict;
        }

        void setInlineImageDictionary(ASDictionary imageDict) {
            this.imageDict = imageDict;
        }

        InlineImage getImage() {
            return this.image;
        }

        void setImage(InlineImage image) {
            this.image = image;
        }
    }

    private static class XRange {
        private int minX;
        private int maxX;

        private XRange() {
        }

        int getMinX() {
            return this.minX;
        }

        int getMaxX() {
            return this.maxX;
        }

        void setMaxX(int maxX) {
            this.maxX = maxX;
        }

        void setXRange(int minX, int maxX) {
            this.minX = minX;
            this.maxX = maxX;
        }
    }

    private static class ImageAreaRange {
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        private ImageAreaRange() {
        }

        int getMinX() {
            return this.minX;
        }

        int getMinY() {
            return this.minY;
        }

        int getMaxX() {
            return this.maxX;
        }

        int getMaxY() {
            return this.maxY;
        }

        void setRange(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }
}

