/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class GStateHolder {
    private static String CURRENT_STROKING_COLOR_SPACE = "CURRENT_STROKING_COLOR_SPACE";
    private static String CURRENT_NON_STROKING_COLOR_SPACE = "CURRENT_NON_STROKING_COLOR_SPACE";
    private static String CURRENT_STROKING_COLOR = "CURRENT_STROKING_COLOR";
    private static String CURRENT_NON_STROKING_COLOR = "CURRENT_NON_STROKING_COLOR";
    private static String CURRENT_STROKING_COLOR_CS = "CURRENT_STROKING_COLOR_CS";
    private static String CURRENT_NON_STROKING_COLOR_CS = "CURRENT_NON_STROKING_COLOR_CS";
    private int key_suffix = 0;
    private Map<String, Instruction> gState = new LinkedHashMap<String, Instruction>();

    GStateHolder() {
    }

    void writeGState(RedactionContentWriter writer) throws PDFIOException {
        for (Instruction ins : this.gState.values()) {
            Iterator<Object> oprandIter;
            Object currentOperand;
            OperandStack operandStack;
            ASName operator = ins.getOperator();
            if (operator == ASName.k_gs) {
                OperandStack operands = ins.getOperands();
                ASName gStateKey = ContentModifier.getObjectName(operands);
                writer.sourceResourceState.removeExtGState(gStateKey);
            } else if (operator == ASName.k_cs || operator == ASName.k_CS) {
                operandStack = ins.getOperands();
                ASName csKey = ContentModifier.getObjectName(operandStack);
                if (csKey != null) {
                    writer.sourceResourceState.removeColour(csKey);
                }
            } else if ((operator == ASName.k_scn || operator == ASName.k_SCN) && (currentOperand = (oprandIter = (operandStack = ins.getOperands()).iterator()).next()) instanceof ASName) {
                ASName patternKey = (ASName)currentOperand;
                writer.sourceResourceState.removePattern(patternKey);
            }
            writer.write(ins);
        }
        this.gState.clear();
    }

    public GStateHolder clone() {
        GStateHolder gState = new GStateHolder();
        gState.gState = new LinkedHashMap<String, Instruction>(this.gState);
        gState.key_suffix = this.key_suffix;
        return gState;
    }

    void updateGState(Instruction instruction) {
        ASName operator = instruction.getOperator();
        if (RedactionContentWriter.colorOperators.contains(operator)) {
            if (operator == ASName.k_G || operator == ASName.k_RG || operator == ASName.k_K) {
                this.gState.remove(CURRENT_STROKING_COLOR_CS);
                this.gState.put(CURRENT_STROKING_COLOR_CS, instruction);
            } else if (operator == ASName.k_g || operator == ASName.k_rg || operator == ASName.k_k) {
                this.gState.remove(CURRENT_NON_STROKING_COLOR_CS);
                this.gState.put(CURRENT_NON_STROKING_COLOR_CS, instruction);
            } else if (operator == ASName.k_CS) {
                this.gState.remove(CURRENT_STROKING_COLOR_SPACE);
                this.gState.put(CURRENT_STROKING_COLOR_SPACE, instruction);
            } else if (operator == ASName.k_cs) {
                this.gState.remove(CURRENT_NON_STROKING_COLOR_SPACE);
                this.gState.put(CURRENT_NON_STROKING_COLOR_SPACE, instruction);
            } else if (operator == ASName.k_SC || operator == ASName.k_SCN) {
                this.gState.remove(CURRENT_STROKING_COLOR);
                this.gState.put(CURRENT_STROKING_COLOR, instruction);
            } else if (operator == ASName.k_sc || operator == ASName.k_scn) {
                this.gState.remove(CURRENT_NON_STROKING_COLOR);
                this.gState.put(CURRENT_NON_STROKING_COLOR, instruction);
            }
        } else {
            String key = operator.asString();
            if (operator != ASName.k_gs && operator != ASName.k_cm) {
                this.gState.remove(key);
            } else {
                key = key + this.key_suffix++;
            }
            this.gState.put(key, instruction);
        }
    }
}

