/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSimpleType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class XMPReal
extends XMPSimpleType {
    private static final Pattern pattern = Pattern.compile("^(\\+|-)?\\d*(|.\\d*[0-9]|,\\d*[0-9])?$");
    private static XMPReal _xmpReal = new XMPReal();

    private XMPReal() {
    }

    public static XMPReal getInstance() {
        return _xmpReal;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m) {
        if (!super.isValid(m)) {
            return false;
        }
        String value = m.getValue();
        Matcher matcher = pattern.matcher(value);
        if (!matcher.find()) {
            return false;
        }
        if ("http://ns.adobe.com/xap/1.0/g/".equals(m.getNameSpaceURI())) {
            if (m.getName() != null && (m.getName().equals("cyan") || m.getName().equals("magenta") || m.getName().equals("yellow") || m.getName().equals("black") || m.getName().equals("L"))) {
                try {
                    Double d = new Double(value);
                    return d < 0.0 || d > 100.0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        } else if ("http://ns.adobe.com/camera-rawsettings/1.0/".equals(m.getNameSpaceURI()) && m.getName() != null && m.getName().equals("Exposure")) {
            try {
                Double d = new Double(value);
                return d >= -4.0 && d <= 4.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

