/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorExtensionSchemaUsageNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorInvalidExtensionSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorSchemaUsageNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPAgentName;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPBeatSpliceStretch;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPBoolean;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPCFAPattern;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPClosedChoice;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPColorant;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPDate;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPDeviceSettings;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPDimensions;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPFlash;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPGPSCoordinate;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPInteger;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPJob;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPLangAlt;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPLocale;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPMIMEType;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPMarker;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPMedia;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPOECFSFR;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPOpenChoice;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPProjectLink;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPProperName;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPRational;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPReal;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPRenditionClass;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPResampleStretch;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPResourceEvent;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPResourceRef;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSeqInteger;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPText;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPThumbnail;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPTime;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPTimeScaleStretch;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPTimecode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPURI;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPURL;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPValueType;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPVersion;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPXPath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XMPBasicTypeValidator {
    private static final HashMap<String, XMPValueType> BASIC_XMP_PROPERTY_MAP;
    private static final String VALUE = "value";
    private static final String RDF = "rdf";
    private static final String OPEN_CHOICE = "open choice of ";
    private static final String CLOSED_CHOICE = "closed choice of ";
    private static final String SEQ = "seq ";
    private static final String ALT = "alt ";
    private static final String BAG = "bag ";

    public static String getBaseValueType(String valueType) {
        if (valueType == null) {
            return null;
        }
        String basicTypeLowerCase = valueType.toLowerCase();
        if (basicTypeLowerCase.startsWith(OPEN_CHOICE)) {
            valueType = valueType.substring(OPEN_CHOICE.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(CLOSED_CHOICE)) {
            valueType = valueType.substring(CLOSED_CHOICE.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(BAG)) {
            valueType = valueType.substring(BAG.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(ALT)) {
            valueType = valueType.substring(ALT.length(), valueType.length());
        } else if (basicTypeLowerCase.startsWith(SEQ)) {
            valueType = valueType.substring(SEQ.length(), valueType.length());
        }
        return valueType;
    }

    public static boolean isValueTypeBasicXMPProperty(String valueType) {
        return BASIC_XMP_PROPERTY_MAP.containsKey(XMPBasicTypeValidator.getBaseValueType(valueType));
    }

    static boolean isPropertyUsageValid(String basicDataName, MetadataUsageTreeNode metadataTree, Map<String, PDFA2XMPSchema> referenceSchemas, boolean closedChoice, PDFA2XMPErrorCollector errorCodes, PDFA2XMPSchema.PDFA2XMPProperty prop, PDFA2XMPSchema xmpSchema) {
        try {
            XMPValueType valueType = null;
            String basicTypeLowerCase = basicDataName.toLowerCase();
            if (basicTypeLowerCase.startsWith(CLOSED_CHOICE)) {
                basicDataName = basicDataName.substring(CLOSED_CHOICE.length(), basicDataName.length());
                closedChoice = true;
            }
            if (basicDataName == null || basicDataName.length() == 0) {
                basicDataName = "Text";
            }
            basicDataName = XMPBasicTypeValidator.getBaseValueType(basicDataName);
            if (metadataTree.isNodeArray()) {
                for (MetadataUsageTreeNode node : metadataTree.getNodes()) {
                    if (XMPBasicTypeValidator.isPropertyUsageValid(basicDataName, node, referenceSchemas, closedChoice, errorCodes, prop, xmpSchema)) continue;
                    return false;
                }
            } else {
                valueType = BASIC_XMP_PROPERTY_MAP.get(basicDataName);
                if (valueType == null) {
                    boolean flag = XMPBasicTypeValidator.validateExtensionSchemaProperty(metadataTree, referenceSchemas, prop, xmpSchema, errorCodes);
                    if (!flag) {
                        errorCodes.addErrorCodeConditional(xmpSchema.getURI(), new PDFA2XMPErrorExtensionSchemaUsageNotValid(0, 0), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                    }
                    return flag;
                }
                List<MetadataUsageTreeNode> nodes = metadataTree.getNodes();
                if (nodes == null || nodes.size() > 2) {
                    boolean flag = valueType.isValid(metadataTree, closedChoice);
                    if (!flag) {
                        errorCodes.addErrorCode(xmpSchema.getURI(), new PDFA2XMPErrorSchemaUsageNotValid(0, 0));
                    }
                    return flag;
                }
                boolean rdfValueFound = false;
                boolean isValueTypeReal = false;
                if (nodes.size() <= 2) {
                    for (MetadataUsageTreeNode node : nodes) {
                        if (!node.getName().equals(VALUE) || !node.getPrefix().equals(RDF)) continue;
                        rdfValueFound = true;
                        if (!"Real".equals(basicDataName)) continue;
                        isValueTypeReal = true;
                    }
                }
                if (!rdfValueFound) {
                    boolean flag = valueType.isValid(metadataTree);
                    if (!flag) {
                        errorCodes.addErrorCode(xmpSchema.getURI(), new PDFA2XMPErrorSchemaUsageNotValid(0, 0));
                    }
                    return flag;
                }
                for (MetadataUsageTreeNode node : nodes) {
                    if (node.getName().equals(VALUE) && node.getPrefix().equals(RDF)) {
                        if (XMPBasicTypeValidator.isPropertyUsageValid(basicDataName, node, referenceSchemas, closedChoice, errorCodes, prop, xmpSchema)) continue;
                        return false;
                    }
                    if (isValueTypeReal && node.getName().equals("binRep") && node.getPrefix().equals("vQual")) {
                        return XMPBasicTypeValidator.isPropertyUsageValid("Text", node, referenceSchemas, closedChoice, errorCodes, prop, xmpSchema);
                    }
                    String type = prop.getType();
                    if (XMPBasicTypeValidator.isPropertyUsageValid(type, node, referenceSchemas, closedChoice, errorCodes, prop, xmpSchema)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            errorCodes.addErrorCode(xmpSchema.getURI(), new PDFA2XMPErrorSchemaUsageNotValid(0, 0));
            return false;
        }
    }

    private static boolean validateExtensionSchemaProperty(MetadataUsageTreeNode propertyTree, Map<String, PDFA2XMPSchema> referenceSchemas, PDFA2XMPSchema.PDFA2XMPProperty prop, PDFA2XMPSchema xmpSchema, PDFA2XMPErrorCollector errorCollector) {
        String refererenceType = prop.getType();
        PDFA2XMPSchema.PDFA2XMPType pdfaXMPType = xmpSchema.getType(XMPBasicTypeValidator.getBaseValueType(refererenceType));
        if (pdfaXMPType == null) {
            return false;
        }
        if (propertyTree.getNodes() == null) {
            return false;
        }
        for (MetadataUsageTreeNode node : propertyTree.getNodes()) {
            PDFA2XMPSchema.PDFA2XMPField field = pdfaXMPType.getFields().get(node.getName());
            if (field != null) {
                if (XMPBasicTypeValidator.isPropertyUsageValid(field.getvalueType(), node, referenceSchemas, false, errorCollector, prop, xmpSchema)) continue;
                return false;
            }
            Set<PDFA2XMPSchema.PDFA2XMPType> types = xmpSchema.getTypeByURI(node.getNameSpaceURI());
            Iterator<PDFA2XMPSchema.PDFA2XMPType> iter = types.iterator();
            boolean validated = false;
            while (iter.hasNext()) {
                PDFA2XMPSchema.PDFA2XMPType t = iter.next();
                PDFA2XMPSchema.PDFA2XMPField f = t.getFields().get(node.getName());
                if (f == null) continue;
                if (!XMPBasicTypeValidator.isPropertyUsageValid(f.getvalueType(), node, referenceSchemas, false, errorCollector, prop, xmpSchema)) {
                    return false;
                }
                validated = true;
                break;
            }
            if (validated) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<String, XMPValueType> temp = new HashMap<String, XMPValueType>();
        temp.put("Boolean", XMPBoolean.getInstance());
        temp.put("Date", XMPDate.getInstance());
        temp.put("open Choice", XMPOpenChoice.getInstance());
        temp.put("closed Choice", new XMPClosedChoice(new String[]{""}));
        temp.put("Dimensions", XMPDimensions.getInstance());
        temp.put("Integer", XMPInteger.getInstance());
        temp.put("seq Integer", XMPSeqInteger.getInstance());
        temp.put("Lang Alt", XMPLangAlt.getInstance());
        temp.put("Locale", XMPLocale.getInstance());
        temp.put("MIMEType", XMPMIMEType.getInstance());
        temp.put("ProperName", XMPProperName.getInstance());
        temp.put("Real", XMPReal.getInstance());
        temp.put("Colorant", XMPColorant.getInstance());
        temp.put("Font", XMPFont.getInstance());
        temp.put("Text", XMPText.getInstance());
        temp.put("Thumbnail", XMPThumbnail.getInstance());
        temp.put("URI", XMPURI.getInstance());
        temp.put("URL", XMPURL.getInstance());
        temp.put("XPath", XMPXPath.getInstance());
        temp.put("AgentName", XMPAgentName.getInstance());
        temp.put("RenditionClass", XMPRenditionClass.getInstance());
        temp.put("ResourceEvent", XMPResourceEvent.getInstance());
        temp.put("ResourceRef", XMPResourceRef.getInstance());
        temp.put("Version", XMPVersion.getInstance());
        temp.put("Job", XMPJob.getInstance());
        temp.put("Flash", XMPFlash.getInstance());
        temp.put("CFAPattern", XMPCFAPattern.getInstance());
        temp.put("DeviceSettings", XMPDeviceSettings.getInstance());
        temp.put("GPSCoordinate", XMPGPSCoordinate.getInstance());
        temp.put("OECF/SFR", XMPOECFSFR.getInstance());
        temp.put("Rational", XMPRational.getInstance());
        temp.put("beatSpliceStretch", XMPBeatSpliceStretch.getInstance());
        temp.put("Marker", XMPMarker.getInstance());
        temp.put("Media", XMPMedia.getInstance());
        temp.put("ProjectLink", XMPProjectLink.getInstance());
        temp.put("resampleStretch", XMPResampleStretch.getInstance());
        temp.put("Time", XMPTime.getInstance());
        temp.put("Timecode", XMPTimecode.getInstance());
        temp.put("timeScaleStretch", XMPTimeScaleStretch.getInstance());
        BASIC_XMP_PROPERTY_MAP = temp;
    }
}

