/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftone;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractExtGStateErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorHTPKeyNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorHalfToneNameKeyPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorHalfToneTypeNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorInvalidBlendMode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorInvalidRenderingIntent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorTransferFunction2ValueNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorTransferFunctionUsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SharedConstraints;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ExtGStateProcessor {
    private static HashSet<ASName> allowedBlendingModes = new HashSet();

    ExtGStateProcessor() {
    }

    static boolean process(PDFExtGStateMap extGStateMap, Set referencedExtGStateNames, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, PDFA2ValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (extGStateMap == null || extGStateMap.isEmpty()) {
            return true;
        }
        if (referencedExtGStateNames == null || referencedExtGStateNames.isEmpty()) {
            return true;
        }
        for (ASName name : referencedExtGStateNames) {
            PDFExtGState extGState = (PDFExtGState)extGStateMap.get(name);
            if (ExtGStateProcessor.process(extGState, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
            return false;
        }
        return true;
    }

    static boolean process(PDFExtGState extGState, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, PDFA2ValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (extGState == null) {
            return true;
        }
        PDFA2ErrorSet<PDFA2AbstractExtGStateErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractExtGStateErrorCode>();
        int objectNumber = extGState.getCosDictionary().getObjNum();
        int genNumber = extGState.getCosDictionary().getObjGen();
        try {
            PDFHalftone halfTone;
            ASName ri;
            if (extGState.getCosDictionary().containsKey(ASName.k_HTP)) {
                if (conversionHandler != null && conversionOptions.getRemoveExtGStateHTPKey()) {
                    extGState.removeValue(ASName.k_HTP);
                    if (!conversionHandler.extGStateHTPKeyRemoved(extGState)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorHTPKeyNotAllowed(objectNumber, genNumber));
                }
            }
            if (extGState.getCosDictionary().containsKey(ASName.k_TR)) {
                if (conversionHandler != null && conversionOptions.getRemoveTransferFunctions()) {
                    extGState.removeValue(ASName.k_TR);
                    if (!conversionHandler.transferFunctionRemoved(extGState, ASName.k_TR)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorTransferFunctionUsed(objectNumber, genNumber));
                }
            }
            CosObject tr2 = extGState.getDictionaryCosObjectValue(ASName.k_TR2);
            ASName tr2Name = null;
            if (!(tr2 == null || tr2 instanceof CosName && (tr2Name = tr2.nameValue()) == ASName.k_Default)) {
                if (conversionHandler != null && conversionOptions.getRemoveTransferFunctions()) {
                    extGState.removeValue(ASName.k_TR2);
                    if (!conversionHandler.transferFunctionRemoved(extGState, ASName.k_TR2)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorTransferFunction2ValueNotAllowed(tr2Name != null ? tr2Name.asString() : null, objectNumber, genNumber));
                }
            }
            if ((ri = extGState.getRenderingIntent()) != null && !SharedConstraints.allowedRenderingIntents.contains(ri)) {
                if (conversionHandler != null && conversionOptions.getOverrideRenderingIntent() != null) {
                    PDFRenderingIntent newIntent = conversionOptions.getOverrideRenderingIntent();
                    extGState.setRenderingIntent(newIntent);
                    if (!conversionHandler.renderingIntentOverridden(ri, newIntent.getValue())) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorInvalidRenderingIntent(ri.asString(), objectNumber, genNumber));
                }
            }
            if (!extGState.isHalftoneDefault() && (halfTone = extGState.getHalfTone()) != null) {
                if (halfTone.getHalftoneType() != 1 && halfTone.getHalftoneType() != 5) {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorHalfToneTypeNotAllowed(halfTone.getHalftoneType(), halfTone.getCosObject().getObjNum(), halfTone.getCosObject().getObjGen()));
                }
                if (halfTone.getHalftoneName() != null) {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorHalfToneNameKeyPresent(halfTone.getCosObject().getObjNum(), halfTone.getCosObject().getObjGen()));
                }
            }
            CosObject obj = extGState.getCosDictionary().get(ASName.k_BM);
            ASName bm = null;
            if (obj instanceof CosName) {
                bm = obj.nameValue();
                if (!allowedBlendingModes.contains(bm)) {
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorInvalidBlendMode(bm.asString(), objectNumber, genNumber));
                }
            } else if (obj instanceof CosArray) {
                CosArray array = (CosArray)obj;
                Iterator<CosObject> iter = array.iterator();
                CosObject bmName = null;
                while (iter.hasNext()) {
                    bmName = iter.next();
                    if (!(bmName instanceof CosName) || allowedBlendingModes.contains(bm = ((CosName)bmName).nameValue())) continue;
                    errorCodes.addErrorCode(new PDFA2ExtGStateErrorInvalidBlendMode(bm.asString(), objectNumber, genNumber));
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2ExtGStateErrorPDFGeneralFailure(objectNumber, genNumber));
        }
        return !errorCodes.hasErrors() || validationHandler.extGStateError(extGState, errorCodes);
    }

    static {
        allowedBlendingModes.add(ASName.k_Normal);
        allowedBlendingModes.add(ASName.k_Compatible);
        allowedBlendingModes.add(ASName.k_Multiply);
        allowedBlendingModes.add(ASName.k_Screen);
        allowedBlendingModes.add(ASName.k_Overlay);
        allowedBlendingModes.add(ASName.k_Darken);
        allowedBlendingModes.add(ASName.k_Lighten);
        allowedBlendingModes.add(ASName.k_ColorDodge);
        allowedBlendingModes.add(ASName.k_ColorBurn);
        allowedBlendingModes.add(ASName.k_HardLight);
        allowedBlendingModes.add(ASName.k_SoftLight);
        allowedBlendingModes.add(ASName.k_Difference);
        allowedBlendingModes.add(ASName.k_Exclusion);
        allowedBlendingModes.add(ASName.k_Hue);
        allowedBlendingModes.add(ASName.k_Saturation);
        allowedBlendingModes.add(ASName.k_Color);
        allowedBlendingModes.add(ASName.k_Luminosity);
    }
}

