/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAInvalidNamespaceUsage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SchemaCollector;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsageCollector;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.xmp.XMPException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public final class XMPProcessor {
    private static final String[] PREDEFINED_SCHEMAS = new String[]{"schemas/AdobePDFSchema.pxs", "schemas/DublinCoreSchema.pxs", "schemas/EXIFSchema.pxs", "schemas/PDFAExtensionSchemaSchema.pxs", "schemas/PDFAIdentificationSchema.pxs", "schemas/PhotoshopSchema.pxs", "schemas/RDFSchema.pxs", "schemas/RDFSSchema.pxs", "schemas/TIFFSchema.pxs", "schemas/XMPBasicJobTicketSchema.pxs", "schemas/XMPBasicSchema.pxs", "schemas/XMPMediaManagementSchema.pxs", "schemas/XMPMetaSchema.pxs", "schemas/XMPPagedTextSchema.pxs", "schemas/XMPRightsManagementSchema.pxs", "schemas/PDFUASchema.pxs"};
    private static Map<String, PDFAXMPSchema> implicitSchemas;
    private XMLNamespaceUsageCollector usageCollector;
    private SchemaCollector schemaCollector;
    private Map<String, PDFAXMPSchema> explicitSchemas;
    private Map<String, PDFAXMPSchema> referenceSchemas;
    private Map<String, XMLNamespaceUsage> namespaceUsage;
    private Set<PDFAInvalidNamespaceUsage> invalidNamespaceUsage;

    private void init() throws PDFConfigurationException {
        try {
            this.loadImplicitSchemas();
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to load schemas for PDF/A specification.", e);
        }
        catch (TransformerException e) {
            throw new PDFConfigurationException("Unable to load schemas for PDF/A specification.", e);
        }
        this.usageCollector = new XMLNamespaceUsageCollector();
        try {
            this.schemaCollector = new SchemaCollector();
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to set namespace features on XML Reader.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMPProcessor(PDFDocument pdfDocument, boolean useInternalXMP) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        this.init();
        InputStream xmpStream = null;
        try {
            xmpStream = useInternalXMP ? XMPProcessor.getStreamFromInternalXMP(pdfDocument) : XMPProcessor.getStreamFromExternalXMP(pdfDocument);
            this.processMetadata(xmpStream);
        }
        finally {
            if (xmpStream != null) {
                try {
                    xmpStream.close();
                }
                catch (IOException e) {
                    throw new PDFIOException("Error during stream close.", e);
                }
            }
        }
    }

    public XMPProcessor(InputStream xmpStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        this.init();
        this.processMetadata(xmpStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplicitSchemas() throws PDFConfigurationException, SAXException, TransformerException {
        Class<XMPProcessor> clazz = XMPProcessor.class;
        synchronized (XMPProcessor.class) {
            if (implicitSchemas != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            HashMap<String, PDFAXMPSchema> internalImplicitSchemas = new HashMap<String, PDFAXMPSchema>();
            try {
                for (String schemaFile : PREDEFINED_SCHEMAS) {
                    InputStream schemaStream = this.getClass().getResourceAsStream(schemaFile);
                    ObjectInputStream ois = new ObjectInputStream(schemaStream);
                    PDFAXMPSchema schema = (PDFAXMPSchema)ois.readObject();
                    ois.close();
                    internalImplicitSchemas.put(schema.getURI(), schema);
                }
            }
            catch (IOException e) {
                throw new PDFConfigurationException("Bad configuration - unable to load predefine PDF/A XMP schemas.");
            }
            catch (ClassNotFoundException e) {
                throw new PDFConfigurationException("Bad configuration - unable to load predefine PDF/A XMP schemas.", e);
            }
            implicitSchemas = Collections.unmodifiableMap(internalImplicitSchemas);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Set<PDFAInvalidNamespaceUsage> getInvalidNamespaceUsage(Map<String, Set<String>> nsQualifierSet) throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, XMPException {
        if (this.invalidNamespaceUsage == null) {
            this.invalidNamespaceUsage = this.generateInvalidNamespaceUsage(nsQualifierSet);
        }
        return this.invalidNamespaceUsage;
    }

    public Map<String, PDFAXMPSchema> getEmbeddedSchemas() {
        if (this.explicitSchemas == null) {
            this.explicitSchemas = new HashMap<String, PDFAXMPSchema>();
        }
        return this.explicitSchemas;
    }

    public Map<String, PDFAXMPSchema> getReferenceSchemas() {
        if (this.referenceSchemas == null) {
            this.referenceSchemas = new HashMap<String, PDFAXMPSchema>();
        }
        return this.referenceSchemas;
    }

    private Set<PDFAInvalidNamespaceUsage> generateInvalidNamespaceUsage(Map<String, Set<String>> nsQualifierSet) throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, XMPException {
        HashSet<PDFAInvalidNamespaceUsage> invalidUsage = new HashSet<PDFAInvalidNamespaceUsage>();
        if (this.namespaceUsage == null) {
            return invalidUsage;
        }
        for (XMLNamespaceUsage currentNamespaceUsage : this.namespaceUsage.values()) {
            PDFAInvalidNamespaceUsage currentInvalidUsage = new PDFAInvalidNamespaceUsage(currentNamespaceUsage);
            for (PDFAXMPSchema predefinedSchema : implicitSchemas.values()) {
                if (!currentInvalidUsage.removeSchema(predefinedSchema)) continue;
                currentInvalidUsage.addNamespaceDefinitionLocation(PDFAInvalidNamespaceUsage.DefinitionLocation.PDFA_SPECIFICATON);
            }
            for (PDFAXMPSchema embeddedSchema : this.explicitSchemas.values()) {
                if (!currentInvalidUsage.removeSchema(embeddedSchema)) continue;
                currentInvalidUsage.addNamespaceDefinitionLocation(PDFAInvalidNamespaceUsage.DefinitionLocation.PDFA_SCHEMA);
            }
            currentInvalidUsage.removeQualifiers(nsQualifierSet);
            if (currentInvalidUsage.areErrorsCleared()) continue;
            invalidUsage.add(currentInvalidUsage);
        }
        return invalidUsage;
    }

    private boolean processMetadata(InputStream metadataIS) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException {
        if (metadataIS == null) {
            return false;
        }
        try {
            Source source = XMLUtils.createSource(new InputSource(metadataIS), new XMLFilter[]{this.schemaCollector, this.usageCollector}, false);
            Result result = XMLUtils.createNullResult();
            XMLUtils.transformToXML(source, result, false);
            this.namespaceUsage = this.usageCollector.getNamespaceUsage();
            this.explicitSchemas = this.schemaCollector.getSchemas();
            this.referenceSchemas = new HashMap<String, PDFAXMPSchema>();
            for (Map.Entry<String, PDFAXMPSchema> entry : this.explicitSchemas.entrySet()) {
                String nsURI = entry.getKey();
                PDFAXMPSchema explicitSchema = entry.getValue();
                PDFAXMPSchema referenceSchema = new PDFAXMPSchema(explicitSchema);
                PDFAXMPSchema implicitSchema = implicitSchemas.get(nsURI);
                if (implicitSchema != null) {
                    referenceSchema.mergeSchema(implicitSchema);
                }
                this.referenceSchemas.put(nsURI, referenceSchema);
            }
            for (Map.Entry<String, PDFAXMPSchema> entry : implicitSchemas.entrySet()) {
                String nsURI = entry.getKey();
                if (this.referenceSchemas.get(nsURI) != null) continue;
                PDFAXMPSchema implicitSchema = entry.getValue();
                this.referenceSchemas.put(nsURI, new PDFAXMPSchema(implicitSchema));
            }
        }
        catch (SAXException e) {
            throw new PDFConfigurationException(e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException("PDF metadata XML may be invalid.", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InputStream getStreamFromExternalXMP(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMetadata metadata = pdfDocument.requireCatalog().getMetadata();
        if (metadata == null) {
            return null;
        }
        ByteArrayOutputStream metadataOS = null;
        InputByteStream metadataIBS = null;
        InputStream metadataIS = null;
        try {
            try {
                metadataOS = new ByteArrayOutputStream(metadata.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)metadata.getLength());
                metadata.getStreamData(metadataOS);
                metadataIBS = pdfDocument.getStreamManager().getInputByteStream(metadataOS.toByteArray());
                if (metadataIBS == null || metadataIBS.length() == 0L) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                metadataIS = metadataIBS.toInputStream();
                return metadataIS;
            }
            finally {
                try {
                    if (metadataIBS != null) {
                        metadataIBS.close();
                    }
                }
                finally {
                    if (metadataOS != null) {
                        metadataOS.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InputStream getStreamFromInternalXMP(PDFDocument pdfDocument) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        OutputByteStream metadataOBS = null;
        OutputStream metadataOS = null;
        InputByteStream metadataIBS = null;
        InputStream metadataIS = null;
        try {
            DocumentMetadata metadata = XMPService.getDocumentMetadata(pdfDocument);
            if (metadata == null) {
                return null;
            }
            try {
                metadataOBS = pdfDocument.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
                metadataOS = metadataOBS.toOutputStream();
                metadata.exportXMP(metadataOS);
                metadataIBS = metadataOBS.closeAndConvert();
                metadataOBS = null;
                if (metadataIBS == null || metadataIBS.length() == 0L) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                metadataIS = metadataIBS.toInputStream();
                return metadataIS;
            }
            finally {
                if (metadataOBS != null) {
                    metadataOBS.close();
                }
                if (metadataOS != null) {
                    metadataOS.close();
                }
                if (metadataIBS != null) {
                    metadataIBS.close();
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

