/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetColorSpace;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetField;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFieldErrorCode;
import java.util.Iterator;

class AcroFormProcessor {
    AcroFormProcessor() {
    }

    static boolean process(PDFInteractiveForm iform, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        block9: {
            if (iform == null) {
                return true;
            }
            if (!validationHandler.beginFormFieldTreeScan()) {
                return false;
            }
            PDFAErrorSetField errorCodes = new PDFAErrorSetField();
            try {
                if (iform.getNeedAppearances()) {
                    errorCodes.addErrorCode(PDFAFieldErrorCode.needAppearancesSet);
                }
            }
            catch (PDFInvalidDocumentException e) {
                errorCodes.addErrorCode(PDFAFieldErrorCode.pdfGeneralFailure);
            }
            if (errorCodes.hasErrors() && !validationHandler.formFieldError(errorCodes)) {
                return false;
            }
            try {
                Iterator<PDFField> iter = iform.iterator();
                while (iter.hasNext()) {
                    PDFField field = iter.next();
                    if (AcroFormProcessor.process(field, conversionOptions, conversionHandler, validationHandler)) continue;
                    return false;
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (validationHandler.colorSpaceError(new PDFAErrorSetColorSpace(PDFAColorSpaceErrorCode.pdfGeneralFailure))) break block9;
                return false;
            }
        }
        return validationHandler.endFormFieldTreeScan();
    }

    static boolean process(PDFField field, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        if (field == null) {
            return true;
        }
        if (!validationHandler.beginFormFieldScan(field)) {
            return false;
        }
        PDFAErrorSetField errorCodes = new PDFAErrorSetField();
        try {
            if (field.getCosDictionary().containsKey(ASName.k_A)) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                    CosDictionary actionDict = (CosDictionary)field.getCosDictionary().get(ASName.k_A);
                    PDFAction action = PDFActionFactory.getInstance(actionDict);
                    field.getCosDictionary().remove(ASName.k_A);
                    if (!conversionHandler.illegalActionRemoved(action)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(PDFAFieldErrorCode.actionNotAllowed);
                }
            }
            if (field.getAdditionalActions() != null) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                    PDFAdditionalActions aa = field.getAdditionalActions();
                    if (field.getDictionaryDictionaryValue(ASName.k_AA) == null && field.isAcrobatAnnotation()) {
                        field.getParent().getCosDictionary().remove(ASName.k_AA);
                    } else {
                        field.getCosDictionary().remove(ASName.k_AA);
                    }
                    if (!conversionHandler.illegalAdditionalActionsRemoved(aa)) {
                        return false;
                    }
                } else {
                    errorCodes.addErrorCode(PDFAFieldErrorCode.additionalActionsNotAllowed);
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAFieldErrorCode.pdfGeneralFailure);
        }
        if (errorCodes.hasErrors() && !validationHandler.formFieldError(errorCodes)) {
            return false;
        }
        return validationHandler.endFormFieldScan();
    }
}

