/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAMetadataErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetMetadata
extends PDFAErrorSet {
    public PDFAErrorSetMetadata() {
        super(PDFAMetadataErrorCode.class);
    }

    public PDFAErrorSetMetadata(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean catalogMissingMetadata() {
        return this.errorCodeSet(PDFAMetadataErrorCode.catalogMissingMetadata);
    }

    public boolean metadataUsesFilter() {
        return this.errorCodeSet(PDFAMetadataErrorCode.metadataUsesFilter);
    }

    public boolean malformedMetadataXML() {
        return this.errorCodeSet(PDFAMetadataErrorCode.malformedMetadataXML);
    }

    public boolean pdfaInfoNotPresent() {
        return this.errorCodeSet(PDFAMetadataErrorCode.pdfaInfoNotPresent);
    }

    public boolean pdfaVersionScanMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.pdfaVersionScanMismatch);
    }

    public boolean pdfaConformanceScanMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.pdfaConformanceScanMismatch);
    }

    public boolean xmpAndDocInfoTitleMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoTitleMismatch);
    }

    public boolean xmpAndDocInfoAuthorMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoAuthorMismatch);
    }

    public boolean xmpAndDocInfoSubjectMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoSubjectMismatch);
    }

    public boolean xmpAndDocInfoKeywordsMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoKeywordsMismatch);
    }

    public boolean xmpAndDocInfoCreatorMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoCreatorMismatch);
    }

    public boolean xmpAndDocInfoProducerMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoProducerMismatch);
    }

    public boolean xmpAndDocInfoCreationDateMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoCreationDateMismatch);
    }

    public boolean xmpAndDocInfoModDateMismatch() {
        return this.errorCodeSet(PDFAMetadataErrorCode.xmpAndDocInfoModDateMismatch);
    }

    public boolean invalidPrefix() {
        return this.errorCodeSet(PDFAMetadataErrorCode.invalidPrefix);
    }

    public boolean invalidXMPHeader() {
        return this.errorCodeSet(PDFAMetadataErrorCode.invalidXMPHeader);
    }

    public boolean missingExtensionSchema() {
        return this.errorCodeSet(PDFAMetadataErrorCode.missingExtensionSchema);
    }

    public boolean elementUsedNotDefined() {
        return this.errorCodeSet(PDFAMetadataErrorCode.elementUsedNotDefined);
    }

    public boolean schemaUsageNotValid() {
        return this.errorCodeSet(PDFAMetadataErrorCode.schemaUsageNotValid);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAMetadataErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.catalogMissingMetadata()) {
            violations.add("catalog is missing metadata");
        }
        if (this.metadataUsesFilter()) {
            violations.add("metadata uses a stream filter");
        }
        if (this.malformedMetadataXML()) {
            violations.add("metadata XML is malformed");
        }
        if (this.pdfaInfoNotPresent()) {
            violations.add("PDF/A info not set in metadata");
        }
        if (this.pdfaVersionScanMismatch()) {
            violations.add("PDF/A version (pdfaid:part) does not match validation params");
        }
        if (this.pdfaConformanceScanMismatch()) {
            violations.add("PDF/A conformance (pdfaid:conformance) does not match validation params");
        }
        if (this.xmpAndDocInfoTitleMismatch()) {
            violations.add("XMP metadata and DocInfo \"title\" entries do not mach");
        }
        if (this.xmpAndDocInfoAuthorMismatch()) {
            violations.add("XMP metadata and DocInfo \"author\" entries do not match");
        }
        if (this.xmpAndDocInfoSubjectMismatch()) {
            violations.add("XMP metadata and DocInfo \"subject\" entries do not match");
        }
        if (this.xmpAndDocInfoKeywordsMismatch()) {
            violations.add("XMP metadata and DocInfo \"keywords\" entries do not match");
        }
        if (this.xmpAndDocInfoCreatorMismatch()) {
            violations.add("XMP metadata and DocInfo \"creator\" entries do not match");
        }
        if (this.xmpAndDocInfoProducerMismatch()) {
            violations.add("XMP metadata and DocInfo \"producer\" entries do not match");
        }
        if (this.xmpAndDocInfoCreationDateMismatch()) {
            violations.add("XMP metadata and DocInfo \"creation date\" entries do not match");
        }
        if (this.xmpAndDocInfoModDateMismatch()) {
            violations.add("XMP metadata and DocInfo \"modification date\" entries do not match");
        }
        if (this.invalidPrefix()) {
            violations.add("XMP metadata uses an invalid prefix or namespace URI");
        }
        if (this.invalidXMPHeader()) {
            violations.add("XMP xpacket header in invalid.  It may be missing, have invalid attriubtes, and/or be missing required attributes.");
        }
        if (this.missingExtensionSchema()) {
            violations.add("XMP metadata uses a namespace for which an extension schema is not defined");
        }
        if (this.elementUsedNotDefined()) {
            violations.add("XMP metadata uses an element which is not defined in the specification or an embedded schema");
        }
        if (this.schemaUsageNotValid()) {
            violations.add("XMP metadata is not used as required by XMP and PDFA spec.");
        }
        return super.toString() + " " + violations;
    }
}

