/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAExtGStateErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetExtGState
extends PDFAErrorSet {
    public PDFAErrorSetExtGState() {
        super(PDFAExtGStateErrorCode.class);
    }

    public PDFAErrorSetExtGState(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean transferFunctionNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.transferFunctionNotAllowed);
    }

    public boolean transferFunction2ValueNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.transferFunction2ValueNotAllowed);
    }

    public boolean softMaskValueNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.softMaskValueNotAllowed);
    }

    public boolean blendModeNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.blendModeNotAllowed);
    }

    public boolean strokeOpacityValueNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.strokeOpacityValueNotAllowed);
    }

    public boolean fillOpacityValueNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.fillOpacityValueNotAllowed);
    }

    public boolean renderingIntentValueNotAllowed() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.renderingIntentValueNotAllowed);
    }

    public boolean blendModeTypeInvalid() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.blendModeTypeInvalid);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAExtGStateErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.transferFunctionNotAllowed()) {
            violations.add("TR entry not permitted");
        }
        if (this.transferFunction2ValueNotAllowed()) {
            violations.add("TR2 value not permitted");
        }
        if (this.softMaskValueNotAllowed()) {
            violations.add("SMask value not permitted");
        }
        if (this.blendModeNotAllowed()) {
            violations.add("BM value not permitted");
        }
        if (this.strokeOpacityValueNotAllowed()) {
            violations.add("CA value not permitted");
        }
        if (this.fillOpacityValueNotAllowed()) {
            violations.add("ca value not permitted");
        }
        if (this.renderingIntentValueNotAllowed()) {
            violations.add("RI value not permitted");
        }
        if (this.blendModeTypeInvalid()) {
            violations.add("RI value not permitted");
        }
        return super.toString() + " " + violations;
    }
}

