/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfParser;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.filter.spi.ImageFilterInterface;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentImageItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentPathItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentTextItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DisplayArea;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsCallBackInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.ShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.AxialShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.CoonsPatchMeshesShading;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.FunctionBasedShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.RadialShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.ImageInputSourceImpl;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.image.ImageResamplingMethod;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.StatefulOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectProcessingFunction;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GStateStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.Path;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StatefulContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObject;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceN;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpacePattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ColorSpaceCacheImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingAxial;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingCoons;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMeshes;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingNoMeshes;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingRadial;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFSoftMask;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFSoftMaskLuminosity;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFXObjectImageSoftMask;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Parser;
import com.adobe.internal.pdftoolkit.services.fontresources.FontMatchingParameters;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCManager;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCUsageAppHandler;
import com.adobe.internal.pdftoolkit.services.pdfParser.PDFContentItemsList;
import com.adobe.internal.pdftoolkit.services.pdfParser.PDFGState;
import com.adobe.internal.pdftoolkit.services.pdfParser.ParserUtils;
import com.adobe.internal.pdftoolkit.services.pdfParser.TransparencyParameterContainer;
import com.adobe.internal.util.ArrayListStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class ContentStreamParser<G extends GraphicsState, CO extends ContentItem<G>, T extends com.adobe.internal.pdftoolkit.graphicsDOM.TextState, D extends DisplayArea<G, T, CO>>
extends StatefulOperatorHandler {
    public static final int DEFAULT_WIDTH_AND_HEIGHT = 9;
    private static final double[] DEFAULT_CROP_BOX = new double[]{0.0, 0.0, 612.0, 792.0};
    private Map<String, Font> loadedAFEFonts;
    private Map<String, TilingPattern<? extends GraphicsState, ? extends com.adobe.internal.pdftoolkit.graphicsDOM.TextState, ? extends ContentItem<? extends GraphicsState>>> loadedTilingPatterns;
    private Map<String, ShadingPattern<? extends GraphicsState, ? extends com.adobe.internal.pdftoolkit.graphicsDOM.TextState, ? extends ContentItem<? extends GraphicsState>>> loadedShadingPatterns;
    private Map<CosDictionary, ShadingPattern<G, T, CO>> shadingDictToObjMap;
    private Map<String, ContentImageItem<G>> loadedImageXObjects;
    ContentItemsList<G, CO> currentContentItemsList = null;
    private double[] downsampleImagesFactor = null;
    ArrayListStack<TransparencyParameterContainer> transparencyParameterContainerStack = new ArrayListStack();
    private Map<String, ColorSpaceCacheImpl> loadedColorSpaces;
    private static final double defaultScalingFactorInCaseOfZeroScaledText = 0.01;
    private static final double defaultScalingFactorInCaseOfZeroScaledImage = 0.1;
    private ContentStreamProcessor streamProcessor;
    private DocumentInterface<G, T, CO, D> outDoc;
    private boolean processAnnotations = false;
    private ArrayListStack<Boolean> markedContentVisibilityStack = null;
    private GraphicsCallBackInterface callBackManager = null;
    private boolean isGSSoftMask = false;
    private boolean isIgnoreError = false;
    private boolean isApplyOverPrintMode = false;
    private Map<PDFXObjectForm, XObject<G, T, CO>> loadedSmaskFormXObjects;
    private boolean isExceptionMode;
    private boolean isTextAsClipPath = false;
    private GeneralPath currentTextGroupPath = null;
    private OCManager ocManager = null;

    public ContentStreamParser(DocumentInterface<G, T, CO, D> outDoc, PDFFontSet pdfFontSet, double[] downsampleImagesFactor, boolean processAnnotations, GraphicsCallBackInterface callBackManager, boolean isApplyOverPrintMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        this.downsampleImagesFactor = downsampleImagesFactor;
        this.fontSet = pdfFontSet;
        this.outDoc = outDoc;
        this.streamProcessor = new StatefulContentStreamProcessor(this);
        this.processAnnotations = processAnnotations;
        this.callBackManager = callBackManager;
        this.isApplyOverPrintMode = isApplyOverPrintMode;
    }

    public void setIsIgnoreError(boolean isIgnoreError) {
        this.isIgnoreError = isIgnoreError;
    }

    private void init(double[] clipRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.loadedColorSpaces = new HashMap<String, ColorSpaceCacheImpl>();
        ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceGray.newInstance(this.currentPage.getPDFDocument()), this.loadedColorSpaces, ASName.k_DeviceGray);
        ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceRGB.newInstance(this.currentPage.getPDFDocument()), this.loadedColorSpaces, ASName.k_DeviceRGB);
        ColorSpaceCacheImpl.newInstance(PDFColorSpaceDeviceCMYK.newInstance(this.currentPage.getPDFDocument()), this.loadedColorSpaces, ASName.k_DeviceCMYK);
        this.gStateStack = new GStateStack<PDFGState>(new PDFGState(this.loadedColorSpaces));
        this.getGState().addPathToClip(new Area(new Rectangle((int)clipRect[0], (int)clipRect[1], (int)(clipRect[2] - clipRect[0]), (int)(clipRect[3] - clipRect[1]))));
        this.loadedAFEFonts = new HashMap<String, Font>();
        this.loadedTilingPatterns = new HashMap<String, TilingPattern<? extends GraphicsState, ? extends com.adobe.internal.pdftoolkit.graphicsDOM.TextState, ? extends ContentItem<? extends GraphicsState>>>();
        this.loadedShadingPatterns = new HashMap<String, ShadingPattern<? extends GraphicsState, ? extends com.adobe.internal.pdftoolkit.graphicsDOM.TextState, ? extends ContentItem<? extends GraphicsState>>>();
        this.shadingDictToObjMap = new HashMap<CosDictionary, ShadingPattern<G, T, CO>>(64);
        this.fontCache = new HashMap();
        this.cosToFontMap = new HashMap();
        TransparencyParameterContainer transparencyParameterContainer = new TransparencyParameterContainer();
        transparencyParameterContainer.setNonStrokeAlpha(1.0);
        transparencyParameterContainer.setStrokeAlpha(1.0);
        this.transparencyParameterContainerStack.push(transparencyParameterContainer);
        this.currentContentItemsList = new PDFContentItemsList<G, CO>(this.streamProcessor, Content.newInstance(this.currentPage), this.getGState(), transparencyParameterContainer, this.processAnnotations);
    }

    private double[] getBBox(double width, double height, boolean useTrimBox) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFRectangle bBox;
        if (useTrimBox) {
            bBox = this.currentPage.getTrimBox();
            bBox = bBox.createIntersection(this.currentPage.getCropBox());
        } else {
            bBox = this.currentPage.getCropBox();
        }
        if (bBox == null) {
            if (width != 0.0 && height != 0.0) {
                return new double[]{0.0, 0.0, width, height};
            }
            return DEFAULT_CROP_BOX;
        }
        bBox = bBox.normalized(this.currentPage.getPDFDocument());
        if (width != 0.0 && height != 0.0) {
            return new double[]{bBox.llx(), bBox.lly(), bBox.llx() + width, bBox.lly() + height};
        }
        double[] bbox = bBox.getValues();
        if (bBox.height() != 0.0 || bBox.width() != 0.0) {
            if (bBox.height() == 0.0) {
                bbox[3] = bbox[1] + 9.0;
            } else if (bBox.width() == 0.0) {
                bbox[2] = bbox[0] + 9.0;
            }
        }
        return bbox;
    }

    public D processObjectsInPage(PDFPage page, double width, double height, boolean useTrimBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        this.xobjectsCycleDetector = XObjectsCycleDetector.getInstance(page.getPDFDocument());
        this.currentPage = page;
        D displayArea = this.outDoc.getFactory().createDisplayArea(this.getBBox(width, height, useTrimBox));
        displayArea.setDisplayRotation(page.getRotation().getValue());
        this.init(page.getCropBox().getValues());
        displayArea.setContentItems(this.currentContentItemsList);
        return displayArea;
    }

    void processAnnotations() {
        if (!this.processAnnotations) {
            return;
        }
        try {
            PDFAnnotationIterator annotItr = this.currentPage.getAnnotationsIterator();
            PDFAnnotation annot = null;
            while (annotItr.hasNext()) {
                PDFXObjectForm xObject;
                PDFOCObject ocObject;
                annot = annotItr.next();
                if (annot.getDictionaryCosObjectValue(ASName.k_OC) instanceof CosDictionary && (ocObject = PDFOCObject.getOC(annot)) != null) {
                    this.initializeOC();
                    if (this.ocManager != null && !this.ocManager.isVisible(ocObject)) continue;
                }
                if ((xObject = annot.getNormalStateAppearance()) == null) continue;
                this.q(null);
                this.getGState().setCTM(new ASMatrix(xObject.getMatrix()).concat(new ASMatrix(1.0, 0.0, 0.0, 1.0, annot.getRect().llx(), annot.getRect().lly())));
                double[] colorValues = this.getGState().getFillColorValues();
                double[] strokeColorValues = this.getGState().getStrokeColorValues();
                this.getGState().setStrokeColorValues(this.getGState().getStrokePDFColorSpace().toRGB(null));
                if (colorValues != null) {
                    this.getGState().setFillColorValues(this.getGState().getFillPDFColorSpace().toRGB(null));
                }
                XObject xObj = this.outDoc.getFactory().createXObject(this.createGraphicsState());
                xObj.setContentItems(new PDFContentItemsList(this.streamProcessor, Content.newInstance(xObject), this.getGState(), null));
                this.currentContentItemsList.add(xObj);
                this.Q(null);
                this.getGState().setFillColorValues(colorValues);
                this.getGState().setStrokeColorValues(strokeColorValues);
            }
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.contentStack.peek().getResources();
    }

    @Override
    public PDFGState getGState() {
        return (PDFGState)this.gStateStack.peek();
    }

    @Override
    public void pushGState() {
        PDFGState gState = new PDFGState((PDFGState)this.gStateStack.peek());
        this.gStateStack.push(gState);
    }

    @Override
    public PDFGState popGState() {
        return (PDFGState)this.gStateStack.pop();
    }

    @Override
    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pushGState();
    }

    @Override
    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.popGState();
    }

    @Override
    public void cm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix ctm = new ASMatrix(a, b, c, d, e, f);
        PDFGState gState = this.getGState();
        gState.setCTM(ctm.concat(gState.getCTM()));
    }

    @Override
    public void m(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.getPath().moveTo((float)x, (float)y);
    }

    @Override
    public void l(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        try {
            this.currentPath.getPath().lineTo((float)x, (float)y);
        }
        catch (IllegalPathStateException e) {
            // empty catch block
        }
    }

    @Override
    public void c(double x1, double y1, double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.getPath().curveTo((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3);
    }

    @Override
    public void v(double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.getPath().quadTo((float)x2, (float)y2, (float)x3, (float)y3);
    }

    @Override
    public void y(double x1, double y1, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.getPath().quadTo((float)x1, (float)y1, (float)x3, (float)y3);
    }

    @Override
    public void h(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.closePath();
    }

    @Override
    public void re(double x, double y, double width, double height, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.getPath().moveTo((float)x, (float)y);
        this.currentPath.getPath().lineTo((float)(x + width), (float)y);
        this.currentPath.getPath().lineTo((float)(x + width), (float)(y + height));
        this.currentPath.getPath().lineTo((float)x, (float)(y + height));
        this.closePath();
    }

    @Override
    protected void createNewPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentPath = new Path();
        this.currentPath.setWindingRule(0);
    }

    @Override
    protected void endPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentPath = null;
    }

    @Override
    public void S(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.addPathAsContentItem(PathPainting.STROKE);
        this.endPath();
    }

    private void closePath() {
        try {
            this.currentPath.getPath().closePath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void s(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.closePath();
        this.addPathAsContentItem(PathPainting.STROKE);
        this.endPath();
    }

    @Override
    public void f(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath != null) {
            this.closePath();
            this.currentPath.setWindingRule(1);
            this.addPathAsContentItem(PathPainting.FILL);
            this.endPath();
        }
    }

    @Override
    public void F(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.f(instruction);
    }

    private void addPathAsContentItem(PathPainting pathPaintType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        G graphicsState = this.createGraphicsState();
        if (this.currentPath != null && (this.markedContentVisibilityStack == null || this.markedContentVisibilityStack.peek().booleanValue())) {
            ContentPathItem<G> pathCI = this.outDoc.getFactory().createContentPathItem(graphicsState);
            pathCI.setPath(this.currentPath.getPath(), pathPaintType);
            pathCI.setTransformationMatrix(this.getGState().getCTM());
            this.currentContentItemsList.add(pathCI);
        }
    }

    @Override
    public void fStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.closePath();
        this.currentPath.setWindingRule(0);
        this.addPathAsContentItem(PathPainting.FILLODDEVEN);
        this.endPath();
    }

    @Override
    public void B(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.setWindingRule(1);
        this.addPathAsContentItem(PathPainting.FILLANDSTROKE);
        this.endPath();
    }

    @Override
    public void BStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.setWindingRule(0);
        this.addPathAsContentItem(PathPainting.FILLANDSTROKEODDEVEN);
        this.endPath();
    }

    @Override
    public void b(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.closePath();
        this.currentPath.setWindingRule(1);
        this.addPathAsContentItem(PathPainting.FILLANDSTROKE);
        this.endPath();
    }

    @Override
    public void bStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.closePath();
        this.currentPath.setWindingRule(0);
        this.addPathAsContentItem(PathPainting.FILLANDSTROKEODDEVEN);
        this.endPath();
    }

    @Override
    public void n(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.endPath();
    }

    @Override
    public void W(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            return;
        }
        this.closePath();
        this.currentPath.setWindingRule(1);
        GeneralPath transformedPath = (GeneralPath)this.currentPath.getPath().clone();
        transformedPath.transform(new AffineTransform(this.getGState().getCTM().getValues()));
        transformedPath = ParserUtils.optimizePath(transformedPath);
        this.getGState().addPathToClip(new Area(transformedPath));
    }

    @Override
    public void WStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            return;
        }
        this.closePath();
        this.currentPath.setWindingRule(0);
        GeneralPath transformedPath = (GeneralPath)this.currentPath.getPath().clone();
        transformedPath.transform(new AffineTransform(this.getGState().getCTM().getValues()));
        transformedPath = ParserUtils.optimizePath(transformedPath);
        this.getGState().addPathToClip(new Area(transformedPath));
    }

    @Override
    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.showString(string);
    }

    @Override
    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.TStar(null);
        this.Tj(string, null);
    }

    @Override
    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.Tw(wordSpacing, null);
        this.Tc(charSpacing, null);
        this.showString(string);
    }

    @Override
    public void TJ(ASArray tjArray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.showText(tjArray);
    }

    private void showString(ASString string) throws PDFInvalidDocumentException {
        ASArray array = new ASArray();
        array.add(string);
        try {
            this.showText(array);
        }
        catch (MissingResourceException me) {
            Throwable toThrow = null;
            if (this.callBackManager != null) {
                toThrow = this.callBackManager.reportError(me);
            }
            if (toThrow != null) {
                throw new PDFInvalidDocumentException(toThrow);
            }
        }
        catch (Exception e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    private G createGraphicsState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSoftMaskLuminosity softMaskLuminosity;
        PDFXObject g;
        G gState = this.outDoc.getFactory().createGraphicsState();
        double[] colorValues = this.getGState().getFillColorValues();
        if (colorValues == null) {
            colorValues = this.getGState().getFillPDFColorSpace().toRGB(null);
        }
        ((GraphicsState)gState).setFillColorValues(colorValues);
        colorValues = this.getGState().getStrokeColorValues();
        if (colorValues == null) {
            colorValues = this.getGState().getStrokePDFColorSpace().toRGB(null);
        }
        ((GraphicsState)gState).setStrokeColorValues(colorValues);
        ((GraphicsState)gState).setLineCap(ParserUtils.mapLineCap(this.getGState().getLineCap()));
        ((GraphicsState)gState).setLineJoin(ParserUtils.mapLineJoints(this.getGState().getLineJoin()));
        double lineWidth = this.getGState().getLineWidth();
        ASRectangle transformedRect = new ASRectangle(0.0, 0.0, 0.0, lineWidth).transform(this.getGState().getCTM());
        ((GraphicsState)gState).setLineWidth(transformedRect.height());
        ((GraphicsState)gState).setMiterLimit(this.getGState().getMiterLimit());
        ((GraphicsState)gState).setStrokeAdjustment(this.getGState().getStrokeAdjustment());
        double productStrokeAlpha = this.getGState().getStrokeAlpha() * this.transparencyParameterContainerStack.peek().getStrokeAlpha();
        if (productStrokeAlpha != 0.0) {
            productStrokeAlpha = productStrokeAlpha < 0.01 ? this.getGState().getStrokeAlpha() : productStrokeAlpha;
        }
        ((GraphicsState)gState).setStrokeAlpha(productStrokeAlpha);
        double productNonStrokeAlpha = this.getGState().getNonStrokeAlpha() * this.transparencyParameterContainerStack.peek().getNonStrokeAlpha();
        if (productNonStrokeAlpha != 0.0) {
            productNonStrokeAlpha = productNonStrokeAlpha < 0.01 ? this.getGState().getStrokeAlpha() : productNonStrokeAlpha;
        }
        ((GraphicsState)gState).setNonStrokeAlpha(productNonStrokeAlpha);
        ((GraphicsState)gState).setSmoothness(this.getGState().getSmoothness());
        Area clippingArea = this.getGState().getClippingArea();
        if (clippingArea != null) {
            ((GraphicsState)gState).setClipPath(clippingArea);
        }
        ((GraphicsState)gState).setFillTilingPatternName(this.getGState().getFillTilingPatternName());
        ((GraphicsState)gState).setStrokeTilingPatternName(this.getGState().getStrokeTilingPatternName());
        ((GraphicsState)gState).setLoadedTilingPatterns(this.loadedTilingPatterns);
        ((GraphicsState)gState).setFillShadingPatternName(this.getGState().getFillShadingPattern());
        ((GraphicsState)gState).setStrokeShadingPatternName(this.getGState().getStrokeShadingPattern());
        ((GraphicsState)gState).setLoadedShadingPatterns(this.loadedShadingPatterns);
        ((GraphicsState)gState).setDashArray(this.getGState().getDashPattern().getPattern());
        ((GraphicsState)gState).setDashPhase(this.getGState().getDashPattern().getPhase());
        ((GraphicsState)gState).setOverPrintMode(this.getGState().getOverprintMode());
        ((GraphicsState)gState).setFlatnessTolerance(this.getGState().getFlatness());
        ((GraphicsState)gState).setTextKnockoutFlag(this.getGState().getTextKnockout());
        ((GraphicsState)gState).setRenderingIntent(ParserUtils.mapRenderingIntent(this.getGState().getRenderingIntent()));
        ASName[] blendMode = this.getGState().getBlendMode();
        PDFGState gs = this.getGState();
        CosDictionary cosSoftMask = gs.getSoftMask();
        PDFSoftMask gsSoftMask = PDFSoftMask.getInstance(cosSoftMask);
        ContentItem cachedSoftMask = ((GraphicsState)gState).getCachedSoftMask();
        if (cachedSoftMask != null) {
            ((GraphicsState)gState).setGraphicsStateSoftMask(cachedSoftMask);
        } else if (gsSoftMask != null && !this.isGSSoftMask && gsSoftMask.getSubtype() == ASName.k_Luminosity && (g = (softMaskLuminosity = (PDFSoftMaskLuminosity)gsSoftMask).getG()) instanceof PDFXObjectForm) {
            PDFXObjectForm pdfxObjectForm = (PDFXObjectForm)g;
            if (this.loadedSmaskFormXObjects == null) {
                this.loadedSmaskFormXObjects = new HashMap<PDFXObjectForm, XObject<G, T, CO>>();
            }
            if (this.loadedSmaskFormXObjects.containsKey(pdfxObjectForm)) {
                ((GraphicsState)gState).setGraphicsStateSoftMask(this.loadedSmaskFormXObjects.get(pdfxObjectForm));
                ((GraphicsState)gState).setCachedSoftMask(this.loadedSmaskFormXObjects.get(pdfxObjectForm));
            } else {
                PDFGroupAttributes group;
                if (softMaskLuminosity.hasBackdropColor()) {
                    CosArray bc = softMaskLuminosity.getBackdropColor();
                    int noc = bc.size();
                    switch (noc) {
                        case 1: {
                            ((GraphicsState)gState).setBackdropColor(new Color(bc.getInt(0)).getRGB());
                            break;
                        }
                        case 3: {
                            ((GraphicsState)gState).setBackdropColor(new Color(bc.getInt(0), bc.getInt(1), bc.getInt(2)).getRGB());
                            break;
                        }
                        case 4: {
                            double[] rgb = this.getGState().getFillPDFColorSpace().toRGB(new double[]{bc.getInt(0), bc.getInt(1), bc.getInt(2), bc.getInt(3)});
                            if (rgb == null) {
                                rgb = new double[]{0.0, 0.0, 0.0};
                            }
                            ((GraphicsState)gState).setBackdropColor(new Color((int)rgb[0], (int)rgb[1], (int)rgb[2]).getRGB());
                        }
                    }
                }
                if (!(group = pdfxObjectForm.getGroup()).getIsolated() && !group.getKnockout()) {
                    this.isGSSoftMask = true;
                    XObject<G, T, CO> xObj = this.processXobjectForm(pdfxObjectForm, gState);
                    xObj.setBBox(pdfxObjectForm.getBBox().getValues());
                    ((GraphicsState)gState).setGraphicsStateSoftMask(xObj);
                    ((GraphicsState)gState).setCachedSoftMask(xObj);
                    this.isGSSoftMask = false;
                    this.loadedSmaskFormXObjects.put(pdfxObjectForm, xObj);
                }
            }
        }
        if (blendMode != null) {
            for (int i = 0; i < blendMode.length; ++i) {
                if (blendMode[i] == ASName.k_Multiply) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.MULTIPLY);
                    continue;
                }
                if (blendMode[i] == ASName.k_Screen) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.SCREEN);
                    continue;
                }
                if (blendMode[i] == ASName.k_Darken) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.DARKEN);
                    continue;
                }
                if (blendMode[i] == ASName.k_Lighten) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.LIGHTEN);
                    continue;
                }
                if (blendMode[i] == ASName.k_Difference) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.DIFFERENCE);
                    continue;
                }
                if (blendMode[i] == ASName.k_Exclusion) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.EXCLUSION);
                    continue;
                }
                if (blendMode[i] == ASName.k_ColorDodge) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.COLORDODGE);
                    continue;
                }
                if (blendMode[i] == ASName.k_ColorBurn) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.COLORBURN);
                    continue;
                }
                if (blendMode[i] == ASName.k_HardLight) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.HARDLIGHT);
                    continue;
                }
                if (blendMode[i] == ASName.k_SoftLight) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.SOFTLIGHT);
                    continue;
                }
                if (blendMode[i] == ASName.k_Overlay) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.OVERLAY);
                    continue;
                }
                if (blendMode[i] == ASName.k_Luminosity) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.LUMINOSITY);
                    continue;
                }
                if (blendMode[i] == ASName.k_Color) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.COLOR);
                    continue;
                }
                if (blendMode[i] == ASName.k_Saturation) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.SATURATION);
                    continue;
                }
                if (blendMode[i] != ASName.k_Hue) continue;
                ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.HUE);
            }
        }
        boolean overprint = this.getGState().getNonStrokeOverprint();
        if (this.isApplyOverPrintMode && overprint) {
            int overprintMode = this.getGState().getOverprintMode();
            ((GraphicsState)gState).setOverPrintMode(overprintMode);
            ((GraphicsState)gState).setOverPrint(overprint);
            ASName colorSpaceName = this.getGState().getStrokePDFColorSpace().getUnderlyingColorspace().getName();
            if (colorSpaceName == ASName.k_CMYK) {
                if (overprintMode == 1) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTSrc);
                } else {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTDst);
                }
            }
            if (colorSpaceName == ASName.k_DeviceN || colorSpaceName == ASName.k_Separation) {
                if (overprintMode == 1) {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTDst);
                } else {
                    ((GraphicsState)gState).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTSrc);
                }
            }
        }
        if (this.isExceptionMode) {
            PDFSoftMask softMask;
            double alphaConstant;
            boolean alphaSource;
            StringBuilder builder = new StringBuilder();
            boolean isAnyException = false;
            if (blendMode != null) {
                for (int i = 0; i < blendMode.length; ++i) {
                    if (blendMode[i] == ASName.k_Normal || blendMode[i] != ASName.k_Hue && blendMode[i] != ASName.k_Saturation) continue;
                    builder.append(blendMode[i].asString() + " blending mode in Transparency unsupported, ");
                    isAnyException = true;
                }
            }
            if (alphaSource = this.getGState().getAlphaSource()) {
                builder.append("alpha parameters are to be interpreted as shape values");
                isAnyException = true;
            }
            if ((alphaConstant = this.getGState().getAlphaConstant()) != 1.0) {
                builder.append("constant shape or constant opacity value to be used in the transparent imaging model");
                isAnyException = true;
            }
            if ((softMask = PDFSoftMask.getInstance(this.getGState().getSoftMask())) != null) {
                if (softMask.getType() == ASName.create("Alpha")) {
                    builder.append("Soft Mask from Group Alpha");
                }
                if (softMask.getType() == ASName.k_Luminosity) {
                    builder.append("Soft Mask from Group Luminosity");
                }
                isAnyException = true;
            }
            if (isAnyException) {
                throw new UnsupportedOperationException(builder.toString());
            }
        }
        return gState;
    }

    private void showText(ASArray tjArray, PDFFont font, Font afeFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        PDFSimpleFontEncoding encoding = null;
        PDFEncodingDifferences differences = null;
        PDFResources type3FontResources = null;
        double fs = this.getTextState().getFontSize();
        double h = this.getTextState().getHorizScaling() / 100.0;
        double c = this.getTextState().getCharSpacing();
        double w = this.getTextState().getWordSpacing();
        double fsh = fs * h;
        double ch = c * h;
        double wh = w * h;
        double txDelta = 0.0;
        double tyDelta = 0.0;
        double prevTxDelta = 0.0;
        int[] dw2 = null;
        boolean isVerticalWritingMode = false;
        double textRise = this.getGState().getTextState().getRise();
        int renderingMode = this.getGState().getTextState().getRenderingMode();
        T tState = this.outDoc.getFactory().createTextState();
        G gState = this.createGraphicsState();
        ContentTextItem<T, G> textCI = this.outDoc.getFactory().createContentTextItem(gState, tState);
        if (font instanceof PDFFontType0 && ((PDFFontType0)font).getWritingMode() == PDFWritingMode.VERTICAL) {
            isVerticalWritingMode = true;
            ASMatrix tm = this.getCurrentTextObject().getTextMatrix();
            PDFFontType0 fontType0 = (PDFFontType0)font;
            dw2 = fontType0.getDescendantFont().getDW2();
            tm = tm.preMultiply(0.0, (double)(-dw2[0]) / 1000.0);
            this.getCurrentTextObject().setTextMatrix(tm);
        }
        ASMatrix tMatrix = this.getCurrentTextObject().getTextMatrix().concat(this.getGState().getCTM());
        if (font instanceof PDFFontType3) {
            encoding = ((PDFFontType3)font).getEncoding();
            differences = encoding.getDifferences();
            type3FontResources = ((PDFFontType3)font).getResources();
            if (type3FontResources == null) {
                type3FontResources = this.currentPage.getResources();
            }
        } else {
            String key = GraphicsUtils.generateKey(font.getCosObject().getObjNum(), this.getTextState().getFontName(), null);
            this.loadedAFEFonts.put(key, afeFont);
            if (tMatrix.geta() == 0.0 || tMatrix.getd() == 0.0) {
                double a = tMatrix.geta() == 0.0 ? 0.01 : tMatrix.geta();
                double d = tMatrix.getd() == 0.0 ? 0.01 : tMatrix.getd();
                tMatrix = new ASMatrix(a, tMatrix.getb(), tMatrix.getc(), d, tMatrix.getx(), tMatrix.gety());
                ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setIsTextScalingAdjusted(true);
            }
            ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setFontName(key);
            ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setFontMap(this.loadedAFEFonts);
            ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setFontSize(fs);
        }
        ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setMatrix(new double[]{tMatrix.geta(), tMatrix.getb(), tMatrix.getc(), tMatrix.getd(), tMatrix.getx(), tMatrix.gety()});
        ArrayList<Glyph> textString = new ArrayList<Glyph>();
        textCI.setText(textString);
        ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setTextRenderingMode(renderingMode);
        ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setTextRise(textRise);
        double leading = this.getTextState().getLeading();
        if (!this.isTD) {
            ((com.adobe.internal.pdftoolkit.graphicsDOM.TextState)tState).setTextLeading(leading);
        }
        if (this.markedContentVisibilityStack == null || !this.markedContentVisibilityStack.isEmpty() && this.markedContentVisibilityStack.peek().booleanValue()) {
            this.currentContentItemsList.add(textCI);
        }
        for (ASObject obj : tjArray) {
            if (obj instanceof ASNumber) {
                double tj = ((ASNumber)obj).doubleValue();
                if (isVerticalWritingMode) {
                    tyDelta = -tj / 1000.0 * fsh;
                } else {
                    txDelta = -tj / 1000.0 * fsh;
                }
                ASMatrix tm = this.getCurrentTextObject().getTextMatrix();
                tm = tm.preMultiply(txDelta, tyDelta);
                this.getCurrentTextObject().setTextMatrix(tm);
                continue;
            }
            if (!(obj instanceof ASString)) continue;
            List charCodes = null;
            byte[] codeBytes = ((ASString)obj).getBytes();
            try {
                charCodes = font.getCharCodes(codeBytes, false);
                int count = charCodes.size();
                for (int j = 0; j < count; ++j) {
                    byte[] charCodeBytes = (byte[])((List)charCodes.get(j)).get(0);
                    double w0 = 0.0;
                    int charCode = 0;
                    for (int i = 0; i < charCodeBytes.length; ++i) {
                        if (i > 0) {
                            charCode <<= 8;
                        }
                        charCode |= charCodeBytes[i] & 0xFF;
                    }
                    int gid = 0;
                    if (afeFont != null) {
                        if (font instanceof PDFFontSimple) {
                            gid = PDFFontUtils.getSimpleFontGidFromCharCode(charCode, PDFFontUtils.charCode2glyphName(charCode, (PDFFontSimple)font, ((FontImpl)afeFont).getFontData()), ((PDFFontSimple)font).getEncoding(), ((FontImpl)afeFont).getFontData(), font.getFontDescriptor());
                        } else if (font instanceof PDFFontType0) {
                            gid = PDFFontUtils.charCode2gid(charCode, (PDFFontType0)font, ((FontImpl)afeFont).getFontData());
                        }
                    }
                    txDelta = 0.0;
                    tyDelta = 0.0;
                    ASMatrix tm = this.getCurrentTextObject().getTextMatrix().concat(this.getGState().getCTM());
                    if (isVerticalWritingMode) {
                        w0 = font.getGlyphHeight(charCodeBytes) / 1000.0;
                        w0 = Math.abs(w0);
                        tyDelta += w0 * fsh;
                        tyDelta += ch;
                        if (this.isSpace(charCodeBytes, charCode)) {
                            tyDelta += wh;
                        }
                        tyDelta *= -1.0;
                        if (font instanceof PDFFontType0) {
                            txDelta = -0.5 * this.getWidth(font, charCodeBytes);
                        }
                        tm = tm.preMultiply(txDelta, j != 0 ? tyDelta : 0.0);
                        this.getCurrentTextObject().setTextMatrix(tm);
                    } else {
                        w0 = this.getWidth(font, charCodeBytes);
                        txDelta += w0 * fsh;
                        txDelta += ch;
                        if (this.isSpace(charCodeBytes, charCode)) {
                            txDelta += wh;
                        }
                    }
                    Type3Glyph glyph = null;
                    if (font instanceof PDFFontType3) {
                        this.q(null);
                        this.getGState().setCTM(((PDFFontType3)font).getFontMatrix().concat(tm).preScale(fsh, fs).translate(0.0, textRise));
                        if (this.markedContentVisibilityStack == null || this.markedContentVisibilityStack.peek().booleanValue()) {
                            PDFContents glyphContents;
                            PDFContentItemsList glyphContentItemsList = null;
                            ASName glyphName = differences.toGlyphName(charCode);
                            if (glyphName != null && (glyphContents = (PDFContents)((PDFFontType3)font).getCharProcs().get(glyphName)) != null) {
                                Content content = Content.newInstance(glyphContents, type3FontResources);
                                glyphContentItemsList = new PDFContentItemsList(this.streamProcessor, content, this.getGState(), this.transparencyParameterContainerStack.peek());
                                glyph = new Type3Glyph(glyphContentItemsList, this.outDoc.getFactory().getCurrentID());
                                glyph.setXPos(tm.getx());
                                glyph.setYPos(tm.gety());
                            }
                        }
                        this.Q(null);
                    } else {
                        glyph = new Type3Glyph(charCode, gid, tm.getx(), tm.gety(), this.outDoc.getFactory().getCurrentID());
                    }
                    if (glyph != null) {
                        textCI.getText().add(glyph);
                    }
                    if (renderingMode > 3) {
                        this.isTextAsClipPath = true;
                    }
                    if (this.isTextAsClipPath) {
                        if (this.currentTextGroupPath == null) {
                            this.currentTextGroupPath = new GeneralPath();
                        }
                        GeneralPath glyphOutlines = GraphicsUtils.getTransformedGlyphsOutlines(null, gid, tm, fs, textRise, glyph, afeFont);
                        this.currentTextGroupPath.append(glyphOutlines.getPathIterator(null), false);
                    }
                    tm = this.getCurrentTextObject().getTextMatrix();
                    if (isVerticalWritingMode && font instanceof PDFFontType0) {
                        prevTxDelta = txDelta;
                        tm = tm.preMultiply(-prevTxDelta, 0.0);
                        this.getCurrentTextObject().setTextMatrix(tm);
                        continue;
                    }
                    tm = tm.preMultiply(txDelta, tyDelta);
                    this.getCurrentTextObject().setTextMatrix(tm);
                }
                if (!(font instanceof PDFFontType0) || ((PDFFontType0)font).getWritingMode() != PDFWritingMode.VERTICAL) continue;
                ASMatrix tm = this.getCurrentTextObject().getTextMatrix();
                tm = tm.preMultiply(0.0, (double)dw2[0] / 1000.0 - 1.0);
                this.getCurrentTextObject().setTextMatrix(tm);
            }
            catch (PDFInvalidDocumentException e) {}
        }
    }

    private boolean isSpace(byte[] charCodeBytes, int charCode) {
        if (charCodeBytes.length != 1) {
            return false;
        }
        return charCode == 32;
    }

    private double getWidth(PDFFont font, byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double w0 = 0.0;
        if (font instanceof PDFFontType3) {
            double w = this.getCharWidth(font, charCodeBytes);
            double Fa = ((PDFFontType3)font).getFontMatrix().geta();
            Fa *= 10000.0;
            Fa = (double)Math.round(Fa) * 1.0E-4;
            w0 = w * Fa;
        } else {
            w0 = this.getCharWidth(font, charCodeBytes) / 1000.0;
        }
        return w0;
    }

    private double getCharWidth(PDFFont font, byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return font.getGlyphWidth(charCodeBytes);
    }

    @Override
    public TextState getTextState() {
        return this.getGState().getTextState();
    }

    @Override
    public TextObject getCurrentTextObject() {
        return this.currentTextObj;
    }

    @Override
    public void ID(ASDictionary imageDict, InputByteStream imageData, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.markedContentVisibilityStack != null && !this.markedContentVisibilityStack.peek().booleanValue()) {
                return;
            }
            ContentImageItem<G> imageCI = this.createImageContentItem();
            if (imageDict.containsKey(ASName.k_IM) && imageDict.getBoolean(ASName.k_IM).isTrue() || imageDict.containsKey(ASName.k_ImageMask) && imageDict.getBoolean(ASName.k_ImageMask).isTrue()) {
                imageCI.setIsImageMask(true);
            }
            InlineImage inlineImage = InlineImage.newInstance(this.contentStack.peek(), imageDict, imageData);
            PDFResources resources = this.getResources();
            ColorSpaceCache colorSpace = ParserUtils.createPDFColorSpaceForInlineImage(imageDict, resources != null ? resources : this.currentPage.getResources(), this.loadedColorSpaces, imageCI.getIsImageMask(), inlineImage.getImageDecodeArray());
            if (colorSpace == null) {
                colorSpace = this.getGState().getFillPDFColorSpace();
            }
            ARGBImage image = new ARGBImage(new ImageInputSourceImpl<InputStream>(inlineImage.getImageData(), false), inlineImage.getWidth(), inlineImage.getHeight(), imageCI.getIsImageMask() ? 1 : inlineImage.getBitsPerComponent(), colorSpace, true, imageCI.getIsImageMask(), null);
            imageCI.setImage(image);
            if (this.downsampleImagesFactor != null) {
                image.downsample(this.downsampleImagesFactor[0], this.downsampleImagesFactor[1], ImageResamplingMethod.kResampleNearestNeighbor);
            }
            this.currentContentItemsList.add(imageCI);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private ContentImageItem<G> createImageContentItem() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        G graphicsState = this.createGraphicsState();
        ContentImageItem<G> imageCI = this.outDoc.getFactory().createContentImageItem(graphicsState);
        double[] transformationMatric = this.getGState().getCTM().getValues();
        if (transformationMatric[0] == 0.0) {
            transformationMatric[0] = 0.1;
        }
        if (transformationMatric[3] == 0.0) {
            transformationMatric[3] = 0.1;
        }
        imageCI.setTransformationMatrix(transformationMatric);
        return imageCI;
    }

    @Override
    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XObjectProcessingFunctionImpl function = new XObjectProcessingFunctionImpl(name);
        this.processXObject(name, instruction, function);
    }

    private void colorSpaceChanged(boolean fill) {
        if (fill) {
            this.getGState().setFillTilingPatternName(null);
            this.getGState().setFillShadingPattern(null);
        } else {
            this.getGState().setStrokeTilingPatternName(null);
            this.getGState().setStrokeShadingPattern(null);
        }
    }

    private void resolveColorSpace(ASName csName, boolean fill) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.colorSpaceChanged(fill);
        if (csName != ASName.k_Pattern) {
            PDFResources resources = this.getResources();
            PDFColorSpace pdfResourceCS = resources.getColorSpace(csName);
            ColorSpaceCacheImpl resourceCS = ColorSpaceCacheImpl.newInstance(pdfResourceCS, this.loadedColorSpaces, csName);
            this.setPDFColorSpace(resourceCS, fill);
        }
    }

    private void setPDFColorSpace(ColorSpaceCache cs, boolean fill) {
        if (fill) {
            this.getGState().setFillPDFColorSpace(cs);
        } else {
            this.getGState().setStrokePDFColorSpace(cs);
        }
    }

    @Override
    public void cs(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(name, true);
    }

    @Override
    public void CS(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(name, false);
    }

    @Override
    public void g(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(ASName.k_DeviceGray, true);
        this.getGState().setFillColorValues(this.getGState().getFillPDFColorSpace().toRGB(new double[]{gray}));
    }

    @Override
    public void G(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(ASName.k_DeviceGray, false);
        this.getGState().setStrokeColorValues(this.getGState().getStrokePDFColorSpace().toRGB(new double[]{gray}));
    }

    @Override
    public void rg(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(ASName.k_DeviceRGB, true);
        this.getGState().setFillColorValues(this.getGState().getFillPDFColorSpace().toRGB(new double[]{r, g, b}));
    }

    @Override
    public void RG(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(ASName.k_DeviceRGB, false);
        this.getGState().setStrokeColorValues(this.getGState().getStrokePDFColorSpace().toRGB(new double[]{r, g, b}));
    }

    @Override
    public void k(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(ASName.k_DeviceCMYK, true);
        this.getGState().setFillColorValues(this.getGState().getFillPDFColorSpace().toRGB(new double[]{c, m, y, k}));
    }

    @Override
    public void K(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.resolveColorSpace(ASName.k_DeviceCMYK, false);
        this.getGState().setStrokeColorValues(this.getGState().getStrokePDFColorSpace().toRGB(new double[]{c, m, y, k}));
    }

    @Override
    public void sc(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] colorValues = new double[colors.length];
        for (int i = 0; i < colorValues.length; ++i) {
            colorValues[i] = colors[colorValues.length - 1 - i];
        }
        colorValues = this.getGState().getFillPDFColorSpace().toRGB(colorValues);
        this.getGState().setFillColorValues(colorValues);
    }

    @Override
    public void scn(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.sc(colors, null);
    }

    @Override
    public void SC(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] colorValues = new double[colors.length];
        for (int i = 0; i < colorValues.length; ++i) {
            colorValues[i] = colors[colorValues.length - 1 - i];
        }
        colorValues = this.getGState().getStrokePDFColorSpace().toRGB(colorValues);
        this.getGState().setStrokeColorValues(colorValues);
    }

    @Override
    public void SCN(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.SC(colors, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTilingPattern(PDFPatternTiling tilingPattern, float[] colors, ASName name, boolean fill) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix patternMatrix = tilingPattern.hasMatrix() ? new ASMatrix(tilingPattern.getMatrix().getArrayDouble()) : ASMatrix.createIdentityMatrix();
        double[] rgbColor = null;
        if (colors != null && colors.length != 0) {
            ColorSpaceCache patternCachedCS = null;
            PDFColorSpace patternCS = null;
            ColorSpaceCache colorSpaceCache = patternCachedCS = fill ? this.getGState().getFillPDFColorSpace() : this.getGState().getStrokePDFColorSpace();
            if (patternCachedCS == null || patternCachedCS.getUnderlyingColorspace().getName() != ASName.k_Pattern || (patternCS = ((PDFColorSpacePattern)patternCachedCS.getUnderlyingColorspace()).getPatternColorSpace()) == null) {
                throw new PDFInvalidDocumentException("Uncolored tiling pattern is applied with the current colorspace either non-pattern or invalid.");
            }
            double[] colorValues = new double[colors.length];
            for (int i = 0; i < colorValues.length; ++i) {
                colorValues[i] = colors[colorValues.length - 1 - i];
            }
            rgbColor = patternCS.toRGB(colorValues);
        }
        String key = GraphicsUtils.generateKey(tilingPattern.getCosObject().getObjNum(), name, rgbColor);
        if (fill) {
            this.getGState().setFillTilingPatternName(key);
        } else {
            this.getGState().setStrokeTilingPatternName(key);
        }
        if (this.loadedTilingPatterns != null && this.loadedTilingPatterns.containsKey(key)) {
            return;
        }
        this.gStateStack.push(new PDFGState(this.loadedColorSpaces));
        try {
            if (rgbColor != null) {
                this.getGState().setFillColorValues(rgbColor);
                this.getGState().setStrokeColorValues(rgbColor);
            }
            double xTrans = patternMatrix.getx();
            double yTrans = patternMatrix.gety();
            patternMatrix = patternMatrix.setTranslate(0.0, 0.0);
            this.getGState().setClippingArea(new Area(ParserUtils.getClipPathForTilingPatternCell(patternMatrix, tilingPattern.getBBox())));
            this.getGState().setCTM(patternMatrix);
            G gs = this.createGraphicsState();
            TilingPattern tilingObj = this.outDoc.getFactory().createTilingPattern(gs);
            tilingObj.setPhase(new double[]{xTrans, yTrans});
            tilingObj.setScale(new double[]{patternMatrix.geta() > 0.0 ? 1.0 : -1.0, patternMatrix.getd() > 0.0 ? 1.0 : -1.0});
            tilingObj.setBBox(tilingPattern.getBBox().getValues());
            ASCoordinate step = null;
            double[] dArray = new double[2];
            step = new ASCoordinate(tilingPattern.getXStep(), 0.0).transform(patternMatrix);
            dArray[0] = step.x();
            dArray[1] = step.y();
            tilingObj.setXStep(dArray);
            double[] dArray2 = new double[2];
            step = new ASCoordinate(0.0, tilingPattern.getYStep()).transform(patternMatrix);
            dArray2[0] = step.x();
            dArray2[1] = step.y();
            tilingObj.setYStep(dArray2);
            TransparencyParameterContainer transparencyParameterContainer = new TransparencyParameterContainer();
            transparencyParameterContainer.setNonStrokeAlpha(((GraphicsState)gs).getNonStrokeAlpha());
            transparencyParameterContainer.setStrokeAlpha(((GraphicsState)gs).getStrokeAlpha());
            ModifiableContent content = ModifiableContent.newInstance(tilingPattern);
            tilingObj.setContentItems(new PDFContentItemsList(this.streamProcessor, content, this.getGState(), transparencyParameterContainer));
            this.loadedTilingPatterns.put(key, tilingObj);
        }
        finally {
            this.gStateStack.pop();
        }
    }

    @Override
    public void scn(float[] colors, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.processPattern(colors, name, true);
    }

    @Override
    public void SCN(float[] colors, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.processPattern(colors, name, false);
    }

    private void processPattern(float[] colors, ASName name, boolean fill) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources resources = this.getResources();
        PDFPattern pattern = resources.getPattern(name);
        if (pattern instanceof PDFPatternShading) {
            this.processShadingPattern((PDFPatternShading)pattern, name, fill);
        } else if (pattern instanceof PDFPatternTiling) {
            this.processTilingPattern((PDFPatternTiling)pattern, colors, name, fill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XObject<G, T, CO> processXobjectForm(PDFXObjectForm xObjectForm, G gs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XObject xObj = this.outDoc.getFactory().createXObject(gs);
        this.getGState().setCTM(new ASMatrix(xObjectForm.getMatrix()).concat(this.getGState().getCTM()));
        PDFGroupAttributes group = xObjectForm.getGroup();
        if (group != null) {
            xObj.setIsIsolatedGroup(group.getIsolated());
            xObj.setIsKnockoutGroup(group.getKnockout());
        }
        TransparencyParameterContainer transparencyParameterContainer = new TransparencyParameterContainer();
        transparencyParameterContainer.setNonStrokeAlpha(((GraphicsState)gs).getNonStrokeAlpha());
        transparencyParameterContainer.setStrokeAlpha(((GraphicsState)gs).getStrokeAlpha());
        Content content = Content.newInstance(xObjectForm);
        PDFContentItemsList items = new PDFContentItemsList(this.streamProcessor, content, this.getGState(), transparencyParameterContainer);
        Iterator itr = items.iterator();
        ContentItemsList<G, CO> oldList = this.currentContentItemsList;
        GStateStack oldGStateStack = this.gStateStack;
        this.gStateStack = new GStateStack(this.gStateStack.peek());
        try {
            while (itr.hasNext()) {
                itr.next();
            }
        }
        finally {
            this.currentContentItemsList = oldList;
            this.gStateStack = oldGStateStack;
        }
        xObj.setContentItems(items);
        return xObj;
    }

    @Override
    public void sh(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.markedContentVisibilityStack != null && !this.markedContentVisibilityStack.peek().booleanValue()) {
            return;
        }
        PDFResources resources = this.getResources();
        PDFShading shading = resources.getShading(name);
        String key = GraphicsUtils.generateKey(shading.getPDFCosObject().getCosObject().getObjNum(), name, null);
        G g = this.createGraphicsState();
        ContentPathItem<G> pathCI = this.outDoc.getFactory().createContentPathItem(g);
        key = key.concat(new Integer(pathCI.getID()).toString());
        this.getGState().setFillShadingPattern(key);
        if (this.applyShading(shading, name, key, shading instanceof PDFPatternShading ? ((PDFPatternShading)((Object)shading)).getMatrix() : null, g, null, null)) {
            pathCI.setPath(new GeneralPath(((GraphicsState)g).getClipPath()), PathPainting.FILL);
            pathCI.setIsShadingPresent(true);
            pathCI.setTransformationMatrix(this.getGState().getCTM());
            this.currentContentItemsList.add(pathCI);
        }
    }

    private boolean applyShading(PDFShading pdfShading, ASName name, String key, CosArray matrix, G g, CosArray background, CosArray bBox) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (pdfShading instanceof PDFShadingNoMeshes) {
            ((GraphicsState)g).setFillShadingPatternName(key);
            PDFShadingNoMeshes noMeshes = (PDFShadingNoMeshes)pdfShading;
            if (this.loadedShadingPatterns != null && this.loadedShadingPatterns.containsKey(key)) {
                return true;
            }
            int type = noMeshes.getShadingType();
            switch (type) {
                case 1: {
                    FunctionBasedShadingPattern shadingObj = (FunctionBasedShadingPattern)this.outDoc.getFactory().createShadingPattern(g, ShadingPattern.ShadingType.FunctionBased);
                    if (shadingObj != null) {
                        ParserUtils.preProcessFunctionBasedShading((PDFShadingFunction)noMeshes, shadingObj);
                        this.loadedShadingPatterns.put(key, shadingObj);
                    }
                    return true;
                }
                case 2: {
                    AxialShadingPattern shadingObj = (AxialShadingPattern)this.outDoc.getFactory().createShadingPattern(g, ShadingPattern.ShadingType.Axial);
                    boolean turnOffColorComputation = false;
                    AxialShadingPattern hashedObj = null;
                    if (shadingObj != null) {
                        if (this.shadingDictToObjMap != null && !this.shadingDictToObjMap.isEmpty() && (hashedObj = (AxialShadingPattern)this.shadingDictToObjMap.get(noMeshes.getCosDictionary())) != null) {
                            turnOffColorComputation = true;
                        }
                        ParserUtils.preProcessAxialShading((PDFShadingAxial)noMeshes, shadingObj, this.currentPage.getCropBox(), this.loadedColorSpaces, matrix != null ? matrix.getArrayDouble() : null, this.getGState().getCTM(), turnOffColorComputation);
                        if (turnOffColorComputation) {
                            shadingObj.setColorValues(hashedObj.getColorValues());
                        } else {
                            this.shadingDictToObjMap.put(noMeshes.getCosDictionary(), shadingObj);
                        }
                        this.loadedShadingPatterns.put(key, shadingObj);
                    }
                    return true;
                }
                case 3: {
                    RadialShadingPattern shadingObj = (RadialShadingPattern)this.outDoc.getFactory().createShadingPattern(g, ShadingPattern.ShadingType.Radial);
                    boolean turnOffColorComputation = false;
                    RadialShadingPattern hashedObj = null;
                    if (shadingObj != null) {
                        if (this.shadingDictToObjMap != null && !this.shadingDictToObjMap.isEmpty() && (hashedObj = (RadialShadingPattern)this.shadingDictToObjMap.get(noMeshes.getCosDictionary())) != null) {
                            turnOffColorComputation = true;
                        }
                        shadingObj.setBackground(background != null ? background.getArrayDouble() : null);
                        shadingObj.setBBox(bBox != null ? bBox.getArrayDouble() : null);
                        ParserUtils.preProcessRadialShading((PDFShadingRadial)noMeshes, shadingObj, matrix != null ? matrix.getArrayDouble() : null, this.loadedColorSpaces, ((GraphicsState)g).getClipPath(), turnOffColorComputation);
                        if (turnOffColorComputation) {
                            shadingObj.setColors(hashedObj.getColors());
                            shadingObj.setFractions(hashedObj.getFractions());
                            shadingObj.setCircleInfo(hashedObj.getCircleInfo());
                        } else {
                            this.shadingDictToObjMap.put(noMeshes.getCosDictionary(), shadingObj);
                        }
                        this.loadedShadingPatterns.put(key, shadingObj);
                    }
                    return true;
                }
            }
        } else if (pdfShading instanceof PDFShadingMeshes) {
            PDFShadingMeshes shadingMeshes = (PDFShadingMeshes)pdfShading;
            ((GraphicsState)g).setFillShadingPatternName(key);
            int type = shadingMeshes.getShadingType();
            switch (type) {
                case 4: {
                    if (!this.isExceptionMode) break;
                    throw new UnsupportedOperationException("Free-Form Gouraud-Shaded Triangle Meshes shading Pattern Unsupported.");
                }
                case 5: {
                    if (!this.isExceptionMode) break;
                    throw new UnsupportedOperationException("Lattice-Form Gouraud-Shaded Triangle Meshes shading Pattern Unsupported.");
                }
                case 6: {
                    CoonsPatchMeshesShading shadingObj = (CoonsPatchMeshesShading)this.outDoc.getFactory().createShadingPattern(g, ShadingPattern.ShadingType.CoonsPatchMeshes);
                    if (shadingObj != null) {
                        ParserUtils.preProcessCoonsPatchMeshesShading((PDFShadingCoons)shadingMeshes, shadingObj, matrix != null ? matrix.getArrayDouble() : null, this.loadedColorSpaces, (int)((GraphicsState)g).getClipPath().getBounds2D().getHeight());
                        this.loadedShadingPatterns.put(key, shadingObj);
                    }
                    return true;
                }
                case 7: {
                    if (!this.isExceptionMode) break;
                    throw new UnsupportedOperationException("Tensor-Product Patch Meshes shading Pattern Unsupported.");
                }
            }
        }
        return false;
    }

    private void processShadingPattern(PDFPatternShading shadingPattern, ASName name, boolean fill) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFShading pdfShading = shadingPattern.getShading();
        String key = GraphicsUtils.generateKey(shadingPattern.getCosObject().getObjNum(), name, null);
        CosArray background = pdfShading.getPDFCosObject().getDictionaryArrayValue(ASName.k_Background);
        CosArray bBox = pdfShading.getPDFCosObject().getDictionaryArrayValue(ASName.k_BBox);
        if (fill) {
            this.getGState().setFillShadingPattern(key);
        } else {
            this.getGState().setStrokeShadingPattern(key);
        }
        this.applyShading(pdfShading, name, key, shadingPattern.getMatrix(), this.createGraphicsState(), background, bBox);
    }

    private void showText(ASArray array) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block13: {
            PDFFont font = this.getTextState().getFont();
            try {
                if (font == null) {
                    return;
                }
                if (font instanceof PDFFontType3) {
                    this.showText(array, font, null);
                    break block13;
                }
                Font afeFont = null;
                try {
                    afeFont = font.getAFEFont(false);
                }
                catch (FontLoadingException e) {
                    // empty catch block
                }
                if (afeFont == null) {
                    FontMatchingParameters fontMatchingParameters = new FontMatchingParameters(font.getBaseFont().asString(), FontResources.getFontLocale(font));
                    afeFont = FontResources.findFont(font.getPDFDocument(), (PDFFontSetImpl)this.fontSet, fontMatchingParameters, true);
                }
                if (afeFont == null) {
                    Throwable toThrow = new PDFInvalidDocumentException("AFE font couldn't be found for the pdf font with object id: " + font.getCosObject().getObjNum());
                    if (this.callBackManager != null) {
                        toThrow = this.callBackManager.reportError(toThrow);
                    }
                    if (toThrow != null) {
                        throw new PDFRuntimeException(null, toThrow);
                    }
                }
                this.showText(array, font, afeFont);
            }
            catch (InvalidFontException e1) {
                throw new PDFInvalidDocumentException(e1);
            }
            catch (UnsupportedFontException e1) {
                throw new PDFInvalidDocumentException(e1);
            }
            catch (FontLoadingException e1) {
                throw new PDFInvalidDocumentException(e1);
            }
            catch (PDFFontException e1) {
                throw new PDFInvalidDocumentException(e1);
            }
        }
    }

    public void setIsExceptionMode(boolean isExceptionMode) {
        this.isExceptionMode = isExceptionMode;
    }

    @Override
    public void ET(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextGroupPath != null) {
            this.getGState().addPathToClip(new Area(this.currentTextGroupPath));
        }
        this.isTextAsClipPath = false;
        this.currentTextGroupPath = null;
    }

    private void initializeOC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCProperties ocProps;
        if (this.ocManager == null && (ocProps = this.currentPage.getPDFDocument().requireCatalog().getOCProperties()) != null && ocProps.getOCGs() != null && ocProps.getDefaultOCConfigDict() != null) {
            this.ocManager = OCManager.newInstance(ocProps, new OCUsageAppHandler(){

                @Override
                public Locale getLocale() {
                    return ocProps.getPDFDocument().getCosDocument().getOptions().getDocLocale();
                }

                @Override
                public ASName getAppEvent() {
                    return ContentStreamParser.this.callBackManager != null ? ContentStreamParser.this.callBackManager.getOCUsageAppEvent() : null;
                }
            });
        }
        if (this.markedContentVisibilityStack == null) {
            this.markedContentVisibilityStack = new ArrayListStack();
            this.markedContentVisibilityStack.push(true);
        }
    }

    @Override
    public void BMC(ASName tag, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.initializeOC();
        this.markedContentVisibilityStack.push(this.markedContentVisibilityStack.peek());
        super.BMC(tag, instruction);
    }

    @Override
    public void BDC(ASName tag, ASDictionary properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.initializeOC();
        this.markedContentVisibilityStack.push(this.markedContentVisibilityStack.peek());
    }

    @Override
    public void BDC(ASName tag, ASName propertyName, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.initializeOC();
        if (tag == ASName.k_OC) {
            PDFMCProperty property = null;
            PDFResources pdfResources = this.getResources();
            if (pdfResources != null && (property = pdfResources.getMCProperty(propertyName)) != null) {
                PDFOCObject ocObj = PDFOCObject.getInstance(property.getCosObject());
                this.markedContentVisibilityStack.push(this.markedContentVisibilityStack.peek() & (this.ocManager == null || this.ocManager.isVisible(ocObj)));
                return;
            }
        }
        this.markedContentVisibilityStack.push(this.markedContentVisibilityStack.peek());
    }

    @Override
    public void EMC(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.markedContentVisibilityStack != null && !this.markedContentVisibilityStack.isEmpty()) {
            this.markedContentVisibilityStack.pop();
        }
    }

    GStateStack<GState> getGraphicsStateStack() {
        return this.gStateStack;
    }

    void setCurrentTextObj(TextObject textObj) {
        this.currentTextObj = textObj;
    }

    class XObjectProcessingFunctionImpl
    implements XObjectProcessingFunction {
        private ASName name;

        public XObjectProcessingFunctionImpl(ASName name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ColorSpaceCache getColorSpaceIfJPXImage(PDFXObjectImage xObjImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFFilterList list = xObjImage.getInputFilters();
            if (list == null) return null;
            if (list.isEmpty()) return null;
            if (((PDFFilter)list.get(0)).getFilterName() != ASName.k_JPXDecode) return null;
            boolean bl = true;
            boolean isJPXImage = bl;
            if (!isJPXImage) {
                return null;
            }
            InputByteStream jpxStream = xObjImage.getCosStream().getStreamEncoded();
            try {
                try {
                    ImageFilterInterface.ImageInfo imageInfo = Jpeg2000Parser.getImageInfo(Jpeg2000Parser.parse(jpxStream));
                    switch (imageInfo.getNumberOfColorComponents()) {
                        case 1: {
                            ColorSpaceCache colorSpaceCache = (ColorSpaceCache)ContentStreamParser.this.loadedColorSpaces.get(GraphicsUtils.DeviceGray);
                            return colorSpaceCache;
                        }
                        case 3: {
                            ColorSpaceCache colorSpaceCache = (ColorSpaceCache)ContentStreamParser.this.loadedColorSpaces.get(GraphicsUtils.DeviceRGB);
                            return colorSpaceCache;
                        }
                        case 4: {
                            ColorSpaceCache colorSpaceCache = (ColorSpaceCache)ContentStreamParser.this.loadedColorSpaces.get(GraphicsUtils.DeviceCMYK);
                            return colorSpaceCache;
                        }
                    }
                    return null;
                }
                finally {
                    if (jpxStream != null) {
                        jpxStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }

        @Override
        public void process(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (ContentStreamParser.this.markedContentVisibilityStack != null && !((Boolean)ContentStreamParser.this.markedContentVisibilityStack.peek()).booleanValue()) {
                return;
            }
            if (xObject != null) {
                if (xObject instanceof PDFXObjectForm) {
                    PDFXObjectForm xObjectForm = (PDFXObjectForm)xObject;
                    PDFOCObject ocObject = PDFOCObject.getOC(xObjectForm);
                    if (ocObject != null) {
                        ContentStreamParser.this.initializeOC();
                        if (ContentStreamParser.this.ocManager != null && !ContentStreamParser.this.ocManager.isVisible(ocObject)) {
                            return;
                        }
                    }
                    XObject xObj = ContentStreamParser.this.processXobjectForm(xObjectForm, ContentStreamParser.this.createGraphicsState());
                    xObj.setBBox(xObjectForm.getBBox().getValues());
                    xObj.setCTM(xObjectForm.getMatrix());
                    ContentStreamParser.this.currentContentItemsList.add(xObj);
                } else if (xObject instanceof PDFXObjectImage) {
                    PDFXObjectImage imageXObject = (PDFXObjectImage)xObject;
                    String key = GraphicsUtils.generateKey(imageXObject.getCosObject().getObjNum(), this.name, null);
                    ContentImageItem imageCI = ContentStreamParser.this.createImageContentItem();
                    if (ContentStreamParser.this.isApplyOverPrintMode && ((GraphicsState)imageCI.getGState()).getOverPrint()) {
                        PDFColorSpace imageColorSpace = imageXObject.getColorSpace();
                        if (imageColorSpace instanceof PDFColorSpaceDeviceCMYK) {
                            ((GraphicsState)imageCI.getGState()).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTSrc);
                        } else if (imageColorSpace instanceof PDFColorSpaceSeparation) {
                            ((GraphicsState)imageCI.getGState()).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTSrc);
                        } else if (imageColorSpace instanceof PDFColorSpaceDeviceN) {
                            ((GraphicsState)imageCI.getGState()).setBlendingMode(GraphicsState.BlendingMode.OVERPRINTDst);
                        } else if (((GraphicsState)imageCI.getGState()).getBlendingMode().equals((Object)GraphicsState.BlendingMode.OVERPRINTDst) || ((GraphicsState)imageCI.getGState()).getBlendingMode().equals((Object)GraphicsState.BlendingMode.OVERPRINTSrc)) {
                            ((GraphicsState)imageCI.getGState()).setBlendingMode(GraphicsState.BlendingMode.NORMAL);
                        }
                    }
                    if (ContentStreamParser.this.loadedImageXObjects == null) {
                        ContentStreamParser.this.loadedImageXObjects = new HashMap();
                    }
                    ContentImageItem alreadyProcessedImageCI = (ContentImageItem)ContentStreamParser.this.loadedImageXObjects.get(key);
                    ARGBImage imageRGB = null;
                    PDFXObjectImageSoftMask sMaskXObject = imageXObject.getSoftMask();
                    boolean isImageMask = imageXObject.getIsImageMask();
                    ImageInputSourceImpl<Object> inputImageSource = null;
                    ImageInputSourceImpl<InputStream> inputSoftMaskSource = null;
                    if (alreadyProcessedImageCI != null) {
                        if (!isImageMask && alreadyProcessedImageCI.getImage().isClosed()) {
                            inputImageSource = new ImageInputSourceImpl<CosObject>(imageXObject.getCosObject(), true);
                        }
                        if (sMaskXObject != null && alreadyProcessedImageCI.getSoftMask().isClosed()) {
                            inputSoftMaskSource = new ImageInputSourceImpl<InputStream>(sMaskXObject.getImageStreamData(), false);
                        }
                        imageRGB = alreadyProcessedImageCI.getImage().slice(inputImageSource);
                    }
                    if (imageRGB != null) {
                        imageCI.setImage(imageRGB);
                        imageCI.setSoftMask(sMaskXObject != null ? alreadyProcessedImageCI.getSoftMask().slice(inputSoftMaskSource) : null);
                    } else {
                        ContentStreamParser.this.loadedImageXObjects.put(key, imageCI);
                        if (inputImageSource == null) {
                            inputImageSource = new ImageInputSourceImpl<Object>(isImageMask ? imageXObject.getImageStreamData() : imageXObject.getCosObject(), !isImageMask);
                        }
                        try {
                            ColorSpaceCache cs;
                            block32: {
                                cs = null;
                                PDFColorSpace pdfCS = imageXObject.getColorSpace();
                                if (pdfCS != null) {
                                    try {
                                        cs = ColorSpaceCacheImpl.newInstance(pdfCS, ContentStreamParser.this.loadedColorSpaces, null, imageXObject.getDecode());
                                    }
                                    catch (Exception e) {
                                        if (ContentStreamParser.this.isIgnoreError) break block32;
                                        throw new PDFIOException(e);
                                    }
                                }
                            }
                            if (cs == null) {
                                cs = imageXObject.getIsImageMask() ? (ColorSpaceCache)ContentStreamParser.this.loadedColorSpaces.get(GraphicsUtils.DeviceGray) : this.getColorSpaceIfJPXImage(imageXObject);
                            }
                            imageRGB = new ARGBImage(inputImageSource, imageXObject.getWidth(), imageXObject.getHeight(), imageXObject.getBitsPerComponent(), cs, false, imageXObject.getIsImageMask(), imageXObject.hasDecodeArray() ? imageXObject.getDecode() : null);
                            imageCI.setImage(imageRGB);
                            if (ContentStreamParser.this.downsampleImagesFactor != null) {
                                imageRGB.downsample(ContentStreamParser.this.downsampleImagesFactor[0], ContentStreamParser.this.downsampleImagesFactor[1], ImageResamplingMethod.kResampleNearestNeighbor);
                            }
                            if (sMaskXObject != null) {
                                if (inputSoftMaskSource == null) {
                                    inputSoftMaskSource = new ImageInputSourceImpl<InputStream>(sMaskXObject.getImageStreamData(), false);
                                }
                                ARGBImage sMask = new ARGBImage(inputSoftMaskSource, ((PDFXObjectImage)sMaskXObject).getWidth(), ((PDFXObjectImage)sMaskXObject).getHeight(), ((PDFXObjectImage)sMaskXObject).getBitsPerComponent(), ColorSpaceCacheImpl.newInstance(sMaskXObject.getColorSpace(), ContentStreamParser.this.loadedColorSpaces, null, sMaskXObject.getDecode()), imageXObject.hasDecodeArray() ? imageXObject.getDecode() : null);
                                imageCI.setSoftMask(sMask);
                                if (ContentStreamParser.this.downsampleImagesFactor != null) {
                                    sMask.downsample(ContentStreamParser.this.downsampleImagesFactor[0], ContentStreamParser.this.downsampleImagesFactor[1], ImageResamplingMethod.kResampleNearestNeighbor);
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new PDFIOException(e);
                        }
                    }
                    imageCI.setIsImageMask(imageXObject.getIsImageMask());
                    ContentStreamParser.this.currentContentItemsList.add(imageCI);
                }
            }
        }
    }
}

