/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetails;
import java.util.ArrayList;
import java.util.HashSet;

public class EmbeddedFontGroup {
    private ArrayList<EmbeddedFontDetails> detailsList = new ArrayList();
    private int maxGlyphsInEmbeddedFont = -1;
    private Font largestAFEFont;
    private HashSet<Integer> fontFileCosObjectNumSet = new HashSet();

    EmbeddedFontGroup() {
    }

    void addToGroup(EmbeddedFontDetails embeddedFontDetails) throws PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.detailsList.add(embeddedFontDetails);
        PDFFontFile fontFile = PDFFontUtils.getFontFileFromFontDescriptor(embeddedFontDetails.getPdfFont().getFontDescriptor());
        this.fontFileCosObjectNumSet.add(fontFile.getCosObject().getObjNum());
        Font currFont = embeddedFontDetails.getAfeFont();
        if (currFont != null) {
            try {
                int glyphsCount;
                FontData fd = ((FontImpl)currFont).getFontData();
                if (fd != null && (glyphsCount = fd.getNumGlyphs()) > this.maxGlyphsInEmbeddedFont) {
                    this.largestAFEFont = currFont;
                    this.maxGlyphsInEmbeddedFont = glyphsCount;
                }
            }
            catch (InvalidFontException e) {
                throw new PDFFontException("InvalidFontException occured while getting fontdata from AFE.", e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFFontException("UnsupportedFontException occured while getting fontdata from AFE.", e);
            }
            catch (FontLoadingException e) {
                throw new PDFFontException("FontLoadingException occured while getting fontdata from AFE.", e);
            }
        }
    }

    public boolean groupContainsDistinctFontFiles() {
        return this.fontFileCosObjectNumSet.size() > 1;
    }

    public Font getLargestAFEFont() {
        return this.largestAFEFont;
    }

    public ArrayList<EmbeddedFontDetails> getEmbeddedFontDetailList() {
        return this.detailsList;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        for (EmbeddedFontDetails dt : this.detailsList) {
            try {
                bldr.append(dt.getPdfFont().getBaseFont() + " - ");
            }
            catch (Exception e) {}
        }
        return bldr.toString();
    }
}

