/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.XMLDataParams;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Protocol;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProtocolContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler.GibsonLiveObject;
import com.adobe.internal.pdftoolkit.services.xfa.impl.JavaScriptHandler;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Element;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.dom.DOM;
import com.adobe.xfa.dom.XFANodeHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public class XMLData
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("XMLData.class", new HashMap<String, Function>(2){
        private static final long serialVersionUID = 1L;
        {
            this.put("applyXPath", new Function(XMLData.class, "applyXPath", Param.Type.Object, XMLDataParams.applyXPath, 2, false, false));
            this.put("parse", new Function(XMLData.class, "parse", Param.Type.Object, XMLDataParams.parse, 2, false, false));
        }
    }, new HashMap<String, Property>(0){
        private static final long serialVersionUID = 1L;
    });
    private static final long serialVersionUID = 1665462759538873200L;
    static final String className = "XMLData";

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    @Override
    public String getClassName() {
        return className;
    }

    private PDFDocument getPDFDocument() {
        Scriptable scope = this.getParentScope();
        if (scope instanceof Doc) {
            Doc doc = (Doc)scope;
            return doc.getActiveDocument();
        }
        throw new PDFRuntimeException("PDF document associated cann't be found.");
    }

    public Object applyXPath(Object oXml, String cxPath) throws PDFInvalidParameterException {
        Node poNode = (Node)((GibsonLiveObject)((Object)oXml)).getXFAObj();
        if (poNode == null) {
            throw new PDFInvalidParameterException("Root node passed to applyXPath method is null.");
        }
        int nNodes = poNode.getXMLChildCount();
        Element oPeer = poNode.getXfaPeer();
        XPathEvaluatorImpl evaluator = new XPathEvaluatorImpl();
        XPathNSResolver nsResolver = evaluator.createNSResolver(DOM.attach(oPeer));
        org.w3c.dom.Node node = DOM.attach(poNode);
        XPathResult result = (XPathResult)evaluator.evaluate(cxPath, node, nsResolver, (short)0, null);
        Obj xfaNodeImpl = null;
        switch (result.getResultType()) {
            case 1: {
                return result.getNumberValue();
            }
            case 2: {
                return result.getStringValue();
            }
            case 3: {
                return result.getBooleanValue();
            }
            case 4: 
            case 5: {
                org.w3c.dom.Node currentNode = null;
                ArrayNodeList xfaNodeList = new ArrayNodeList();
                while ((currentNode = result.iterateNext()) != null) {
                    ((ListBase)xfaNodeList).append(((XFANodeHolder)currentNode).getmXFANode().getXfaPeer());
                }
                nNodes = ((ListBase)xfaNodeList).length();
                switch (nNodes) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        xfaNodeImpl = ((ListBase)xfaNodeList).item(0);
                        break;
                    }
                    default: {
                        xfaNodeImpl = xfaNodeList;
                    }
                }
                if (xfaNodeImpl == null || nNodes == 0) break;
                List<ScriptHandler> handlers = DocumentContext.find((PDFDocument)this.getPDFDocument(), (boolean)false, null).moAppModel.getScriptHandlers();
                JavaScriptHandler javaScriptHandler = (JavaScriptHandler)this.getScriptHandler(handlers);
                return javaScriptHandler.createXFAObject(javaScriptHandler, xfaNodeImpl, false, false, poNode.getOwnerDocument().getAppModel());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(String param1, Boolean param2) throws PDFIOException {
        DataModel dataModel = null;
        AppModel xfa = new AppModel(null);
        if (xfa != null) {
            DataModelFactory dataFactory = new DataModelFactory();
            dataFactory.attributesAreValues(true);
            xfa.addFactory(dataFactory);
            xfa.newDOM();
            Protocol poProtocol = XFAPlugin.getProtocol(this.getPDFDocument());
            new ProtocolContext(poProtocol, this.getPDFDocument());
            dataModel = DataModel.getDataModel(xfa, false, true);
            ByteArrayInputStream is = new ByteArrayInputStream(param1.getBytes());
            try {
                dataModel.loadXML((InputStream)is, (boolean)param2, false);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
        }
        List<ScriptHandler> handlers = DocumentContext.find((PDFDocument)this.getPDFDocument(), (boolean)false, null).moAppModel.getScriptHandlers();
        JavaScriptHandler javaScriptHandler = (JavaScriptHandler)this.getScriptHandler(handlers);
        return javaScriptHandler.createXFAObject(javaScriptHandler, dataModel, false, false, xfa);
    }

    private ScriptHandler getScriptHandler(List<ScriptHandler> mScriptHandlers) {
        for (int i = 0; i < mScriptHandlers.size(); ++i) {
            ScriptHandler scriptHandler = mScriptHandlers.get(i);
            if (!scriptHandler.languageName().equals("javascript")) continue;
            return scriptHandler;
        }
        return null;
    }
}

