/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.Annot3DParams;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Annot3D
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Annot3D.class", new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, new HashMap<String, Property>(6){
        private static final long serialVersionUID = 1L;
        {
            this.put("name", new Property(Annot3D.class, "name", "getName", null, null, false, false));
            this.put("page", new Property(Annot3D.class, "page", "getPage", null, null, false, false));
            this.put("activated", new Property(Annot3D.class, "activated", "getActivated", "setActivated", Annot3DParams.activated, false, false));
            this.put("innerRect", new Property(Annot3D.class, "innerRect", "getInnerRect", null, null, false, false));
            this.put("context3D", new Property(Annot3D.class, "context3D", "getContext3D", null, null, false, false));
            this.put("rect", new Property(Annot3D.class, "rect", "getRect", "setRect", Annot3DParams.rect, false, false));
        }
    });
    private static final long serialVersionUID = 4533133800288276910L;
    PDFAnnotation3D pdfAnnot;
    static final String className = "Annot3D";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public Annot3D(Object annot) {
        if (annot instanceof PDFAnnotation) {
            this.pdfAnnot = (PDFAnnotation3D)annot;
        }
    }

    public Annot3D() {
    }

    @Override
    public String getClassName() {
        return className;
    }

    public PDFAnnotation getPdfAnnot() {
        return this.pdfAnnot;
    }

    public void setPdfAnnot(PDFAnnotation3D pdfAnnot) {
        this.pdfAnnot = pdfAnnot;
    }

    public boolean getActivated() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.hasInteractive();
    }

    public void setActivated(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setInteractive(value);
    }

    public Object getContext3D() {
        return Undefined.instance;
    }

    public Object getInnerRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle box = this.pdfAnnot.getBox();
        return Context.javaToJS((Object)new Double[]{new Double(box.left()), new Double(box.top()), new Double(box.right()), new Double(box.bottom())}, (Scriptable)this);
    }

    public Object getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getName();
    }

    public int getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getPage().getIndex();
    }

    public double[] getRect() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        double[] rect = new double[]{0.0, 0.0, 0.0, 0.0};
        this.getPdfAnnot().getRect().getValues();
        return rect;
    }

    public void setRect(Object coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        double[] arr1 = new double[4];
        if (coords instanceof NativeArray) {
            NativeArray arr = (NativeArray)coords;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof NativeJavaArray) {
            coords = Context.jsToJava((Object)coords, NativeJavaArray.class);
            arr1 = new double[((NativeJavaArray)coords).getIds().length];
            for (int i = 0; i < ((NativeJavaArray)coords).getIds().length; ++i) {
                if (((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof NativeJavaObject) {
                    arr1[i] = (Double)((NativeJavaObject)((NativeJavaArray)coords).get(i, (Scriptable)this)).unwrap();
                    continue;
                }
                if (!(((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof Double)) continue;
                arr1[i] = (Double)((NativeJavaArray)coords).get(i, (Scriptable)this);
            }
        } else if (coords instanceof Double[]) {
            for (int i = 0; i < ((Double[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Double[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof Integer[]) {
            for (int i = 0; i < ((Integer[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Integer[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof Object[]) {
            for (int i = 0; i < ((Object[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Object[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof double[]) {
            for (int i = 0; i < ((double[])coords).length; ++i) {
                arr1[i] = ((double[])coords)[i];
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        }
        PDFRectangle annotRect2 = PDFRectangle.newInstance(this.pdfAnnot.getPDFDocument(), arr1[0], arr1[3], arr1[2], arr1[1]);
        this.pdfAnnot.setRect(annotRect2);
    }
}

