/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources.subsetting;

import com.adobe.fontengine.font.Font;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class FontSubsetter {
    protected PDFDocument pdfDoc;
    protected Map<PDFFont, TreeMap<Integer, Integer>> fontToCharCodesMap = new HashMap<PDFFont, TreeMap<Integer, Integer>>();
    protected Map<PDFFontFile, FontInfo> fontFileToFontInfoMap = new HashMap<PDFFontFile, FontInfo>();

    protected FontSubsetter(PDFDocument pdfDoc, Map<PDFFont, TreeMap<Integer, Integer>> fontToCharCodesMap) {
        this.pdfDoc = pdfDoc;
        this.fontToCharCodesMap = fontToCharCodesMap;
    }

    public void createSubsets() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        this.populateFontInfo();
        this.doSubsetting();
    }

    protected abstract void populateFontInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException;

    protected abstract void doSubsetting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException;

    protected static abstract class FontInfo {
        private Font font;

        protected FontInfo() {
        }

        protected void setFont(Font font) {
            this.font = font;
        }

        protected Font getFont() {
            return this.font;
        }
    }
}

