/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFField;

public final class FDFFieldList
extends PDFCosArrayList<FDFField> {
    public FDFFieldList(CosArray cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFFieldList getInstance(CosArray cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        FDFFieldList pdfObject = (FDFFieldList)PDFCosObject.getCachedInstance(cosObject, FDFFieldList.class);
        if (pdfObject == null) {
            pdfObject = new FDFFieldList(cosObject);
        }
        return pdfObject;
    }

    public static FDFFieldList getInstance(PDFFieldList fieldList) throws PDFInvalidDocumentException {
        if (fieldList == null) {
            return null;
        }
        return FDFFieldList.getInstance((CosArray)fieldList.getCosObject());
    }

    public static FDFFieldList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new FDFFieldList(cosObject);
    }

    @Override
    public FDFField itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return FDFField.getInstance(cosObject);
    }
}

