/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFContent;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFDocumentImpl;

public final class FDFCatalog
extends PDFCosDictionary {
    private FDFCatalog(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFCatalog getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        FDFCatalog pdfObject = (FDFCatalog)PDFCosObject.getCachedInstance(cosObject, FDFCatalog.class);
        if (pdfObject == null) {
            pdfObject = new FDFCatalog(cosObject);
        }
        return pdfObject;
    }

    public static FDFCatalog requireInstance(CosObject cosObject) throws PDFInvalidParameterException, PDFInvalidDocumentException {
        FDFCatalog pdfObject = FDFCatalog.getInstance(cosObject);
        if (pdfObject == null) {
            throw new PDFInvalidParameterException("Required instance unable to be constructed.");
        }
        return pdfObject;
    }

    ASName getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Version);
    }

    void setVersion(ASName version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Version, version);
    }

    public FDFContent requireContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return FDFContent.requireInstance(this.getDictionaryDictionaryValue(ASName.k_FDF));
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Unable to get FDF content", e);
        }
    }

    FDFContent getContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFContent.getInstance(this.getDictionaryDictionaryValue(ASName.k_FDF));
    }

    public FDFContent procureContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FDFContent content = this.getContent();
        if (content == null) {
            content = FDFContent.newInstance(FDFDocumentImpl.getFDFDocument(this.getCosObject()));
            this.setContent(content);
        }
        return content;
    }

    void setContent(FDFContent content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_FDF, content);
    }
}

