/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.XFAChangeLogger;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.XFAValidationContext;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFAVersionComparator;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzer;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerResult;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModList;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModMatch;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStack;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStackItem;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStatusA9;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultDocModAnalyzer
implements DocModAnalyzer {
    private DocModAnalyzerParams.DocModAnalysisMode mModAnalysisType;
    private boolean mNonSigFieldFillInAllowed;
    private boolean mSigFieldFillInAllowed;
    private boolean mFormFieldAddDelAllowed;
    private boolean mPgModAllowed;
    private boolean mPgTemplateSpawningAllowed;
    private boolean mCommentsAllowed;
    private boolean mEFChangesAllowed;
    private boolean mNamedJSDelAllowed;
    private boolean mEnableA9;
    private boolean mFormModified;
    private boolean mXFAFormModified;
    private Set<String> mLockedFieldSet;
    private PDFDocument mCurDoc;
    private CosDocument mCurCosDoc;
    private CosDictionary mCurCatalog;
    private CosDocument mRbCosDoc;
    private CosDictionary mRbCatalog;
    private CosObject mSigObj;
    private DocModList mModList;
    private DocModMatch mMatchList;
    private CosList mCurAnnotList;
    private CosList mCurFieldList;
    private CosList mCurPagesList;
    private CosList mRbAnnotList;
    private CosList mRbFieldList;
    private CosList mRbPagesList;
    private XFAValidationContext mXFAValidationContext;
    private DocModAnalyzerParams mParams;
    private static final int OBJ_BAD = 0;
    private static final int OBJ_OK = 1;
    private static final int OBJ_REVISIT = 2;

    @Override
    public DocModAnalyzerResult doModAnalysis(DocModAnalyzerParams docModAnalyzerParams) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        this.reset();
        this.mParams = docModAnalyzerParams;
        this.mCurDoc = this.mParams.getPdfDoc();
        this.mSigObj = this.mParams.getSigObj();
        this.mModAnalysisType = this.mParams.getMode();
        this.mEnableA9 = this.mParams.isEnableYT();
        this.mXFAValidationContext = this.mParams.getXfaContext();
        if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode) {
            this.mPgModAllowed = true;
            this.mPgTemplateSpawningAllowed = true;
            this.mCommentsAllowed = true;
            this.mEFChangesAllowed = true;
            this.mNamedJSDelAllowed = true;
            this.mLockedFieldSet = new HashSet<String>();
            String[] lockedFields = this.mParams.getLockedFields();
            if (lockedFields != null) {
                for (int i = 0; i < lockedFields.length; ++i) {
                    this.mLockedFieldSet.add(lockedFields[i]);
                }
            }
        } else if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.MDPAllowNone) {
            if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPAllowDefault) {
                this.mNonSigFieldFillInAllowed = true;
                this.mSigFieldFillInAllowed = true;
                this.mPgTemplateSpawningAllowed = true;
            } else if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPAllowDefaultPlusComments) {
                this.mNonSigFieldFillInAllowed = true;
                this.mSigFieldFillInAllowed = true;
                this.mPgTemplateSpawningAllowed = true;
                this.mCommentsAllowed = true;
            } else if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.NoMDP) {
                this.mNonSigFieldFillInAllowed = true;
                this.mSigFieldFillInAllowed = true;
                this.mPgTemplateSpawningAllowed = true;
                this.mCommentsAllowed = true;
            } else {
                throw new PDFInvalidParameterException("Undefined permission mode");
            }
        }
        try {
            this.mCurCosDoc = this.mCurDoc.getCosDocument();
            long rbEOF = this.mSigObj.getObjEOF();
            if (rbEOF == this.mCurCosDoc.getEOF() && !this.mCurCosDoc.isDirty()) {
                if (this.validateTemplatesTree(rbEOF)) {
                    return new DocModAnalyzerResult(this.mFormModified, this.mXFAFormModified, true);
                }
                return new DocModAnalyzerResult(this.mFormModified, this.mXFAFormModified, false);
            }
            if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPAllowNone && SignatureUtils.isAuthorSignature(PDFSignature.getInstance(this.mSigObj))) {
                return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
            }
            try {
                ((DocumentListenerRegistryBase)this.mCurDoc.getListenerRegistry()).sendMessage(new DocumentMessage(DocumentMessage.FLUSH_FONTS, this.mCurDoc), true);
            }
            catch (PDFUnableToCompleteOperationException e) {
                // empty catch block
            }
            if (this.mXFAValidationContext != null) {
                this.mRbCosDoc = this.mXFAValidationContext.getRollbackCosDoc();
            }
            if (this.mRbCosDoc == null) {
                this.mRbCosDoc = PDFSignature.getInstance(this.mSigObj).generateRollBackDocument();
            }
            this.mModList = new DocModList(this.mCurCosDoc, this.mRbCosDoc, rbEOF);
            if (this.mModList.getList().isEmpty()) {
                return new DocModAnalyzerResult(this.mFormModified, this.mXFAFormModified, true);
            }
            this.mCurCatalog = this.mCurCosDoc.getRoot();
            this.mRbCatalog = this.mRbCosDoc.getRoot();
            this.markSig(this.mSigObj);
            this.mMatchList = new DocModMatch(this.mModList);
            if (DocModUtils.isDocDynamic(this.mCurCosDoc)) {
                boolean retVal = this.doModAnalysisDynamic();
                return new DocModAnalyzerResult(this.mFormModified, this.mXFAFormModified, retVal);
            }
            if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode) {
                if (!this.compareCatalogs(this.mCurCatalog, this.mRbCatalog)) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (!this.compareNamesDicts(DocModUtils.safeGetDict(this.mCurCatalog, ASName.k_Names), DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_Names))) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (!this.compareAcroFormDicts(DocModUtils.safeGetDict(this.mCurCatalog, ASName.k_AcroForm), DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_AcroForm))) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (!this.compareXFA(DocModUtils.safeGetDict(this.mCurCatalog, ASName.k_AcroForm), DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_AcroForm))) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
            }
            CosList rbTemplatedPages = null;
            CosList rbNonTemplatedPages = null;
            int rbNumPages = DocModUtils.getNumPages(this.mRbCosDoc);
            ArrayList<CosDictionary> rbPagesByPageNumber = new ArrayList<CosDictionary>();
            rbTemplatedPages = new CosList();
            rbNonTemplatedPages = new CosList();
            for (int i = 0; i < rbNumPages; ++i) {
                CosDictionary rbPage = DocModUtils.getPage(this.mRbCosDoc, i);
                rbPagesByPageNumber.add(rbPage);
                if (DocModUtils.safeGetName(rbPage, ASName.k_TemplateInstantiated) == null) {
                    rbNonTemplatedPages.add(rbPage.getObjNum(), rbPage);
                    continue;
                }
                rbTemplatedPages.add(rbPage.getObjNum(), rbPage);
            }
            CosDictionary rbNames = DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_Names);
            HashMap<ASString, CosObject> rbTemplatesMap = new HashMap<ASString, CosObject>();
            if (rbNames != null) {
                DocModUtils.nameTreeToMapRecur(DocModUtils.safeGetDict(rbNames, ASName.k_Pages), rbTemplatesMap);
                DocModUtils.nameTreeToMapRecur(DocModUtils.safeGetDict(rbNames, ASName.k_Templates), rbTemplatesMap);
            }
            int curNumPages = DocModUtils.getNumPages(this.mCurCosDoc);
            for (int i = 0; i < curNumPages; ++i) {
                CosDictionary rbAnnot;
                CosDictionary rbPage;
                CosDictionary rbAnnot2;
                CosDictionary rbAnnot3;
                int rbNumAnnots;
                int curNumAnnots;
                CosArray rbAnnotsArray;
                CosArray curAnnotsArray;
                CosDictionary curPage = DocModUtils.getPage(this.mCurCosDoc, i);
                ASName pageName = DocModUtils.safeGetName(curPage, ASName.k_TemplateInstantiated);
                int pageObjNum = curPage.getObjNum();
                if (rbTemplatedPages.containsIndex(pageObjNum) && !this.mModList.isAddedOrModified(pageObjNum)) {
                    pageName = null;
                }
                if (pageName != null) {
                    CosObject rbTemplate = (CosObject)rbTemplatesMap.get(new ASString(pageName.asString(true)));
                    if (!(rbTemplate instanceof CosDictionary)) {
                        return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                    }
                    if (!this.mPgModAllowed) {
                        if (this.mModList.isAdded(pageObjNum) && !this.mPgTemplateSpawningAllowed) {
                            return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                        }
                        if (!this.compareSpawnedPgWithTemplate(curPage, (CosDictionary)rbTemplate)) {
                            return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                        }
                    }
                    curAnnotsArray = DocModUtils.safeGetArray(curPage, ASName.k_Annots);
                    rbAnnotsArray = DocModUtils.safeGetArray((CosDictionary)rbTemplate, ASName.k_Annots);
                    curNumAnnots = curAnnotsArray != null ? curAnnotsArray.size() : 0;
                    rbNumAnnots = rbAnnotsArray != null ? rbAnnotsArray.size() : 0;
                    int rbAnnotIdx = 0;
                    for (int curAnnotN = 0; curAnnotN < curNumAnnots; ++curAnnotN) {
                        CosDictionary curAnnot = (CosDictionary)curAnnotsArray.get(curAnnotN);
                        CosDictionary rbMatchAnnot = null;
                        if (DocModUtils.safeGetName(curAnnot, ASName.k_Subtype) == ASName.k_Widget) {
                            int rbAnnotN;
                            if (this.mFormFieldAddDelAllowed) {
                                ++rbAnnotIdx;
                                continue;
                            }
                            String curFullName = DocModUtils.getFullName(curAnnot);
                            if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode && !this.mLockedFieldSet.contains(curFullName)) {
                                ++rbAnnotIdx;
                                continue;
                            }
                            for (rbAnnotN = rbAnnotIdx; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                                rbAnnot3 = (CosDictionary)rbAnnotsArray.get(rbAnnotN);
                                if (!curFullName.equals(DocModUtils.getFullName(rbAnnot3))) continue;
                                rbMatchAnnot = rbAnnot3;
                                rbAnnotIdx = rbAnnotN;
                                break;
                            }
                            if (rbMatchAnnot == null) {
                                String curPartialName = DocModUtils.getPartialName(curAnnot);
                                for (int rbAnnotN2 = rbAnnotIdx; rbAnnotN2 < rbNumAnnots; ++rbAnnotN2) {
                                    rbAnnot2 = (CosDictionary)rbAnnotsArray.get(rbAnnotN2);
                                    if (!curPartialName.equals(DocModUtils.getPartialName(rbAnnot2))) continue;
                                    rbMatchAnnot = rbAnnot2;
                                    rbAnnotIdx = rbAnnotN2;
                                    break;
                                }
                            }
                            if (rbMatchAnnot != null) {
                                for (rbAnnotN = rbAnnotIdx; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                                    rbAnnot3 = (CosDictionary)rbAnnotsArray.get(rbAnnotN);
                                    if (!this.compareWidgets(curAnnot, rbAnnot3, false)) continue;
                                    rbMatchAnnot = rbAnnot3;
                                    rbAnnotIdx = rbAnnotN + 1;
                                    break;
                                }
                            }
                        } else {
                            if (this.mCommentsAllowed) {
                                ++rbAnnotIdx;
                                continue;
                            }
                            for (int rbAnnotN = rbAnnotIdx; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                                CosDictionary rbAnnot4 = (CosDictionary)rbAnnotsArray.get(rbAnnotIdx);
                                if (!this.compareAnnots(curAnnot, rbAnnot4, false)) continue;
                                rbMatchAnnot = rbAnnot4;
                                rbAnnotIdx = rbAnnotN + 1;
                                break;
                            }
                        }
                        if (rbMatchAnnot != null) continue;
                        return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                    }
                    continue;
                }
                CosDictionary cosDictionary = rbPage = this.mModList.isAdded(pageObjNum) ? null : (CosDictionary)this.mRbCosDoc.getIndirectObjectByNumber(pageObjNum);
                if (rbPage == null) {
                    if (this.mPgModAllowed) continue;
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (!this.mPgModAllowed) {
                    if (!this.comparePages(curPage, rbPage)) {
                        return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                    }
                    if (i < CosUtils.indexOfCosObjectRef(rbPagesByPageNumber, rbPage)) {
                        return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                    }
                    rbNonTemplatedPages.delete(pageObjNum);
                }
                curAnnotsArray = DocModUtils.safeGetArray(curPage, ASName.k_Annots);
                rbAnnotsArray = DocModUtils.safeGetArray(rbPage, ASName.k_Annots);
                curNumAnnots = curAnnotsArray != null ? curAnnotsArray.size() : 0;
                rbNumAnnots = rbAnnotsArray != null ? rbAnnotsArray.size() : 0;
                CosList rbWidgetAnnots = new CosList();
                CosList rbNonWidgetAnnots = new CosList();
                for (int rbAnnotN = 0; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                    rbAnnot = (CosDictionary)rbAnnotsArray.get(rbAnnotN);
                    if (DocModUtils.safeGetName(rbAnnot, ASName.k_Subtype) == ASName.k_Widget) {
                        rbWidgetAnnots.add(rbAnnot.getObjNum(), rbAnnot);
                        continue;
                    }
                    rbNonWidgetAnnots.add(rbAnnot.getObjNum(), rbAnnot);
                }
                for (int curAnnotN = 0; curAnnotN < curNumAnnots; ++curAnnotN) {
                    CosDictionary curAnnot = (CosDictionary)curAnnotsArray.get(curAnnotN);
                    int curObjNum = curAnnot.getObjNum();
                    ASName curAnnotType = DocModUtils.safeGetName(curAnnot, ASName.k_Subtype);
                    if (curAnnotType == ASName.k_Popup) continue;
                    if (curAnnotType == ASName.k_Widget) {
                        if (this.mFormFieldAddDelAllowed) continue;
                        String curFullName = DocModUtils.getFullName(curAnnot);
                        if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode && !this.mLockedFieldSet.contains(curFullName)) continue;
                        rbAnnot2 = (CosDictionary)rbWidgetAnnots.get(curObjNum);
                        if (this.mModList.isAdded(curObjNum)) {
                            CosObject cosFieldType = DocModUtils.getInheritedValue(curAnnot, ASName.k_FT);
                            if (!(cosFieldType instanceof CosName)) {
                                return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                            }
                            if (!this.mEnableA9 || ((CosName)cosFieldType).nameValue() != ASName.k_Sig) {
                                return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                            }
                            this.markSig(curAnnot.get(ASName.k_V));
                            continue;
                        }
                        if (!this.compareWidgets(curAnnot, rbAnnot2, this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode)) {
                            return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                        }
                        rbWidgetAnnots.delete(curObjNum);
                        continue;
                    }
                    if (this.mCommentsAllowed) continue;
                    rbAnnot3 = (CosDictionary)rbNonWidgetAnnots.get(curObjNum);
                    if (this.mModList.isAdded(curObjNum)) {
                        return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                    }
                    if (!this.compareAnnots(curAnnot, rbAnnot3, true)) {
                        return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                    }
                    rbNonWidgetAnnots.delete(curObjNum);
                }
                if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode && !this.mFormFieldAddDelAllowed && !rbWidgetAnnots.isEmpty()) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode || this.mCommentsAllowed || rbNonWidgetAnnots.isEmpty()) continue;
                Iterator<Object> iter = rbNonWidgetAnnots.iterator();
                while (iter.hasNext()) {
                    rbAnnot = (CosDictionary)iter.next();
                    if (DocModUtils.safeGetName(rbAnnot, ASName.k_Subtype) == ASName.k_Popup) continue;
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
            }
            if (!this.mPgModAllowed && !rbNonTemplatedPages.isEmpty()) {
                return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
            }
            if (!this.mMatchList.matchLists()) {
                return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
            }
            if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode) {
                ASName[] rootExclusions;
                this.mMatchList = new DocModMatch(this.mModList);
                CosList curDocList = new CosList();
                CosList rbDocList = new CosList();
                Iterator<Object> iter = this.mModList.getList().iterator();
                while (iter.hasNext()) {
                    CosObjectID id = (CosObjectID)iter.next();
                    if (this.mModList.isAddedOrModified(id.getObjNum())) {
                        curDocList.add(id.getObjNum(), id);
                    }
                    if (!this.mModList.isDeleted(id.getObjNum())) continue;
                    rbDocList.add(id.getObjNum(), id);
                }
                ASName[] rootExclusionsA8 = new ASName[]{ASName.k_StructTreeRoot, ASName.k_AcroForm, ASName.k_Metadata};
                ASName[] rootExclusionsA9 = new ASName[]{ASName.k_StructTreeRoot, ASName.k_AcroForm, ASName.k_Metadata, ASName.create("DSS")};
                ASName[] aSNameArray = rootExclusions = this.mEnableA9 ? rootExclusionsA9 : rootExclusionsA8;
                if (!this.visitDocument(this.mCurCosDoc, curDocList, rootExclusions, false, false)) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (!this.visitDocument(this.mRbCosDoc, rbDocList, rootExclusions, true, false)) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
                if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.NoMDP && !this.mMatchList.matchLists()) {
                    return new DocModAnalyzerResult(true, this.mXFAFormModified, this.badReturn());
                }
            }
            if (this.mEnableA9) {
                if (this.mXFAFormModified) {
                    this.mFormModified = this.mXFAFormModified;
                } else {
                    DocModStatusA9 modStatusObj = new DocModStatusA9(this.mCurCosDoc, this.mRbCosDoc, this.mModList, this.mParams);
                    modStatusObj.setLists(this.mCurAnnotList, this.mCurFieldList, this.mCurPagesList, this.mRbAnnotList, this.mRbFieldList, this.mRbPagesList);
                    this.mFormModified = modStatusObj.getModStatusA9() ^ true;
                }
            }
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException("Invalid document encountered during modification analysis", e);
        }
        catch (PDFIOException e) {
            throw new PDFIOException("IO exception encountered during modification analysis", e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSecurityException("Security exception encountered during modification analysis", e);
        }
        return new DocModAnalyzerResult(this.mFormModified, this.mXFAFormModified, true);
    }

    private boolean validateTemplatesTree(long rbEOF) throws PDFCosParseException, PDFSecurityException, PDFIOException, PDFInvalidDocumentException {
        if (this.mXFAValidationContext != null) {
            this.mRbCosDoc = this.mXFAValidationContext.getRollbackCosDoc();
        }
        if (this.mRbCosDoc == null) {
            this.mRbCosDoc = PDFSignature.getInstance(this.mSigObj).generateRollBackDocument();
        }
        this.mRbCatalog = this.mRbCosDoc.getRoot();
        CosList rbTemplatedPages = null;
        CosList rbNonTemplatedPages = null;
        int rbNumPages = DocModUtils.getNumPages(this.mRbCosDoc);
        ArrayList<CosDictionary> rbPagesByPageNumber = new ArrayList<CosDictionary>();
        rbTemplatedPages = new CosList();
        rbNonTemplatedPages = new CosList();
        for (int i = 0; i < rbNumPages; ++i) {
            CosDictionary rbPage = DocModUtils.getPage(this.mRbCosDoc, i);
            rbPagesByPageNumber.add(rbPage);
            if (DocModUtils.safeGetName(rbPage, ASName.k_TemplateInstantiated) == null) {
                rbNonTemplatedPages.add(rbPage.getObjNum(), rbPage);
                continue;
            }
            rbTemplatedPages.add(rbPage.getObjNum(), rbPage);
        }
        CosDictionary rbNames = DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_Names);
        HashMap<ASString, CosObject> rbTemplatesMap = new HashMap<ASString, CosObject>();
        if (rbNames != null) {
            DocModUtils.nameTreeToMapRecur(DocModUtils.safeGetDict(rbNames, ASName.k_Pages), rbTemplatesMap);
            DocModUtils.nameTreeToMapRecur(DocModUtils.safeGetDict(rbNames, ASName.k_Templates), rbTemplatesMap);
        }
        Iterator<Object> rbTemplatedPagesIter = rbTemplatedPages.iterator();
        Iterator templateNameIter = rbTemplatesMap.keySet().iterator();
        HashSet<String> templateNamesSet = new HashSet<String>();
        while (templateNameIter.hasNext()) {
            ASString templateName = (ASString)templateNameIter.next();
            templateNamesSet.add(templateName.asString());
        }
        while (rbTemplatedPagesIter.hasNext()) {
            CosDictionary rbPage = (CosDictionary)rbTemplatedPagesIter.next();
            ASName templateName = DocModUtils.safeGetName(rbPage, ASName.k_TemplateInstantiated);
            String templateNameString = templateName.asString();
            if (templateNamesSet.contains(templateNameString)) continue;
            return false;
        }
        return true;
    }

    private void reset() {
        this.mModAnalysisType = DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode;
        this.mNonSigFieldFillInAllowed = false;
        this.mSigFieldFillInAllowed = false;
        this.mFormFieldAddDelAllowed = false;
        this.mPgModAllowed = false;
        this.mPgTemplateSpawningAllowed = false;
        this.mCommentsAllowed = false;
        this.mEFChangesAllowed = false;
        this.mNamedJSDelAllowed = false;
        this.mEnableA9 = false;
        this.mFormModified = false;
        this.mXFAFormModified = false;
        this.mLockedFieldSet = null;
        this.mCurDoc = null;
        this.mCurCosDoc = null;
        this.mCurCatalog = null;
        this.mRbCosDoc = null;
        this.mRbCatalog = null;
        this.mSigObj = null;
        this.mModList = null;
        this.mMatchList = null;
        this.mCurAnnotList = null;
        this.mCurFieldList = null;
        this.mCurPagesList = null;
        this.mRbAnnotList = null;
        this.mRbFieldList = null;
        this.mRbPagesList = null;
        this.mXFAValidationContext = null;
        this.mParams = null;
    }

    private boolean visitDocument(CosDocument cosDoc, CosList visitorList, ASName[] subtreeExclusions, boolean visitParents, boolean dynamic) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (visitorList.isEmpty()) {
            return true;
        }
        CosList seenObjects = new CosList();
        DocModStack stack = new DocModStack();
        CosContainer container = cosDoc.getRoot();
        List<ASName> containerKeys = ((CosDictionary)container).getKeys();
        Iterator<Object> containerIter = containerKeys.iterator();
        ASName containerKey = null;
        CosObject containerItem = null;
        seenObjects.add(container.getObjNum(), new CosObjectID(container.getObjNum(), container.getObjGen()));
        boolean pushState = false;
        while (true) {
            int objStatus;
            if (containerIter.hasNext()) {
                if (container instanceof CosArray) {
                    containerItem = (CosObject)((Object)containerIter.next());
                } else {
                    containerKey = containerIter.next();
                    if (!visitParents && (containerKey == ASName.k_Parent || containerKey == ASName.k_P)) continue;
                    containerItem = ((CosDictionary)container).get(containerKey);
                    if (containerKey == ASName.k_Outlines && this.isOutlinesDictEmpty((CosContainer)containerItem)) continue;
                    if (stack.isEmpty()) {
                        int i;
                        for (i = 0; i < subtreeExclusions.length && containerKey != subtreeExclusions[i]; ++i) {
                        }
                        if (i != subtreeExclusions.length || dynamic && containerItem != null && !containerItem.isIndirect() && containerKey != ASName.k_OpenAction && containerKey != ASName.k_AA && containerKey != ASName.k_URI && containerKey != ASName.k_Legal) continue;
                    }
                }
                if (containerItem == null) continue;
                int objNum = containerItem.getObjNum();
                if (objNum != 0) {
                    if (seenObjects.containsIndex(objNum)) continue;
                    seenObjects.add(objNum, new CosObjectID(objNum, containerItem.getObjGen()));
                }
                if (containerItem instanceof CosContainer) {
                    pushState = true;
                } else {
                    int objStatus2;
                    if (objNum == 0 || !visitorList.containsIndex(objNum)) continue;
                    stack.push(new DocModStackItem(container, containerIter, containerKey, containerItem));
                    int n = objStatus2 = dynamic ? this.visitObjectDynamic(containerItem, stack) : this.visitObject(containerItem, stack);
                    if (objStatus2 == 0) {
                        return this.badReturn();
                    }
                    if (objStatus2 == 2) {
                        seenObjects.delete(objNum);
                    }
                    stack.popAndFlush();
                    continue;
                }
            }
            if (pushState) {
                stack.push(new DocModStackItem(container, containerIter, containerKey, containerItem));
                container = (CosContainer)containerItem;
                if (container instanceof CosArray) {
                    containerKey = null;
                    containerKeys = null;
                    containerIter = ((CosArray)container).iterator();
                } else {
                    containerKeys = ((CosDictionary)container).getKeys();
                    containerIter = containerKeys.iterator();
                }
                pushState = false;
                continue;
            }
            if (stack.isEmpty()) {
                return true;
            }
            DocModStackItem item = stack.popAndGet();
            containerItem = item.getContainerItem();
            containerKey = item.getContainerKey();
            container = item.getContainer();
            containerIter = item.getContainerIter();
            int objNum = containerItem == null ? 0 : containerItem.getObjNum();
            if (objNum == 0 || !visitorList.containsIndex(objNum)) continue;
            stack.push(new DocModStackItem(container, containerIter, containerKey, containerItem));
            int n = objStatus = dynamic ? this.visitObjectDynamic(containerItem, stack) : this.visitObject(containerItem, stack);
            if (objStatus == 0) {
                return this.badReturn();
            }
            if (objStatus == 2) {
                seenObjects.delete(objNum);
            }
            stack.popAndFlush();
        }
    }

    private int visitObject(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        DocModStackItem item;
        int objNum = obj.getObjNum();
        CosObjectID id = this.mModList.getObjID(objNum);
        if (id == null || obj instanceof CosNull) {
            return 1;
        }
        ASName pdfObjType = null;
        ASName pdfSubType = null;
        ASName subTree = curStack.getKeyAtLevel(0);
        if (obj instanceof CosDictionary) {
            pdfObjType = DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Type);
            pdfSubType = DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Subtype);
        }
        if (pdfObjType == null && !curStack.isEmpty()) {
            pdfObjType = curStack.getKeyAtLevel(curStack.size() - 1);
        }
        if (pdfObjType == null && curStack.size() >= 2) {
            pdfObjType = curStack.getKeyAtLevel(curStack.size() - 2);
        }
        if (obj.getDocument() == this.mRbCosDoc && (pdfObjType == ASName.k_Thumb || DocModUtils.isFontRelatedObject(obj, curStack))) {
            return 1;
        }
        if (this.getContainerAnnot(obj, curStack) != null || this.getContainerField(obj, curStack) != null) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (subTree == ASName.k_Names) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (subTree == ASName.k_Perms && (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode || curStack.getKeyAtLevel(1) != ASName.k_DocMDP)) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (this.isOutlineAndNotAction(curStack)) {
            return 0;
        }
        if (pdfSubType == ASName.k_Form) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        CosDictionary pageObj = this.getContainerPage(obj, curStack);
        if (pdfObjType == ASName.k_Annots && obj instanceof CosArray) {
            if (this.mCommentsAllowed || this.mFormFieldAddDelAllowed) {
                this.mMatchList.addOk(objNum, id);
                return 1;
            }
            if (pageObj == null || DocModUtils.safeGetName(pageObj, ASName.k_TemplateInstantiated) == null) {
                return 0;
            }
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (pdfObjType == ASName.k_ExtGState) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (pageObj != null) {
            if (obj != pageObj) {
                if (DocModUtils.safeGetName(pageObj, ASName.k_TemplateInstantiated) == null) {
                    return 0;
                }
                return 2;
            }
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (DocModUtils.isPagesNode(obj, curStack)) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        if (pdfObjType == ASName.k_Length && !curStack.isEmpty() && (item = curStack.get(curStack.size() - 1)).getContainer() instanceof CosStream) {
            this.mMatchList.addOk(objNum, id);
            return 1;
        }
        this.mMatchList.addBad(objNum, id);
        return 2;
    }

    private int visitObjectDynamic(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int objNum = obj.getObjNum();
        CosObjectID id = this.mModList.getObjID(objNum);
        if (id == null || obj instanceof CosNull) {
            return 1;
        }
        ASName pdfObjType = null;
        ASName pdfSubType = null;
        if (obj instanceof CosDictionary) {
            pdfObjType = DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Type);
            pdfSubType = DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Subtype);
        }
        if (pdfObjType == null && !curStack.isEmpty()) {
            pdfObjType = curStack.getKeyAtLevel(curStack.size() - 1);
        }
        if (pdfObjType == null && curStack.size() >= 2) {
            pdfObjType = curStack.getKeyAtLevel(curStack.size() - 2);
        }
        if (pdfObjType == ASName.k_ExtGState) {
            return 1;
        }
        if (pdfObjType == ASName.k_Annots && obj instanceof CosArray) {
            return 1;
        }
        if (pdfSubType == ASName.k_Form) {
            return 1;
        }
        if (this.getContainerAnnot(obj, curStack) != null || this.getContainerField(obj, curStack) != null) {
            return 1;
        }
        if (this.getContainerPage(obj, curStack) != null) {
            return 1;
        }
        return 0;
    }

    private void buildAnnotList(boolean rollBack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList theAnnotList;
        CosList cosList = theAnnotList = rollBack ? this.mRbAnnotList : this.mCurAnnotList;
        if (theAnnotList != null) {
            return;
        }
        theAnnotList = new CosList();
        if (rollBack) {
            this.mRbAnnotList = theAnnotList;
        } else {
            this.mCurAnnotList = theAnnotList;
        }
        this.buildPagesList(rollBack);
        CosList thePagesList = rollBack ? this.mRbPagesList : this.mCurPagesList;
        Iterator<Object> pagesIter = thePagesList.iterator();
        while (pagesIter.hasNext()) {
            CosDictionary curPage = (CosDictionary)pagesIter.next();
            CosArray pageAnnots = DocModUtils.safeGetArray(curPage, ASName.k_Annots);
            if (pageAnnots == null) continue;
            Iterator<CosObject> annotsIter = pageAnnots.iterator();
            while (annotsIter.hasNext()) {
                CosObject annot = annotsIter.next();
                theAnnotList.add(annot.getObjNum(), annot);
            }
        }
        theAnnotList.delete(0);
    }

    private void buildFieldList(boolean rollBack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList theFieldList;
        CosList cosList = theFieldList = rollBack ? this.mRbFieldList : this.mCurFieldList;
        if (theFieldList != null) {
            return;
        }
        theFieldList = new CosList();
        if (rollBack) {
            this.mRbFieldList = theFieldList;
        } else {
            this.mCurFieldList = theFieldList;
        }
        this.buildAnnotList(rollBack);
        CosList theAnnotList = rollBack ? this.mRbAnnotList : this.mCurAnnotList;
        Iterator<Object> iter = theAnnotList.iterator();
        while (iter.hasNext()) {
            CosDictionary annot = (CosDictionary)iter.next();
            if (DocModUtils.safeGetName(annot, ASName.k_Subtype) != ASName.k_Widget) continue;
            theFieldList.add(annot.getObjNum(), annot);
            CosDictionary field = annot;
            while ((field = DocModUtils.safeGetDict(field, ASName.k_Parent)) != null) {
                theFieldList.add(field.getObjNum(), field);
            }
        }
        theFieldList.delete(0);
    }

    private void buildPagesList(boolean rollBack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList thePagesList;
        CosList cosList = thePagesList = rollBack ? this.mRbPagesList : this.mCurPagesList;
        if (thePagesList != null) {
            return;
        }
        thePagesList = new CosList();
        if (rollBack) {
            this.mRbPagesList = thePagesList;
        } else {
            this.mCurPagesList = thePagesList;
        }
        CosDocument theCosDoc = rollBack ? this.mRbCosDoc : this.mCurCosDoc;
        int curNumPages = DocModUtils.getNumPages(theCosDoc);
        for (int i = 0; i < curNumPages; ++i) {
            CosDictionary curPage = DocModUtils.getPage(theCosDoc, i);
            thePagesList.add(curPage.getObjNum(), curPage);
        }
        thePagesList.delete(0);
    }

    private CosDictionary getContainerAnnot(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean rollBack = obj.getDocument() == this.mRbCosDoc;
        this.buildAnnotList(rollBack);
        return DocModUtils.getContainerItem(obj, curStack, rollBack ? this.mRbAnnotList : this.mCurAnnotList);
    }

    private CosDictionary getContainerField(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean rollBack = obj.getDocument() == this.mRbCosDoc;
        this.buildFieldList(rollBack);
        return DocModUtils.getContainerItem(obj, curStack, rollBack ? this.mRbFieldList : this.mCurFieldList);
    }

    private CosDictionary getContainerPage(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean rollBack = obj.getDocument() == this.mRbCosDoc;
        this.buildPagesList(rollBack);
        return DocModUtils.getContainerItem(obj, curStack, rollBack ? this.mRbPagesList : this.mCurPagesList);
    }

    private boolean isOutlineAndNotAction(DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName key = curStack.getKeyAtLevel(0);
        if (key != ASName.k_Outlines) {
            return false;
        }
        for (int i = 1; i < curStack.size(); ++i) {
            key = curStack.getKeyAtLevel(i);
            if (key != ASName.k_A && (key == ASName.k_First || key == ASName.k_Next || key == ASName.k_Prev || key == ASName.k_Next)) continue;
            return false;
        }
        return true;
    }

    private boolean compareCatalogs(CosDictionary curCat, CosDictionary rbCat) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ArrayList<ASName> includeKeys = new ArrayList<ASName>();
        includeKeys.add(ASName.k_AA);
        if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.NoMDP) {
            includeKeys.add(ASName.k_Legal);
        }
        includeKeys.add(ASName.k_OpenAction);
        if (!this.compareObjects(curCat, rbCat, includeKeys, true)) {
            return this.badReturn();
        }
        if (this.mModAnalysisType == DocModAnalyzerParams.DocModAnalysisMode.NoMDP) {
            return true;
        }
        CosDictionary curPerms = DocModUtils.safeGetDict(curCat, ASName.k_Perms);
        CosDictionary rbPerms = DocModUtils.safeGetDict(rbCat, ASName.k_Perms);
        if (curPerms == null && rbPerms == null) {
            return true;
        }
        if (curPerms == null || rbPerms == null) {
            return this.badReturn();
        }
        this.markSig(curPerms.get(ASName.k_DocMDP));
        return this.compareObjects(DocModUtils.safeGetDict(curPerms, ASName.k_DocMDP), DocModUtils.safeGetDict(rbPerms, ASName.k_DocMDP), null, false);
    }

    private boolean comparePages(CosDictionary curPage, CosDictionary rbPage) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int curContObjNum;
        CosObject curCont = curPage.get(ASName.k_Contents);
        int n = curContObjNum = curCont == null ? 0 : curCont.getObjNum();
        if (this.mModList.isAddedOrModified(curContObjNum)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curPage.get(ASName.k_AA), rbPage.get(ASName.k_AA), null, false)) {
            return this.badReturn();
        }
        if (!this.compareInheritableEntries(curPage, rbPage, ASName.k_CropBox)) {
            return this.badReturn();
        }
        if (!this.compareInheritableEntries(curPage, rbPage, ASName.k_MediaBox)) {
            return this.badReturn();
        }
        if (!this.compareInheritableEntries(curPage, rbPage, ASName.k_Resources)) {
            return this.badReturn();
        }
        if (!this.compareInheritableEntries(curPage, rbPage, ASName.k_Rotate)) {
            return this.badReturn();
        }
        this.mMatchList.registerMatchedObjIDs(curPage, rbPage);
        return true;
    }

    private boolean compareInheritableEntries(CosDictionary curPage, CosDictionary rbPage, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject rbPageEntry;
        CosObject curPageEntry = curPage.getInheritable(key, ASName.k_Parent);
        return this.compareObjects(curPageEntry, rbPageEntry = rbPage.getInheritable(key, ASName.k_Parent), null, false);
    }

    private boolean compareNamesDicts(CosDictionary curNamesDict, CosDictionary rbNamesDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (curNamesDict == null && rbNamesDict == null) {
            return true;
        }
        if (curNamesDict == null || rbNamesDict == null) {
            CosDictionary oneNamesDict;
            CosDictionary cosDictionary = oneNamesDict = curNamesDict != null ? curNamesDict : rbNamesDict;
            if (oneNamesDict.size() != 1) {
                return this.badReturn();
            }
            if (!oneNamesDict.containsKey(ASName.k_AP)) {
                return this.badReturn();
            }
            return true;
        }
        ArrayList<ASName> excludeKeys = new ArrayList<ASName>();
        excludeKeys.add(ASName.k_AP);
        if (this.mEFChangesAllowed) {
            excludeKeys.add(ASName.k_EmbeddedFiles);
        }
        excludeKeys.add(ASName.k_JavaScript);
        CosDictionary curEmbeddedFiles = null;
        CosDictionary curJavaScriptTree = null;
        if (curNamesDict != null) {
            curEmbeddedFiles = DocModUtils.safeGetDict(curNamesDict, ASName.k_EmbeddedFiles);
            curJavaScriptTree = DocModUtils.safeGetDict(curNamesDict, ASName.k_JavaScript);
        }
        CosDictionary rbEmbeddedFiles = null;
        CosDictionary rbJavaScriptTree = null;
        if (rbNamesDict != null) {
            rbEmbeddedFiles = DocModUtils.safeGetDict(rbNamesDict, ASName.k_EmbeddedFiles);
            rbJavaScriptTree = DocModUtils.safeGetDict(rbNamesDict, ASName.k_JavaScript);
        }
        if (!this.mEFChangesAllowed && !this.compareEmbeddedFiles(curEmbeddedFiles, rbEmbeddedFiles)) {
            return this.badReturn();
        }
        if (!this.compareJavaScripts(curJavaScriptTree, rbJavaScriptTree)) {
            return this.badReturn();
        }
        return this.compareObjects(curNamesDict, rbNamesDict, excludeKeys, false);
    }

    private boolean compareEmbeddedFiles(CosDictionary curEmbeddedFiles, CosDictionary rbEmbeddedFiles) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray rbEFArray;
        if (curEmbeddedFiles == null && rbEmbeddedFiles == null) {
            return true;
        }
        if (!this.compareObjects(curEmbeddedFiles, rbEmbeddedFiles, null, false)) {
            return this.badReturn();
        }
        CosArray curEFArray = DocModUtils.safeGetArray(curEmbeddedFiles, ASName.k_Names);
        if (!this.compareObjects(curEFArray, rbEFArray = DocModUtils.safeGetArray(rbEmbeddedFiles, ASName.k_Names), null, false)) {
            return this.badReturn();
        }
        if (curEFArray != null) {
            for (int i = 0; i < curEFArray.size(); ++i) {
                int curFObjNum;
                CosDictionary rbF;
                CosDictionary rbEF;
                CosObject curEFElement = curEFArray.get(i);
                CosObject rbEFElement = rbEFArray.get(i);
                if (!(curEFElement instanceof CosDictionary) || !(rbEFElement instanceof CosDictionary)) continue;
                CosDictionary curEF = DocModUtils.safeGetDict((CosDictionary)curEFElement, ASName.k_EF);
                if (!this.compareObjects(curEF, rbEF = DocModUtils.safeGetDict((CosDictionary)rbEFElement, ASName.k_EF), null, false)) {
                    return this.badReturn();
                }
                if (curEF == null) continue;
                CosDictionary curF = DocModUtils.safeGetDict(curEF, ASName.k_F);
                if (!this.compareObjects(curF, rbF = DocModUtils.safeGetDict(rbEF, ASName.k_F), null, false)) {
                    return this.badReturn();
                }
                int n = curFObjNum = curF == null ? 0 : curF.getObjNum();
                if (!this.mModList.isAddedOrModified(curFObjNum)) continue;
                return this.badReturn();
            }
        }
        return true;
    }

    private boolean compareJavaScripts(CosDictionary curJavaScriptTree, CosDictionary rbJavaScriptTree) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            Map<ASString, CosObject> curJSMap = DocModUtils.nameTreeToMap(curJavaScriptTree);
            Map<ASString, CosObject> rbJSMap = DocModUtils.nameTreeToMap(rbJavaScriptTree);
            if (curJSMap.isEmpty() && rbJSMap.isEmpty()) {
                return true;
            }
            if (curJSMap.isEmpty() || rbJSMap.isEmpty()) {
                return this.badReturn();
            }
            if (curJSMap.size() != rbJSMap.size() && !this.mNamedJSDelAllowed) {
                return this.badReturn();
            }
            Iterator<Map.Entry<ASString, CosObject>> iter = curJSMap.entrySet().iterator();
            ArrayList<ASName> excludeKeys = new ArrayList<ASName>();
            excludeKeys.add(ASName.k_JS);
            while (iter.hasNext()) {
                CosObject rbJSItem;
                CosObject curJSItem;
                Map.Entry<ASString, CosObject> entry = iter.next();
                ASString jsName = entry.getKey();
                CosObject curJSObj = entry.getValue();
                CosObject rbJSObj = rbJSMap.get(jsName);
                if (!(curJSObj instanceof CosDictionary) || !(rbJSObj instanceof CosDictionary)) {
                    return this.badReturn();
                }
                if (this.mNamedJSDelAllowed) {
                    CosObject curJSStm = ((CosDictionary)curJSObj).get(ASName.k_JS);
                    String str = "";
                    if (curJSStm instanceof CosString) {
                        str = ((CosString)curJSStm).textValue();
                    } else if (curJSStm instanceof CosStream) {
                        InputByteStream stm = ((CosStream)curJSStm).getStreamDecoded();
                        StringBuilder buf = new StringBuilder();
                        long length = stm.length();
                        for (long i = 0L; i < length; ++i) {
                            buf.append(stm.read());
                        }
                        str = buf.toString();
                    }
                    int len = str.length();
                    boolean blank = false;
                    if (len < 64) {
                        blank = true;
                        for (int i = 0; i < len; ++i) {
                            if (str.charAt(i) <= ' ') continue;
                            blank = false;
                        }
                    }
                    if (blank) continue;
                }
                if (!this.compareStreams(curJSItem = ((CosDictionary)curJSObj).get(ASName.k_JS), rbJSItem = ((CosDictionary)rbJSObj).get(ASName.k_JS))) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curJSItem, rbJSItem, null, false)) {
                    return this.badReturn();
                }
                if (this.compareObjects(curJSObj, rbJSObj, excludeKeys, false)) continue;
                return this.badReturn();
            }
            return true;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private boolean compareAcroFormDicts(CosDictionary curAcroFormDict, CosDictionary rbAcroFormDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ArrayList<ASName> excludeKeys = new ArrayList<ASName>();
        ASString curAFString = curAcroFormDict == null ? null : DocModUtils.safeGetString(curAcroFormDict, ASName.k_DA);
        ASString rbAFString = rbAcroFormDict == null ? null : DocModUtils.safeGetString(rbAcroFormDict, ASName.k_DA);
        ASString oneAFString = null;
        if (curAFString != null && rbAFString == null) {
            oneAFString = curAFString;
        } else if (rbAFString != null && curAFString == null) {
            oneAFString = rbAFString;
        }
        if (oneAFString != null && oneAFString.asString().compareTo("/Helv 0 Tf 0 g ") == 0) {
            excludeKeys.add(ASName.k_DA);
        }
        excludeKeys.add(ASName.k_DR);
        excludeKeys.add(ASName.k_Fields);
        excludeKeys.add(ASName.k_CO);
        excludeKeys.add(ASName.k_XFA);
        excludeKeys.add(ASName.k_SigFlags);
        return this.compareObjects(curAcroFormDict, rbAcroFormDict, excludeKeys, false);
    }

    private boolean compareXFA(CosDictionary curAcroFormDict, CosDictionary rbAcroFormDict) throws PDFSecurityException, PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException {
        if (curAcroFormDict == null && rbAcroFormDict == null) {
            return true;
        }
        if (curAcroFormDict == null || rbAcroFormDict == null) {
            return this.badReturn();
        }
        CosObject curXFA = curAcroFormDict.get(ASName.k_XFA);
        CosObject rbXFA = rbAcroFormDict.get(ASName.k_XFA);
        return this.compareXFAVersions(curXFA, rbXFA);
    }

    private boolean doModAnalysisDynamic() throws PDFSecurityException, PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException {
        ASName[] rootExclusions;
        if (!this.compareXFA(DocModUtils.safeGetDict(this.mCurCatalog, ASName.k_AcroForm), DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_AcroForm))) {
            return this.badReturn();
        }
        if (!this.compareCatalogs(this.mCurCatalog, this.mRbCatalog)) {
            return this.badReturn();
        }
        if (!this.compareNamesDicts(DocModUtils.safeGetDict(this.mCurCatalog, ASName.k_Names), DocModUtils.safeGetDict(this.mRbCatalog, ASName.k_Names))) {
            return this.badReturn();
        }
        CosList curDocList = new CosList();
        CosList rbDocList = new CosList();
        Iterator<Object> iter = this.mModList.getList().iterator();
        while (iter.hasNext()) {
            CosObjectID id = (CosObjectID)iter.next();
            if (this.mModList.isAddedOrModified(id.getObjNum())) {
                curDocList.add(id.getObjNum(), id);
            }
            if (!this.mModList.isDeleted(id.getObjNum())) continue;
            rbDocList.add(id.getObjNum(), id);
        }
        ASName[] rootExclusionsA8 = new ASName[]{ASName.k_StructTreeRoot, ASName.k_AcroForm, ASName.k_Pages, ASName.k_Metadata, ASName.k_Perms, ASName.k_Version, ASName.k_Names};
        ASName[] rootExclusionsA9 = new ASName[]{ASName.k_StructTreeRoot, ASName.k_AcroForm, ASName.k_Pages, ASName.k_Metadata, ASName.k_Perms, ASName.k_Version, ASName.k_Names, ASName.create("DSS")};
        ASName[] aSNameArray = rootExclusions = this.mEnableA9 ? rootExclusionsA9 : rootExclusionsA8;
        if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.NoMDP) {
            if (!this.visitDocument(this.mCurCosDoc, curDocList, rootExclusions, false, true)) {
                return this.badReturn();
            }
            if (!this.visitDocument(this.mRbCosDoc, rbDocList, rootExclusions, true, true)) {
                return this.badReturn();
            }
        }
        this.mFormModified = this.mXFAFormModified;
        return true;
    }

    private boolean compareXFAVersions(CosObject curXFA, CosObject rbXFA) throws PDFSecurityException, PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException {
        if (curXFA == null && rbXFA == null) {
            return true;
        }
        if (curXFA == null || rbXFA == null) {
            return this.badReturn();
        }
        if (curXFA != null) {
            if (this.mXFAValidationContext == null) {
                try {
                    this.mXFAValidationContext = new XFAValidationContext(this.mCurDoc, this.mRbCosDoc, null, this.mModAnalysisType, false);
                }
                catch (PDFCosParseException e) {
                    throw new PDFInvalidDocumentException("Invalid document encountered during validation context creation", e);
                }
            }
            SignatureOptions mSigOptions = this.mXFAValidationContext.getSigValidateOptions();
            try {
                XFAVersionComparator versionComparator = new XFAVersionComparator(this.mCurDoc, this.mRbCosDoc, XFAVersionComparator.DSMDPType.MDPCommentsAndDefault, null, this.mModAnalysisType, this.mXFAValidationContext);
                if (!versionComparator.compareXFAVersions()) {
                    return this.badReturn();
                }
                XFAChangeLogger changeLogger = mSigOptions.getXFAChangeLogger();
                if (mSigOptions.XFAChangeRecordingEnabled()) {
                    mSigOptions.getXFAChangeLogger().enableChangeLogging();
                }
                versionComparator.initComparator(XFAVersionComparator.DSMDPType.MDPAllowNone, changeLogger, DocModAnalyzerParams.DocModAnalysisMode.MDPAllowNone);
                versionComparator.compareXFAVersions();
                if (changeLogger.isFormModified()) {
                    this.mXFAFormModified = true;
                }
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFInvalidParameterException(e);
            }
        }
        return true;
    }

    private boolean compareSpawnedPgWithTemplate(CosDictionary curPage, CosDictionary rbTemplate) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            ASName templateName = DocModUtils.safeGetName(curPage, ASName.k_TemplateInstantiated);
            if (templateName == null) {
                return this.badReturn();
            }
            CosObject curResDict = DocModUtils.getInheritedValue(curPage, ASName.k_Resources);
            if (!(curResDict instanceof CosDictionary)) {
                return this.badReturn();
            }
            CosDictionary curXObjects = DocModUtils.safeGetDict((CosDictionary)curResDict, ASName.k_XObject);
            if (curXObjects == null) {
                return this.badReturn();
            }
            CosDictionary curFormXObject = DocModUtils.safeGetDict(curXObjects, templateName);
            if (curFormXObject == null) {
                return this.badReturn();
            }
            ASName formType = DocModUtils.safeGetName(curFormXObject, ASName.k_Subtype);
            if (formType != ASName.k_Form) {
                return this.badReturn();
            }
            CosObject rbContentsStm = rbTemplate.get(ASName.k_Contents);
            if (!(curFormXObject instanceof CosStream)) {
                return this.badReturn();
            }
            if (!this.compareObjects(curPage.get(ASName.k_CropBox), rbTemplate.get(ASName.k_CropBox), null, false)) {
                return this.badReturn();
            }
            if (!this.compareObjects(curPage.get(ASName.k_MediaBox), rbTemplate.get(ASName.k_MediaBox), null, false)) {
                return this.badReturn();
            }
            if (DocModUtils.safeGetInt(curPage, ASName.k_Rotate) != DocModUtils.safeGetInt(rbTemplate, ASName.k_Rotate)) {
                return this.badReturn();
            }
            InputStream curData = this.getContents(curFormXObject);
            InputStream rbData = null;
            if (rbContentsStm == null) {
                rbData = new ByteArrayInputStream(new byte[0]);
            } else if (rbContentsStm instanceof CosStream || rbContentsStm instanceof CosArray) {
                rbData = this.getContents(rbContentsStm);
            } else {
                return this.badReturn();
            }
            if (curData.read() != 113) {
                return this.badReturn();
            }
            if (curData.read() != 10) {
                return this.badReturn();
            }
            long length = rbData.available();
            for (long i = 0L; i < length; ++i) {
                if (curData.read() == rbData.read()) continue;
                return this.badReturn();
            }
            int nextChar = curData.read();
            if (nextChar == 10) {
                nextChar = curData.read();
            }
            if (nextChar != 81) {
                return this.badReturn();
            }
            if (curData.read() != 10) {
                return this.badReturn();
            }
            return true;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private InputStream getContents(CosObject cosContents) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (cosContents instanceof CosStream) {
            return ((CosStream)cosContents).getStreamDecoded().toInputStream();
        }
        if (cosContents instanceof CosArray) {
            CosArray cosArray = (CosArray)cosContents;
            ArrayList<InputByteStream> workStmArray = new ArrayList<InputByteStream>();
            for (int i = 0; i < cosArray.size(); ++i) {
                CosObject item = cosArray.get(i);
                if (!(item instanceof CosStream)) {
                    throw new PDFCosParseException("Bad stream array");
                }
                InputByteStream itemStm = ((CosStream)item).getStreamDecoded();
                workStmArray.add(itemStm);
                if (i == cosArray.size() - 1) continue;
                itemStm.seek(itemStm.length() - 1L);
                int lastByte = itemStm.read();
                if (lastByte == 48 || lastByte == 10) continue;
                byte[] padding = new byte[]{10};
                InputByteStream padStm = cosContents.getDocument().getStreamManager().getInputByteStream(padding);
                workStmArray.add(padStm);
            }
            InputByteStream[] stmArray = new InputByteStream[workStmArray.size()];
            for (int i = 0; i < workStmArray.size(); ++i) {
                stmArray[i] = (InputByteStream)workStmArray.get(i);
            }
            return cosContents.getDocument().getStreamManager().getInputByteStream(stmArray).toInputStream();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    private boolean compareStreams(CosObject curStmObj, CosObject rbStmObj) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        long rbStmLen;
        int i;
        InputByteStream[] stmArray;
        InputByteStream padStm;
        byte[] padding;
        int lastByte;
        InputByteStream itemStm;
        ArrayList<InputByteStream> workStmArray;
        CosArray cosArray;
        int curStmObjNum;
        if (curStmObj == null && rbStmObj == null) {
            return true;
        }
        this.mMatchList.registerMatchedObjIDs(curStmObj, rbStmObj);
        int n = curStmObjNum = curStmObj == null ? 0 : curStmObj.getObjNum();
        if (!this.mModList.isAddedOrModified(curStmObjNum)) {
            return true;
        }
        InputByteStream curInStm = null;
        InputByteStream rbInStm = null;
        if (curStmObj instanceof CosStream) {
            curInStm = ((CosStream)curStmObj).getStreamDecoded();
        } else if (curStmObj instanceof CosArray) {
            cosArray = (CosArray)curStmObj;
            workStmArray = new ArrayList<InputByteStream>();
            for (int i2 = 0; i2 < cosArray.size(); ++i2) {
                CosObject item = cosArray.get(i2);
                if (!(item instanceof CosStream)) {
                    throw new PDFCosParseException("Bad stream array");
                }
                itemStm = ((CosStream)item).getStreamDecoded();
                workStmArray.add(itemStm);
                if (i2 == cosArray.size() - 1) continue;
                itemStm.seek(itemStm.length() - 1L);
                lastByte = itemStm.read();
                if (lastByte == 48 || lastByte == 10) continue;
                padding = new byte[]{10};
                padStm = curStmObj.getDocument().getStreamManager().getInputByteStream(padding);
                workStmArray.add(padStm);
            }
            stmArray = new InputByteStream[workStmArray.size()];
            for (i = 0; i < workStmArray.size(); ++i) {
                stmArray[i] = (InputByteStream)workStmArray.get(i);
            }
            curInStm = curStmObj.getDocument().getStreamManager().getInputByteStream(stmArray);
        } else {
            return this.badReturn();
        }
        if (rbStmObj instanceof CosStream) {
            rbInStm = ((CosStream)rbStmObj).getStreamDecoded();
        } else if (rbStmObj instanceof CosArray) {
            cosArray = (CosArray)rbStmObj;
            workStmArray = new ArrayList();
            for (int i3 = 0; i3 < cosArray.size(); ++i3) {
                CosObject item = cosArray.get(i3);
                if (!(item instanceof CosStream)) {
                    throw new PDFCosParseException("Bad stream array");
                }
                itemStm = ((CosStream)item).getStreamDecoded();
                workStmArray.add(itemStm);
                if (i3 == cosArray.size() - 1) continue;
                itemStm.seek(itemStm.length() - 1L);
                lastByte = itemStm.read();
                if (lastByte == 48 || lastByte == 10) continue;
                padding = new byte[]{10};
                padStm = rbStmObj.getDocument().getStreamManager().getInputByteStream(padding);
                workStmArray.add(padStm);
            }
            stmArray = new InputByteStream[workStmArray.size()];
            for (i = 0; i < workStmArray.size(); ++i) {
                stmArray[i] = (InputByteStream)workStmArray.get(i);
            }
            rbInStm = rbStmObj.getDocument().getStreamManager().getInputByteStream(stmArray);
        } else {
            return this.badReturn();
        }
        long curStmLen = curInStm == null ? 0L : curInStm.length();
        long l = rbStmLen = rbInStm == null ? 0L : rbInStm.length();
        if (curStmLen != rbStmLen) {
            return this.badReturn();
        }
        if (curStmLen == 0L) {
            return true;
        }
        int i4 = 0;
        while ((long)i4 < curStmLen) {
            if (curInStm.read() != rbInStm.read()) {
                return this.badReturn();
            }
            ++i4;
        }
        return true;
    }

    private boolean compareWidgets(CosDictionary curAnnot, CosDictionary rbAnnot, boolean compareRects) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean modified = false;
        CosDictionary node = curAnnot;
        while (node != null) {
            if (this.mModList.isAddedOrModified(node.getObjNum())) {
                modified = true;
                break;
            }
            node = DocModUtils.safeGetDict(node, ASName.k_Parent);
        }
        if (!modified) {
            return true;
        }
        CosObject cosObj = DocModUtils.getInheritedValue(curAnnot, ASName.k_FT);
        if (!(cosObj instanceof CosName)) {
            return this.badReturn();
        }
        ASName curFieldType = ((CosName)cosObj).nameValue();
        if (curFieldType == ASName.k_Sig) {
            this.markSig(curAnnot.get(ASName.k_V));
        }
        int curFieldFlags = 0;
        cosObj = DocModUtils.getInheritedValue(curAnnot, ASName.k_Ff);
        if (cosObj instanceof CosNumeric) {
            curFieldFlags = ((CosNumeric)cosObj).intValue();
        }
        int rbFieldFlags = 0;
        cosObj = DocModUtils.getInheritedValue(rbAnnot, ASName.k_Ff);
        if (cosObj instanceof CosNumeric) {
            rbFieldFlags = ((CosNumeric)cosObj).intValue();
        }
        if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.NoMDP) {
            if ((curFieldFlags & 0xFFFFFFFE) != (rbFieldFlags & 0xFFFFFFFE)) {
                return this.badReturn();
            }
            int curAnnotFlags = 0;
            cosObj = DocModUtils.getInheritedValue(curAnnot, ASName.k_F);
            if (cosObj instanceof CosNumeric) {
                curAnnotFlags = ((CosNumeric)cosObj).intValue();
            }
            int rbAnnotFlags = 0;
            cosObj = DocModUtils.getInheritedValue(rbAnnot, ASName.k_F);
            if (cosObj instanceof CosNumeric) {
                rbAnnotFlags = ((CosNumeric)cosObj).intValue();
            }
            if ((curAnnotFlags & 0xFFFFFF3F) != (rbAnnotFlags & 0xFFFFFF3F)) {
                return this.badReturn();
            }
            if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_DV), DocModUtils.getInheritedValue(rbAnnot, ASName.k_DV), null, false)) {
                return this.badReturn();
            }
            if (this.mEnableA9) {
                if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_A), DocModUtils.getInheritedValue(rbAnnot, ASName.k_A), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_Opt), DocModUtils.getInheritedValue(rbAnnot, ASName.k_Opt), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_Q), DocModUtils.getInheritedValue(rbAnnot, ASName.k_Q), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curAnnot.get(ASName.k_TU), rbAnnot.get(ASName.k_TU), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curAnnot.get(ASName.k_Border), rbAnnot.get(ASName.k_Border), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_MaxLen), DocModUtils.getInheritedValue(rbAnnot, ASName.k_MaxLen), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_DS), DocModUtils.getInheritedValue(rbAnnot, ASName.k_DS), null, false)) {
                    return this.badReturn();
                }
            }
            CosObject curValue = curAnnot.get((curFieldFlags & 0x2000000) != 0 ? ASName.k_RV : ASName.k_V);
            CosObject rbValue = rbAnnot.get((rbFieldFlags & 0x2000000) != 0 ? ASName.k_RV : ASName.k_V);
            boolean valuesMatch = this.compareObjects(curValue, rbValue, null, false);
            if (curFieldType == ASName.k_Btn && !valuesMatch) {
                boolean bl = valuesMatch = DocModUtils.buttonOff(curValue) && DocModUtils.buttonOff(rbValue);
            }
            if ((curFieldType == ASName.k_Sig && !this.mSigFieldFillInAllowed || curFieldType != ASName.k_Sig && !this.mNonSigFieldFillInAllowed) && !valuesMatch) {
                return this.badReturn();
            }
            CosDictionary curMk = DocModUtils.safeGetDict(curAnnot, ASName.k_MK);
            CosDictionary rbMk = DocModUtils.safeGetDict(rbAnnot, ASName.k_MK);
            CosObject curBc = null;
            CosObject curBg = null;
            CosObject curR = null;
            CosObject curCa = null;
            if (curMk != null) {
                curBc = curMk.get(ASName.k_BC);
                curBg = curMk.get(ASName.k_BG);
                curR = curMk.get(ASName.k_R);
                curCa = curMk.get(ASName.k_CA);
            }
            CosObject rbBc = null;
            CosObject rbBg = null;
            CosObject rbR = null;
            CosObject rbCa = null;
            if (rbMk != null) {
                rbBc = rbMk.get(ASName.k_BC);
                rbBg = rbMk.get(ASName.k_BG);
                rbR = rbMk.get(ASName.k_R);
                rbCa = rbMk.get(ASName.k_CA);
            }
            if (rbBc != null && !this.compareObjects(curBc, rbBc, null, false)) {
                return this.badReturn();
            }
            if (!this.mEnableA9 && !this.compareObjects(curBg, rbBg, null, false)) {
                return this.badReturn();
            }
            if (this.mEnableA9 && !this.compareObjects(curR, rbR, null, false)) {
                return this.badReturn();
            }
            if (this.mEnableA9 && !this.compareObjects(curCa, rbCa, null, false)) {
                return this.badReturn();
            }
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_T), DocModUtils.getInheritedValue(rbAnnot, ASName.k_T), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_SV), DocModUtils.getInheritedValue(rbAnnot, ASName.k_SV), null, false)) {
            return this.badReturn();
        }
        if (this.mModAnalysisType != DocModAnalyzerParams.DocModAnalysisMode.NoMDP && !this.compareAnnotsCommon(curAnnot, rbAnnot, compareRects)) {
            return this.badReturn();
        }
        return true;
    }

    private boolean compareAnnots(CosDictionary curAnnot, CosDictionary rbAnnot, boolean compareRects) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName rbType;
        if (!this.mModList.isAddedOrModified(curAnnot.getObjNum())) {
            return true;
        }
        ASName curType = DocModUtils.safeGetName(curAnnot, ASName.k_Subtype);
        if (curType != (rbType = DocModUtils.safeGetName(rbAnnot, ASName.k_Subtype))) {
            return this.badReturn();
        }
        if (curType == ASName.k_Popup) {
            return true;
        }
        if (curAnnot.get(ASName.k_Rect) == null || rbAnnot.get(ASName.k_Rect) == null) {
            return true;
        }
        ASString curContents = DocModUtils.safeGetString(curAnnot, ASName.k_Contents);
        ASString rbContents = DocModUtils.safeGetString(rbAnnot, ASName.k_Contents);
        if (curContents != null && rbContents != null) {
            if (!this.compareObjects(curAnnot.get(ASName.k_Contents), rbAnnot.get(ASName.k_Contents), null, false)) {
                return this.badReturn();
            }
        } else if (curContents != null || rbContents != null) {
            byte[] cont = null;
            cont = curContents != null ? curContents.getBytes() : rbContents.getBytes();
            if (cont.length != 0 && (cont.length != 2 || cont[0] != 40 || cont[1] != 41)) {
                return this.badReturn();
            }
        }
        if (curType == ASName.k_Stamp) {
            CosDictionary curAppearance = DocModUtils.safeGetDict(curAnnot, ASName.k_AP);
            CosDictionary rbAppearance = DocModUtils.safeGetDict(rbAnnot, ASName.k_AP);
            if (curAppearance != null || rbAppearance != null) {
                if (curAppearance == null || rbAppearance == null) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curAppearance.get(ASName.k_F), rbAppearance.get(ASName.k_F), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curAppearance.get(ASName.k_Poster), rbAppearance.get(ASName.k_Poster), null, false)) {
                    return this.badReturn();
                }
            }
        }
        if (curType == ASName.k_Movie) {
            CosDictionary curMovie = DocModUtils.safeGetDict(curAnnot, ASName.k_Movie);
            CosDictionary rbMovie = DocModUtils.safeGetDict(rbAnnot, ASName.k_Movie);
            if (curMovie == null || rbMovie == null) {
                return this.badReturn();
            }
            if (!this.compareObjects(curMovie.get(ASName.k_F), rbMovie.get(ASName.k_F), null, false)) {
                return this.badReturn();
            }
            if (!this.compareObjects(curMovie.get(ASName.k_Poster), rbMovie.get(ASName.k_Poster), null, false)) {
                return this.badReturn();
            }
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_F), rbAnnot.get(ASName.k_F), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_FS), rbAnnot.get(ASName.k_FS), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_T), rbAnnot.get(ASName.k_T), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Dest), rbAnnot.get(ASName.k_Dest), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_InkList), rbAnnot.get(ASName.k_InkList), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Name), rbAnnot.get(ASName.k_Name), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_QuadPoints), rbAnnot.get(ASName.k_QuadPoints), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Sound), rbAnnot.get(ASName.k_Sound), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_A), DocModUtils.getInheritedValue(rbAnnot, ASName.k_A), null, false)) {
            return this.badReturn();
        }
        if (!this.compareAnnotsCommon(curAnnot, rbAnnot, compareRects)) {
            return this.badReturn();
        }
        return true;
    }

    private boolean compareAnnotsCommon(CosDictionary curAnnot, CosDictionary rbAnnot, boolean compareRects) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_AA), DocModUtils.getInheritedValue(rbAnnot, ASName.k_AA), null, false)) {
            return this.badReturn();
        }
        CosDictionary curBS = DocModUtils.safeGetDict(curAnnot, ASName.k_BS);
        CosDictionary rbBS = DocModUtils.safeGetDict(rbAnnot, ASName.k_BS);
        if (curBS != null || rbBS != null) {
            if (curBS == null || rbBS == null) {
                return this.badReturn();
            }
            CosObject curW = curBS.get(ASName.k_W);
            double curWVal = 1.0;
            if (curW instanceof CosNumeric) {
                curWVal = ((CosNumeric)curW).doubleValue();
            }
            CosObject rbW = rbBS.get(ASName.k_W);
            double rbWVal = 1.0;
            if (rbW instanceof CosNumeric) {
                rbWVal = ((CosNumeric)rbW).doubleValue();
            }
            if (curWVal != rbWVal) {
                return this.badReturn();
            }
            CosObject curS = curBS.get(ASName.k_S);
            ASName curSVal = ASName.k_S;
            if (curS instanceof CosName) {
                curSVal = ((CosName)curS).nameValue();
            }
            CosObject rbS = rbBS.get(ASName.k_S);
            ASName rbSVal = ASName.k_S;
            if (rbS instanceof CosName) {
                rbSVal = ((CosName)rbS).nameValue();
            }
            if (curSVal != rbSVal) {
                return this.badReturn();
            }
        }
        if (compareRects) {
            CosArray curRect = DocModUtils.safeGetArray(curAnnot, ASName.k_Rect);
            CosArray rbRect = DocModUtils.safeGetArray(rbAnnot, ASName.k_Rect);
            if (curRect != null || rbRect != null) {
                if (curRect == null || rbRect == null) {
                    return this.badReturn();
                }
                if (curRect.size() != 4 || rbRect.size() != 4) {
                    return this.badReturn();
                }
                for (int i = 0; i < 4; ++i) {
                    double magicVal;
                    CosObject curObj = curRect.get(i);
                    if (!(curObj instanceof CosNumeric)) {
                        return this.badReturn();
                    }
                    double curVal = ((CosNumeric)curObj).doubleValue();
                    CosObject rbObj = rbRect.get(i);
                    if (!(rbObj instanceof CosNumeric)) {
                        return this.badReturn();
                    }
                    double rbVal = ((CosNumeric)rbObj).doubleValue();
                    double d = magicVal = this.mEnableA9 ? 2.33 : 233.0;
                    if (!(Math.abs(curVal - rbVal) > magicVal)) continue;
                    return this.badReturn();
                }
            }
        }
        return true;
    }

    private boolean compareObjects(CosObject obj1, CosObject obj2, ArrayList<ASName> keyList, boolean include) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj1 == null) {
                obj1 = obj2;
            }
            if (obj1 instanceof CosArray) {
                if (((CosArray)obj1).size() == 0) {
                    return true;
                }
                return this.badReturn();
            }
            if (obj1 instanceof CosDictionary) {
                Iterator<ASName> iter = ((CosDictionary)obj1).keyIterator();
                while (iter.hasNext()) {
                    ASName key = iter.next();
                    if (!(keyList != null && keyList.contains(key) ? include : !include)) continue;
                    return this.badReturn();
                }
                return true;
            }
            return this.badReturn();
        }
        if (obj1.getClass() != obj2.getClass()) {
            return this.badReturn();
        }
        this.mMatchList.registerMatchedObjIDs(obj1, obj2);
        if (obj1.getObjNum() == 0 != (obj1.getObjNum() == 0) || obj1 instanceof CosScalar) {
            if (DocModUtils.compareScalars(obj1, obj2)) {
                return true;
            }
            return this.badReturn();
        }
        if (obj1 instanceof CosArray) {
            int count = ((CosArray)obj1).size();
            if (((CosArray)obj2).size() != count) {
                return this.badReturn();
            }
            for (int i = 0; i < count; ++i) {
                CosObject arrayObj1 = ((CosArray)obj1).get(i);
                CosObject arrayObj2 = ((CosArray)obj2).get(i);
                if (arrayObj1.getObjNum() == 0 || arrayObj2.getObjNum() == 0) {
                    if (this.compareObjects(arrayObj1, arrayObj2, null, false)) continue;
                    return this.badReturn();
                }
                if (arrayObj1.getObjNum() == arrayObj2.getObjNum() && arrayObj1.getObjGen() == arrayObj2.getObjGen()) {
                    this.mMatchList.registerUnmatchedIfModified(arrayObj1, arrayObj2);
                    continue;
                }
                return this.badReturn();
            }
            return true;
        }
        if (obj1 instanceof CosDictionary) {
            CosObject val2;
            CosObject val1;
            ASName key;
            if (obj1 instanceof CosStream) {
                try {
                    if (((CosStream)obj1).getStreamEncoded().length() != ((CosStream)obj2).getStreamEncoded().length()) {
                        return this.badReturn();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
                keyList = new ArrayList();
                keyList.add(ASName.k_Filter);
                keyList.add(ASName.k_FFilter);
                keyList.add(ASName.k_DecodeParms);
                keyList.add(ASName.k_FDecodeParms);
                include = true;
            }
            Iterator<ASName> iter = ((CosDictionary)obj1).keyIterator();
            while (iter.hasNext()) {
                key = iter.next();
                if (include ? keyList == null || !keyList.contains(key) : keyList != null && keyList.contains(key)) continue;
                val1 = ((CosDictionary)obj1).get(key);
                val2 = ((CosDictionary)obj2).get(key);
                if (val2 == null) {
                    return this.badReturn();
                }
                if (val1.getObjNum() == 0 || val2.getObjNum() == 0) {
                    if (this.compareObjects(val1, val2, null, false)) continue;
                    return this.badReturn();
                }
                if (val1.getObjNum() == val2.getObjNum() && val1.getObjGen() == val2.getObjGen()) {
                    this.mMatchList.registerUnmatchedIfModified(val1, val2);
                    continue;
                }
                return this.badReturn();
            }
            if (keyList != null && !keyList.isEmpty() || !include && ((CosDictionary)obj1).size() != ((CosDictionary)obj2).size()) {
                iter = ((CosDictionary)obj2).keyIterator();
                while (iter.hasNext()) {
                    key = iter.next();
                    if (!include ? keyList != null && keyList.contains(key) : keyList == null || !keyList.contains(key)) continue;
                    val1 = ((CosDictionary)obj1).get(key);
                    if (val1 == null) {
                        return this.badReturn();
                    }
                    val2 = ((CosDictionary)obj2).get(key);
                    if (val1.getObjNum() == 0 || val2.getObjNum() == 0) {
                        if (this.compareObjects(val1, val2, null, false)) continue;
                        return this.badReturn();
                    }
                    if (val1.getObjNum() == val2.getObjNum() && val1.getObjGen() == val2.getObjGen()) {
                        this.mMatchList.registerUnmatchedIfModified(val1, val2);
                        continue;
                    }
                    return this.badReturn();
                }
            }
            return true;
        }
        return this.badReturn();
    }

    private void markSig(CosObject sigObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (!(sigObj instanceof CosDictionary)) {
            return;
        }
        this.markSigContents((CosDictionary)sigObj);
        int sigObjNum = sigObj.getObjNum();
        CosObject rbSigObj = this.mRbCosDoc.getIndirectObjectByNumber(sigObjNum);
        if (!(rbSigObj instanceof CosDictionary)) {
            return;
        }
        this.markSigContents((CosDictionary)rbSigObj);
    }

    private void markSigContents(CosDictionary sigDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject sigType = sigDict.get(ASName.k_Type);
        if (sigType instanceof CosName && ((CosName)sigType).nameValue() != ASName.k_Sig) {
            return;
        }
        CosObject sigCont = sigDict.get(ASName.k_Contents);
        if (!(sigCont instanceof CosString)) {
            return;
        }
        ((CosString)sigCont).setIsEncrypted(false);
        CosArray refArray = DocModUtils.safeGetArray(sigDict, ASName.k_Reference);
        if (refArray == null) {
            return;
        }
        Iterator<CosObject> iter = refArray.iterator();
        while (iter.hasNext()) {
            CosObject digestValue;
            CosObject refDict = iter.next();
            if (!(refDict instanceof CosDictionary) || !((digestValue = ((CosDictionary)refDict).get(ASName.k_DigestValue)) instanceof CosString)) continue;
            ((CosString)digestValue).setIsEncrypted(false);
        }
    }

    private boolean badReturn() {
        this.mFormModified = true;
        return false;
    }

    private boolean isOutlinesDictEmpty(CosContainer OutlineContainer) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary OutlinesDict = (CosDictionary)OutlineContainer;
        return !OutlinesDict.isEmpty() && OutlinesDict.containsKey(ASName.k_Count) && DocModUtils.safeGetInt(OutlinesDict, ASName.k_Count) == 0;
    }
}

