/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorFieldMDP;

public final class ObjectSelectorFieldMDPExclude
extends ObjectSelectorFieldMDP {
    String[] excludeFieldNames;

    public ObjectSelectorFieldMDPExclude(String[] excludeFieldNames) {
        this.excludeFieldNames = excludeFieldNames;
    }

    @Override
    public boolean shouldDigestFieldAnnot(PDFField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return !this.fieldIsExcluded(field);
    }

    @Override
    public boolean shouldDigestFieldAnnotValue(PDFField field, boolean fieldIsSigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (field != null) {
            if (this.fieldIsExcluded(field)) {
                return false;
            }
            if (fieldIsSigField) {
                return false;
            }
        }
        return true;
    }

    private boolean fieldIsExcluded(PDFField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String fieldName = field.getQualifiedName();
        for (int i = 0; i < this.excludeFieldNames.length; ++i) {
            if (!fieldName.equals(this.excludeFieldNames[i])) continue;
            return true;
        }
        return false;
    }
}

