/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;

public final class VerifierFactory {
    private PDFSignatureSubFilter subFilter;

    private VerifierFactory() {
    }

    private VerifierFactory(PDFSignatureSubFilter subFilter) {
        this.subFilter = subFilter;
    }

    public static VerifierFactory newInstance(PDFSignatureSubFilter subFilter) {
        return new VerifierFactory(subFilter);
    }

    public Verifier newVerifier(SignatureServiceProvider myProvider, byte[][] derCertChain) throws PDFConfigurationException, PDFInvalidParameterException, PDFSignatureException {
        boolean detachedSignature = false;
        if (this.subFilter == PDFSignatureSubFilter.X509RSASha1) {
            return myProvider.getPKCS1Verifier(derCertChain);
        }
        if (this.subFilter == PDFSignatureSubFilter.PKCS7Detached) {
            detachedSignature = true;
            return myProvider.getPKCS7Verifier(detachedSignature);
        }
        if (this.subFilter == PDFSignatureSubFilter.PKCS7Sha1) {
            detachedSignature = false;
            return myProvider.getPKCS7Verifier(detachedSignature);
        }
        if (this.subFilter == PDFSignatureSubFilter.ETSIRFC3161) {
            return myProvider.getDocumentTimeStampVerifier();
        }
        if (this.subFilter == PDFSignatureSubFilter.ETSICADESDetached) {
            return myProvider.getCADESDetachedVerifier();
        }
        return null;
    }
}

