/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.digsig.DocModAnalysisStatus;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsLeanDoc;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureValidationStatus;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.SignatureHandler;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.XFAValidationContext;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFADigSigWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.form.FieldMDP;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.xfa.template.containers.Field;

public class FormModelWorkFlow
extends XFADigSigWorkFlow {
    public FormModelWorkFlow(SignatureFieldInterface sigField) {
        this.sigField = sigField;
        if (sigField != null) {
            this.pdfDoc = sigField.getPDFDocument();
        }
    }

    public FormModelWorkFlow(PDFDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
    }

    @Override
    public SigFieldLock getFieldLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.sigField == null) {
            return null;
        }
        return this.sigField.getFieldLock();
    }

    @Override
    public SigSeedValue getSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.sigField == null) {
            return null;
        }
        return this.sigField.getSeedValue();
    }

    @Override
    public void handleLeanDocGeneration(SignatureOptionsLeanDoc sigOptions) {
        if (sigOptions != null && (SigningUtils.isCertification(sigOptions) || sigOptions.getSigningType() == SigningUtils.SigningType.UsageRights)) {
            if (sigOptions.leanDocumentGenerationEnabled()) {
                XFAInternalUtils.enableLeanDocGeneration(this.pdfDoc);
            }
        } else {
            XFADOM xfaDOM = XFADOMService.getXFADOMFromCache(this.pdfDoc);
            if (xfaDOM != null && xfaDOM.getXFADocument().isDirty()) {
                XFAInternalUtils.enableLeanDocGeneration(this.pdfDoc);
            }
        }
    }

    @Override
    public void setFieldLock(SigFieldLock fieldLock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.sigField == null) {
            return;
        }
        this.sigField.setFieldLock(fieldLock);
    }

    @Override
    public void verifyFieldMDP(XFAValidationContext xfaValidationContext, DocModAnalysisStatus docModAnalysisStatus) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.sigField == null) {
            return;
        }
        FieldMDP fieldMDPVerifier = new FieldMDP(this.pdfDoc, this.sigField);
        boolean isFieldMDPValid = fieldMDPVerifier.doFieldMDPAnalysis(xfaValidationContext);
        if (!isFieldMDPValid) {
            docModAnalysisStatus.appendStatus(4L);
        }
    }

    @Override
    Field getXFAField() throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.sigField == null) {
            return null;
        }
        SignatureFieldXFA xfaField = this.sigField.getXFAField();
        if (xfaField == null) {
            throw new PDFInvalidParameterException("XFA Signature field is null");
        }
        return xfaField.getXFAFieldSignature();
    }

    @Override
    public void prepareToSign(SignatureHandler sigHandler, PDFDocument pdfDoc, SignatureFieldInterface sigField, PDFSignature signature, SignatureOptions sigOptions, Credentials credentials) throws PDFSignatureException {
        sigHandler.prepareToSign(pdfDoc, sigField, signature, sigOptions, credentials);
    }

    @Override
    public SignatureValidationStatus validate(SignatureHandler sigHandler, PDFDocument pdfDoc, SignatureFieldInterface sigField, PDFSignature pdfSignature, SignatureOptions sigOptions, SignatureServiceProvider sigServiceProvider) throws PDFSignatureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return sigHandler.validate(pdfSignature.getPDFDocument(), sigField, sigOptions, sigServiceProvider);
    }

    @Override
    public boolean isFormModelWorkFlow() {
        return true;
    }

    @Override
    public void removeSigningEventsIfNotRequired(SignatureOptions sigOptions) {
    }
}

