/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.InputStream;

public final class RSAMessageDigester
extends AbstractDigester {
    private JSAFE_MessageDigest digester;

    public RSAMessageDigester(String digestAlgorithm) throws PDFSignatureException {
        this.digestMethod = digestAlgorithm;
        this.initDigester();
    }

    @Override
    protected void initDigester() throws PDFSignatureException {
        try {
            this.digester = JSAFE_MessageDigest.getInstance((String)this.digestMethod, (String)"Java");
            this.digester.digestInit();
        }
        catch (JSAFE_UnimplementedException e) {
            throw new PDFSignatureException("The digest algorithm" + this.digestMethod + " is not available", e);
        }
        catch (JSAFE_InvalidParameterException e) {
            throw new PDFSignatureException("The digest algorithm" + this.digestMethod + " is not available", e);
        }
    }

    @Override
    public byte[] calculateDigest() throws PDFSignatureException {
        try {
            return this.digester.digestFinal();
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.JSafe Invalid Use Exception in the RipeMD Message Digest case", e);
        }
    }

    @Override
    public int getSize() throws PDFSignatureException {
        return this.digester.getDigestSize();
    }

    @Override
    public void feedDataToDigester(InputStream is) throws PDFIOException {
        byte[] chunk = new byte[8192];
        try {
            while (is.available() > 0) {
                int numBytesRead = is.read(chunk);
                this.digester.digestUpdate(chunk, 0, numBytesRead);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFIOException(e);
        }
    }
}

